/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.config.simpleconfig;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Utils {
    public static <V> V getUnsafely(Field field, Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            field.setAccessible(true);
            return (V)field.get(obj);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V getUnsafely(Field field, Object obj, V defaultValue) {
        V ret = Utils.getUnsafely(field, obj);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    public static void setUnsafely(Field field, Object obj, Object newValue) {
        if (obj != null) {
            try {
                field.setAccessible(true);
                field.set(obj, newValue);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <V> V constructUnsafely(Class<V> cls) {
        try {
            Constructor<V> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getClassNameOrNull(Class<?> fieldTypeParam, Object elem) {
        try {
            Method getNameMethod = fieldTypeParam.getMethod("getName", new Class[0]);
            if (Modifier.isPublic(getNameMethod.getModifiers()) && !Modifier.isStatic(getNameMethod.getModifiers()) && getNameMethod.getReturnType() == String.class) {
                return (String)getNameMethod.invoke(elem, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

