// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package ai.chat2db.server.web.api.controller.ai.tongyi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Representation of the token counts processed for a completions request. Counts consider all tokens across prompts,
 * choices, choice alternates, best_of generations, and other consumers.
 */
@Data
@NoArgsConstructor
public final class TongyiChatCompletionsUsage {

    /*
     * The number of tokens generated across all completions emissions.
     */
    @JsonProperty(value = "output_tokens")
    private int outputTokens;

    /*
     * The number of tokens in the provided prompts for the completions request.
     */
    @JsonProperty(value = "input_tokens")
    private int inputTokens;


    /**
     * Creates an instance of CompletionsUsage class.
     *
     * @param completionTokens the completionTokens value to set.
     * @param promptTokens the promptTokens value to set.
     */
    @JsonCreator
    private TongyiChatCompletionsUsage(
            @JsonProperty(value = "output_tokens") int completionTokens,
            @JsonProperty(value = "input_tokens") int promptTokens) {
        this.outputTokens = completionTokens;
        this.inputTokens = promptTokens;
    }
}
