// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package ai.chat2db.server.web.api.controller.ai.baichuan.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Representation of the token counts processed for a completions request. Counts consider all tokens across prompts,
 * choices, choice alternates, best_of generations, and other consumers.
 */
@Data
@NoArgsConstructor
public final class BaichuanChatCompletionsUsage {

    /*
     * The number of tokens generated across all completions emissions.
     */
    @JsonProperty(value = "answer_tokens")
    private int answerTokens;

    /*
     * The number of tokens in the provided prompts for the completions request.
     */
    @JsonProperty(value = "prompt_tokens")
    private int promptTokens;

    /*
     * The total number of tokens processed for the completions request and response.
     */
    @JsonProperty(value = "total_tokens")
    private int totalTokens;

    /**
     * Creates an instance of CompletionsUsage class.
     *
     * @param completionTokens the completionTokens value to set.
     * @param promptTokens the promptTokens value to set.
     * @param totalTokens the totalTokens value to set.
     */
    @JsonCreator
    private BaichuanChatCompletionsUsage(
            @JsonProperty(value = "answer_tokens") int completionTokens,
            @JsonProperty(value = "prompt_tokens") int promptTokens,
            @JsonProperty(value = "total_tokens") int totalTokens) {
        this.answerTokens = completionTokens;
        this.promptTokens = promptTokens;
        this.totalTokens = totalTokens;
    }
}
