// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package ai.chat2db.server.web.api.controller.ai.baichuan.model;

import ai.chat2db.server.web.api.controller.ai.fastchat.model.FastChatMessage;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * The configuration information for a chat completions request. Completions support a wide variety of tasks and
 * generate text that continues from or "completes" provided prompt data.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public final class BaichuanChatCompletionsOptions {

    /*
     * The collection of context messages associated with this chat completions request.
     * Typical usage begins with a chat message for the System role that provides instructions for
     * the behavior of the assistant, followed by alternating messages between the User and
     * Assistant roles.
     */
    private List<FastChatMessage> messages;

    //
    /*
     * The model name to provide as part of this completions request.
     * Not applicable to Fast Chat AI, where deployment information should be included in the Fast Chat
     * resource URI that's connected to.
     */
    private String model;
}
