


<div align="center">
    <a href="https://trendshift.io/repositories/11808" target="_blank"><img src="https://trendshift.io/api/badge/repositories/11808" alt="CodePhiliaX%2FChat2DB | Trendshift" style="width: 250px; height: 55px;" width="250" height="55"/></a>
</div>
<br/>
<p align="center">
 <a href="https://discord.com/invite/uNjb3n5JVN" target="_blank">
    <img src="https://img.shields.io/badge/-Join%20us%20on%20Discord-%237289DA.svg?style=flat&logo=discord&logoColor=white"
            alt="chat on Discord"></a>
<a href="https://twitter.com/intent/tweet?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.&url=https://github.com/chat2db/Chat2DB&hashtags=ChatGPT,AGI,SQL%20Client,Reporting%20tool" target="blank" > <img src="https://img.shields.io/twitter/follow/_Chat2DB?label=Twitter&style=social" alt=""/> </a> 
<a href="https://t.me/share/url?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.&url=https://github.com/chat2db/Chat2DB" target="_blank"><img src="https://img.shields.io/twitter/url?label=Telegram&logo=Telegram&style=social&url=https://github.com/chat2db/Chat2DB" alt="Share on Telegram"/></a>
<a href="https://api.whatsapp.com/send?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.%20https://github.com/chat2db/Chat2DB"><img src="https://img.shields.io/twitter/url?label=whatsapp&logo=whatsapp&style=social&url=https://github.com/chat2db/Chat2DB" /></a>
<a href="https://www.reddit.com/submit?url=https://github.com/chat2db/Chat2DB&title=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities." target="blank"><img src="https://img.shields.io/twitter/url?label=Reddit&logo=Reddit&style=social&url=https://github.com/chat2db/Chat2DB" alt="Share on Reddit"/></a>
<a href="mailto:?subject=Check%20this%20GitHub%20repository%20out.&body=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.%3A%0Ahttps://github.com/chat2db/Chat2DB" target="_blank"><img src="https://img.shields.io/twitter/url?label=Gmail&logo=Gmail&style=social&url=https://github.com/chat2db/Chat2DB"/></a>

</p>
<div align="center">
  <a href="./README.md"><img alt="README in English" src="https://img.shields.io/badge/English-d9d9d9"></a>
  <a href="./README_CN.md"><img alt="简体中文版自述文件" src="https://img.shields.io/badge/简体中文-d9d9d9"></a>
  <a href="./README_JA.md"><img alt="日本語のREADME" src="https://img.shields.io/badge/日本語-d9d9d9"></a>
</div>



https://github.com/user-attachments/assets/bd5d5f64-540f-4793-a801-17fa96c4766e




Chat2DBはAI機能を統合したインテリジェントで汎用的なSQLクライアントおよびデータ報告ツールです。Chat2DBは、SQLクエリの作成を迅速化し、データベースの管理、レポートの生成、データの探索、および複数のデータベースとのインタラクションをサポートします。Chat2DBはオープンソースプロジェクトであり、皆様の貢献を歓迎します。

**1. インテリジェントSQL生成**:  
Chat2DB Proは、AI駆動によるインテリジェントなSQL開発をサポートし、SQLクエリをより速く作成する手助けをします。

**2. データベース管理**:  
MySQL、PostgreSQL、H2、Oracle、SQLServer、SQLite、MariaDB、ClickHouse、DM、Presto、DB2、OceanBase、Hive、KingBase、MongoDB、Redis、Snowflakeなど、10種類以上のデータベースをサポートしています。

**3. インテリジェントレポート生成**:  
Chat2DB Proは、AI駆動によるインテリジェントなデータ報告をサポートし、ダッシュボードの作成を迅速に行う手助けをします。

**4. データ構造の同期**:  
Chat2DB Proは、データベーステーブル構造の同期をサポートし、データベーステーブルの構造を迅速に同期する手助けをします。

## 機能比較

<table style="width: 100%;">
  <tr>
    <th align="center">機能</th>
    <th align="center">コミュニティ オープンソース</th>
    <th align="center">ローカル</th>
    <th align="center">Pro</th>
  </tr>
  <tr>
    <td align="center">データベースの種類</td>
    <td align="center">16種類以上</td>
    <td align="center">100種類以上を対象</td>
    <td align="center">100種類以上を対象</td>
  </tr>
  <tr>
    <td align="center">サポートされているAI</td>
    <td align="center">AI設定が必要</td>
    <td align="center">インストール時にAIが利用可能</td>
    <td align="center">インストール時にAIが利用可能</td>
  </tr>
  <tr>
    <td align="center">AI機能</td>
    <td align="center">基本的</td>
    <td align="center">多様</td>
    <td align="center">多様</td>
  </tr>
  <tr>
    <td align="center">視覚的テーブルエディタ</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">SQLコンソール</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">SQLフォーマット</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">クエリ記録の保存</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">テーマカラー設定</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">データ構造の同期</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">データベースのグループ化</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">データベース構造のインポート/エクスポート</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">データのインポート/エクスポート</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">データ移行</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">テーブルのコピー/削除</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">SQLファイルのオープンと実行</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">UMLダイアグラム</td>
    <td align="center">❌</td>
    <td align="center">開発中</td>
    <td align="center">開発中</td>
  </tr>
  <tr>
    <td align="center">コード生成</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">インサート/アップデートとして結果をコピー</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">クエリ結果の修正</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">インテリジェントSQLエディタ</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">AIによるテーブル作成</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">AIデータセット</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Chat2Excel</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">インテリジェントダッシュボード</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">エディタ設定</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">カスタムショートカット</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">クロスデバイス使用</td>
    <td align="center">❌</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
  </tr>
</table>


## ダウンロードとインストール
Chat2DBは、Windows、MacOS、Linuxをサポートするクロスプラットフォームアプリケーションです。以下のリンクからChat2DBをダウンロードできます：
- [Proバージョンのダウンロード](https://chat2db.ai/download)
- [ローカルバージョンのダウンロード](https://chat2db.ai/download)
- [オープンソースバージョンのダウンロード](https://github.com/CodePhiliaX/Chat2DB/releases/tag/v0.3.6)

## コミュニティエディションのDockerインストール

### システム要件

Chat2DBをインストールする前に、システムが以下の要件を満たしていることを確認してください：
- Docker 19.03.0以上
- Docker Compose 1.25.0以上
- CPU >= 2コア
- RAM >= 4 GiB

```bash
  docker rm chat2db
  
  docker run --name=chat2db -ti -p 10824:10824 -v ~/.chat2db-docker:/root/.chat2db  chat2db/chat2db:latest

  docker start chat2db
```
## コードデバッグ

## 実行環境

注意： ローカルデバッグが必要な場合：

- Java runtime: <a href="https://adoptopenjdk.net/" target="_blank">Open JDK 17</a>
- Node.js runtime: Node 16 <a href="https://nodejs.org/" target="_blank">Node.js</a>.

**リポジトリをローカルにクローン**

```bash
$ git clone git@github.com:chat2db/Chat2DB.git
```

**フロントエンドデバッグ**

```bash
Node version must be 16 or higher  
Use yarn only, npm is not supported
$ cd Chat2DB/chat2db-client
$ yarn
$ yarn run start:web
```

**バックエンドデバッグ**

```bash
$ cd ../chat2db-server
$ mvn clean install # Maven version 3.8 or higher is required
$ cd chat2db-server/chat2db-server-start/target/
$ java -jar -Dloader.path=./lib -Dchatgpt.apiKey=xxxxx chat2db-server-start.jar  # 需要安装java 17以上版本，启动应用 chatgpt.apiKey 需要输入ChatGPT的key,如果不输入无法使用AIGC功能
```
**スタンドアロンデプロイ**
```bash
# chat2db-client
$ npm run build:web:prod 
$ cp -r dist ../chat2db-server/chat2db-server-start/src/main/resources/static/front 
$ cp -r dist/index.html ../chat2db-server/chat2db-server-start/src/main/resources/thymeleaf
```

## お問い合わせ

- メール: Chat2DB@ch2db.com
- Discord: [Discordサーバーに参加](https://discord.gg/JDkwB6JS8A)
- Twitter: [@Chat2DB](https://x.com/Chat2DB_AI)
- YouTube: [Chat2DB チャンネル](https://www.youtube.com/@chat2db.tutorial)
- GitHub: [Chat2DB GitHub](https://github.com/codePhiliaX/chat2db)

## 謝辞

Chat2DBに貢献してくださったすべての方々に感謝します~~



<a href="https://github.com/chat2db/Chat2DB/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=chat2db/Chat2DB" />
</a>

## Star History

<a href="https://star-history.com/#CodePhiliaX/chat2db&Date">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date&theme=dark" />
    <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date" />
    <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date" />
  </picture>
</a>

## License
このソフトウェアで使用されている主なライセンスは[Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)であり、[Chat2DB License](./Chat2DB_LICENSE)が補完されています。


