<div align="center">
    <a href="https://trendshift.io/repositories/11808" target="_blank"><img src="https://trendshift.io/api/badge/repositories/11808" alt="CodePhiliaX%2FChat2DB | Trendshift" style="width: 250px; height: 55px;" width="250" height="55"/>
</div>
<br/>
        
<div align="center">
  
[![ReadmeX][readmex-image]][readmex-url]
[![Discord][discord-image]][discord-url]
[![Twitter][twitter-image]][twitter-url]
[![Telegram][telegram-image]][telegram-url]
[![Whatsapp][whatsapp-image]][whatsapp-url]
[![Reddit][reddit-image]][reddit-url]
[![Gmail][gmail-image]][gmail-url]

[readmex-image]: https://raw.githubusercontent.com/CodePhiliaX/resource-trusteeship/main/readmex.svg
[readmex-url]: https://readmex.com/CodePhiliaX/Chat2DB
[discord-image]: https://img.shields.io/badge/-Join%20us%20on%20Discord-%237289DA.svg?style=flat&logo=discord&logoColor=white
[discord-url]: https://discord.com/invite/uNjb3n5JVN
[twitter-image]: https://img.shields.io/twitter/follow/_Chat2DB?label=Chat2DB
[twitter-url]: https://twitter.com/intent/tweet?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.&url=https://github.com/chat2db/Chat2DB&hashtags=ChatGPT,AGI,SQL%20Client,Reporting%20tool
[telegram-image]: https://img.shields.io/twitter/url?label=Telegram&logo=Telegram&style=social&url=https://github.com/chat2db/Chat2DB
[telegram-url]: https://t.me/share/url?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.&url=https://github.com/chat2db/Chat2DB
[whatsapp-image]: https://img.shields.io/twitter/url?label=whatsapp&logo=whatsapp&style=social&url=https://github.com/chat2db/Chat2DB
[whatsapp-url]: https://api.whatsapp.com/send?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.%20https://github.com/chat2db/Chat2DB
[reddit-image]: https://img.shields.io/twitter/url?label=Reddit&logo=Reddit&style=social&url=https://github.com/chat2db/Chat2DB
[reddit-url]: https://www.reddit.com/submit?url=https://github.com/chat2db/Chat2DB&title=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.
[gmail-image]: https://img.shields.io/twitter/url?label=Gmail&logo=Gmail&style=social&url=https://github.com/chat2db/Chat2DB
[gmail-url]: mailto:?subject=Check%20this%20GitHub%20repository%20out.&body=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.%3A%0Ahttps://github.com/chat2db/Chat2DB

</div>

<div align="center">
  <a href="./README.md"><img alt="README in English" src="https://img.shields.io/badge/English-d9d9d9"></a>
  <a href="./README_CN.md"><img alt="简体中文版自述文件" src="https://img.shields.io/badge/简体中文-d9d9d9"></a>
  <a href="./README_JA.md"><img alt="日本語のREADME" src="https://img.shields.io/badge/日本語-d9d9d9"></a>
 
</div>




https://github.com/user-attachments/assets/3c857883-8153-4bda-92b8-d25c6adb5b13



# 
Chat2DB 是一个智能的通用SQL客户端和数据报表工具，它集成了AI的能力。Chat2DB可以帮助您更快地编写SQL查询、管理数据库、生成报告、探索数据、并且可以与多种数据库进行交互。Chat2DB是一个开源项目，我们欢迎您的贡献。

**1. 智能生成SQL**:
Chat2DB Pro支持AI驱动的智能SQL开发，可以帮助您更快地编写SQL查询。


**2. 数据库管理**:
 支持多种10+数据库，包括MySQL、PostgreSQL、H2、Oracle、SQLServer、SQLite、MariaDB、ClickHouse、DM、Presto、DB2、OceanBase、Hive、KingBase、MongoDB、Redis、Snowflake等。



**3. 智能生成报表**:
    Chat2DB Pro支持AI驱动的智能数据报表，可以帮助您更快地生成看板。

**4. 数据结构同步**:
    Chat2DB Pro支持数据库表结构同步，可以帮助您更快地同步数据库表结构。

## 功能比较

<table style="width: 100%;">
  <tr>
    <th align="center">功能</th>
    <th align="center">社区开源版</th>
    <th align="center">Local版(收费)</th>
    <th align="center">Pro版(收费)</th>
  </tr>
  <tr>
    <td align="center">数据库类型</td>
    <td align="center">16+</td>
    <td align="center">目标100+</td>
    <td align="center">目标100+</td>
  </tr>
  <tr>
    <td align="center">支持的 AI</td>
    <td align="center">需要配置AI</td>
    <td align="center">安装即可使用AI</td>
    <td align="center">安装即可使用AI</td>
  </tr>
  <tr>
    <td align="center">AI 能力</td>
    <td align="center">简单</td>
    <td align="center">多样</td>
    <td align="center">多样</td>
  </tr>
  <tr>
    <td align="center">可视化编辑表</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">SQL控制台</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
 <tr>
    <td align="center">SQL格式化</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
 <tr>
    <td align="center">保存查询记录</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
 <tr>
    <td align="center">主题颜色设置</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">数据结构同步</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">数据库分组</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">数据库结构导入导出</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">数据导入导出</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">数据迁移</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">复制/清空表</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">打开运行SQL文件</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">UML图</td>
    <td align="center">❌</td>
    <td align="center">开发中</td>
    <td align="center">开发中</td>
  </tr>
  <tr>
    <td align="center">生成代码</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">复制结果为
Insert/update
    </td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">修改查询结果</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">智能SQL编辑器</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">AI建表</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">AI数据集</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Chat2Excel</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
<tr>
    <td align="center">智能看板</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
<tr>
    <td align="center">编辑器设置</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
<tr>
    <td align="center">自定义快捷键</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
<tr>
    <td align="center">跨多设备使用</td>
    <td align="center">❌</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
  </tr>
</table>

## 下载安装
Chat2DB 是一个跨平台的应用程序，支持Windows、MacOS和Linux。您可以从以下链接下载Chat2DB。
- [下载 Pro 版](https://chat2db.ai/download)
- [下载 Local 版](https://chat2db.ai/download)
- [下载开源版](https://github.com/CodePhiliaX/Chat2DB/releases/tag/v0.3.6)

## 社区版 Docker 安装

### 系统要求

在安装 Chat2DB 之前，请确保您的系统满足以下要求：
- Docker 19.03.0 或更高版本
- Docker Compose 1.25.0 或更高版本
- CPU >= 2 Core
- RAM >= 4 GiB


```bash
  // 拉取最新客户端,然后运行docker,名字是 `chat2db` , 并且将 `/root/.chat2db` 挂载到 `~/.chat2db-docker`
  docker run --name=chat2db -ti -p 10824:10824 -v ~/.chat2db-docker:/root/.chat2db  chat2db/chat2db:latest
  // 这里正常会提示`Tomcat started on port(s): 10824 (http) with context path` 就可以结束了

  // 如果这里提示  `The container name "/chat2db" is already in use by container`, 代表已经存在容器了 运行
  docker start chat2db
  // 如果想更新chat2db 则需要先rm
  docker rm chat2db
```
## 代码调试


## 运行环境

注意：
如果需要本地调试

- java 运行 <a href="https://adoptopenjdk.net/" target="_blank">Open JDK 17</a>
- Node 运行环境 Node16 <a href="https://nodejs.org/" target="_blank">Node.js</a>.

**git clone 到本地**

```bash
$ git clone git@github.com:chat2db/Chat2DB.git
```

**前端调试**

```bash
node版本必须为16及以上 
一定要用yarn
$ cd Chat2DB/chat2db-client
$ yarn
$ yarn run start:web
```

**后端调试**

```bash
$ cd ../chat2db-server
$ mvn clean install # 需要安装maven 3.8以上版本
$ cd chat2db-server/chat2db-server-start/target/
$ java -jar -Dloader.path=./lib -Dchatgpt.apiKey=xxxxx chat2db-server-start.jar  # 需要安装java 17以上版本，启动应用 chatgpt.apiKey 需要输入ChatGPT的key,如果不输入无法使用AIGC功能
```
**独立部署**
```bash
# chat2db-client
$ npm run build:web:prod 
$ cp -r dist ../chat2db-server/chat2db-server-start/src/main/resources/static/front 
$ cp -r dist/index.html ../chat2db-server/chat2db-server-start/src/main/resources/thymeleaf

# 再打包后端服务
```

##  联系我们

<a><img src="https://github.com/chat2db/Chat2DB/assets/22975773/81d13eff-c615-49f5-aee3-4107089593e0" width="25%"/></a>

- Email: Chat2DB@ch2db.com
- Discord: [Join our Discord server](https://discord.gg/JDkwB6JS8A)
- Twitter: [@Chat2DB](https://x.com/Chat2DB_AI)
- YouTube: [Chat2DB Channel](https://www.youtube.com/@chat2db.tutorial)
- GitHub: [Chat2DB GitHub](https://github.com/codePhiliaX/chat2db)


##  致谢

感谢所有为 Chat2DB 贡献力量的同学们~~

<a href="https://github.com/chat2db/Chat2DB/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=chat2db/Chat2DB" />
</a>

## Star History

<a href="https://star-history.com/#CodePhiliaX/chat2db&Date">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date&theme=dark" />
    <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date" />
    <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date" />
  </picture>
</a>

## License
The primary license used by this software is the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0), supplemented by the [Chat2DB License](./Chat2DB_LICENSE).



