/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.collection;

import java.util.Collection;
import java.util.Iterator;
import net.infonode.util.collection.Closure;

public final class CopyOnWriteArrayList {
    private Object[] elements;
    private int size;

    public CopyOnWriteArrayList(int n) {
        this.elements = new Object[n];
    }

    public void removeAll(Collection collection) {
        Object[] objectArray = new Object[this.size - collection.size()];
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            if (collection.contains(this.elements[i])) continue;
            objectArray[n++] = this.elements[i];
        }
        this.size = n;
        this.elements = objectArray;
    }

    public void add(Object object) {
        if (this.size >= this.elements.length) {
            Object[] objectArray = new Object[CopyOnWriteArrayList.getPreferredSize(this.size)];
            System.arraycopy(this.elements, 0, objectArray, 0, this.size);
            this.elements = objectArray;
        }
        this.elements[this.size++] = object;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public void remove(int n) {
        --this.size;
        Object[] objectArray = new Object[CopyOnWriteArrayList.getPreferredSize(this.size)];
        System.arraycopy(this.elements, 0, objectArray, 0, n);
        System.arraycopy(this.elements, n + 1, objectArray, n, this.size - n);
        this.elements = objectArray;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i] != object) continue;
            return i;
        }
        return -1;
    }

    public void each(Closure closure) {
        Object[] objectArray = this.elements;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            closure.apply(objectArray[i]);
        }
    }

    public Iterator iterator() {
        return new IteratorImpl(this.elements, this.size, 0);
    }

    private static int getPreferredSize(int n) {
        return n * 3 / 2 + 1;
    }

    public int size() {
        return this.size;
    }

    public Object get(int n) {
        return this.elements[n];
    }

    public Object[] getElements() {
        return this.elements;
    }

    private static class IteratorImpl
    implements Iterator {
        private Object[] e;
        private int size;
        private int index;

        IteratorImpl(Object[] objectArray, int n, int n2) {
            this.e = objectArray;
            this.size = n;
            this.index = n2;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.size;
        }

        public Object next() {
            return this.e[this.index++];
        }
    }
}

