/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.lang;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MagicInt
implements Comparable<MagicInt> {
    private final int value;

    public MagicInt(int value) {
        this.value = value;
    }

    public MagicInt(int value, ByteOrder bo) {
        this.value = ByteBuffer.allocate(4).order(bo).putInt(0, value).order(ByteOrder.BIG_ENDIAN).getInt(0);
    }

    public MagicInt(String value) {
        this.value = MagicInt.stringToMagic(value);
    }

    public static int stringToMagic(String value) {
        if (value.length() != 4) {
            throw new StringIndexOutOfBoundsException(String.format("'%s' is not a valid type string (must be exactly 4 characters long)", value));
        }
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            bytes[i] = (byte)value.charAt(i);
            ++i;
        }
        return ByteBuffer.wrap(bytes).getInt(0);
    }

    public static String magicToString(int value) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(0, value).array();
        char[] chars = new char[4];
        int i = 0;
        while (i < 4) {
            chars[i] = (char)bytes[i];
            ++i;
        }
        return new String(chars);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MagicInt other = (MagicInt)obj;
        return this.value == other.value;
    }

    public String toString() {
        return MagicInt.magicToString(this.value);
    }

    public int toInt() {
        return this.value;
    }

    public int toInt(ByteOrder bo) {
        return ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN).putInt(0, this.value).order(bo).getInt(0);
    }

    @Override
    public int compareTo(MagicInt o) {
        return this.value - o.value;
    }
}

