/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.blizzard.blp.BLPEncodingType;
import com.hiveworkshop.blizzard.blp.BLPIndexColorModel;
import com.hiveworkshop.blizzard.blp.BLPPackedSampleModel;
import com.hiveworkshop.blizzard.blp.MipmapProcessor;
import com.hiveworkshop.lang.LocalizedFormatedString;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class IndexedMipmapProcessor
extends MipmapProcessor {
    private BLPIndexColorModel indexedBLPColorModel = null;
    private final int[] bandSizes;

    public IndexedMipmapProcessor(int alphaBits) {
        int[] nArray;
        if (!BLPEncodingType.INDEXED.isAlphaBitsValid(alphaBits)) {
            throw new IllegalArgumentException("Unsupported alphaBits.");
        }
        if (alphaBits != 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = 8;
            nArray = nArray2;
            nArray2[1] = alphaBits;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 8;
        }
        this.bandSizes = nArray;
        this.indexedBLPColorModel = new BLPIndexColorModel(null, this.bandSizes.length > 1 ? this.bandSizes[1] : 0);
    }

    @Override
    public byte[] encodeMipmap(BufferedImage img, ImageWriteParam param, Consumer<LocalizedFormatedString> handler) throws IOException {
        WritableRaster srcWR = img.getRaster();
        ColorModel srcCM = img.getColorModel();
        SampleModel srcSM = srcWR.getSampleModel();
        int h = srcSM.getHeight();
        int w = srcSM.getWidth();
        if (!this.canDecode) {
            if (srcCM instanceof BLPIndexColorModel) {
                BLPIndexColorModel blpICM = (BLPIndexColorModel)srcCM;
                this.indexedBLPColorModel = new BLPIndexColorModel(blpICM.getColorMap(), this.bandSizes.length > 1 ? this.bandSizes[1] : 0);
            } else if (srcCM instanceof IndexColorModel) {
                IndexColorModel iCM = (IndexColorModel)srcCM;
                int[] srcCMap = new int[iCM.getMapSize()];
                iCM.getRGBs(srcCMap);
                ColorModel srcCMapCM = ColorModel.getRGBdefault();
                ColorModel destCMapCM = BLPIndexColorModel.CMAP_COLORMODEL;
                int[] destCMap = new int[srcCMap.length];
                int[] components = new int[srcCMapCM.getNumColorComponents()];
                int i = 0;
                while (i < srcCMap.length) {
                    destCMap[i] = destCMapCM.getDataElement(srcCMapCM.getComponents(srcCMap[i], components, 0), 0);
                    ++i;
                }
                this.indexedBLPColorModel = new BLPIndexColorModel(destCMap, this.bandSizes.length > 1 ? this.bandSizes[1] : 0);
            } else {
                throw new IIOException("Cannot obtain sensible color map from ColorModel.");
            }
            this.canDecode = true;
        }
        BLPPackedSampleModel destSM = new BLPPackedSampleModel(w, h, this.bandSizes, null);
        DataBuffer destDB = ((SampleModel)destSM).createDataBuffer();
        WritableRaster destWR = WritableRaster.createWritableRaster(destSM, destDB, null);
        boolean hasAlpha = this.bandSizes.length > 1;
        boolean srcHasAlpha = hasAlpha && srcSM.getNumBands() > 1;
        boolean rescaleAlpha = srcHasAlpha && srcSM.getSampleSize(1) != this.bandSizes[1];
        int alphaMask = hasAlpha ? (1 << this.bandSizes[1]) - 1 : 0;
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                destWR.setSample(x, y, 0, srcWR.getSample(x, y, 0));
                if (hasAlpha) {
                    if (srcHasAlpha) {
                        int alphaSample = srcWR.getSample(x, y, 1);
                        if (rescaleAlpha) {
                            alphaSample = (int)((float)alphaMask * (float)alphaSample / (float)(srcSM.getSampleSize(1) - 1));
                        }
                        destWR.setSample(x, y, 1, alphaSample);
                    } else {
                        destWR.setSample(x, y, 1, alphaMask);
                    }
                }
                ++x;
            }
            ++y;
        }
        return ((DataBufferByte)srcWR.getDataBuffer()).getData();
    }

    @Override
    public BufferedImage decodeMipmap(byte[] mmData, ImageReadParam param, int width, int height, Consumer<LocalizedFormatedString> handler) throws IOException {
        BLPPackedSampleModel sm = new BLPPackedSampleModel(width, height, this.bandSizes, null);
        int expected = sm.getBufferSize();
        if (mmData.length != expected) {
            handler.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "BadBuffer", mmData.length, expected));
            mmData = Arrays.copyOf(mmData, expected);
        }
        DataBufferByte db = new DataBufferByte(mmData, mmData.length);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        BufferedImage img = new BufferedImage(this.indexedBLPColorModel, raster, false, null);
        return img;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getSupportedImageTypes(int width, int height) {
        return Arrays.asList(new ImageTypeSpecifier(this.indexedBLPColorModel, new BLPPackedSampleModel(width, height, this.bandSizes, null))).iterator();
    }

    @Override
    public void readObject(ImageInputStream src, Consumer<LocalizedFormatedString> warning) throws IOException {
        src.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int[] cmap = new int[256];
        src.readFully(cmap, 0, cmap.length);
        this.indexedBLPColorModel = new BLPIndexColorModel(cmap, this.bandSizes.length > 1 ? this.bandSizes[1] : 0);
        this.canDecode = true;
    }

    @Override
    public void writeObject(ImageOutputStream dst) throws IOException {
        dst.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int[] cmap = this.indexedBLPColorModel.getColorMap();
        dst.writeInts(cmap, 0, cmap.length);
    }
}

