/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.blizzard.blp.BLPCommon;
import com.hiveworkshop.blizzard.blp.BLPEncodingType;
import com.hiveworkshop.lang.LocalizedFormatedString;
import com.hiveworkshop.lang.MagicInt;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public final class BLPStreamMetadata
extends IIOMetadata {
    public static final int LEGACY_MAX_DIMENSION = 512;
    private int version = 1;
    private ContentType contentType;
    private PixmapType pixmapType;
    private SampleType sampleType;
    private byte alphaBits;
    private boolean hasMipmaps;
    private int width;
    private int height;
    private int extra;
    private Consumer<LocalizedFormatedString> warning;

    public BLPStreamMetadata() {
        this.setEncoding(BLPEncodingType.JPEG, (byte)0);
        this.hasMipmaps = true;
        this.width = 1;
        this.height = 1;
        this.extra = 6;
        this.setWarningHandler(null);
    }

    private static void warn(LocalizedFormatedString msg) {
        Logger.getLogger(BLPStreamMetadata.class.getName()).warning(msg.toString());
    }

    public void setWarningHandler(Consumer<LocalizedFormatedString> handler) {
        if (handler == null) {
            handler = BLPStreamMetadata::warn;
        }
        this.warning = handler;
    }

    public BLPEncodingType getEncodingType() {
        if (this.contentType == ContentType.JPEG && this.pixmapType == PixmapType.NONE) {
            return BLPEncodingType.JPEG;
        }
        if (this.contentType == ContentType.DIRECT && this.pixmapType == PixmapType.INDEXED) {
            return BLPEncodingType.INDEXED;
        }
        return BLPEncodingType.UNKNOWN;
    }

    public byte getAlphaBits() {
        return this.alphaBits;
    }

    public void setEncoding(BLPEncodingType encodingType, byte alphaBits) {
        if (encodingType == BLPEncodingType.UNKNOWN) {
            throw new IllegalArgumentException("cannot use UNKNOWN encodingType");
        }
        if (!encodingType.isAlphaBitsValid(alphaBits)) {
            throw new IllegalArgumentException("encodingType does not support alphaBits");
        }
        if (encodingType.minVersion > this.version) {
            throw new IllegalArgumentException("version does not support encodingType");
        }
        switch (encodingType) {
            default: {
                this.contentType = ContentType.JPEG;
                this.pixmapType = PixmapType.NONE;
                this.sampleType = SampleType.DXT1;
                break;
            }
            case INDEXED: {
                this.contentType = ContentType.DIRECT;
                this.pixmapType = PixmapType.INDEXED;
                this.sampleType = SampleType.DXT1;
            }
        }
        this.alphaBits = alphaBits;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        if (version < 0 || 2 < version) {
            throw new IllegalArgumentException("versions 0 to 2 supported");
        }
        this.version = version;
    }

    public boolean hasMipmaps() {
        return this.hasMipmaps;
    }

    public void setMipmaps(boolean hasMipmaps) {
        this.hasMipmaps = hasMipmaps;
    }

    private static int scaleImageDimension(int dimension, int level) {
        return Math.max(dimension >>> level, 1);
    }

    public int getWidth() {
        return this.width;
    }

    public int getWidth(int level) {
        return BLPStreamMetadata.scaleImageDimension(this.width, level);
    }

    public void setWidth(int width) {
        if (width < 1 || this.getDimensionMaximum() < width) {
            throw new IllegalArgumentException("Invalid dimension size.");
        }
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getHeight(int level) {
        return BLPStreamMetadata.scaleImageDimension(this.height, level);
    }

    public void setHeight(int height) {
        if (height < 1 || this.getDimensionMaximum() < height) {
            throw new IllegalArgumentException("Invalid dimension size.");
        }
        this.height = height;
    }

    public int getDimensionMaximum() {
        if (this.version < 1) {
            return 512;
        }
        return 65535;
    }

    public int getMipmapCount() {
        return this.hasMipmaps ? 32 - Integer.numberOfLeadingZeros(Math.max(this.width, this.height)) : 1;
    }

    public void readObject(ImageInputStream src) throws IOException {
        long heightU;
        long widthU;
        ContentType[] ctvalues;
        src.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.version = BLPCommon.resolveVersion(new MagicInt(src.readInt(), ByteOrder.LITTLE_ENDIAN));
        if (this.version == -1) {
            throw new IIOException("Not valid BLP file magic.");
        }
        int content = src.readInt();
        if (content >= (ctvalues = ContentType.values()).length || content < 0) {
            ContentType defaultContentType = ContentType.JPEG;
            this.warning.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "BadContent", content, defaultContentType.name()));
            content = defaultContentType.ordinal();
        }
        this.contentType = ctvalues[content];
        if (this.version < 2) {
            this.alphaBits = (byte)src.readInt();
            this.pixmapType = PixmapType.values()[this.contentType.ordinal()];
            this.sampleType = SampleType.DXT1;
        } else {
            SampleType[] stvalues;
            PixmapType[] ptvalues;
            int pixmap = src.readByte() & 0xFF;
            if (pixmap >= (ptvalues = PixmapType.values()).length) {
                throw new IIOException(String.format("pixmap type %#0X is invalid", pixmap));
            }
            this.pixmapType = ptvalues[pixmap];
            this.alphaBits = src.readByte();
            int sample = src.readByte() & 0xFF;
            if (sample >= (stvalues = SampleType.values()).length) {
                throw new IIOException(String.format("sample type %#0X is invalid", (byte)sample));
            }
            this.sampleType = SampleType.values()[sample];
            this.hasMipmaps = src.readByte() != 0;
        }
        BLPEncodingType encodingType = this.getEncodingType();
        if (encodingType == BLPEncodingType.UNKNOWN) {
            this.warning.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "BadEncoding", this.contentType.name(), this.pixmapType.name(), this.sampleType.name()));
        }
        if (!encodingType.isAlphaBitsValid(this.alphaBits)) {
            boolean defaultAlphaBits = false;
            this.warning.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "BadAlpha", this.alphaBits, 0));
            this.alphaBits = 0;
        }
        this.width = src.readInt();
        this.height = src.readInt();
        int maxDim = this.getDimensionMaximum();
        if ((long)maxDim < Math.max(widthU = (long)this.width & 0xFFFFFFFFL, heightU = (long)this.height & 0xFFFFFFFFL)) {
            if (this.version < 1) {
                throw new IIOException(String.format("Invalid image dimensions %d*%d pixels.", this.width, this.height));
            }
            long oldWidth = widthU;
            long oldHeight = heightU;
            this.width = (int)Math.min(widthU, (long)maxDim);
            this.height = (int)Math.min(heightU, (long)maxDim);
            this.warning.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "BadDimension", oldWidth, oldHeight, this.width, this.height));
        }
        if (this.version < 2) {
            this.extra = src.readInt();
            this.hasMipmaps = src.readInt() != 0;
        }
        int bigDim = Math.max(this.width, this.height);
        if (this.version < 2 && 512 < bigDim) {
            int i = 0;
            while (512 < bigDim) {
                ++i;
                bigDim >>>= 1;
            }
            this.warning.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "WastefulDimension", i));
        }
    }

    public void writeObject(ImageOutputStream dst) throws IOException {
        dst.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        dst.writeInt(BLPCommon.resolveMagic(this.version).toInt(ByteOrder.LITTLE_ENDIAN));
        dst.writeInt(this.contentType.ordinal());
        if (this.version < 2) {
            dst.writeInt(this.alphaBits & 0xFF);
        } else {
            dst.writeByte(this.pixmapType.ordinal());
            dst.writeByte(this.alphaBits);
            dst.writeByte(this.sampleType.ordinal());
            dst.writeByte(this.hasMipmaps ? 1 : 0);
        }
        dst.writeInt(this.width);
        dst.writeInt(this.height);
        if (this.version < 2) {
            dst.writeInt(this.extra);
            dst.writeInt(this.hasMipmaps ? 1 : 0);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String formatName) {
        throw new IllegalArgumentException("no formats are supported");
    }

    @Override
    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new IllegalStateException();
    }

    @Override
    public void reset() {
        throw new IllegalStateException();
    }

    public String toString() {
        return "{BLP Stream Metadata: Version = " + this.version + ", width = " + this.width + ", height = " + this.height + ", content = " + (Object)((Object)this.contentType) + ", pixmap = " + (Object)((Object)this.pixmapType) + ", sample = " + (Object)((Object)this.sampleType) + ", alpha bits = " + this.alphaBits + ", mipmaps = " + this.hasMipmaps + ", extra = " + this.extra + "}";
    }

    public static enum ContentType {
        JPEG,
        DIRECT;

    }

    public static enum PixmapType {
        NONE,
        INDEXED,
        SAMPLED,
        BGRA,
        BGRA_2;

    }

    public static enum SampleType {
        DXT1,
        DXT3,
        BGRA8888,
        BGRA5551,
        BGRA4444,
        BGR565,
        UNKNOWN1,
        DXT5,
        UNKNOWN2,
        BGRA2565;

    }
}

