/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.blizzard.blp.BLPEncodingType;
import com.hiveworkshop.blizzard.blp.BLPReadParam;
import com.hiveworkshop.blizzard.blp.BLPStreamMetadata;
import com.hiveworkshop.blizzard.blp.ExternalMipmapManager;
import com.hiveworkshop.blizzard.blp.IndexedMipmapProcessor;
import com.hiveworkshop.blizzard.blp.InternalMipmapManager;
import com.hiveworkshop.blizzard.blp.JPEGMipmapProcessor;
import com.hiveworkshop.blizzard.blp.MipmapProcessor;
import com.hiveworkshop.lang.LocalizedFormatedString;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class BLPReader
extends ImageReader {
    private BLPStreamMetadata streamMeta = null;
    private ImageInputStream intSrc = null;
    private MipmapReader mipmapReader;
    private MipmapProcessor mipmapProcessor = null;

    public String tempGetInfo() throws IOException {
        this.loadHeader();
        return this.streamMeta.toString();
    }

    public BLPReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    private void loadHeader() throws IOException {
        MipmapReader mipmapReader;
        ImageInputStream src;
        if (this.streamMeta != null) {
            return;
        }
        if (this.input == null) {
            throw new IllegalStateException("no input source has been set");
        }
        Path path = null;
        if (this.input instanceof Path) {
            path = (Path)this.input;
        } else if (this.input instanceof File) {
            path = ((File)this.input).toPath();
        }
        if (this.input instanceof ImageInputStream) {
            src = (ImageInputStream)this.input;
        } else if (path != null) {
            this.intSrc = new FileImageInputStream(path.toFile());
            if (this.intSrc == null) {
                throw new IllegalStateException("Cannot create ImageInputStream from path.");
            }
            src = this.intSrc;
        } else {
            throw new IllegalStateException("bad input state");
        }
        src.seek(0L);
        BLPStreamMetadata streamMeta = new BLPStreamMetadata();
        streamMeta.setWarningHandler(this::processWarningOccurred);
        streamMeta.readObject(src);
        if (streamMeta.getVersion() > 0) {
            final InternalMipmapManager imm = new InternalMipmapManager();
            imm.readObject(src);
            final BLPReader thisref = this;
            mipmapReader = new MipmapReader(){

                @Override
                public byte[] getMipmapDataChunk(int mipmap) throws IOException {
                    return imm.getMipmapDataChunk(src, mipmap, thisref::processWarningOccurred);
                }

                @Override
                public void flushTo(int mipmap) throws IOException {
                    imm.flushToMipmap(src, mipmap);
                }
            };
        } else if (path != null) {
            final ExternalMipmapManager emm = new ExternalMipmapManager(path);
            mipmapReader = new MipmapReader(){

                @Override
                public byte[] getMipmapDataChunk(int mipmap) throws IOException {
                    return emm.getMipmapDataChunk(mipmap);
                }
            };
        } else {
            throw new IIOException("BLP0 image can only be loaded from Path or File input.");
        }
        if (streamMeta.getEncodingType() == BLPEncodingType.JPEG) {
            this.mipmapProcessor = new JPEGMipmapProcessor(streamMeta.getAlphaBits());
        } else if (streamMeta.getEncodingType() == BLPEncodingType.INDEXED) {
            this.mipmapProcessor = new IndexedMipmapProcessor(streamMeta.getAlphaBits());
        } else {
            throw new IIOException("Unsupported content type.");
        }
        this.mipmapProcessor.readObject(src, this::processWarningOccurred);
        if (this.seekForwardOnly) {
            mipmapReader.flushTo(0);
        }
        this.streamMeta = streamMeta;
        this.mipmapReader = mipmapReader;
    }

    private void checkImageIndex(int imageIndex) {
        if (this.streamMeta.getMipmapCount() <= imageIndex) {
            throw new IndexOutOfBoundsException(String.format("Mipmap level does not exist: %d.", imageIndex));
        }
        if (imageIndex < this.minIndex) {
            throw new IndexOutOfBoundsException(String.format("Violation of seekForwardOnly: at %d wanting %d.", this.minIndex, imageIndex));
        }
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (this.intSrc != null) {
            try {
                this.intSrc.close();
            }
            catch (IOException e) {
                this.processWarningOccurred(new LocalizedFormatedString("com.hiveworkshop.text.blp", "ISCloseFail", e.getMessage()));
            }
            this.intSrc = null;
        }
        this.streamMeta = null;
        this.mipmapReader = null;
    }

    protected void processWarningOccurred(LocalizedFormatedString msg) {
        if (this.warningListeners == null) {
            return;
        }
        if (msg == null) {
            throw new IllegalArgumentException("msg is null.");
        }
        int numListeners = this.warningListeners.size();
        int i = 0;
        while (i < numListeners) {
            IIOReadWarningListener listener = (IIOReadWarningListener)this.warningListeners.get(i);
            Locale locale = (Locale)this.warningLocales.get(i);
            if (locale == null) {
                locale = Locale.getDefault();
            }
            listener.warningOccurred(this, msg.toString(locale));
            ++i;
        }
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.loadHeader();
        this.checkImageIndex(imageIndex);
        return this.streamMeta.getHeight(imageIndex);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return null;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.loadHeader();
        this.checkImageIndex(imageIndex);
        return this.mipmapProcessor.getSupportedImageTypes(this.streamMeta.getWidth(imageIndex), this.streamMeta.getHeight(imageIndex));
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        this.loadHeader();
        return this.streamMeta.getMipmapCount();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        this.loadHeader();
        return this.streamMeta;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.loadHeader();
        this.checkImageIndex(imageIndex);
        return this.streamMeta.getWidth(imageIndex);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        BufferedImage destImg;
        this.loadHeader();
        this.checkImageIndex(imageIndex);
        if (this.seekForwardOnly && this.minIndex < imageIndex) {
            this.minIndex = imageIndex;
            this.mipmapReader.flushTo(this.minIndex);
        }
        if (!this.mipmapProcessor.canDecode()) {
            throw new IIOException("Mipmap processor cannot decode.");
        }
        this.processImageStarted(imageIndex);
        byte[] mmData = this.mipmapReader.getMipmapDataChunk(imageIndex);
        int width = this.streamMeta.getWidth(imageIndex);
        int height = this.streamMeta.getHeight(imageIndex);
        BufferedImage srcImg = this.mipmapProcessor.decodeMipmap(mmData, param, width, height, this::processWarningOccurred);
        if (param == null || param instanceof BLPReadParam && ((BLPReadParam)param).isDirectRead()) {
            destImg = srcImg;
        } else {
            destImg = BLPReader.getDestination(param, this.getImageTypes(imageIndex), width, height);
            BLPReader.checkReadParamBandSettings(param, srcImg.getSampleModel().getNumBands(), destImg.getSampleModel().getNumBands());
            Rectangle srcRegion = new Rectangle();
            Rectangle destRegion = new Rectangle();
            BLPReader.computeRegions(param, width, height, destImg, srcRegion, destRegion);
            int[] srcBands = param.getSourceBands();
            int[] destBands = param.getDestinationBands();
            int ssX = param.getSourceXSubsampling();
            int ssY = param.getSourceYSubsampling();
            WritableRaster srcRaster = srcImg.getRaster().createWritableChild(srcRegion.x, srcRegion.y, srcRegion.width, srcRegion.height, 0, 0, srcBands);
            WritableRaster destRaster = destImg.getRaster().createWritableChild(destRegion.x, destRegion.y, destRegion.width, destRegion.height, 0, 0, destBands);
            Object dataElements = null;
            int y = 0;
            while (y < destRegion.height) {
                int x = 0;
                while (x < destRegion.width) {
                    int srcXOff = ssX * x;
                    int srcYOff = ssY * y;
                    dataElements = srcRaster.getDataElements(srcXOff, srcYOff, null);
                    destRaster.setDataElements(x, y, dataElements);
                    ++x;
                }
                ++y;
            }
        }
        this.processImageComplete();
        return destImg;
    }

    @Override
    public void dispose() {
        this.setInput(null);
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new BLPReadParam();
    }

    private static abstract class MipmapReader {
        private MipmapReader() {
        }

        public abstract byte[] getMipmapDataChunk(int var1) throws IOException;

        public void flushTo(int mipmap) throws IOException {
        }
    }
}

