/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.blizzard.blp.BLPEncodingType;
import com.hiveworkshop.blizzard.blp.BLPPackedSampleModel;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public final class BLPIndexColorModel
extends ColorModel {
    private final int[] DEFAULT_COLOR_MAP;
    protected final DirectColorModel indexedColorModel;
    private final int[] colorMap;
    public static final ColorModel CMAP_COLORMODEL = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private float[] normalizedComponentCache;

    private static int resolveTransparency(int alphaBits) {
        if (alphaBits == 0) {
            return 1;
        }
        if (alphaBits == 1) {
            return 2;
        }
        return 3;
    }

    public BLPIndexColorModel(int[] cmap, int alphaBits) {
        int[] nArray;
        if (alphaBits == 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = 8;
            nArray2[1] = 8;
            nArray = nArray2;
            nArray2[2] = 8;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 8;
            nArray3[1] = 8;
            nArray3[2] = 8;
            nArray = nArray3;
            nArray3[3] = alphaBits;
        }
        super(8 + alphaBits, nArray, ColorSpace.getInstance(1004), alphaBits != 0, false, BLPIndexColorModel.resolveTransparency(alphaBits), 0);
        this.DEFAULT_COLOR_MAP = new int[256];
        this.normalizedComponentCache = null;
        if (!BLPEncodingType.INDEXED.isAlphaBitsValid(alphaBits)) {
            throw new IllegalArgumentException("Unsupported alphaBits.");
        }
        this.indexedColorModel = new DirectColorModel(ColorSpace.getInstance(1004), 24 + alphaBits, 0xFF0000, 65280, 255, (1 << alphaBits) - 1 << 24, false, 3);
        this.colorMap = cmap != null ? Arrays.copyOf(cmap, 256) : this.DEFAULT_COLOR_MAP;
    }

    private int getIndexedColor(byte index) {
        return this.colorMap[index & 0xFF] & 0xFFFFFF;
    }

    private void populateComponentCache() {
        if (this.normalizedComponentCache != null) {
            return;
        }
        int nColorComponents = this.indexedColorModel.getNumColorComponents();
        int nComponents = this.indexedColorModel.getNumComponents();
        this.normalizedComponentCache = new float[this.colorMap.length * nColorComponents];
        int[] componentCacheArray = new int[nComponents];
        float[] normCacheArray = new float[nComponents];
        int i = 0;
        while (i < this.colorMap.length) {
            int pixel = this.getIndexedColor((byte)i);
            this.indexedColorModel.getNormalizedComponents(this.indexedColorModel.getComponents(pixel, componentCacheArray, 0), 0, normCacheArray, 0);
            float[] srgbComponents = this.indexedColorModel.getColorSpace().toRGB(normCacheArray);
            int offset = i * nColorComponents;
            System.arraycopy(srgbComponents, 0, this.normalizedComponentCache, offset, nColorComponents);
            ++i;
        }
    }

    public int getBandNumber() {
        return this.hasAlpha() ? 2 : 1;
    }

    @Override
    public int[] getComponents(int pixel, int[] components, int offset) {
        components = this.indexedColorModel.getComponents(this.getIndexedColor((byte)(pixel & 0xFF)), components, offset);
        if (this.hasAlpha()) {
            components[offset + 3] = pixel >> 8 & 0xFF;
        }
        return components;
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        byte[] bytepixel = (byte[])pixel;
        components = this.indexedColorModel.getComponents(this.getIndexedColor((byte)(bytepixel[0] & 0xFF)), components, offset);
        if (this.hasAlpha()) {
            components[offset + 3] = bytepixel[1] & 0xFF;
        }
        return components;
    }

    private byte getBestIndex(float[] normComponents, int normOffset) {
        this.populateComponentCache();
        float[] lrgbComponents = Arrays.copyOfRange(normComponents, normOffset, normOffset + 3);
        float[] srgbComponents = this.indexedColorModel.getColorSpace().toRGB(lrgbComponents);
        int best = -1;
        int nComponents = this.indexedColorModel.getNumColorComponents();
        float bestDiff = Float.MAX_VALUE;
        int i = 0;
        while (i < this.colorMap.length) {
            int cacheOffset = i * nComponents;
            float diff = 0.0f;
            int component = 0;
            while (component < nComponents) {
                float delta = this.normalizedComponentCache[cacheOffset + component] - srgbComponents[component];
                diff += delta * delta;
                ++component;
            }
            if ((diff = (float)Math.sqrt(diff)) < bestDiff) {
                best = i;
                bestDiff = diff;
            }
            ++i;
        }
        return (byte)best;
    }

    @Override
    public int getDataElement(float[] normComponents, int normOffset) {
        int pixel = this.getBestIndex(normComponents, normOffset) & 0xFF;
        if (this.hasAlpha()) {
            pixel |= (this.indexedColorModel.getDataElement(normComponents, normOffset) >> 24 & 0xFF) << 8;
        }
        return pixel;
    }

    @Override
    public int getDataElement(int[] components, int offset) {
        int pixel = this.getBestIndex(this.indexedColorModel.getNormalizedComponents(components, offset, null, 0), 0) & 0xFF;
        if (this.hasAlpha()) {
            pixel |= components[offset + 3] << 8;
        }
        return pixel;
    }

    @Override
    public Object getDataElements(int rgb, Object pixel) {
        if (pixel == null) {
            pixel = new byte[this.getBandNumber()];
        }
        byte[] bytepixel = (byte[])pixel;
        Object rgbpixel = this.indexedColorModel.getDataElements(rgb, null);
        bytepixel[0] = this.getBestIndex(this.indexedColorModel.getNormalizedComponents(rgbpixel, null, 0), 0);
        if (this.hasAlpha()) {
            bytepixel[1] = (byte)this.indexedColorModel.getComponents(rgbpixel, null, 0)[this.getNumColorComponents()];
        }
        return pixel;
    }

    @Override
    public Object getDataElements(float[] normComponents, int normOffset, Object obj) {
        if (obj == null) {
            obj = new byte[this.getBandNumber()];
        }
        byte[] bytepixel = (byte[])obj;
        bytepixel[0] = this.getBestIndex(normComponents, normOffset);
        if (this.hasAlpha()) {
            bytepixel[1] = (byte)this.indexedColorModel.getUnnormalizedComponents(normComponents, normOffset, null, 0)[this.getNumColorComponents()];
        }
        return obj;
    }

    @Override
    public Object getDataElements(int[] components, int offset, Object obj) {
        if (obj == null) {
            obj = new byte[this.getBandNumber()];
        }
        byte[] bytepixel = (byte[])obj;
        bytepixel[0] = this.getBestIndex(this.indexedColorModel.getNormalizedComponents(components, offset, null, 0), 0);
        if (this.hasAlpha()) {
            bytepixel[1] = (byte)components[this.getNumColorComponents()];
        }
        return obj;
    }

    @Override
    public int getRed(Object inData) {
        byte[] bytepixel = (byte[])inData;
        return this.indexedColorModel.getRed(this.getIndexedColor(bytepixel[0]));
    }

    @Override
    public int getGreen(Object inData) {
        byte[] bytepixel = (byte[])inData;
        return this.indexedColorModel.getGreen(this.getIndexedColor(bytepixel[0]));
    }

    @Override
    public int getBlue(Object inData) {
        byte[] bytepixel = (byte[])inData;
        return this.indexedColorModel.getBlue(this.getIndexedColor(bytepixel[0]));
    }

    @Override
    public int getAlpha(Object inData) {
        if (!this.hasAlpha()) {
            return 255;
        }
        byte[] bytepixel = (byte[])inData;
        return this.indexedColorModel.getAlpha((bytepixel[1] & 0xFF) << 24);
    }

    @Override
    public int getRGB(Object inData) {
        byte[] bytepixel = (byte[])inData;
        int pixel = this.getIndexedColor(bytepixel[0]);
        if (this.hasAlpha()) {
            pixel |= (bytepixel[1] & 0xFF) << 24;
        }
        return this.indexedColorModel.getRGB(pixel);
    }

    @Override
    public int getRed(int pixel) {
        return this.indexedColorModel.getRed(this.getIndexedColor((byte)(pixel & 0xFF)));
    }

    @Override
    public int getGreen(int pixel) {
        return this.indexedColorModel.getGreen(this.getIndexedColor((byte)(pixel & 0xFF)));
    }

    @Override
    public int getBlue(int pixel) {
        return this.indexedColorModel.getBlue(this.getIndexedColor((byte)(pixel & 0xFF)));
    }

    @Override
    public int getAlpha(int pixel) {
        if (!this.hasAlpha()) {
            return 255;
        }
        return this.indexedColorModel.getAlpha((pixel >> 8 & 0xFF) << 24);
    }

    @Override
    public int getRGB(int pixel) {
        int pixelBLPD = this.getIndexedColor((byte)(pixel & 0xFF));
        if (this.hasAlpha()) {
            pixelBLPD |= (pixel >> 8 & 0xFF) << 24;
        }
        return this.indexedColorModel.getRGB(pixelBLPD);
    }

    @Override
    public WritableRaster getAlphaRaster(WritableRaster raster) {
        if (this.hasAlpha()) {
            return raster.createWritableChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX(), raster.getMinY(), new int[]{1});
        }
        return null;
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        SampleModel sm = this.createCompatibleSampleModel(w, h);
        return Raster.createWritableRaster(sm, sm.createDataBuffer(), null);
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel()) && raster.getNumBands() == this.getBandNumber();
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        int[] nArray;
        if (this.hasAlpha()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 8;
            nArray = nArray2;
            nArray2[1] = this.getComponentSize(this.getNumColorComponents());
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 8;
        }
        return new BLPPackedSampleModel(w, h, nArray, null);
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        int bands = this.getBandNumber();
        if (sm.getNumBands() != bands) {
            return false;
        }
        if (sm.getTransferType() != 0) {
            return false;
        }
        if (sm.getSampleSize(0) != 8) {
            return false;
        }
        return !this.hasAlpha() || sm.getSampleSize(1) == this.getComponentSize(this.getNumColorComponents());
    }

    public int[] getColorMap() {
        return (int[])this.colorMap.clone();
    }
}

