/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import java.util.Arrays;

public enum BLPEncodingType {
    JPEG(257, 0),
    INDEXED(275, 0),
    UNKNOWN(1, 2);

    public final int alphaBitsMask;
    public final int minVersion;
    private final byte[] alphaBitsArray;

    private BLPEncodingType(int alphaBitsMask, int minVestion) {
        this.alphaBitsMask = alphaBitsMask;
        this.minVersion = minVestion;
        byte[] alphabitsdetect = new byte[32];
        int detected = 0;
        byte i = 0;
        while (alphaBitsMask != 0) {
            if ((alphaBitsMask & 1) != 0) {
                alphabitsdetect[detected++] = i;
            }
            alphaBitsMask >>>= 1;
            i = (byte)(i + 1);
        }
        this.alphaBitsArray = Arrays.copyOfRange(alphabitsdetect, 0, detected);
    }

    public boolean isAlphaBitsValid(int alphaBits) {
        return (this.alphaBitsMask >> alphaBits & 1) != 0;
    }

    public byte[] getAlphaBitsArray() {
        return (byte[])this.alphaBitsArray.clone();
    }

    public byte getBestAlphaBits() {
        return this.alphaBitsArray[this.alphaBitsArray.length - 1];
    }
}

