(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 14.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     38210,        761]
NotebookOptionsPosition[     35259,        714]
NotebookOutlinePosition[     35680,        731]
CellTagsIndexPosition[     35637,        728]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.931038614472908*^9, 3.931038614472908*^9}, {
  3.931038780312809*^9, 3.931038802067093*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"700b4bb5-16b1-4c4e-b008-d5b4af213d70"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Define", " ", "the", " ", "modified", " ", "Bessel", " ", "function"}], 
   "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{"Iv", "[", 
     RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
    RowBox[{"BesselI", "[", 
     RowBox[{"n", ",", "x"}], "]"}]}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Define", " ", "the", " ", "integrand", " ", "for", " ", "A_n", 
     RowBox[{"(", "x", ")"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"AIntegrand", "[", 
     RowBox[{"n_", ",", "x_", ",", "\[Phi]_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"\[Phi]", "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "Pi"}], ")"}]}], ")"}], "^", "2"}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"I", "*", "n", "*", "\[Phi]"}], "+", 
       RowBox[{"x", "*", 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], "]"}]}]}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Define", " ", "the", " ", "integrand", " ", "for", " ", "B_n", 
     RowBox[{"(", "x", ")"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"BIntegrand", "[", 
     RowBox[{"n_", ",", "x_", ",", "\[Phi]_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"I", "*", 
       RowBox[{"\[Phi]", "/", 
        RowBox[{"(", 
         RowBox[{"2", "*", "Pi"}], ")"}]}]}], ")"}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"I", "*", "n", "*", "\[Phi]"}], "+", 
       RowBox[{"x", "*", 
        RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Define", " ", "the", " ", "function", " ", "A_n", 
     RowBox[{"(", "x", ")"}]}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"An", "[", 
     RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "Pi"}], ")"}]}], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"AIntegrand", "[", 
        RowBox[{"n", ",", "x", ",", "\[Phi]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Define", " ", "the", " ", "function", " ", "B_n", 
     RowBox[{"(", "x", ")"}]}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"Bn", "[", 
     RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "Pi"}], ")"}]}], "*", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"BIntegrand", "[", 
        RowBox[{"n", ",", "x", ",", "\[Phi]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p", "[", 
     RowBox[{"q_", ",", "beta_", ",", "v_"}], "]"}], ":=", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{
         RowBox[{"-", "I"}], " ", "*", "\[Theta]", "*", " ", "q"}], "]"}], 
       "*", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"BesselI", "[", 
           RowBox[{
            RowBox[{"\[Theta]", "/", 
             RowBox[{"(", 
              RowBox[{"2", " ", "*", "Pi"}], ")"}]}], ",", "beta"}], "]"}], 
          "/", 
          RowBox[{"BesselI", "[", 
           RowBox[{"0", ",", "beta"}], "]"}]}], ")"}], "^", "v"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Define", " ", "the", " ", "function", " ", "to", " ", "compute", " ", 
     "\[Chi]_t"}], "*)"}], "\n", 
   RowBox[{
    RowBox[{"Chit", "[", 
     RowBox[{"beta_", ",", "V_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sum1", ",", "sum2", ",", "sum3", ",", "denominator"}], "}"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sum1", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"An", "[", 
            RowBox[{"n", ",", "beta"}], "]"}], "*", 
           RowBox[{
            RowBox[{"Iv", "[", 
             RowBox[{"n", ",", "beta"}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"V", "-", "1"}], ")"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"sum2", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"Bn", "[", 
             RowBox[{"n", ",", "beta"}], "]"}], "^", "2"}], "*", 
           RowBox[{
            RowBox[{"Iv", "[", 
             RowBox[{"n", ",", "beta"}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"V", "-", "2"}], ")"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"sum3", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Iv", "[", 
            RowBox[{"n", ",", "beta"}], "]"}], "^", "V"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"denominator", "=", "sum3"}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "sum1"}], "/", "denominator"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"V", "-", "1"}], ")"}], "*", 
         RowBox[{"sum2", "/", "denominator"}]}]}]}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Plaq", "[", 
     RowBox[{"beta_", ",", "V_", ",", "S_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"sum1", ",", "sum2"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"sum1", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Iv", "[", 
              RowBox[{
               RowBox[{"n", "+", "1"}], ",", "beta"}], "]"}], "^", "S"}], "*", 
            RowBox[{
             RowBox[{"Iv", "[", 
              RowBox[{"n", ",", "beta"}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"V", "-", "S"}], ")"}]}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"sum2", "=", 
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"N", "[", 
           RowBox[{
            RowBox[{"Iv", "[", 
             RowBox[{"n", ",", "beta"}], "]"}], "^", "V"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"sum1", "/", "sum2"}]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.931038815073398*^9, 3.931038815074398*^9}, 
   3.9310406633739567`*^9, {3.931040911521589*^9, 3.931040911804489*^9}, {
   3.9310413886226025`*^9, 3.931041395341783*^9}, {3.9310414712359543`*^9, 
   3.931041535011205*^9}, {3.9310417052858524`*^9, 3.931041752220745*^9}, {
   3.93104178313364*^9, 3.9310417850461464`*^9}, 3.931041838050703*^9, 
   3.931041888991398*^9, {3.931055632494051*^9, 3.931055653479501*^9}, {
   3.931055829228794*^9, 3.931055841466347*^9}, {3.931055925928844*^9, 
   3.931055935764254*^9}, {3.9310560588546505`*^9, 3.931056060813362*^9}, {
   3.931056095668613*^9, 3.931056104633339*^9}, {3.931057683697218*^9, 
   3.931057696646225*^9}, {3.931057739567477*^9, 3.9310577409696636`*^9}, {
   3.931057980422138*^9, 3.9310579886491947`*^9}, {3.931059557170021*^9, 
   3.93105960453317*^9}, 3.9310597028757935`*^9, {3.931060062539781*^9, 
   3.931060082422947*^9}, {3.9310610044074078`*^9, 3.9310610132569733`*^9}, {
   3.93106199939023*^9, 3.931062014503115*^9}, {3.931062317691528*^9, 
   3.931062362033596*^9}, {3.931237906034096*^9, 3.9312379283900757`*^9}, {
   3.9324393881284237`*^9, 3.9324394413970356`*^9}, {3.932439529034582*^9, 
   3.932439530028949*^9}, 3.932439595906278*^9, {3.93244045588812*^9, 
   3.932440456805937*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"249bb058-ec4a-854a-a526-c555ee715e03"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"q", "^", "2"}], "*", 
      RowBox[{"p", "[", 
       RowBox[{"q", ",", "7", ",", "256"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}]}], "]"}], "/", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"q", ",", "7", ",", "256"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"q", ",", 
       RowBox[{"-", "15"}], ",", "15"}], "}"}]}], "]"}]}], "/", 
  "256"}]], "Input",
 CellChangeTimes->{{3.9310415452402077`*^9, 3.9310415521530514`*^9}, {
  3.9310416884609585`*^9, 3.9310416889938164`*^9}, {3.931055928732918*^9, 
  3.931055930547962*^9}, {3.9324394786904335`*^9, 3.9324395363393764`*^9}, {
  3.93243960862006*^9, 3.932439741046547*^9}, {3.932439775211975*^9, 
  3.932439866415974*^9}, {3.932440012219679*^9, 3.932440057051349*^9}, {
  3.932440491749071*^9, 3.93244053264431*^9}, {3.932440572561821*^9, 
  3.932440621477142*^9}, {3.932440676407244*^9, 3.932440743039738*^9}, {
  3.932440815390932*^9, 3.9324408578470497`*^9}, {3.932440904793724*^9, 
  3.932440926732948*^9}, {3.932441157756855*^9, 3.932441171855926*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"d25a24c3-0a1f-3341-b09e-5413b071519a"],

Cell[BoxData[
 RowBox[{"0.003957820947786045`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.93243956473567*^9, 3.932439567882126*^9}, {
   3.932439599193533*^9, 3.9324396184748383`*^9}, {3.932439650954565*^9, 
   3.932439743198826*^9}, {3.932439824006285*^9, 3.932439835554289*^9}, 
   3.932439882358602*^9, {3.932440015397499*^9, 3.932440032122164*^9}, 
   3.932440062171348*^9, 3.932440466265*^9, {3.932440802753635*^9, 
   3.932440861367594*^9}, {3.932440917958441*^9, 3.93244093136257*^9}, {
   3.932441179195329*^9, 3.932441217237673*^9}, {3.934108058511841*^9, 
   3.934108077819937*^9}, 3.934159168921173*^9, 3.935037239566839*^9, 
   3.935039086317158*^9, 3.935124029415098*^9, 3.935311311456877*^9, 
   3.938761712967123*^9, 3.942877147054119*^9, 3.9433050393823204`*^9, 
   3.943305308366864*^9, 3.9433129050430565`*^9, 3.944081495722733*^9, {
   3.9464283202094574`*^9, 3.946428333854759*^9}},
 CellLabel->"Out[34]=",ExpressionUUID->"5f4eadfe-9243-f947-b982-950f1595eaa3"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.931041659782814*^9, 3.931041704031603*^9}, {
  3.932439625286289*^9, 3.932439630788624*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"85bd5af9-8fd2-a94f-a485-100ed75c7ab9"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.931055884899749*^9, 3.931055893010716*^9}, 
   3.931602846252575*^9},
 CellLabel->"In[36]:=",ExpressionUUID->"b35ca26c-0e55-534e-99be-be1f8f4f81f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chit", "[", 
  RowBox[{"7", ",", "256"}], "]"}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGCQAGIQncBgyXzP862jUHMxmBbXZf35BEjvkln8G0Qziy3k
eQqkdSbv5APR5jJvVEB0ZZScKoi2OZi77xWQLokrAdM2nY7buLzeOho4rgTT
c359YLIA0rfzWJhBtEXzytsOQPqJwS0wrZzqpv8BSD+XzALTj7O3l2zzfuuo
Mv0ImC6Y9bESRNuU/ALTm/2qpoLoNKZqMF2uoLEcRMtcqALTCXsl94Lojkmd
YHqy+9UPIPrP8XtgOkRAKGU7kJ6jJw2mF4r8vAyiM3p/gWkJ4zT1Th+gO7dn
gWkRB1Y9EH1mkgCY3rLpmheIdjh4H0yHnFnD5ZQI9M8vRm4QbSD2dr8rkG6o
4T0AojOq97YcSQL6o0KiFUSryKt/Mkt/6+jhdv8LiAYANh69zQ==
  "],
 CellLabel->"In[37]:=",ExpressionUUID->"27b3be80-9d9d-334c-84d1-b09975c92a7f"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*SuperscriptBox[\\\"5.563200120475373`*^-8\\\", \\\"255\\\"]\\) \
\:592a\:5c0f\:ff0c\:4e0d\:9002\:5408\:88ab\:8868\:793a\:4e3a\:5f52\:4e00\:5316\
\:673a\:5668\:6570\:ff1b\:53ef\:80fd\:65e0\:6cd5\:4fdd\:6301\:539f\:6765\:7684\
\:7cbe\:5ea6.\"", 2, 37, 5, 17219353962162436165, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.931133368497408*^9, 3.9312195449235325`*^9, 3.931226141309908*^9, 
   3.9312349463730583`*^9, 3.931235269399961*^9, 3.931237936611914*^9, 
   3.931243400350117*^9, {3.9312434608624744`*^9, 3.931243512792633*^9}, 
   3.931243558452915*^9, {3.931243699048908*^9, 3.931243712739601*^9}, {
   3.931244015332086*^9, 3.931244040205614*^9}, 3.931244257569124*^9, 
   3.931247008475889*^9, 3.931306801521916*^9, 3.93131333609865*^9, 
   3.9313228624335785`*^9, 3.931489450558384*^9, 3.931493630800503*^9, 
   3.9315031607926617`*^9, 3.931506311776232*^9, 3.931508104522009*^9, 
   3.931520730555577*^9, 3.931521301745119*^9, {3.931558810944387*^9, 
   3.931558821385992*^9}, 3.931561125448557*^9, {3.931602838740049*^9, 
   3.9316028652319164`*^9}, {3.9316033265710273`*^9, 3.931603344298778*^9}, {
   3.932009365349158*^9, 3.932009384042766*^9}, 3.932009426393252*^9, 
   3.932009646908655*^9, {3.9320097909547577`*^9, 3.932009821997366*^9}, 
   3.932009965976085*^9, 3.9320103777190514`*^9, 3.932011299074913*^9, 
   3.932012193846698*^9, 3.932352499118729*^9, 3.932431983044746*^9, {
   3.93243956490905*^9, 3.932439566859585*^9}, {3.932439599205538*^9, 
   3.9324396184913807`*^9}, 3.932440466280506*^9, 3.932440892968479*^9, 
   3.9324409461826267`*^9, {3.932441179223734*^9, 3.932441217266369*^9}, {
   3.934108058622925*^9, 3.934108077852827*^9}, 3.934159169003788*^9, 
   3.9350372396404514`*^9, 3.935039086356493*^9, 3.935124029500719*^9, 
   3.9353113115695114`*^9, 3.9387617130526314`*^9, 3.9428771471548233`*^9, 
   3.943305039463545*^9, 3.943305308396124*^9, 3.943312905077061*^9, 
   3.944081495788418*^9, 3.944096810598192*^9, {3.9464283202718086`*^9, 
   3.9464283338834534`*^9}},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[37]:=",ExpressionUUID->"033707a1-6f19-fd45-bf09-\
20ed70ee2af7"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*SuperscriptBox[\\\"3.269350551530966`*^-7\\\", \\\"255\\\"]\\) \
\:592a\:5c0f\:ff0c\:4e0d\:9002\:5408\:88ab\:8868\:793a\:4e3a\:5f52\:4e00\:5316\
\:673a\:5668\:6570\:ff1b\:53ef\:80fd\:65e0\:6cd5\:4fdd\:6301\:539f\:6765\:7684\
\:7cbe\:5ea6.\"", 2, 37, 6, 17219353962162436165, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.931133368497408*^9, 3.9312195449235325`*^9, 3.931226141309908*^9, 
   3.9312349463730583`*^9, 3.931235269399961*^9, 3.931237936611914*^9, 
   3.931243400350117*^9, {3.9312434608624744`*^9, 3.931243512792633*^9}, 
   3.931243558452915*^9, {3.931243699048908*^9, 3.931243712739601*^9}, {
   3.931244015332086*^9, 3.931244040205614*^9}, 3.931244257569124*^9, 
   3.931247008475889*^9, 3.931306801521916*^9, 3.93131333609865*^9, 
   3.9313228624335785`*^9, 3.931489450558384*^9, 3.931493630800503*^9, 
   3.9315031607926617`*^9, 3.931506311776232*^9, 3.931508104522009*^9, 
   3.931520730555577*^9, 3.931521301745119*^9, {3.931558810944387*^9, 
   3.931558821385992*^9}, 3.931561125448557*^9, {3.931602838740049*^9, 
   3.9316028652319164`*^9}, {3.9316033265710273`*^9, 3.931603344298778*^9}, {
   3.932009365349158*^9, 3.932009384042766*^9}, 3.932009426393252*^9, 
   3.932009646908655*^9, {3.9320097909547577`*^9, 3.932009821997366*^9}, 
   3.932009965976085*^9, 3.9320103777190514`*^9, 3.932011299074913*^9, 
   3.932012193846698*^9, 3.932352499118729*^9, 3.932431983044746*^9, {
   3.93243956490905*^9, 3.932439566859585*^9}, {3.932439599205538*^9, 
   3.9324396184913807`*^9}, 3.932440466280506*^9, 3.932440892968479*^9, 
   3.9324409461826267`*^9, {3.932441179223734*^9, 3.932441217266369*^9}, {
   3.934108058622925*^9, 3.934108077852827*^9}, 3.934159169003788*^9, 
   3.9350372396404514`*^9, 3.935039086356493*^9, 3.935124029500719*^9, 
   3.9353113115695114`*^9, 3.9387617130526314`*^9, 3.9428771471548233`*^9, 
   3.943305039463545*^9, 3.943305308396124*^9, 3.943312905077061*^9, 
   3.944081495788418*^9, 3.944096810598192*^9, {3.9464283202718086`*^9, 
   3.9464283338953915`*^9}},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[37]:=",ExpressionUUID->"1e8b9a5e-8d0f-164c-b875-\
ed886d114209"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\"\\!\\(\\*SuperscriptBox[\\\"1.8304223006072778`*^-6\\\", \
\\\"255\\\"]\\) \:592a\:5c0f\:ff0c\:4e0d\:9002\:5408\:88ab\:8868\:793a\:4e3a\
\:5f52\:4e00\:5316\:673a\:5668\:6570\:ff1b\:53ef\:80fd\:65e0\:6cd5\:4fdd\:6301\
\:539f\:6765\:7684\:7cbe\:5ea6.\"", 2, 37, 7, 17219353962162436165, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.931133368497408*^9, 3.9312195449235325`*^9, 3.931226141309908*^9, 
   3.9312349463730583`*^9, 3.931235269399961*^9, 3.931237936611914*^9, 
   3.931243400350117*^9, {3.9312434608624744`*^9, 3.931243512792633*^9}, 
   3.931243558452915*^9, {3.931243699048908*^9, 3.931243712739601*^9}, {
   3.931244015332086*^9, 3.931244040205614*^9}, 3.931244257569124*^9, 
   3.931247008475889*^9, 3.931306801521916*^9, 3.93131333609865*^9, 
   3.9313228624335785`*^9, 3.931489450558384*^9, 3.931493630800503*^9, 
   3.9315031607926617`*^9, 3.931506311776232*^9, 3.931508104522009*^9, 
   3.931520730555577*^9, 3.931521301745119*^9, {3.931558810944387*^9, 
   3.931558821385992*^9}, 3.931561125448557*^9, {3.931602838740049*^9, 
   3.9316028652319164`*^9}, {3.9316033265710273`*^9, 3.931603344298778*^9}, {
   3.932009365349158*^9, 3.932009384042766*^9}, 3.932009426393252*^9, 
   3.932009646908655*^9, {3.9320097909547577`*^9, 3.932009821997366*^9}, 
   3.932009965976085*^9, 3.9320103777190514`*^9, 3.932011299074913*^9, 
   3.932012193846698*^9, 3.932352499118729*^9, 3.932431983044746*^9, {
   3.93243956490905*^9, 3.932439566859585*^9}, {3.932439599205538*^9, 
   3.9324396184913807`*^9}, 3.932440466280506*^9, 3.932440892968479*^9, 
   3.9324409461826267`*^9, {3.932441179223734*^9, 3.932441217266369*^9}, {
   3.934108058622925*^9, 3.934108077852827*^9}, 3.934159169003788*^9, 
   3.9350372396404514`*^9, 3.935039086356493*^9, 3.935124029500719*^9, 
   3.9353113115695114`*^9, 3.9387617130526314`*^9, 3.9428771471548233`*^9, 
   3.943305039463545*^9, 3.943305308396124*^9, 3.943312905077061*^9, 
   3.944081495788418*^9, 3.944096810598192*^9, {3.9464283202718086`*^9, 
   3.9464283339120235`*^9}},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[37]:=",ExpressionUUID->"c8b86dcc-3cbd-8740-94e4-\
8a92d855b360"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"\:5728\:672c\:6b21\:8ba1\:7b97\:4e2d\:ff0c\\!\\(\\*StyleBox[RowBox[{\\\"\
General\\\", \\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) \
\:7684\:8fdb\:4e00\:6b65\:8f93\:51fa\:5c06\:88ab\:6291\:5236.\"", 2, 37, 8, 
   17219353962162436165, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.931133368497408*^9, 3.9312195449235325`*^9, 3.931226141309908*^9, 
   3.9312349463730583`*^9, 3.931235269399961*^9, 3.931237936611914*^9, 
   3.931243400350117*^9, {3.9312434608624744`*^9, 3.931243512792633*^9}, 
   3.931243558452915*^9, {3.931243699048908*^9, 3.931243712739601*^9}, {
   3.931244015332086*^9, 3.931244040205614*^9}, 3.931244257569124*^9, 
   3.931247008475889*^9, 3.931306801521916*^9, 3.93131333609865*^9, 
   3.9313228624335785`*^9, 3.931489450558384*^9, 3.931493630800503*^9, 
   3.9315031607926617`*^9, 3.931506311776232*^9, 3.931508104522009*^9, 
   3.931520730555577*^9, 3.931521301745119*^9, {3.931558810944387*^9, 
   3.931558821385992*^9}, 3.931561125448557*^9, {3.931602838740049*^9, 
   3.9316028652319164`*^9}, {3.9316033265710273`*^9, 3.931603344298778*^9}, {
   3.932009365349158*^9, 3.932009384042766*^9}, 3.932009426393252*^9, 
   3.932009646908655*^9, {3.9320097909547577`*^9, 3.932009821997366*^9}, 
   3.932009965976085*^9, 3.9320103777190514`*^9, 3.932011299074913*^9, 
   3.932012193846698*^9, 3.932352499118729*^9, 3.932431983044746*^9, {
   3.93243956490905*^9, 3.932439566859585*^9}, {3.932439599205538*^9, 
   3.9324396184913807`*^9}, 3.932440466280506*^9, 3.932440892968479*^9, 
   3.9324409461826267`*^9, {3.932441179223734*^9, 3.932441217266369*^9}, {
   3.934108058622925*^9, 3.934108077852827*^9}, 3.934159169003788*^9, 
   3.9350372396404514`*^9, 3.935039086356493*^9, 3.935124029500719*^9, 
   3.9353113115695114`*^9, 3.9387617130526314`*^9, 3.9428771471548233`*^9, 
   3.943305039463545*^9, 3.943305308396124*^9, 3.943312905077061*^9, 
   3.944081495788418*^9, 3.944096810598192*^9, {3.9464283202718086`*^9, 
   3.9464283339172993`*^9}},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[37]:=",ExpressionUUID->"81e0c950-f1e2-7344-ae8e-\
80bf881f0f0a"],

Cell[BoxData[
 RowBox[{"0.003931305304159286`", "\[VeryThinSpace]", "-", 
  RowBox[{"8.2801899965575`*^-29", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{
  3.932431983405687*^9, {3.932439565254856*^9, 3.932439567221577*^9}, {
   3.932439599539097*^9, 3.9324396188474483`*^9}, 3.932440466630178*^9, 
   3.932440893313371*^9, 3.932440946543222*^9, {3.932441179580532*^9, 
   3.932441217624765*^9}, {3.9341080590712566`*^9, 3.934108078284683*^9}, 
   3.934159169445287*^9, 3.9350372400250454`*^9, 3.935039086735054*^9, 
   3.935124029922934*^9, 3.935311312044115*^9, 3.938761713490925*^9, 
   3.942877147565201*^9, 3.943305039847185*^9, 3.943305308754538*^9, 
   3.943312905427969*^9, 3.944081496158287*^9, 3.94409681098975*^9, {
   3.9464283206351967`*^9, 3.9464283342645416`*^9}},
 CellLabel->"Out[37]=",ExpressionUUID->"70ee812e-73b0-3141-9ad3-e41664779e10"],

Cell[BoxData[
 TemplateBox[{
  "General", "munfl", 
   "\:f3b5\!\(\*SuperscriptBox[\(6.037144636398764`*^-22\), \(255\)]\) \:592a\
\:5c0f\:ff0c\:4e0d\:9002\:5408\:88ab\:8868\:793a\:4e3a\:5f52\:4e00\:5316\:673a\
\:5668\:6570\:ff1b\:53ef\:80fd\:65e0\:6cd5\:4fdd\:6301\:539f\:6765\:7684\:7cbe\
\:5ea6.\:f3b5", 2, 12, 3, 17127106706556841467, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.931133368497408*^9, 3.9312195449235325`*^9, 3.931226141309908*^9, 
   3.9312349463730583`*^9, 3.931235269399961*^9, 3.931237936611914*^9, 
   3.931243400350117*^9, {3.9312434608624744`*^9, 3.931243512792633*^9}, 
   3.931243558452915*^9, {3.931243699048908*^9, 3.931243712739601*^9}, {
   3.931244015332086*^9, 3.931244040205614*^9}, 3.931244257569124*^9, 
   3.931247008475889*^9, 3.931306801521916*^9, 3.93131333609865*^9, 
   3.9313228624335785`*^9, 3.931489450558384*^9, 3.931493630800503*^9, 
   3.9315031607926617`*^9, 3.931506311776232*^9, 3.931508104522009*^9, 
   3.931520730555577*^9, 3.931521301745119*^9, {3.931558810944387*^9, 
   3.931558821385992*^9}, 3.931561125448557*^9, {3.931602838740049*^9, 
   3.9316028652319164`*^9}, {3.9316033265710273`*^9, 3.931603344298778*^9}, {
   3.932009365349158*^9, 3.932009384042766*^9}, 3.932009426393252*^9, 
   3.932009646908655*^9, {3.9320097909547577`*^9, 3.932009821997366*^9}, 
   3.932009965976085*^9, 3.9320103777190514`*^9, 3.932011299074913*^9, 
   3.932012193846698*^9, 3.932352499131241*^9, 
   3.932373434031002*^9},ExpressionUUID->"f6acf195-8628-cf43-90b1-\
c0fdf943406a"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"\:5728\:672c\:6b21\:8ba1\:7b97\:4e2d\:ff0c\\!\\(\\*StyleBox[RowBox[{\\\"\
General\\\", \\\"::\\\", \\\"munfl\\\"}], \\\"MessageName\\\"]\\) \
\:7684\:8fdb\:4e00\:6b65\:8f93\:51fa\:5c06\:88ab\:6291\:5236.\"", 2, 12, 4, 
   17127106706556841467, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.931133368497408*^9, 3.9312195449235325`*^9, 3.931226141309908*^9, 
   3.9312349463730583`*^9, 3.931235269399961*^9, 3.931237936611914*^9, 
   3.931243400350117*^9, {3.9312434608624744`*^9, 3.931243512792633*^9}, 
   3.931243558452915*^9, {3.931243699048908*^9, 3.931243712739601*^9}, {
   3.931244015332086*^9, 3.931244040205614*^9}, 3.931244257569124*^9, 
   3.931247008475889*^9, 3.931306801521916*^9, 3.93131333609865*^9, 
   3.9313228624335785`*^9, 3.931489450558384*^9, 3.931493630800503*^9, 
   3.9315031607926617`*^9, 3.931506311776232*^9, 3.931508104522009*^9, 
   3.931520730555577*^9, 3.931521301745119*^9, {3.931558810944387*^9, 
   3.931558821385992*^9}, 3.931561125448557*^9, {3.931602838740049*^9, 
   3.9316028652319164`*^9}, {3.9316033265710273`*^9, 3.931603344298778*^9}, {
   3.932009365349158*^9, 3.932009384042766*^9}, 3.932009426393252*^9, 
   3.932009646908655*^9, {3.9320097909547577`*^9, 3.932009821997366*^9}, 
   3.932009965976085*^9, 3.9320103777190514`*^9, 3.932011299074913*^9, 
   3.932012193846698*^9, 3.932352499141239*^9},
 CellLabel->
  "\:6b63\:5728\:8ba1\:7b97In[12]:=",ExpressionUUID->"f130d592-f533-af4a-8201-\
0e46abee1a42"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.932441191937361*^9, 3.9324411919413567`*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"51bb30e3-c109-0749-8c36-52f124b346a3"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.9310576459954166`*^9, {3.93200980490522*^9, 3.932009811946264*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"5e0751c5-a87f-0f4d-b486-13aeb6825825"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.932009802792528*^9, 3.9320098027935963`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"0afade84-7334-aa49-baf1-065e1134b4b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plaq", "[", 
  RowBox[{"49", ",", "256", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.9310605764294376`*^9, 3.931060593891285*^9}, {
   3.931061020786642*^9, 3.931061021354986*^9}, {3.931061964110082*^9, 
   3.9310619650140133`*^9}, {3.931062772745375*^9, 3.931062815356945*^9}, {
   3.931062856708469*^9, 3.9310628712179623`*^9}, {3.931133317003221*^9, 
   3.931133320339405*^9}, {3.931219541357218*^9, 3.931219542098768*^9}, {
   3.931231648800833*^9, 3.931231650217636*^9}, {3.9312349370670166`*^9, 
   3.931234941295223*^9}, {3.931235265293938*^9, 3.931235265711624*^9}, {
   3.931243390631506*^9, 3.931243394999071*^9}, {3.9312434568126183`*^9, 
   3.931243510014465*^9}, {3.9312435551226063`*^9, 3.93124355581505*^9}, {
   3.931243695563988*^9, 3.93124371016407*^9}, {3.931244012128736*^9, 
   3.931244057035681*^9}, {3.93124421118022*^9, 3.931244235406566*^9}, {
   3.931244279021795*^9, 3.931244279329338*^9}, {3.931244343224928*^9, 
   3.931244343720352*^9}, {3.931247002161274*^9, 3.93124701795866*^9}, {
   3.931247315529762*^9, 3.931247320308264*^9}, {3.931247472802887*^9, 
   3.93124747355549*^9}, {3.931247779139503*^9, 3.931247799502521*^9}, {
   3.931247969855537*^9, 3.931247987172277*^9}, {3.9312506575067863`*^9, 
   3.931250657861147*^9}, {3.931250695911434*^9, 3.931250697077219*^9}, {
   3.931306791472964*^9, 3.931306814848901*^9}, {3.9313133327567463`*^9, 
   3.931313333151655*^9}, {3.931322859490429*^9, 3.931322859937054*^9}, {
   3.931324190421196*^9, 3.931324190632391*^9}, {3.9313317244189262`*^9, 
   3.931331747771988*^9}, {3.931489444934274*^9, 3.931489453335287*^9}, 
   3.931490810902539*^9, {3.931492703834295*^9, 3.9314927183520355`*^9}, {
   3.931493105290531*^9, 3.931493117619564*^9}, {3.9314935818726025`*^9, 
   3.931493627910414*^9}, {3.931506305602999*^9, 3.931506305735758*^9}, {
   3.93150810111878*^9, 3.931508101342258*^9}, {3.9316033408641167`*^9, 
   3.9316033415961304`*^9}, {3.932352494708843*^9, 3.932352495133215*^9}, {
   3.932352638673734*^9, 3.932352698062887*^9}, {3.9324319749474316`*^9, 
   3.9324319802023697`*^9}, {3.932437293377786*^9, 3.932437320353834*^9}, {
   3.934108051324793*^9, 3.934108100393148*^9}, {3.934159163146194*^9, 
   3.934159163282009*^9}, {3.934869312121475*^9, 3.93486932504499*^9}, {
   3.93503723416188*^9, 3.935037234809559*^9}, {3.9350390724016685`*^9, 
   3.93503910397471*^9}, {3.935039222336645*^9, 3.935039250417324*^9}, {
   3.935039330374231*^9, 3.935039344411772*^9}, {3.93512402187693*^9, 
   3.935124022094118*^9}, {3.9353112991655693`*^9, 3.935311316121582*^9}, {
   3.938761703976986*^9, 3.938761723372661*^9}, {3.9387617949155426`*^9, 
   3.9387618004534435`*^9}, {3.9427003718894825`*^9, 3.942700372305992*^9}, {
   3.942877138624628*^9, 3.942877151393909*^9}, {3.9433128995084057`*^9, 
   3.9433129255052185`*^9}, {3.944081486952481*^9, 3.9440815250157185`*^9}, {
   3.944083388630453*^9, 3.944083401057768*^9}, {3.9440882317973995`*^9, 
   3.94408823201182*^9}, {3.944091560575514*^9, 3.944091575135432*^9}, {
   3.9440916186382904`*^9, 3.944091643455513*^9}, {3.944119612015438*^9, 
   3.944119612330143*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"547f6a7a-61c6-364c-a431-e80d01d61427"],

Cell[BoxData["0.98976936562152336011016403111985438997`14.436075830313117"], \
"Output",
 CellChangeTimes->{{3.931060595058138*^9, 3.9310606102033577`*^9}, 
   3.931061024062393*^9, {3.931061969451488*^9, 3.931061979274675*^9}, {
   3.93106202212923*^9, 3.931062028288233*^9}, 3.931062367441101*^9, {
   3.931062777459202*^9, 3.931062818467514*^9}, {3.931062865789011*^9, 
   3.931062873278999*^9}, {3.931133323631943*^9, 3.931133329207957*^9}, 
   3.931133368663601*^9, 3.931219545065181*^9, 3.931226141336284*^9, {
   3.931234943315822*^9, 3.9312349463966026`*^9}, 3.9312352695000134`*^9, 
   3.93123793710544*^9, 3.931243400806518*^9, {3.931243461332069*^9, 
   3.931243513254082*^9}, 3.931243558936821*^9, {3.931243699495578*^9, 
   3.931243713186386*^9}, {3.931244015815265*^9, 3.931244059108965*^9}, {
   3.931244213416937*^9, 3.9312442379315186`*^9}, {3.931244335290199*^9, 
   3.9312443462571964`*^9}, {3.931247008918564*^9, 3.9312470201475525`*^9}, {
   3.9312473180272503`*^9, 3.931247321662554*^9}, 3.931247476046638*^9, {
   3.931247781482912*^9, 3.931247801340608*^9}, {3.931247972247738*^9, 
   3.931247988627725*^9}, 3.9312506597453976`*^9, 3.931250698730268*^9, {
   3.931306793120563*^9, 3.93130681690633*^9}, 3.9313133365570126`*^9, 
   3.931322862882679*^9, 3.931324191839632*^9, {3.931331729431978*^9, 
   3.931331750918356*^9}, {3.9314894471695633`*^9, 3.931489454786131*^9}, 
   3.931490812440016*^9, {3.9314927073354855`*^9, 3.931492719703054*^9}, {
   3.931493108283596*^9, 3.931493119858318*^9}, {3.9314935874495106`*^9, 
   3.931493598172331*^9}, 3.931493631240194*^9, 3.93150316126017*^9, {
   3.931506307866888*^9, 3.931506312287955*^9}, 3.931508104980137*^9, 
   3.931520731023306*^9, 3.931521302202343*^9, {3.931558811374778*^9, 
   3.931558821830154*^9}, 3.9315611258944225`*^9, {3.931602839229109*^9, 
   3.931602865729877*^9}, {3.931603327062031*^9, 3.931603344715786*^9}, 
   3.932009365779018*^9, 3.932009647290163*^9, 3.9320097913262577`*^9, 
   3.932009822376785*^9, 3.932010378073345*^9, 3.932352499502319*^9, {
   3.932352640405327*^9, 3.932352700163183*^9}, 3.93243198343786*^9, {
   3.932437298650791*^9, 3.932437322088798*^9}, {3.9324395652860775`*^9, 
   3.932439567253242*^9}, {3.932439599585905*^9, 3.932439618870744*^9}, 
   3.932440466661575*^9, {3.932441179612589*^9, 3.932441217661035*^9}, {
   3.934108059134521*^9, 3.934108101784839*^9}, 3.934159169498672*^9, 
   3.935037240054596*^9, {3.935039073688713*^9, 3.9350391059050198`*^9}, {
   3.9350392251051197`*^9, 3.935039251790676*^9}, {3.935039331861496*^9, 
   3.935039346161392*^9}, {3.935124024117199*^9, 3.9351240299609795`*^9}, {
   3.935311312086151*^9, 3.935311318218695*^9}, {3.938761713540043*^9, 
   3.938761725310118*^9}, {3.938761796815499*^9, 3.9387618023081665`*^9}, {
   3.942877147613018*^9, 3.942877153751442*^9}, 3.943305039889515*^9, 
   3.943305308791218*^9, {3.943312905464779*^9, 3.9433129270411625`*^9}, {
   3.9440814961936417`*^9, 3.944081525987213*^9}, {3.94408338972558*^9, 
   3.9440834034453945`*^9}, 3.944088233881645*^9, {3.944091562212633*^9, 
   3.9440915768088055`*^9}, {3.9440916195671043`*^9, 3.944091644996468*^9}, 
   3.944119614551499*^9, {3.946428320652685*^9, 3.946428334285204*^9}},
 CellLabel->"Out[41]=",ExpressionUUID->"bcd0bf11-6e5e-db4f-bed2-47eec819c35f"],

Cell[BoxData[""], "Print",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.9310416794287353`*^9, 
  3.9310418160724087`*^9},ExpressionUUID->"d978d586-e301-9745-9c48-\
15b2c4295ab4"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9314936201333237`*^9, 3.931493625189684*^9}, {
   3.931506212094902*^9, 3.9315062122228336`*^9}, {3.931508092570947*^9, 
   3.93150809311173*^9}, {3.931520380994507*^9, 3.931520389533678*^9}, {
   3.931520471861744*^9, 3.93152050559288*^9}, {3.9315207258613415`*^9, 
   3.931520738163336*^9}, {3.931558804599138*^9, 3.931558818446645*^9}, 
   3.931560857152367*^9, {3.931561087911198*^9, 3.931561105051611*^9}, {
   3.9315611378526382`*^9, 3.931561187432644*^9}, 3.931602835080759*^9},
 CellLabel->"In[42]:=",ExpressionUUID->"906e6b48-4882-6c4b-a0d8-62fd1bb276a1"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.931602831982738*^9, 3.93160283198673*^9}},
 CellLabel->"In[43]:=",ExpressionUUID->"30b8ca4d-7eeb-9f44-a359-7ad85f4ef41c"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.931493609637775*^9, 3.9314936170793533`*^9}, {
   3.9315031569856663`*^9, 3.9315031672259464`*^9}, {3.931506301465067*^9, 
   3.9315063015752277`*^9}, {3.931508098058037*^9, 3.931508098468151*^9}, 
   3.931521297517746*^9, {3.931521366304055*^9, 3.931521396053353*^9}, {
   3.9315611174655914`*^9, 3.931561119809252*^9}, {3.9315611945223007`*^9, 
   3.931561194851658*^9}, {3.931562059819116*^9, 3.931562087048143*^9}, {
   3.931568425368344*^9, 3.93156842584458*^9}, {3.931569106341507*^9, 
   3.931569109196687*^9}, 3.931599818270537*^9, 3.931602830191772*^9},
 CellLabel->"In[44]:=",ExpressionUUID->"4d7e8a35-bc1a-a447-ad7f-b1c09ee3ed00"],

Cell[BoxData["\n"], "Input",
 CellChangeTimes->{{3.935402669190275*^9, 3.935402669190275*^9}, {
   3.935403031406793*^9, 3.9354030317479267`*^9}, {3.935403146625299*^9, 
   3.9354031468176556`*^9}, 3.93643267350679*^9},
 CellLabel->"In[45]:=",ExpressionUUID->"f5f83fe0-ffc8-2148-86f3-bdf0fb2224fc"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.936432674439253*^9, 3.93643267444029*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"27061fb2-65d4-c94b-b0bc-4ec8e69bf990"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.935403064460039*^9},
 CellLabel->"In[47]:=",ExpressionUUID->"0c0ad04d-3cf0-1347-a19b-ef012b93cbcf"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.936432675314325*^9},
 CellLabel->"In[48]:=",ExpressionUUID->"f76a4a73-5596-0e4c-ae72-fcdeec32dc5e"]
},
WindowSize->{1280, 732},
WindowMargins->{{Automatic, -1285.5}, {-443, Automatic}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (2023\:5e7412\:670812\
\:65e5)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"683e115f-c692-7d42-b0bf-187e7d0d468b"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 220, 3, 28, "Input",ExpressionUUID->"700b4bb5-16b1-4c4e-b008-d5b4af213d70"],
Cell[781, 25, 8590, 229, 697, "Input",ExpressionUUID->"249bb058-ec4a-854a-a526-c555ee715e03"],
Cell[CellGroupData[{
Cell[9396, 258, 1293, 29, 43, "Input",ExpressionUUID->"d25a24c3-0a1f-3341-b09e-5413b071519a"],
Cell[10692, 289, 1041, 15, 32, "Output",ExpressionUUID->"5f4eadfe-9243-f947-b982-950f1595eaa3"]
}, Open  ]],
Cell[11748, 307, 220, 3, 28, "Input",ExpressionUUID->"85bd5af9-8fd2-a94f-a485-100ed75c7ab9"],
Cell[11971, 312, 197, 3, 28, "Input",ExpressionUUID->"b35ca26c-0e55-534e-99be-be1f8f4f81f5"],
Cell[CellGroupData[{
Cell[12193, 319, 623, 12, 28, "Input",ExpressionUUID->"27b3be80-9d9d-334c-84d1-b09975c92a7f"],
Cell[12819, 333, 2213, 35, 28, "Message",ExpressionUUID->"033707a1-6f19-fd45-bf09-20ed70ee2af7"],
Cell[15035, 370, 2213, 35, 28, "Message",ExpressionUUID->"1e8b9a5e-8d0f-164c-b875-ed886d114209"],
Cell[17251, 407, 2214, 35, 28, "Message",ExpressionUUID->"c8b86dcc-3cbd-8740-94e4-8a92d855b360"],
Cell[19468, 444, 2172, 35, 28, "Message",ExpressionUUID->"81e0c950-f1e2-7344-ae8e-80bf881f0f0a"],
Cell[21643, 481, 870, 13, 32, "Output",ExpressionUUID->"70ee812e-73b0-3141-9ad3-e41664779e10"],
Cell[22516, 496, 1602, 27, 28, "Message",ExpressionUUID->"f6acf195-8628-cf43-90b1-c0fdf943406a"],
Cell[24121, 525, 1539, 26, 28, "Message",ExpressionUUID->"f130d592-f533-af4a-8201-0e46abee1a42"]
}, Open  ]],
Cell[25675, 554, 173, 2, 28, "Input",ExpressionUUID->"51bb30e3-c109-0749-8c36-52f124b346a3"],
Cell[25851, 558, 197, 3, 28, "Input",ExpressionUUID->"5e0751c5-a87f-0f4d-b486-13aeb6825825"],
Cell[26051, 563, 173, 2, 28, "Input",ExpressionUUID->"0afade84-7334-aa49-baf1-065e1134b4b8"],
Cell[CellGroupData[{
Cell[26249, 569, 3223, 45, 28, "Input",ExpressionUUID->"547f6a7a-61c6-364c-a431-e80d01d61427"],
Cell[29475, 616, 3305, 45, 32, "Output",ExpressionUUID->"bcd0bf11-6e5e-db4f-bed2-47eec819c35f"],
Cell[32783, 663, 204, 5, 22, "Print",ExpressionUUID->"d978d586-e301-9745-9c48-15b2c4295ab4"]
}, Open  ]],
Cell[33002, 671, 613, 8, 28, "Input",ExpressionUUID->"906e6b48-4882-6c4b-a0d8-62fd1bb276a1"],
Cell[33618, 681, 170, 2, 28, "Input",ExpressionUUID->"30b8ca4d-7eeb-9f44-a359-7ad85f4ef41c"],
Cell[33791, 685, 690, 9, 28, "Input",ExpressionUUID->"4d7e8a35-bc1a-a447-ad7f-b1c09ee3ed00"],
Cell[34484, 696, 298, 4, 48, "Input",ExpressionUUID->"f5f83fe0-ffc8-2148-86f3-bdf0fb2224fc"],
Cell[34785, 702, 170, 2, 28, "Input",ExpressionUUID->"27061fb2-65d4-c94b-b0bc-4ec8e69bf990"],
Cell[34958, 706, 147, 2, 28, "Input",ExpressionUUID->"0c0ad04d-3cf0-1347-a19b-ef012b93cbcf"],
Cell[35108, 710, 147, 2, 28, "Input",ExpressionUUID->"f76a4a73-5596-0e4c-ae72-fcdeec32dc5e"]
}
]
*)

