# 自定义模型

ms-swift内置的模型，你可以直接通过指定model_id或者model_path来使用：`--model <model_id_or_path>`。ms-swift会根据model_id/model_path的后缀和`config.json`文件来判断model_type。

每种model_type都有唯一的模型结构、template和加载方式。当然，你也可以手动传入`--model_type`、`--template`来进行覆盖。ms-swift已支持的model_type和template可以查看[支持的模型与数据集](../Instruction/Supported-models-and-datasets.md)。

以下介绍如何注册一个新模型和对应的template。最佳实践参考[注册多模态模型最佳实践](../BestPractices/MLLM-Registration.md)。

## 模型注册

自定义模型通常使用模型注册的方式进行，可以参考[内置模型](https://github.com/modelscope/ms-swift/blob/main/swift/model/models/qwen.py)、[内置对话模板](https://github.com/modelscope/ms-swift/blob/main/swift/template/templates/qwen.py)或者[examples](https://github.com/modelscope/ms-swift/blob/main/examples/custom)的示例代码。你可以通过指定`--external_plugins xxx.py`解析外置注册的内容（方便pip install而非git clone的用户）。

register_model会在`MODEL_MAPPING`中注册模型，调用函数`register_model(model_meta)`即可完成模型注册，其中model_meta将存储模型的元信息。ModelMeta的参数列表如下：
- model_type: 必填项。模型类型，也是唯一ID。
- model_groups: 必填项。罗列ModelScope/HuggingFace的模型id和模型本地路径。运行[run_model_info.py](https://github.com/modelscope/ms-swift/blob/main/scripts/utils/run_model_info.py)文件将自动产生[支持的模型文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/Supported-models-and-datasets.html)以及自动根据`--model`后缀匹配model_type。
- loader: 模型和tokenizer/processor（多模态模型）的加载器。默认使用`swift.model.ModelLoader`。
- template: 命令行不额外指定`--template`时的默认template类型。默认为None。
- model_arch: 模型架构。默认为None。多模态模型训练需要设置该参数来确定llm/vit/aligner的前缀。
- architectures: config.json中的architectures项，用于自动匹配模型对应的model_type。默认为`[]`。
- additional_saved_files: 全参数训练和merge-lora时需要额外保存的文件。默认为`[]`。
- torch_dtype: 模型加载时未传入`torch_dtype`时的默认dtype。默认为None，从config.json中读取。
- is_multimodal: 是否是多模态模型，默认为False。
- ignore_patterns: 从hub端下载文件需要忽略的文件patterns，默认为`[]`。


register_template会在`TEMPLATE_MAPPING`中注册对话模板，调用函数`register_template(template_meta)`即可完成对话模板注册，其中template_meta将存储template的元信息。TemplateMeta的参数列表如下：
- template_type: 必填项。对话模板类型，也是唯一ID。
- prefix: 必填项。对话模板的前缀，通常包含system、bos_token等部分，独立于多轮对话而产生的对话模板循环。例如qwen的prefix为`[]`。
- prompt: 必填项。表示对话模板中的`{{RESPONSE}}`之前的对话部分。我们使用`{{QUERY}}`代表user询问部分的填充符。例如qwen的prompt为`['<|im_start|>user\n{{QUERY}}<|im_end|>\n<|im_start|>assistant\n']`。
- chat_sep: 必填项。多轮对话中每轮的分隔符。若设置为None，则该template不支持多轮对话。例如qwen的chat_sep为`['<|im_end|>\n']`。
- suffix: 默认为`[['eos_token_id']]`。对话模板的后缀部分，独立于多轮对话而产生的对话模板循环，通常为eos_token。例如qwen的suffix为`['<|im_end|>']。`
- template_cls: 默认为`Template`。通常在定义多模态模型的template时需要进行自定义，自定义`_encode`、`_post_encode`、`_data_collator`函数。
- system_prefix: 默认为None。含system的对话模板前缀。我们使用`{{SYSTEM}}`作为system的填充符。例如qwen的system_prefix为`['<|im_start|>system\n{{SYSTEM}}<|im_end|>\n']`。
  - 注意：若system为空时，`prefix`可以被`system_prefix`替代，则可以将`prefix`写为含system的前缀，而无需设置`system_prefix`。
  - 若prefix不含`{{SYSTEM}}`且未设置system_prefix，则该template不支持system。
- default_system: 默认为None。不传入`--system`时使用的默认system。例如qwen的default_system为`'You are a helpful assistant.'`。
- stop_words: 默认为`[]`。除了eos_token和`suffix[-1]`的额外停止符。例如qwen的stop_words为`['<|endoftext|>']`。
  - 注意：推理时，输出的response将会过滤eos_token和`suffix[-1]`，但是会保留额外的stop_words。
