# 贡献者指引

*欢迎帮SWIFT提供Feature PR、Bug反馈、文档补充或其他类型的贡献！*

## 目录

- [代码规约](#-代码规约)
- [贡献流程](#-贡献流程)
- [资源支持](#-资源支持)

## 📖 代码规约

请查看我们的[代码规约文档](./CODE_OF_CONDUCT.md).

## 🔁 贡献流程

### 我们需要什么
- 新技术和新模型：SWIFT需要支持更多的开源模型和数据集，或我们没有关注到的新技术，如果您对此有兴趣，可以提交PR给我们。
- 技术布道：如果您对技术布道有兴趣，欢迎在任何网站上帮我们撰写教程文档或视频等，并将链接发给我们。
- 社区供稿：您可以撰写和SWIFT有关的技术文章，并供稿给我们，我们审核通过后会在魔搭官方账号（知乎、公众号等）上进行发布，并属上您的名字。

### 激励

- 我们会以魔搭社区的身份给贡献者颁发电子证书，以鼓励您的无私贡献。
- 我们会赠送相关魔搭社区相关周边小礼品。
- 我们会赠送开发期间的免费A10算力，具体可以查看[资源支持](#-资源支持)章节。

### 提交PR（Pull Requests）

任何feature开发都在github上以先Fork后PR的形式进行。

1. Fork：进入[ms-swift](https://github.com/modelscope/ms-swift)页面后，点击**Fork按钮**执行。完成后会在您的个人组织下克隆出一个SWIFT代码库

2. Clone：将第一步产生的代码库clone到本地并**拉新分支**进行开发，开发中请及时点击**Sync Fork按钮**同步`main`分支，防止代码过期并冲突

3. 提交PR：开发、测试完成后将代码推送到远程分支。在github上点击**Pull Requests页面**，新建一个PR，源分支选择您提交的代码分支，目标分支选择`modelscope/swift:main`分支

4. 撰写描述：在PR中填写良好的feature描述是必要的，让Reviewers知道您的修改内容

5. Review：我们希望合入的代码简洁高效，因此可能会提出一些问题并讨论。请注意，任何review中提出的问题是针对代码本身，而非您个人。在所有问题讨论通过后，您的代码会被通过

### 代码规范和开发方式

SWIFT有约定俗成的变量命名方式和开发方式。在开发中请尽量遵循这些方式。

1. 变量命名以下划线分割，类名以所有单词首字母大写方式命名
2. 所有的python缩进都是四个空格取代一个tab
3. 选用知名的开源库，避免使用闭源库或不稳定的开源库，避免重复造轮子

SWIFT在PR提交后会进行两类测试：

- Code Lint测试 对代码进行静态规范走查的测试，为保证改测试通过，请保证本地预先进行了Code lint。方法是：

  ```shell
  pip install pre-commit
  # 在swift文件夹内
  pre-commit run --all-files
  # 对pre-commit报的错误进行修改，直到所有的检查都是成功状态
  ```

- CI Tests 冒烟测试和单元测试，请查看下一章节

### Running CI Tests

在提交PR前，请保证您的开发代码已经受到了测试用例的保护。例如，对新功能的冒烟测试，或者各种边缘case的单元测试等。在代码review时Reviewers也会关注这一点。同时，也会有服务专门运行CI Tests，运行所有的测试用例，测试用例通过后代码才可以合并。

## ✅ 资源支持

SWIFT会为开发者提供资源支持，包括免费的GPU算力。如果需要请邮件联系我们（[contact@modelscope.cn](mailto:contact@modelscope.cn)）或加入我们的微信群：

<p align="left">
<img src="asset/wechat.png" width="250" style="display: inline-block;">
</p>
