/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.IUriHandler;
import org.jumpmind.symmetric.web.ServerSymmetricEngine;
import org.jumpmind.symmetric.web.ServletUtils;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SymmetricServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NETWORK_ERROR_FOR_LOGGING = 5;
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Map<String, Integer> rejectionStatusByEngine = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServerSymmetricEngine engine = this.findEngine(req);
        MDC.put((String)"engineName", (String)(engine != null ? engine.getEngineName() : "?"));
        if (engine == null) {
            boolean nodesBeingCreated = ServletUtils.getSymmetricEngineHolder(this.getServletContext()).areEnginesStarting();
            if (nodesBeingCreated) {
                if (this.shouldLog(SymmetricServlet.getEngineNameFromUrl(req), 1)) {
                    this.log.info("Requests for engine " + SymmetricServlet.getEngineNameFromUrl(req) + " are being rejected because nodes are still initializing");
                }
                this.log.debug("The client node request is being rejected because the server node does not exist yet.  There are nodes being initialized.  It might be that the node is not ready or that the database is unavailable.  Please be patient.  The request was {} from the host {} with an ip address of {}.  The query string was: {}", new Object[]{ServletUtils.normalizeRequestUri(req), req.getRemoteHost(), req.getRemoteAddr(), req.getQueryString()});
            } else {
                this.log.warn("The client node request is being rejected because the server node does not exist.  Please check that the engine.name exists in the url.  It should be of the pattern http://host:port/sync/{engine.name}/{action}.  If it does not, then check the sync.url of this node or the registration.url of the client making the request.  The request was {} from the host {} with an ip address of {}.  The query string was: {}", new Object[]{ServletUtils.normalizeRequestUri(req), req.getRemoteHost(), req.getRemoteAddr(), req.getQueryString()});
            }
            ServletUtils.sendError(res, 660);
            return;
        } else if (engine.isStarted()) {
            IUriHandler handler = this.findMatchingHandler(engine, req);
            if (handler != null) {
                List<IInterceptor> beforeInterceptors = handler.getInterceptors();
                ArrayList<IInterceptor> afterInterceptors = null;
                try {
                    String nodeId = req.getParameter("nodeId");
                    if (beforeInterceptors != null) {
                        afterInterceptors = new ArrayList<IInterceptor>(beforeInterceptors.size());
                        for (IInterceptor interceptor : beforeInterceptors) {
                            if (!interceptor.before(req, res)) {
                                return;
                            }
                            afterInterceptors.add(interceptor);
                        }
                    }
                    handler.handle(req, res);
                    engine.resetErrorCountForNode(nodeId);
                    return;
                }
                catch (Exception e) {
                    this.logException(req, engine, e);
                    if (!res.isCommitted()) {
                        ServletUtils.sendError(res, 500);
                    }
                }
                finally {
                    if (afterInterceptors == null) return;
                    for (IInterceptor interceptor : afterInterceptors) {
                        interceptor.after(req, res);
                    }
                    return;
                }
            } else {
                this.log.warn("The request path of the url could not be handled. Check the engine.name of the target node vs. the sync URL of the source node. The request was {} from the host {} with an ip address of {}.  The query string was: {}", new Object[]{ServletUtils.normalizeRequestUri(req), req.getRemoteHost(), req.getRemoteAddr(), req.getQueryString()});
                ServletUtils.sendError(res, 400);
            }
            return;
        } else if (engine.isStarting()) {
            if (this.shouldLog(engine.getEngineName(), 2)) {
                this.log.info("Requests for engine " + engine.getEngineName() + " are being rejected while it is starting");
            }
            this.log.debug("The client node request is being rejected because the server node is currently starting.  Please be patient.  The request was {} from the host {} with an ip address of {} will not be processed.  The query string was: {}", new Object[]{ServletUtils.normalizeRequestUri(req), req.getRemoteHost(), req.getRemoteAddr(), req.getQueryString()});
            ServletUtils.sendError(res, 660);
            return;
        } else if (!engine.isStarted() && !engine.isConfigured()) {
            if (this.shouldLog(engine.getEngineName(), 3)) {
                this.log.info("Requests for engine " + engine.getEngineName() + " are being rejected because it is not configured properly");
            }
            this.log.debug("The client node request is being rejected because the server node was not started because it is not configured properly. The request {} from the host {} with an ip address of {} will not be processed.  The query string was: {}", new Object[]{ServletUtils.normalizeRequestUri(req), req.getRemoteHost(), req.getRemoteAddr(), req.getQueryString()});
            ServletUtils.sendError(res, 660);
            return;
        } else {
            if (this.shouldLog(engine.getEngineName(), 4)) {
                this.log.info("Requests for engine " + engine.getEngineName() + " are being rejected because it is not started");
            }
            this.log.debug("The client node request is being rejected because the server node is not started. The request {} from the host {} with an ip address of {} will not be processed.  The query string was: {}", new Object[]{ServletUtils.normalizeRequestUri(req), req.getRemoteHost(), req.getRemoteAddr(), req.getQueryString()});
            ServletUtils.sendError(res, 660);
        }
    }

    protected ServerSymmetricEngine findEngine(HttpServletRequest req) {
        String engineName = SymmetricServlet.getEngineNameFromUrl(req);
        ServerSymmetricEngine engine = null;
        SymmetricEngineHolder holder = ServletUtils.getSymmetricEngineHolder(this.getServletContext());
        if (holder != null) {
            if (engineName != null) {
                engine = holder.getEngines().get(engineName);
            }
            if (holder.getEngineCount() == 1 && engine == null && holder.getNumerOfEnginesStarting() <= 1 && holder.getEngines().size() == 1) {
                engine = holder.getEngines().values().iterator().next();
            }
        }
        return engine != null ? engine : null;
    }

    protected static String getEngineNameFromUrl(HttpServletRequest req) {
        String normalizedUri;
        String engineName = null;
        int startIndex = (normalizedUri = ServletUtils.normalizeRequestUri(req)).startsWith("/") ? 1 : 0;
        int endIndex = normalizedUri.indexOf("/", startIndex);
        if (endIndex > 0) {
            engineName = normalizedUri.substring(startIndex, endIndex);
        }
        return engineName;
    }

    protected Collection<IUriHandler> getUriHandlersFrom(ServerSymmetricEngine engine) {
        if (engine != null) {
            return engine.getUriHandlers();
        }
        return null;
    }

    protected IUriHandler findMatchingHandler(ServerSymmetricEngine engine, HttpServletRequest req) throws ServletException {
        Collection<IUriHandler> handlers = this.getUriHandlersFrom(engine);
        if (handlers != null) {
            for (IUriHandler handler : handlers) {
                if (!this.matchesUriPattern(this.normalizeUri((ISymmetricEngine)engine, req), handler.getUriPattern()) || !handler.isEnabled()) continue;
                return handler;
            }
        }
        return null;
    }

    protected boolean matchesUriPattern(String uri, String uriPattern) {
        boolean retVal = false;
        String path = (String)StringUtils.defaultIfEmpty((CharSequence)uri, (CharSequence)"/");
        String pattern = (String)StringUtils.defaultIfEmpty((CharSequence)uriPattern, (CharSequence)"/");
        if ("/".equals(pattern) || "/*".equals(pattern) || pattern.equals(path)) {
            retVal = true;
        } else {
            String[] patternParts = StringUtils.split((String)pattern, (String)"/");
            String[] pathParts = StringUtils.split((String)path, (String)"/");
            boolean matches = true;
            for (int i = 0; i < patternParts.length && i < pathParts.length && matches; ++i) {
                String patternPart = patternParts[i];
                matches = "*".equals(patternPart) || patternPart.equals(pathParts[i]);
            }
            retVal = matches;
        }
        return retVal;
    }

    protected String normalizeUri(ISymmetricEngine engine, HttpServletRequest req) {
        String removeString;
        String uri = ServletUtils.normalizeRequestUri(req);
        if (engine != null && uri.startsWith(removeString = "/" + engine.getEngineName())) {
            uri = uri.substring(removeString.length());
        }
        return uri;
    }

    protected void logException(HttpServletRequest req, ServerSymmetricEngine engine, Exception ex) {
        String nodeId = req.getParameter("nodeId");
        String externalId = req.getParameter("externalId");
        String address = req.getRemoteAddr();
        String hostName = req.getRemoteHost();
        String method = req instanceof HttpServletRequest ? req.getMethod() : "";
        Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
        int errorCount = engine.getErrorCountFor(nodeId);
        String msg = String.format("Error while processing %s request for node: %s", method, nodeId);
        if (!StringUtils.isEmpty((CharSequence)externalId) && !StringUtils.equals((CharSequence)nodeId, (CharSequence)externalId)) {
            msg = msg + String.format(" externalId: %s", externalId);
        }
        if (!StringUtils.isEmpty((CharSequence)hostName) && !StringUtils.isEmpty((CharSequence)address)) {
            msg = StringUtils.equals((CharSequence)hostName, (CharSequence)address) ? msg + String.format(" at %s", hostName) : msg + String.format(" at %s (%s)", address, hostName);
        } else if (!StringUtils.isEmpty((CharSequence)hostName)) {
            msg = msg + String.format(" at %s", hostName);
        } else if (!StringUtils.isEmpty((CharSequence)address)) {
            msg = msg + String.format(" at %s", address);
        }
        msg = msg + String.format(" with path: %s", ServletUtils.normalizeRequestUri(req));
        if (!(ex instanceof IOException) && !(root instanceof IOException) || errorCount >= 5) {
            this.log.error(msg, (Throwable)ex);
        } else if (this.log.isDebugEnabled()) {
            this.log.info(msg, (Throwable)ex);
        } else {
            this.log.info(msg + " The message is: " + ex.getMessage());
        }
        engine.incrementErrorCountForNode(nodeId);
    }

    protected boolean shouldLog(String engineName, int status) {
        Integer lastStatus = this.rejectionStatusByEngine.get(engineName);
        if (lastStatus == null || lastStatus < status) {
            this.rejectionStatusByEngine.put(engineName, status);
            return true;
        }
        return false;
    }
}

