/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.OutgoingBatch;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.TransportUtils;
import org.jumpmind.symmetric.web.AbstractCompressionUriHandler;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.ServletUtils;

public class PullUriHandler
extends AbstractCompressionUriHandler {
    private INodeService nodeService;
    private IConfigurationService configurationService;
    private IDataExtractorService dataExtractorService;
    private IRegistrationService registrationService;
    private IStatisticManager statisticManager;
    private IOutgoingBatchService outgoingBatchService;

    public PullUriHandler(IParameterService parameterService, INodeService nodeService, IConfigurationService configurationService, IDataExtractorService dataExtractorService, IRegistrationService registrationService, IStatisticManager statisticManager, IOutgoingBatchService outgoingBatchService, IInterceptor ... interceptors) {
        super("/pull/*", parameterService, interceptors);
        this.nodeService = nodeService;
        this.configurationService = configurationService;
        this.dataExtractorService = dataExtractorService;
        this.registrationService = registrationService;
        this.statisticManager = statisticManager;
        this.outgoingBatchService = outgoingBatchService;
    }

    @Override
    public void handleWithCompression(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String nodeId = ServletUtils.getParameter(req, "nodeId");
        this.log.debug("Pull requested from node {} at remote address {}", (Object)nodeId, (Object)req.getRemoteAddr());
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            ServletUtils.sendError(res, 400, "Node must be specified");
            return;
        }
        ChannelMap map = new ChannelMap();
        map.addSuspendChannels(req.getHeader("Suspended-Channels"));
        map.addIgnoreChannels(req.getHeader("Ignored-Channels"));
        map.setChannelQueue(req.getHeader("threadChannel"));
        this.handlePull(nodeId, req.getRemoteHost(), req.getRemoteAddr(), (OutputStream)res.getOutputStream(), req.getHeader("Accept-Charset"), res, map);
        this.log.debug("Pull completed for {} at remote address {}", (Object)nodeId, (Object)req.getRemoteAddr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePull(String nodeId, String remoteHost, String remoteAddress, OutputStream outputStream, String encoding, HttpServletResponse res, ChannelMap map) throws IOException {
        block10: {
            NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(nodeId, true);
            long ts = System.currentTimeMillis();
            try {
                ChannelMap remoteSuspendIgnoreChannelsList = this.configurationService.getSuspendIgnoreChannelLists(nodeId);
                map.addSuspendChannels((Collection)remoteSuspendIgnoreChannelsList.getSuspendChannels());
                map.addIgnoreChannels((Collection)remoteSuspendIgnoreChannelsList.getIgnoreChannels());
                if (nodeSecurity != null) {
                    String createdAtNodeId = nodeSecurity.getCreatedAtNodeId();
                    if (nodeSecurity.isRegistrationEnabled() && (createdAtNodeId == null || createdAtNodeId.equals(this.nodeService.findIdentityNodeId()))) {
                        this.registrationService.registerNode(this.nodeService.findNode(nodeId), remoteHost, remoteAddress, outputStream, null, null, false);
                        break block10;
                    }
                    IOutgoingTransport outgoingTransport = this.createOutgoingTransport(outputStream, encoding, map);
                    ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(this.nodeService.findIdentityNodeId(), map.getChannelQueue(), nodeId, ProcessType.PULL_HANDLER_EXTRACT));
                    try {
                        Node targetNode = this.nodeService.findNode(nodeId, true);
                        List batchList = this.dataExtractorService.extract(processInfo, targetNode, map.getChannelQueue(), outgoingTransport);
                        this.logDataReceivedFromPull(targetNode, batchList, processInfo, remoteHost);
                        if (processInfo.getStatus() != ProcessInfo.ProcessStatus.ERROR) {
                            this.addPendingBatchCounts(targetNode.getNodeId(), res);
                            processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
                        }
                    }
                    finally {
                        if (processInfo.getStatus() != ProcessInfo.ProcessStatus.OK) {
                            processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                        }
                    }
                    outgoingTransport.close();
                    break block10;
                }
                this.log.warn("Node {} does not exist", (Object)nodeId);
            }
            finally {
                this.statisticManager.incrementNodesPulled(1L);
                this.statisticManager.incrementTotalNodesPulledTime(System.currentTimeMillis() - ts);
            }
        }
    }

    private void addPendingBatchCounts(String targetNodeId, HttpServletResponse res) {
        Map batchesToSendByChannel;
        if (this.parameterService.is("hybrid.push.pull.enabled") && (batchesToSendByChannel = this.outgoingBatchService.countOutgoingBatchesPendingByChannel(targetNodeId)) != null && !batchesToSendByChannel.isEmpty()) {
            res.addHeader("Batch-To-Send-Count", TransportUtils.toCSV((Map)batchesToSendByChannel));
        }
    }

    private void logDataReceivedFromPull(Node targetNode, List<OutgoingBatch> batchList, ProcessInfo processInfo, String remoteHost) {
        int batchesCount = 0;
        int dataCount = 0;
        for (OutgoingBatch outgoingBatch : batchList) {
            if (outgoingBatch.getStatus() != AbstractBatch.Status.LD) continue;
            ++batchesCount;
            dataCount = (int)((long)dataCount + outgoingBatch.getDataRowCount());
        }
        if (batchesCount > 0) {
            this.statisticManager.addJobStats(targetNode.getNodeId(), 1, "Pull Handler", processInfo.getStartTime().getTime(), processInfo.getLastStatusChangeTime().getTime(), (long)dataCount);
            this.log.info("{} data and {} batches sent during pull request from {}", new Object[]{dataCount, batchesCount, targetNode.toString()});
        }
    }
}

