/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import org.jumpmind.symmetric.model.ChannelMap;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.transport.IOutgoingTransport;
import org.jumpmind.symmetric.transport.internal.InternalOutgoingTransport;
import org.jumpmind.symmetric.web.IInterceptor;
import org.jumpmind.symmetric.web.IUriHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUriHandler
implements IUriHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String uriPattern;
    private List<IInterceptor> interceptors;
    protected IParameterService parameterService;
    private boolean enabled = true;

    public AbstractUriHandler(String uriPattern, IParameterService parameterService, IInterceptor ... interceptors) {
        this.uriPattern = uriPattern;
        this.interceptors = new ArrayList<IInterceptor>(interceptors.length);
        for (IInterceptor i : interceptors) {
            this.interceptors.add(i);
        }
        this.parameterService = parameterService;
    }

    protected InputStream createInputStream(HttpServletRequest req) throws IOException {
        Object is = null;
        String contentType = req.getHeader("Content-Type");
        boolean useCompression = contentType != null && (contentType.equalsIgnoreCase("gzip") || contentType.equalsIgnoreCase("application/gzip"));
        is = req.getInputStream();
        if (useCompression) {
            is = new GZIPInputStream((InputStream)is);
        }
        return is;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    @Override
    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setInterceptors(List<IInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public List<IInterceptor> getInterceptors() {
        return this.interceptors;
    }

    protected IOutgoingTransport createOutgoingTransport(OutputStream outputStream, String encoding, ChannelMap map) throws IOException {
        return new InternalOutgoingTransport(outputStream, map, encoding);
    }

    protected IOutgoingTransport createOutgoingTransport(OutputStream outputStream, String encoding) throws IOException {
        return new InternalOutgoingTransport(outputStream, new ChannelMap(), encoding);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

