/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.net.CookieHandler;
import java.net.CookieManager;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.transport.TransportManagerFactory;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.symmetric.web.HttpMethodFilter;
import org.jumpmind.symmetric.web.ServletUtils;
import org.jumpmind.symmetric.web.SymmetricEngineHolder;
import org.jumpmind.symmetric.web.rest.RestService;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SymmetricWebServer {
    private static final Logger log = LoggerFactory.getLogger(SymmetricWebServer.class);
    protected static final String DEFAULT_WEBAPP_DIR = System.getProperty("symmetric.default.web.dir", AppUtils.getSymHome() + "/web");
    public static final String DEFAULT_HTTP_PORT = System.getProperty("symmetric.default.http.port", "31415");
    public static final String DEFAULT_HTTPS_PORT = System.getProperty("symmetric.default.https.port", "31417");
    public static final int DEFAULT_MAX_IDLE_TIME = 90000;
    private Server server;
    private WebAppContext webapp;
    protected boolean join = true;
    protected String webHome = "/";
    protected int maxIdleTime = 90000;
    protected boolean httpEnabled = true;
    protected int httpPort = Integer.parseInt(DEFAULT_HTTP_PORT);
    protected boolean httpsEnabled = false;
    protected boolean https2Enabled = false;
    protected int httpsPort = -1;
    protected String propertiesFile = null;
    protected String host = null;
    protected boolean noNio = false;
    protected boolean noDirectBuffer = false;
    protected String webAppDir = DEFAULT_WEBAPP_DIR;
    protected String name = "SymmetricDS";
    protected String httpSslVerifiedServerNames = "all";
    protected boolean httpsNeedClientAuth = false;
    protected boolean httpsWantClientAuth = false;
    protected String allowDirListing = "false";
    protected String disallowedMethods = "OPTIONS";
    protected String allowedMethods = "";
    protected boolean allowSelfSignedCerts = true;
    protected boolean accessLogEnabled = false;
    protected String accessLogFile;
    protected String cookieName;

    public SymmetricWebServer() {
        this(null, DEFAULT_WEBAPP_DIR);
    }

    public SymmetricWebServer(String propertiesUrl) {
        this(propertiesUrl, DEFAULT_WEBAPP_DIR);
    }

    public SymmetricWebServer(int maxIdleTime, String propertiesUrl) {
        this(propertiesUrl, DEFAULT_WEBAPP_DIR);
        this.maxIdleTime = maxIdleTime;
    }

    public SymmetricWebServer(String webDirectory, int maxIdleTime, String propertiesUrl, boolean join, boolean noNio, boolean noDirectBuffer) {
        this(propertiesUrl, webDirectory);
        this.maxIdleTime = maxIdleTime;
        this.join = join;
        this.noDirectBuffer = noDirectBuffer;
        this.noNio = noNio;
    }

    public SymmetricWebServer(String propertiesUrl, String webappDir) {
        this.propertiesFile = propertiesUrl;
        this.webAppDir = webappDir;
        this.initFromProperties();
    }

    protected final void initFromProperties() {
        try {
            Class.forName(AbstractCommandLauncher.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        TypedProperties serverProperties = new TypedProperties(System.getProperties());
        this.httpEnabled = serverProperties.is("http.enable", Boolean.parseBoolean(System.getProperty("http.enable", "true")));
        this.httpsEnabled = serverProperties.is("https.enable", Boolean.parseBoolean(System.getProperty("https.enable", "true")));
        this.https2Enabled = serverProperties.is("https2.enable", Boolean.parseBoolean(System.getProperty("https2.enable", "false")));
        this.httpPort = serverProperties.getInt("http.port", Integer.parseInt(System.getProperty("http.port", "" + this.httpPort)));
        this.httpsPort = serverProperties.getInt("https.port", Integer.parseInt(System.getProperty("https.port", "" + this.httpsPort)));
        this.host = serverProperties.get("host.bind.name", System.getProperty("host.bind.name", this.host));
        this.httpSslVerifiedServerNames = serverProperties.get("https.verified.server.names", System.getProperty("https.verified.server.names", this.httpSslVerifiedServerNames));
        this.allowSelfSignedCerts = serverProperties.is("https.allow.self.signed.certs", Boolean.parseBoolean(System.getProperty("https.allow.self.signed.certs", "" + this.allowSelfSignedCerts)));
        this.allowDirListing = serverProperties.get("server.allow.dir.list", "false");
        this.allowedMethods = serverProperties.get("server.allow.http.methods", "");
        this.disallowedMethods = serverProperties.get("server.disallow.http.methods", "OPTIONS");
        this.httpsNeedClientAuth = serverProperties.is("https.need.client.auth", false);
        this.httpsWantClientAuth = serverProperties.is("https.want.client.auth", false);
        this.accessLogEnabled = serverProperties.is("server.access.log.enabled", false);
        this.accessLogFile = serverProperties.get("server.access.log.file");
        this.cookieName = serverProperties.get("server.cookie.name");
        if (serverProperties.is("server.http.cookies.enabled", false) && CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
        if (StringUtils.isBlank((CharSequence)this.cookieName)) {
            this.cookieName = "JSESSIONID_" + (this.httpsPort > 0 && this.httpsEnabled ? Integer.valueOf(this.httpsPort) : "") + (this.httpEnabled && this.httpPort > 0 ? "_" + this.httpPort : "");
        }
    }

    public SymmetricWebServer start() throws Exception {
        if (this.httpPort > 0 && this.httpsPort > 0 && this.httpEnabled && this.httpsEnabled) {
            return this.startMixed(this.httpPort, this.httpsPort);
        }
        if (this.httpPort > 0 && this.httpEnabled) {
            return this.start(this.httpPort);
        }
        if (this.httpsPort > 0 && this.httpsEnabled) {
            return this.startSecure(this.httpsPort);
        }
        throw new IllegalStateException("Either an http or https port needs to be set before starting the server.");
    }

    public SymmetricWebServer start(int httpPort) throws Exception {
        return this.start(httpPort, 0, Mode.HTTP);
    }

    public SymmetricWebServer startSecure(int httpsPort) throws Exception {
        return this.start(0, httpsPort, Mode.HTTPS);
    }

    public SymmetricWebServer startMixed(int httpPort, int secureHttpPort) throws Exception {
        return this.start(httpPort, secureHttpPort, Mode.MIXED);
    }

    public SymmetricWebServer start(int httpPort, int securePort, Mode mode) throws Exception {
        SymmetricUtils.logNotices();
        TransportManagerFactory.initHttps((String)this.httpSslVerifiedServerNames, (boolean)this.allowSelfSignedCerts, (boolean)this.https2Enabled);
        System.setProperty("symmetric.standalone.web", "true");
        this.server = new Server();
        this.server.setConnectors(this.getConnectors(this.server, httpPort, securePort, mode));
        this.webapp = new WebAppContext();
        this.webapp.setParentLoaderPriority(true);
        this.webapp.setConfigurationDiscovered(true);
        if (System.getProperty("symmetric.server.web.home") != null) {
            this.webHome = System.getProperty("symmetric.server.web.home");
        }
        this.webapp.setContextPath(this.webHome);
        this.webapp.setWar(this.webAppDir);
        this.webapp.setResourceBase(this.webAppDir);
        this.webapp.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", this.allowDirListing);
        FilterHolder filterHolder = new FilterHolder(HttpMethodFilter.class);
        filterHolder.setInitParameter("server.allow.http.methods", this.allowedMethods);
        filterHolder.setInitParameter("server.disallow.http.methods", this.disallowedMethods);
        this.webapp.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        this.webapp.getServletContext().getContextHandler().setMaxFormContentSize(Integer.parseInt(System.getProperty("org.eclipse.jetty.server.Request.maxFormContentSize", "800000")));
        this.webapp.getServletContext().getContextHandler().setMaxFormKeys(Integer.parseInt(System.getProperty("org.eclipse.jetty.server.Request.maxFormKeys", "100000")));
        if (this.propertiesFile != null) {
            this.webapp.getServletContext().getContextHandler().setInitParameter("singleServerPropertiesFile", this.propertiesFile);
            this.webapp.getServletContext().getContextHandler().setInitParameter("multiServerMode", Boolean.toString(false));
        } else {
            this.webapp.getServletContext().getContextHandler().setInitParameter("multiServerMode", Boolean.toString(true));
        }
        this.webapp.getSessionHandler().getSessionCookieConfig().setName(this.cookieName);
        this.webapp.getSessionHandler().getSessionCookieConfig().setHttpOnly(true);
        if (this.httpsEnabled && !this.httpEnabled) {
            this.webapp.getSessionHandler().getSessionCookieConfig().setSecure(true);
        }
        if (this.accessLogEnabled) {
            RequestLogWriter writer = new RequestLogWriter();
            if (StringUtils.isNotBlank((CharSequence)this.accessLogFile)) {
                writer = new RequestLogWriter(this.accessLogFile);
            }
            this.server.setRequestLog((RequestLog)new CustomRequestLog((RequestLog.Writer)writer, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\""));
        }
        this.server.setHandler((Handler)this.webapp);
        Class<?> remoteStatusEndpoint = this.loadRemoteStatusEndpoint();
        if (remoteStatusEndpoint != null) {
            ServerContainer container = WebSocketServerContainerInitializer.initialize((ServletContextHandler)this.webapp);
            container.setDefaultMaxBinaryMessageBufferSize(Integer.MAX_VALUE);
            container.setDefaultMaxTextMessageBufferSize(Integer.MAX_VALUE);
            ServerEndpointConfig websocketConfig = ServerEndpointConfig.Builder.create(remoteStatusEndpoint, (String)"/control").build();
            container.addEndpoint(websocketConfig);
            if (this.allowSelfSignedCerts) {
                System.setProperty("org.eclipse.jetty.websocket.jsr356.ssl-trust-all", "true");
            }
        }
        this.server.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                System.out.println("Started");
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
                log.info("Web server failed to start: " + cause.getMessage());
            }

            public void lifeCycleStopping(LifeCycle event) {
                log.info("Web server is stopping");
            }
        });
        this.server.start();
        if (this.join) {
            log.info("Joining the web server main thread");
            this.server.join();
        }
        return this;
    }

    protected ServletContext getServletContext() {
        return this.webapp != null ? this.webapp.getServletContext() : null;
    }

    public RestService getRestService() {
        ServletContext servletContext = this.getServletContext();
        WebApplicationContext rootContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        RestService restService = null;
        if (rootContext != null) {
            restService = (RestService)rootContext.getBean(RestService.class);
        }
        return restService;
    }

    public ISymmetricEngine getEngine() {
        SymmetricEngineHolder engineHolder;
        ISymmetricEngine engine = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null && (engineHolder = ServletUtils.getSymmetricEngineHolder(servletContext)) != null) {
            if (engineHolder.getEngines().size() == 1) {
                return (ISymmetricEngine)engineHolder.getEngines().values().iterator().next();
            }
            throw new IllegalStateException("Could not choose a single engine to return.  There are " + engineHolder.getEngines().size() + " engines configured.");
        }
        return engine;
    }

    public ISymmetricEngine getEngine(String name) {
        SymmetricEngineHolder engineHolder;
        ISymmetricEngine engine = null;
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null && (engineHolder = ServletUtils.getSymmetricEngineHolder(servletContext)) != null) {
            return (ISymmetricEngine)engineHolder.getEngines().get(name);
        }
        return engine;
    }

    public void waitForEnginesToComeOnline(long maxWaitTimeInMs) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        ServletContext servletContext = this.getServletContext();
        if (servletContext != null) {
            SymmetricEngineHolder engineHolder = ServletUtils.getSymmetricEngineHolder(servletContext);
            while (engineHolder.areEnginesStarting()) {
                AppUtils.sleep((long)500L);
                if (System.currentTimeMillis() - startTime <= maxWaitTimeInMs) continue;
                throw new InterruptedException("Timed out waiting for engines to start");
            }
        }
    }

    protected Connector[] getConnectors(Server server, int port, int securePort, Mode mode) {
        ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
        HttpConfiguration httpConfig = new HttpConfiguration();
        if (mode == Mode.HTTPS || mode == Mode.MIXED) {
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(securePort);
        }
        httpConfig.setSendServerVersion(false);
        httpConfig.setOutputBufferSize(32768);
        if (mode == Mode.HTTP || mode == Mode.MIXED) {
            ServerConnector http = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            http.setPort(port);
            http.setHost(this.host);
            http.setIdleTimeout((long)this.maxIdleTime);
            connectors.add(http);
            log.info("About to start {} web server on {}:{}:{}", new Object[]{this.name, this.host == null ? "default" : this.host, port, "HTTP/1.1"});
        }
        if (mode == Mode.HTTPS || mode == Mode.MIXED) {
            ISecurityService securityService = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)SecurityServiceFactory.SecurityServiceType.SERVER, (TypedProperties)new TypedProperties(System.getProperties()));
            securityService.installDefaultSslCert(this.host);
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            keyStorePassword = keyStorePassword != null ? keyStorePassword : "changeit";
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            sslContextFactory.setKeyStore(securityService.getKeyStore());
            sslContextFactory.setTrustStore(securityService.getTrustStore());
            sslContextFactory.setKeyManagerPassword(keyStorePassword);
            sslContextFactory.setCertAlias(System.getProperty("sym.keystore.ssl.cert.alias", "sym"));
            sslContextFactory.setNeedClientAuth(this.httpsNeedClientAuth);
            sslContextFactory.setWantClientAuth(this.httpsWantClientAuth);
            String ignoredProtocols = System.getProperty("symmetric.ssl.ignore.protocols");
            if (ignoredProtocols != null && ignoredProtocols.length() > 0) {
                String[] protocols = ignoredProtocols.split(",");
                sslContextFactory.addExcludeProtocols(protocols);
            } else {
                sslContextFactory.addExcludeProtocols(new String[]{"SSLv3"});
            }
            String ignoredCiphers = System.getProperty("symmetric.ssl.ignore.ciphers");
            if (ignoredCiphers != null && ignoredCiphers.length() > 0) {
                String[] ciphers = ignoredCiphers.split(",");
                sslContextFactory.addExcludeCipherSuites(ciphers);
            }
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            String protocolName = null;
            ServerConnector https = null;
            if (this.https2Enabled) {
                sslContextFactory.setCipherComparator(HTTP2Cipher.COMPARATOR);
                sslContextFactory.setProvider("Conscrypt");
                HTTP2ServerConnectionFactory h2 = new HTTP2ServerConnectionFactory(httpsConfig);
                ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
                alpn.setDefaultProtocol("h2");
                SslConnectionFactory ssl = new SslConnectionFactory((SslContextFactory)sslContextFactory, alpn.getProtocol());
                https = new ServerConnector(server, new ConnectionFactory[]{ssl, alpn, h2, new HttpConnectionFactory(httpsConfig)});
                protocolName = "HTTPS/2";
            } else {
                SslConnectionFactory ssl = new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString());
                https = new ServerConnector(server, new ConnectionFactory[]{ssl, new HttpConnectionFactory(httpsConfig)});
                protocolName = "HTTPS/1.1";
            }
            https.setPort(securePort);
            https.setIdleTimeout((long)this.maxIdleTime);
            https.setHost(this.host);
            connectors.add(https);
            log.info("About to start {} web server on {}:{}:{}", new Object[]{this.name, this.host == null ? "default" : this.host, securePort, protocolName});
        }
        return connectors.toArray(new Connector[connectors.size()]);
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public static void main(String[] args) throws Exception {
        new SymmetricWebServer().start(8080);
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public void setWebHome(String webHome) {
        this.webHome = webHome;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setHttpPort(int httpPort) {
        System.setProperty("http.port", Integer.toString(httpPort));
        this.httpPort = httpPort;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpsPort(int httpsPort) {
        System.setProperty("https.port", Integer.toString(httpsPort));
        this.httpsPort = httpsPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setWebAppDir(String webAppDir) {
        this.webAppDir = webAppDir;
    }

    public void setNoNio(boolean noNio) {
        this.noNio = noNio;
    }

    public boolean isNoNio() {
        return this.noNio;
    }

    public void setNoDirectBuffer(boolean noDirectBuffer) {
        this.noDirectBuffer = noDirectBuffer;
    }

    public boolean isNoDirectBuffer() {
        return this.noDirectBuffer;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public void setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    public void setHttps2Enabled(boolean https2Enabled) {
        this.https2Enabled = https2Enabled;
    }

    public boolean isHttps2Enabled() {
        return this.https2Enabled;
    }

    public void setHttpsNeedClientAuth(boolean httpsNeedClientAuth) {
        this.httpsNeedClientAuth = httpsNeedClientAuth;
    }

    public boolean isHttpsNeedClientAuth() {
        return this.httpsNeedClientAuth;
    }

    public boolean isHttpsWantClientAuth() {
        return this.httpsWantClientAuth;
    }

    public void setHttpsWantClientAuth(boolean httpsWantClientAuth) {
        this.httpsWantClientAuth = httpsWantClientAuth;
    }

    protected Class<?> loadRemoteStatusEndpoint() {
        try {
            Class clazz = ClassUtils.getClass((String)"com.jumpmind.symmetric.console.remote.ServerEndpoint");
            return clazz;
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (Exception ex) {
            log.debug("Failed to load remote status endpoint.", (Throwable)ex);
        }
        return null;
    }

    public static enum Mode {
        HTTP,
        HTTPS,
        MIXED;

    }
}

