/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.SymmetricWebServer;
import org.jumpmind.symmetric.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SymmetricLauncher
extends AbstractCommandLauncher {
    private static final Logger log = LoggerFactory.getLogger(SymmetricLauncher.class);
    private static final String OPTION_PORT_SERVER = "port";
    private static final String OPTION_HOST_SERVER = "host";
    private static final String OPTION_SECURE_PORT_SERVER = "secure-port";
    private static final String OPTION_MAX_IDLE_TIME = "max-idle-time";
    private static final String OPTION_START_SERVER = "server";
    private static final String OPTION_START_CLIENT = "client";
    private static final String OPTION_START_SECURE_SERVER = "secure-server";
    private static final String OPTION_START_MIXED_SERVER = "mixed-server";
    private static final String OPTION_NO_NIO = "no-nio";
    private static final String OPTION_NO_DIRECT_BUFFER = "no-directbuffer";
    private static final String OPTION_WINXP = "winxp";

    public SymmetricLauncher(String app, String argSyntax, String messageKeyPrefix) {
        super(app, argSyntax, messageKeyPrefix);
    }

    public static void main(String ... args) throws Exception {
        MDC.put((String)"engineName", (String)"startup");
        new SymmetricLauncher("sym", "", "Launcher.Option.").execute(args);
    }

    protected boolean printHelpIfNoOptionsAreProvided() {
        return false;
    }

    protected boolean requiresPropertiesFile(CommandLine line) {
        return false;
    }

    protected void printHelp(CommandLine cmd, Options options) {
        System.out.println(this.app + " version " + Version.version());
        System.out.println("Launch the SymmetricDS engine as a standalone client or server.\n");
        super.printHelp(cmd, options);
    }

    protected void buildOptions(Options options) {
        super.buildOptions(options);
        this.buildCryptoOptions(options);
        this.addOption(options, "S", OPTION_START_SERVER, false);
        this.addOption(options, "C", OPTION_START_CLIENT, false);
        this.addOption(options, "T", OPTION_START_SECURE_SERVER, false);
        this.addOption(options, "U", OPTION_START_MIXED_SERVER, false);
        this.addOption(options, "H", OPTION_HOST_SERVER, true);
        this.addOption(options, "P", OPTION_PORT_SERVER, true);
        this.addOption(options, "Q", OPTION_SECURE_PORT_SERVER, true);
        this.addOption(options, "I", OPTION_MAX_IDLE_TIME, true);
        this.addOption(options, "nnio", OPTION_NO_NIO, false);
        this.addOption(options, "ndb", OPTION_NO_DIRECT_BUFFER, false);
        this.addOption(options, OPTION_WINXP, OPTION_WINXP, false);
    }

    protected boolean executeWithOptions(CommandLine line) throws Exception {
        String host = null;
        int httpPort = 0;
        int httpSecurePort = 0;
        String webDir = SymmetricWebServer.DEFAULT_WEBAPP_DIR;
        int maxIdleTime = 90000;
        boolean noNio = false;
        boolean noDirectBuffer = false;
        this.configureCrypto(line);
        this.removeOldHeapDumps();
        if (line.hasOption(OPTION_HOST_SERVER)) {
            host = line.getOptionValue(OPTION_HOST_SERVER);
        }
        if (line.hasOption(OPTION_PORT_SERVER)) {
            httpPort = Integer.valueOf(line.getOptionValue(OPTION_PORT_SERVER));
        }
        if (line.hasOption(OPTION_SECURE_PORT_SERVER)) {
            httpSecurePort = Integer.valueOf(line.getOptionValue(OPTION_SECURE_PORT_SERVER));
        }
        if (line.hasOption(OPTION_MAX_IDLE_TIME)) {
            maxIdleTime = Integer.valueOf(line.getOptionValue(OPTION_MAX_IDLE_TIME));
        }
        if (line.hasOption(OPTION_NO_NIO)) {
            noNio = true;
        }
        if (line.hasOption(OPTION_NO_DIRECT_BUFFER)) {
            noDirectBuffer = true;
        }
        if (line.hasOption(OPTION_WINXP)) {
            new Thread(){
                {
                    this.setDaemon(true);
                    this.start();
                }

                @Override
                public void run() {
                    log.info("Starting workaround thread to prevent system clock acceleration on Windows XP");
                    while (true) {
                        try {
                            while (true) {
                                Thread.sleep(Integer.MAX_VALUE);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };
        }
        if (line.hasOption(OPTION_START_CLIENT)) {
            this.getSymmetricEngine(false).start();
            System.out.println("Started");
        } else {
            SymmetricWebServer webServer = new SymmetricWebServer(this.chooseWebDir(line, webDir), maxIdleTime, this.propertiesFile != null ? this.propertiesFile.getCanonicalPath() : null, true, noNio, noDirectBuffer);
            if (StringUtils.isNotBlank((CharSequence)host)) {
                webServer.setHost(host);
            }
            if (httpPort > 0) {
                webServer.setHttpPort(httpPort);
            }
            if (httpSecurePort > 0) {
                webServer.setHttpsPort(httpSecurePort);
            }
            if (line.hasOption(OPTION_START_MIXED_SERVER)) {
                webServer.setHttpEnabled(true);
                webServer.setHttpsEnabled(true);
                if (httpPort > 0) {
                    webServer.setHttpPort(httpPort);
                }
                if (httpSecurePort > 0) {
                    webServer.setHttpsPort(httpSecurePort);
                }
            } else if (line.hasOption(OPTION_START_SECURE_SERVER)) {
                webServer.setHttpEnabled(false);
                webServer.setHttpsEnabled(true);
                if (httpSecurePort > 0) {
                    webServer.setHttpsPort(httpSecurePort);
                }
            } else if (line.hasOption(OPTION_START_SERVER)) {
                webServer.setHttpEnabled(true);
                webServer.setHttpsEnabled(false);
            }
            webServer.start();
        }
        return true;
    }

    protected void removeOldHeapDumps() {
        String heapDumpPath = null;
        List<String> options = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String option : options) {
            if (!option.startsWith("-XX:HeapDumpPath=")) continue;
            heapDumpPath = option.split("=")[1];
        }
        if (log.isDebugEnabled()) {
            log.debug("Heap dump path is " + (heapDumpPath == null ? null : new File(heapDumpPath).getAbsolutePath()));
        }
        if (heapDumpPath != null) {
            File directory = new File(heapDumpPath);
            if (!directory.exists()) {
                return;
            }
            Collection files = FileUtils.listFiles((File)directory, (String[])new String[]{"hprof"}, (boolean)false);
            ArrayList<File> recentFiles = new ArrayList<File>();
            ArrayList<File> oldFiles = new ArrayList<File>();
            for (File file : files) {
                if (file.lastModified() < System.currentTimeMillis() - 604800000L) {
                    oldFiles.add(file);
                    continue;
                }
                recentFiles.add(file);
            }
            Collections.sort(recentFiles, new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.lastModified() > f2.lastModified() ? -1 : 1;
                }
            });
            for (int i = 2; i < recentFiles.size(); ++i) {
                oldFiles.add((File)recentFiles.get(i));
            }
            for (File file : oldFiles) {
                log.info("Removing old heap dump " + file.getName());
                file.delete();
            }
        }
    }

    protected String chooseWebDir(CommandLine line, String webDir) {
        return webDir;
    }
}

