/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.jumpmind.db.sql.ColumnNotFoundException;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.exception.IoException;
import org.jumpmind.exception.ParseException;
import org.jumpmind.util.FormatUtils;
import org.jumpmind.util.LinkedCaseInsensitiveMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Row
extends LinkedCaseInsensitiveMap<Object> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Row.class);

    public Row(int numberOfColumns) {
        super(numberOfColumns);
    }

    public Row(String columnName, Object value) {
        super(1);
        this.put(columnName, value);
    }

    public Row(String[] names, Object[] values) {
        for (int i = 0; i < names.length && i < values.length; ++i) {
            this.put(names[i], values[i]);
        }
    }

    public byte[] bytesValue() {
        Object obj = this.values().iterator().next();
        return this.toBytes(obj);
    }

    protected byte[] toBytes(Object obj) {
        if (obj != null) {
            if (obj instanceof byte[]) {
                return (byte[])obj;
            }
            if (obj instanceof Blob) {
                Blob blob = (Blob)obj;
                try {
                    return IOUtils.toByteArray((InputStream)blob.getBinaryStream());
                }
                catch (IOException e) {
                    throw new IoException((Exception)e);
                }
                catch (SQLException e) {
                    throw new SqlException(e);
                }
            }
            if (obj instanceof String) {
                return obj.toString().getBytes(Charset.defaultCharset());
            }
            throw new IllegalStateException(String.format("Cannot translate a %s into a byte[]", obj.getClass().getName()));
        }
        return null;
    }

    public Number numberValue() {
        Object obj = this.values().iterator().next();
        if (obj != null) {
            if (obj instanceof Number) {
                return (Number)obj;
            }
            return new BigDecimal(obj.toString());
        }
        return null;
    }

    public Date dateValue() {
        Object obj = this.values().iterator().next();
        if (obj != null) {
            if (obj instanceof Date) {
                return (Date)obj;
            }
            return Timestamp.valueOf(obj.toString());
        }
        return null;
    }

    public Long longValue() {
        Object obj = this.values().iterator().next();
        if (obj != null) {
            if (obj instanceof Long) {
                return (Long)obj;
            }
            if (obj instanceof Double) {
                return ((Double)obj).longValue();
            }
            return Long.valueOf(obj.toString());
        }
        return null;
    }

    public String stringValue() {
        Object obj = this.values().iterator().next();
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public String csvValue() {
        StringBuilder concatenatedRow = new StringBuilder();
        Collection objs = this.values();
        int index = 0;
        for (Object obj : objs) {
            if (index > 0) {
                concatenatedRow.append(",");
            }
            concatenatedRow.append(obj != null ? obj.toString() : "");
            ++index;
        }
        return concatenatedRow.toString();
    }

    public byte[] getBytes(String columnName) {
        Object obj = this.get(columnName);
        return this.toBytes(obj);
    }

    public String getString(String columnName) {
        return this.getString(columnName, true);
    }

    public String getString(String columnName, boolean checkForColumn) {
        Object obj = this.get(columnName);
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).toPlainString();
            }
            if (obj instanceof byte[]) {
                return Hex.encodeHexString((byte[])((byte[])obj));
            }
            return obj.toString();
        }
        if (checkForColumn) {
            this.checkForColumn(columnName);
        }
        return null;
    }

    public int getInt(String columnName) {
        Object obj = this.get(columnName);
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            return Integer.parseInt(obj.toString());
        }
        this.checkForColumn(columnName);
        return 0;
    }

    public long getLong(String columnName) {
        Object obj = this.get(columnName);
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            return Long.parseLong(obj.toString());
        }
        this.checkForColumn(columnName);
        return 0L;
    }

    public float getFloat(String columnName) {
        Object obj = this.get(columnName);
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            return Float.parseFloat(obj.toString());
        }
        this.checkForColumn(columnName);
        return 0.0f;
    }

    public BigDecimal getBigDecimal(String columnName) {
        Object obj = this.get(columnName);
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof String) {
            return new BigDecimal(obj.toString());
        }
        if (obj instanceof Integer) {
            return new BigDecimal((Integer)obj);
        }
        this.checkForColumn(columnName);
        return null;
    }

    public boolean getBoolean(String columnName) {
        Object obj = this.get(columnName);
        if ("1".equals(obj)) {
            return true;
        }
        if (obj instanceof Number) {
            int value = ((Number)obj).intValue();
            return value > 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        this.checkForColumn(columnName);
        return false;
    }

    public Time getTime(String columnName) {
        Object obj = this.get(columnName);
        if (obj instanceof Time) {
            return (Time)obj;
        }
        Date date = this.getDateTime(columnName);
        return new Time(date.getTime());
    }

    public Timestamp getTimestamp(String columnName) {
        Object obj = this.get(columnName);
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)obj);
        }
        if (obj instanceof LocalDate) {
            return Timestamp.valueOf(((LocalDate)obj).atStartOfDay());
        }
        Date date = this.getDateTime(columnName);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public Date getDateTime(String columnName) {
        Object obj = this.get(columnName);
        if (obj instanceof Number) {
            long value = ((Number)obj).longValue();
            return new Date(value);
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof String) {
            try {
                return this.getDate((String)obj, FormatUtils.TIMESTAMP_PATTERNS);
            }
            catch (ParseException ex) {
                return new Date(Long.parseLong((String)obj));
            }
        }
        if (obj instanceof LocalDateTime) {
            return new Date(Timestamp.valueOf((LocalDateTime)obj).getTime());
        }
        if (obj instanceof LocalDate) {
            return new Date(Timestamp.valueOf(((LocalDate)obj).atStartOfDay()).getTime());
        }
        this.checkForColumn(columnName);
        return null;
    }

    protected void checkForColumn(String columnName) {
        if (!this.containsKey(columnName)) {
            throw new ColumnNotFoundException(columnName);
        }
    }

    private final Date getDate(String value, String[] patterns) {
        int spaceIndex = value.lastIndexOf(" ");
        int fractionIndex = value.lastIndexOf(".");
        if (spaceIndex > 0 && fractionIndex > 0 && value.substring(fractionIndex, value.length()).length() > 3) {
            int plusIndex = value.lastIndexOf("+");
            int minusIndex = value.substring(fractionIndex).lastIndexOf("-");
            if (plusIndex != -1 || minusIndex != -1) {
                return FormatUtils.parseTimestampWithTimezone((String)value);
            }
            return Timestamp.valueOf(value);
        }
        return FormatUtils.parseDate((String)value, (String[])patterns);
    }

    public Object[] toArray(String[] keys) {
        Object[] values = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = this.get(keys[i]);
        }
        return values;
    }

    public Object[] toArray() {
        Set keys = this.keySet();
        Object[] values = new Object[keys.size()];
        int i = 0;
        for (String key : keys) {
            values[i++] = this.get(key);
        }
        return values;
    }

    public String[] toStringArray(String[] keys) {
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = this.getString(keys[i]);
        }
        return values;
    }

    public long getLength() {
        long length = 0L;
        for (Map.Entry entry : this.entrySet()) {
            try {
                Object obj = entry.getValue();
                if (obj instanceof Blob) {
                    length += ((Blob)obj).length();
                    continue;
                }
                if (obj instanceof Clob) {
                    length += ((Clob)obj).length();
                    continue;
                }
                length += (long)obj.toString().length();
            }
            catch (SQLException se) {
                log.warn("Unable to determine length of row, failure on column " + (String)entry.getKey(), (Throwable)se);
            }
        }
        return length;
    }
}

