/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.sql;

import java.sql.Connection;
import java.sql.SQLException;
import org.jumpmind.db.sql.IConnectionHandler;
import org.jumpmind.db.sql.SqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeCatalogConnectionHandler
implements IConnectionHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String previousCatalog;
    private String changeCatalog;

    public ChangeCatalogConnectionHandler(String newCatalog) {
        this.changeCatalog = newCatalog;
    }

    @Override
    public void before(Connection connection) {
        if (this.changeCatalog != null) {
            try {
                this.previousCatalog = connection.getCatalog();
                connection.setCatalog(this.changeCatalog);
            }
            catch (SQLException e) {
                this.log.debug("Unable to switch to catalog '{}': ", (Object)this.changeCatalog, (Object)e.getMessage());
                if (this.changeCatalog != null) {
                    try {
                        connection.setCatalog(this.previousCatalog);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new SqlException(e);
            }
        }
    }

    @Override
    public void after(Connection connection) {
        try {
            if (this.previousCatalog != null) {
                connection.setCatalog(this.previousCatalog);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

