/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import java.util.Map;
import org.apache.commons.codec.binary.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.CompressionTypes;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.PlatformIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.mssql.MsSql2005DdlBuilder;

public class MsSql2008DdlBuilder
extends MsSql2005DdlBuilder {
    public static final String CHANGE_TRACKING_SYM_PREFIX = "SymmetricDS";

    public MsSql2008DdlBuilder() {
        this.databaseName = "mssql2008";
        this.databaseInfo.addNativeTypeMapping(91, "DATE", 91);
        this.databaseInfo.addNativeTypeMapping(92, "TIME", 92);
        this.databaseInfo.addNativeTypeMapping(-150, "SQL_VARIANT", 2004);
        this.databaseInfo.addNativeTypeMapping(93, "DATETIME2");
        this.databaseInfo.addNativeTypeMapping(-101, "DATETIMEOFFSET");
        this.databaseInfo.addNativeTypeMapping(-102, "DATETIMEOFFSET", -101);
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setHasSize(92, true);
        this.databaseInfo.setHasSize(-103, true);
        this.databaseInfo.setDefaultSize(93, 7);
        this.databaseInfo.setDefaultSize(92, 7);
        this.databaseInfo.setDefaultSize(-101, 7);
        this.databaseInfo.setMaxSize("DATETIME2", 7);
        this.databaseInfo.setMaxSize("TIME", 7);
        this.databaseInfo.setMaxSize("DATETIMEOFFSET", 7);
    }

    @Override
    public String mapDefaultValue(Object defaultValue, Column column) {
        String defaultValueStr = defaultValue.toString();
        Map<String, String> defaultValuesToTranslate = this.databaseInfo.getDefaultValuesToTranslate();
        if (defaultValuesToTranslate.containsKey(defaultValueStr)) {
            return defaultValuesToTranslate.get(defaultValueStr);
        }
        int typeCode = column.getMappedTypeCode();
        if (!(defaultValue == null || typeCode != 93 && typeCode != -101 && typeCode != -102 || column.allPlatformColumnNamesContain("mssql"))) {
            boolean isDateTimeOffset;
            String uppercaseValue = defaultValueStr.trim().toUpperCase();
            String nativeType = this.getNativeType(column);
            boolean bl = isDateTimeOffset = nativeType != null && nativeType.toUpperCase().contains("OFFSET");
            if (uppercaseValue.startsWith("SYSDATE") || uppercaseValue.startsWith("SYSTIMESTAMP") || uppercaseValue.startsWith("CURRENT_DATE") || uppercaseValue.startsWith("CURRENT_TIMESTAMP") || uppercaseValue.startsWith("CURRENT DATE") || uppercaseValue.startsWith("CURRENT TIMESTAMP") || uppercaseValue.startsWith("LOCALTIME") || uppercaseValue.startsWith("NOW(") || uppercaseValue.startsWith("TRANSACTION_TIMESTAMP(") || uppercaseValue.startsWith("STATEMENT_TIMESTAMP(") || uppercaseValue.startsWith("CLOCK_TIMESTAMP(")) {
                if (isDateTimeOffset) {
                    return "SYSDATETIMEOFFSET()";
                }
                return "SYSDATETIME()";
            }
            if (uppercaseValue.startsWith("UTC_TIMESTAMP")) {
                if (isDateTimeOffset) {
                    return "SWITCHOFFSET(SYSDATETIMEOFFSET(), '+00:00')";
                }
                return "SYSUTCDATETIME()";
            }
            return defaultValueStr;
        }
        return super.mapDefaultValue(defaultValue, column);
    }

    @Override
    protected boolean shouldUseQuotes(String defaultValue, Column column) {
        String defaultValueStr;
        for (defaultValueStr = this.mapDefaultValue(defaultValue, column); defaultValueStr != null && defaultValueStr.startsWith("(") && defaultValueStr.endsWith(")"); defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1)) {
        }
        return super.shouldUseQuotes(defaultValue, column) && !defaultValueStr.trim().toUpperCase().startsWith("SYSDATETIME(") && !defaultValueStr.trim().toUpperCase().startsWith("SYSDATETIMEOFFSET(") && !defaultValueStr.trim().toUpperCase().startsWith("SYSUTCDATETIME(") && !defaultValueStr.trim().toUpperCase().startsWith("SWITCHOFFSET(");
    }

    @Override
    protected boolean hasSize(Column column) {
        if (column.getMappedTypeCode() == 93) {
            PlatformColumn platformColumn = column.findPlatformColumn(this.databaseName);
            String nativeType = this.getNativeType(column);
            if (platformColumn != null) {
                nativeType = platformColumn.getType();
            }
            if (nativeType.equalsIgnoreCase("DATETIME") || nativeType.equalsIgnoreCase("SMALLDATETIME")) {
                return false;
            }
        }
        return super.hasSize(column);
    }

    @Override
    protected void writeExternalIndexCreate(Table table, IIndex index, StringBuilder ddl) {
        super.writeExternalIndexCreate(table, index, ddl);
        if (index.getPlatformIndexes() != null && index.getPlatformIndexes().size() > 0) {
            Map<String, PlatformIndex> platformIndices = index.getPlatformIndexes();
            for (PlatformIndex platformIndex : platformIndices.values()) {
                if (!StringUtils.equals((CharSequence)platformIndex.getName(), (CharSequence)index.getName())) continue;
                if (platformIndex.getFilterCondition() != null) {
                    this.println(ddl);
                    ddl.append(platformIndex.getFilterCondition());
                    this.println(ddl);
                }
                if (platformIndex.getCompressionType() == CompressionTypes.NONE) continue;
                this.println(ddl);
                ddl.append(" WITH(data_compression=" + platformIndex.getCompressionType().name() + ")");
                this.println(ddl);
            }
        }
    }

    @Override
    protected void writeTableCreationStmt(Table table, StringBuilder ddl) {
        super.writeTableCreationStmt(table, ddl);
        if (table.getCompressionType() != CompressionTypes.NONE) {
            ddl.append(" WITH(data_compression=" + table.getCompressionType().name() + ")");
        }
    }

    @Override
    public void initCteExpression() {
        if (this.getDatabaseInfo().isLogBased()) {
            this.getDatabaseInfo().setCteExpression("DECLARE @ctcontext varbinary(128) = CAST('SymmetricDS:' AS varbinary(128)); WITH CHANGE_TRACKING_CONTEXT (@ctcontext) ");
        }
    }
}

