/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.interbase;

import java.util.Iterator;
import java.util.List;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;
import org.jumpmind.db.platform.PlatformUtils;

public class InterbaseDdlBuilder
extends AbstractDdlBuilder {
    public static int SWITCH_TO_LONGVARCHAR_SIZE = 4096;

    public InterbaseDdlBuilder() {
        super("interbase");
        this.databaseInfo.setMaxIdentifierLength(31);
        this.databaseInfo.setCommentPrefix("/*");
        this.databaseInfo.setCommentSuffix("*/");
        this.databaseInfo.setSystemForeignKeyIndicesAlwaysNonUnique(true);
        this.databaseInfo.addNativeTypeMapping(2003, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-5, "NUMERIC(18,0)");
        this.databaseInfo.addNativeTypeMapping(-2, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-7, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(2004, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(2005, "BLOB SUB_TYPE TEXT");
        this.databaseInfo.addNativeTypeMapping(2001, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(8, "DOUBLE PRECISION");
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE PRECISION", 8);
        this.databaseInfo.addNativeTypeMapping(2000, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-4, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-1, "VARCHAR(" + SWITCH_TO_LONGVARCHAR_SIZE + ")", 12);
        this.databaseInfo.addNativeTypeMapping(0, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(1111, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(7, "FLOAT");
        this.databaseInfo.addNativeTypeMapping(2006, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(2002, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(-3, "BLOB", -4);
        this.databaseInfo.addNativeTypeMapping("BOOLEAN", "SMALLINT", "SMALLINT");
        this.databaseInfo.addNativeTypeMapping("DATALINK", "BLOB", "LONGVARBINARY");
        this.databaseInfo.addNativeTypeMapping(-9, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-16, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-15, "CHAR", 1);
        this.databaseInfo.setMaxSize("TIMESTAMP", 4);
        this.databaseInfo.setMaxSize("TIME", 4);
        this.databaseInfo.setMaxSize("DATE", 2);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setDefaultSize(93, 4);
        this.databaseInfo.setDefaultSize(92, 4);
        this.databaseInfo.setHasSize(-2, false);
        this.databaseInfo.setHasSize(-3, false);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setMinIsolationLevelToPreventPhantomReads(2);
    }

    @Override
    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        super.createTable(table, ddl, temporary, recreate);
        if (!temporary) {
            Column[] columns = table.getAutoIncrementColumns();
            for (int idx = 0; idx < columns.length; ++idx) {
                this.writeAutoIncrementCreateStmts(table, columns[idx], ddl);
            }
        }
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getMappedTypeCode() == -7 || PlatformUtils.supportsJava14JdbcTypes() && column.getMappedTypeCode() == PlatformUtils.determineBooleanTypeCode()) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getMappedTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        if (!temporary && !recreate) {
            Column[] columns = table.getAutoIncrementColumns();
            for (int idx = 0; idx < columns.length; ++idx) {
                this.writeAutoIncrementDropStmts(table, columns[idx], ddl);
            }
        }
        super.dropTable(table, ddl, temporary, recreate);
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }

    private void writeAutoIncrementCreateStmts(Table table, Column column, StringBuilder ddl) {
        ddl.append("CREATE GENERATOR ");
        this.printIdentifier(this.getGeneratorName(table, column), ddl);
        this.printEndOfStatement(ddl);
        ddl.append("CREATE TRIGGER ");
        this.printIdentifier(this.getTriggerName(table, column), ddl);
        ddl.append(" FOR ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.println(" ACTIVE BEFORE INSERT POSITION 0 AS", ddl);
        ddl.append("BEGIN IF (NEW.");
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" IS NULL) THEN NEW.");
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" = GEN_ID(");
        this.printIdentifier(this.getGeneratorName(table, column), ddl);
        ddl.append(", 1); END");
        this.printEndOfStatement(ddl);
    }

    private void writeAutoIncrementDropStmts(Table table, Column column, StringBuilder ddl) {
        ddl.append("DROP TRIGGER ");
        this.printIdentifier(this.getTriggerName(table, column), ddl);
        this.printEndOfStatement(ddl);
        ddl.append("DROP GENERATOR ");
        this.printIdentifier(this.getGeneratorName(table, column), ddl);
        this.printEndOfStatement(ddl);
    }

    protected String getTriggerName(Table table, Column column) {
        String secondPart = column.getName();
        if (table.getName().endsWith("_")) {
            secondPart = secondPart + "_";
        }
        return this.getConstraintName("TRG", table, secondPart, null);
    }

    protected String getGeneratorName(Table table, Column column) {
        String secondPart = column.getName();
        if (table.getName().endsWith("_")) {
            secondPart = secondPart + "_";
        }
        return this.getConstraintName("GEN", table, secondPart, null);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        for (int idx = 0; idx < columns.length; ++idx) {
            result.append("GEN_ID(");
            result.append(this.getDelimitedIdentifier(this.getGeneratorName(table, columns[idx])));
            result.append(", 0)");
        }
        result.append(" FROM RDB$DATABASE");
        return result.toString();
    }

    @Override
    public String fixLastIdentityValues(Table table) {
        Column[] columns = table.getAutoIncrementColumns();
        if (columns.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("SELECT ");
        for (int idx = 0; idx < columns.length; ++idx) {
            result.append("GEN_ID(");
            result.append(this.getDelimitedIdentifier(this.getGeneratorName(table, columns[idx])));
            result.append(", (SELECT MAX(").append(columns[idx].getName()).append(")+1 FROM ");
            result.append(table.getName()).append("))");
        }
        result.append(" FROM RDB$DATABASE");
        return result.toString();
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        TableChange change;
        boolean pkColumnAdded = false;
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (change instanceof AddColumnChange) {
                AddColumnChange addColumnChange = (AddColumnChange)change;
                if (addColumnChange.getNewColumn().isPrimaryKey()) {
                    pkColumnAdded = true;
                    continue;
                }
                this.processChange(currentModel, desiredModel, addColumnChange, ddl);
                changeIt.remove();
                continue;
            }
            if (change instanceof RemoveColumnChange) {
                RemoveColumnChange removeColumnChange = (RemoveColumnChange)change;
                if (removeColumnChange.getColumn().isPrimaryKey()) continue;
                this.processChange(currentModel, desiredModel, removeColumnChange, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof CopyColumnValueChange)) continue;
            CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
            this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
            changeIt.remove();
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (!(change instanceof AddPrimaryKeyChange) || pkColumnAdded) continue;
            this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
            changeIt.remove();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        Table curTable = currentModel.findTable(change.getChangedTable().getName(), this.delimitedIdentifierModeOn);
        if (!change.isAtEnd()) {
            Column prevColumn = change.getPreviousColumn();
            if (prevColumn != null) {
                prevColumn = curTable.findColumn(prevColumn.getName(), this.delimitedIdentifierModeOn);
            }
            ddl.append("ALTER TABLE ");
            ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
            this.printIndent(ddl);
            ddl.append("ALTER ");
            this.printIdentifier(this.getColumnName(change.getNewColumn()), ddl);
            ddl.append(" POSITION ");
            ddl.append(prevColumn == null ? "1" : String.valueOf(curTable.getColumnIndex(prevColumn) + 1));
            this.printEndOfStatement(ddl);
        }
        if (change.getNewColumn().isAutoIncrement()) {
            this.writeAutoIncrementCreateStmts(curTable, change.getNewColumn(), ddl);
        }
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        if (change.getColumn().isAutoIncrement()) {
            this.writeAutoIncrementDropStmts(change.getChangedTable(), change.getColumn(), ddl);
        }
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyUpdate(ForeignKey key, StringBuilder ddl) {
        ForeignKey.ForeignKeyAction original = key.getOnUpdateAction();
        if (key.getOnUpdateAction() == ForeignKey.ForeignKeyAction.RESTRICT) {
            key.setOnUpdateAction(ForeignKey.ForeignKeyAction.NOACTION);
        }
        super.writeCascadeAttributesForForeignKeyUpdate(key, ddl);
        key.setOnUpdateAction(original);
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyDelete(ForeignKey key, StringBuilder ddl) {
        ForeignKey.ForeignKeyAction original = key.getOnDeleteAction();
        if (key.getOnDeleteAction() == ForeignKey.ForeignKeyAction.RESTRICT) {
            key.setOnDeleteAction(ForeignKey.ForeignKeyAction.NOACTION);
        }
        super.writeCascadeAttributesForForeignKeyDelete(key, ddl);
        key.setOnDeleteAction(original);
    }
}

