/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.informix;

import java.util.Map;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;

public class InformixDdlBuilder
extends AbstractDdlBuilder {
    public InformixDdlBuilder() {
        super("informix");
        this.databaseInfo.addNativeTypeMapping(12, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-1, "LVARCHAR", -1);
        this.databaseInfo.addNativeTypeMapping(-4, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(93, "DATETIME YEAR TO FRACTION", 93);
        this.databaseInfo.addNativeTypeMapping(-101, "DATETIME YEAR TO FRACTION");
        this.databaseInfo.addNativeTypeMapping(-102, "DATETIME YEAR TO FRACTION");
        this.databaseInfo.addNativeTypeMapping(92, "DATETIME YEAR TO FRACTION", 93);
        this.databaseInfo.addNativeTypeMapping(-103, "DATETIME YEAR TO FRACTION", 93);
        this.databaseInfo.addNativeTypeMapping(-2, "BYTE", -2);
        this.databaseInfo.addNativeTypeMapping(-3, "BYTE", -2);
        this.databaseInfo.addNativeTypeMapping(-7, "BOOLEAN", 16);
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(8, "FLOAT", 8);
        this.databaseInfo.setDefaultSize(12, 255);
        this.databaseInfo.setDefaultSize(1, 255);
        this.databaseInfo.setDefaultSize(93, 5);
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setHasSize(92, true);
        this.databaseInfo.setHasSize(-103, true);
        this.databaseInfo.setMaxSize("DATETIME YEAR TO FRACTION", 5);
        this.databaseInfo.setMaxSize("INTERVAL", 5);
        this.databaseInfo.setAlterTableForDropUsed(true);
        this.databaseInfo.setSystemIndicesReturned(true);
        this.databaseInfo.setCatalogSeparator(":");
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setAutoIncrementUpdateAllowed(false);
        this.databaseInfo.setRequiresAutoCommitForDdl(true);
        Map<String, String> env = System.getenv();
        String clientIdentifierMode = env.get("DELIMIDENT");
        if (clientIdentifierMode != null && clientIdentifierMode.equalsIgnoreCase("y")) {
            this.databaseInfo.setDelimiterToken("\"");
            this.databaseInfo.setDelimitedIdentifiersSupported(true);
        } else {
            this.databaseInfo.setDelimiterToken("");
            this.databaseInfo.setDelimitedIdentifiersSupported(false);
            this.delimitedIdentifierModeOn = false;
        }
    }

    @Override
    public String getSqlType(Column column) {
        String sqlType = super.getSqlType(column);
        int typeCode = column.getMappedTypeCode();
        if (typeCode == 93 || typeCode == -101 || typeCode == -102 || typeCode == 92) {
            sqlType = sqlType.replace("DATETIME YEAR TO FRACTION(0)", "DATETIME YEAR TO SECOND");
        }
        return sqlType;
    }

    @Override
    protected void writeColumn(Table table, Column column, StringBuilder ddl) {
        if (column.isAutoIncrement()) {
            this.printIdentifier(this.getColumnName(column), ddl);
            if (column.getMappedTypeCode() == -5) {
                ddl.append(" BIGSERIAL");
            } else {
                ddl.append(" SERIAL");
            }
        } else {
            super.writeColumn(table, column, ddl);
        }
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "select dbinfo('sqlca.sqlerrd1') from sysmaster:sysdual";
    }

    @Override
    protected void writeExternalPrimaryKeysCreateStmt(Table table, Column[] primaryKeyColumns, StringBuilder ddl) {
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            ddl.append("ALTER TABLE ");
            ddl.append(this.getFullyQualifiedTableNameShorten(table));
            this.printIndent(ddl);
            ddl.append("ADD CONSTRAINT ");
            this.writePrimaryKeyStmt(table, primaryKeyColumns, ddl);
            ddl.append(" CONSTRAINT ");
            this.printIdentifier(this.getConstraintName(null, table, "PK", null), ddl);
            this.printEndOfStatement(ddl);
        }
    }

    @Override
    protected void writeExternalForeignKeyCreateStmt(Database database, Table table, ForeignKey key, StringBuilder ddl) {
        if (key.getForeignTableName() == null) {
            this.log.warn("Foreign key table is null for key " + key);
        } else {
            this.writeTableAlterStmt(table, ddl);
            ddl.append("ADD CONSTRAINT FOREIGN KEY (");
            this.writeLocalReferences(key, ddl);
            ddl.append(") REFERENCES ");
            this.printIdentifier(this.getTableName(key.getForeignTableName()), ddl);
            ddl.append(" (");
            this.writeForeignReferences(key, ddl);
            ddl.append(")");
            this.writeCascadeAttributesForForeignKey(key, ddl);
            ddl.append(" CONSTRAINT ");
            this.printIdentifier(this.getForeignKeyName(table, key), ddl);
            this.printEndOfStatement(ddl);
        }
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyUpdate(ForeignKey key, StringBuilder ddl) {
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyDelete(ForeignKey key, StringBuilder ddl) {
        if (key.getOnDeleteAction() == ForeignKey.ForeignKeyAction.CASCADE) {
            super.writeCascadeAttributesForForeignKeyDelete(key, ddl);
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, RemovePrimaryKeyChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP CONSTRAINT ");
        this.printIdentifier(this.getConstraintName(null, change.getChangedTable(), "PK", null), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, PrimaryKeyChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP CONSTRAINT ");
        this.printIdentifier(this.getConstraintName(null, change.getChangedTable(), "PK", null), ddl);
        this.printEndOfStatement(ddl);
        this.writeExternalPrimaryKeysCreateStmt(change.getChangedTable(), change.getNewPrimaryKeyColumns(), ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }
}

