/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.IDdlBuilderFactory;
import org.jumpmind.db.platform.ase.AseDdlBuilder;
import org.jumpmind.db.platform.db2.Db2DdlBuilder;
import org.jumpmind.db.platform.derby.DerbyDdlBuilder;
import org.jumpmind.db.platform.firebird.FirebirdDdlBuilder;
import org.jumpmind.db.platform.firebird.FirebirdDialect1DdlBuilder;
import org.jumpmind.db.platform.greenplum.GreenplumDdlBuilder;
import org.jumpmind.db.platform.h2.H2DdlBuilder;
import org.jumpmind.db.platform.hbase.HbaseDdlBuilder;
import org.jumpmind.db.platform.hsqldb.HsqlDbDdlBuilder;
import org.jumpmind.db.platform.hsqldb2.HsqlDb2DdlBuilder;
import org.jumpmind.db.platform.informix.InformixDdlBuilder;
import org.jumpmind.db.platform.interbase.InterbaseDdlBuilder;
import org.jumpmind.db.platform.mssql.MsSql2000DdlBuilder;
import org.jumpmind.db.platform.mssql.MsSql2005DdlBuilder;
import org.jumpmind.db.platform.mssql.MsSql2008DdlBuilder;
import org.jumpmind.db.platform.mssql.MsSql2016DdlBuilder;
import org.jumpmind.db.platform.mysql.MySqlDdlBuilder;
import org.jumpmind.db.platform.nuodb.NuoDbDdlBuilder;
import org.jumpmind.db.platform.oracle.Oracle122DdlBuilder;
import org.jumpmind.db.platform.oracle.OracleDdlBuilder;
import org.jumpmind.db.platform.postgresql.PostgreSqlDdlBuilder;
import org.jumpmind.db.platform.postgresql.PostgreSqlDdlBuilder95;
import org.jumpmind.db.platform.redshift.RedshiftDdlBuilder;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhereDdlBuilder;
import org.jumpmind.db.platform.sqlite.SqliteDdlBuilder;
import org.jumpmind.db.platform.tibero.TiberoDdlBuilder;
import org.jumpmind.db.platform.voltdb.VoltDbDdlBuilder;
import org.jumpmind.util.AppUtils;

public class DdlBuilderFactory
implements IDdlBuilderFactory {
    protected static IDdlBuilderFactory instance;

    protected DdlBuilderFactory() {
    }

    public static synchronized IDdlBuilderFactory getInstance() {
        if (instance == null) {
            instance = (IDdlBuilderFactory)AppUtils.newInstance(IDdlBuilderFactory.class, DdlBuilderFactory.class);
        }
        return instance;
    }

    @Override
    public IDdlBuilder create(String databaseName) {
        if ("db2".equals(databaseName)) {
            return new Db2DdlBuilder();
        }
        if ("derby".equalsIgnoreCase(databaseName)) {
            return new DerbyDdlBuilder();
        }
        if ("firebird".equalsIgnoreCase(databaseName)) {
            return new FirebirdDdlBuilder();
        }
        if ("firebird_dialect1".equalsIgnoreCase(databaseName)) {
            return new FirebirdDialect1DdlBuilder();
        }
        if ("greenplum".equalsIgnoreCase(databaseName)) {
            return new GreenplumDdlBuilder();
        }
        if ("h2".equalsIgnoreCase(databaseName)) {
            return new H2DdlBuilder();
        }
        if ("hsqldb".equalsIgnoreCase(databaseName)) {
            return new HsqlDbDdlBuilder();
        }
        if ("hsqldb2".equalsIgnoreCase(databaseName)) {
            return new HsqlDb2DdlBuilder();
        }
        if ("informix".equalsIgnoreCase(databaseName)) {
            return new InformixDdlBuilder();
        }
        if ("interbase".equalsIgnoreCase(databaseName)) {
            return new InterbaseDdlBuilder();
        }
        if ("mssql2000".equalsIgnoreCase(databaseName)) {
            return new MsSql2000DdlBuilder();
        }
        if ("mssql2005".equalsIgnoreCase(databaseName)) {
            return new MsSql2005DdlBuilder();
        }
        if ("mssql2008".equalsIgnoreCase(databaseName)) {
            return new MsSql2008DdlBuilder();
        }
        if ("mssql2016".equalsIgnoreCase(databaseName)) {
            return new MsSql2016DdlBuilder();
        }
        if ("mysql".equalsIgnoreCase(databaseName)) {
            return new MySqlDdlBuilder();
        }
        if ("oracle".equalsIgnoreCase(databaseName)) {
            return new OracleDdlBuilder();
        }
        if ("oracle122".equalsIgnoreCase(databaseName)) {
            return new Oracle122DdlBuilder();
        }
        if ("postgres".equalsIgnoreCase(databaseName)) {
            return new PostgreSqlDdlBuilder();
        }
        if ("postgres95".equalsIgnoreCase(databaseName)) {
            return new PostgreSqlDdlBuilder95();
        }
        if ("sqlite".equalsIgnoreCase(databaseName)) {
            return new SqliteDdlBuilder();
        }
        if ("ase".equalsIgnoreCase(databaseName)) {
            return new AseDdlBuilder();
        }
        if ("sqlanywhere".equalsIgnoreCase(databaseName)) {
            return new SqlAnywhereDdlBuilder();
        }
        if ("redshift".equalsIgnoreCase(databaseName)) {
            return new RedshiftDdlBuilder();
        }
        if ("voltdb".equalsIgnoreCase(databaseName)) {
            return new VoltDbDdlBuilder();
        }
        if ("nuodb".equalsIgnoreCase(databaseName)) {
            return new NuoDbDdlBuilder();
        }
        if ("hbase".equalsIgnoreCase(databaseName)) {
            return new HbaseDdlBuilder();
        }
        if ("tibero".equalsIgnoreCase(databaseName)) {
            return new TiberoDdlBuilder();
        }
        return null;
    }
}

