/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddForeignKeyChange;
import org.jumpmind.db.alter.AddIndexChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.AddTableChange;
import org.jumpmind.db.alter.ColumnAutoIncrementChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.ColumnDefaultValueChange;
import org.jumpmind.db.alter.ColumnGeneratedChange;
import org.jumpmind.db.alter.ColumnRequiredChange;
import org.jumpmind.db.alter.ColumnSizeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.GeneratedColumnDefinitionChange;
import org.jumpmind.db.alter.IModelChange;
import org.jumpmind.db.alter.ModelComparator;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemoveForeignKeyChange;
import org.jumpmind.db.alter.RemoveIndexChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.RemoveTableChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.ModelException;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.DdlException;
import org.jumpmind.db.platform.DefaultValueHelper;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.util.MultiInstanceofPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDdlBuilder
implements IDdlBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    protected static final String SIZE_PLACEHOLDER = "{0}";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String indent = "    ";
    private String valueLocale;
    private DateFormat valueDateFormat;
    private DateFormat valueTimeFormat;
    private NumberFormat valueNumberFormat;
    private DefaultValueHelper defaultValueHelper = new DefaultValueHelper();
    private Map<String, String> charSequencesToEscape = new LinkedHashMap<String, String>();
    protected DatabaseInfo databaseInfo = new DatabaseInfo();
    protected boolean delimitedIdentifierModeOn = true;
    protected boolean caseSensitive = true;
    protected boolean sqlCommentsOn = false;
    protected boolean scriptModeOn = false;
    protected String databaseName;

    public AbstractDdlBuilder(String databaseName) {
        this.databaseName = databaseName;
        this.addEscapedCharSequence("'", "''");
    }

    public DefaultValueHelper getDefaultValueHelper() {
        return this.defaultValueHelper;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getValueLocale() {
        return this.valueLocale;
    }

    public void setValueLocale(String localeStr) {
        if (localeStr != null) {
            int sepPos = localeStr.indexOf(95);
            String language = null;
            String country = null;
            String variant = null;
            if (sepPos > 0) {
                language = localeStr.substring(0, sepPos);
                country = localeStr.substring(sepPos + 1);
                if ((sepPos = country.indexOf(95)) > 0) {
                    variant = country.substring(sepPos + 1);
                    country = country.substring(0, sepPos);
                }
            } else {
                language = localeStr;
            }
            if (language != null) {
                Locale locale = null;
                locale = variant != null ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : new Locale(language));
                this.valueLocale = localeStr;
                this.setValueDateFormat(DateFormat.getDateInstance(3, locale));
                this.setValueTimeFormat(DateFormat.getTimeInstance(3, locale));
                this.setValueNumberFormat(NumberFormat.getNumberInstance(locale));
                return;
            }
        }
        this.valueLocale = null;
        this.setValueDateFormat(null);
        this.setValueTimeFormat(null);
        this.setValueNumberFormat(null);
    }

    protected DateFormat getValueDateFormat() {
        return this.valueDateFormat;
    }

    protected void setValueDateFormat(DateFormat format) {
        this.valueDateFormat = format;
    }

    protected DateFormat getValueTimeFormat() {
        return this.valueTimeFormat;
    }

    protected void setValueTimeFormat(DateFormat format) {
        this.valueTimeFormat = format;
    }

    protected NumberFormat getValueNumberFormat() {
        return this.valueNumberFormat;
    }

    protected void setValueNumberFormat(NumberFormat format) {
        this.valueNumberFormat = format;
    }

    protected final void addEscapedCharSequence(String charSequence, String escapedVersion) {
        this.charSequencesToEscape.put(charSequence, escapedVersion);
    }

    @Override
    public String createTables(Database database, boolean dropTables) {
        StringBuilder ddl = new StringBuilder();
        this.createTables(database, dropTables, ddl);
        return ddl.toString();
    }

    public void createTables(Database database, boolean dropTables, StringBuilder ddl) {
        if (dropTables) {
            this.dropTables(database, ddl);
        }
        for (int idx = 0; idx < database.getTableCount(); ++idx) {
            Table table = database.getTable(idx);
            this.writeTableComment(table, ddl);
            this.createTable(table, ddl, false, false);
        }
        this.createExternalForeignKeys(database, ddl);
    }

    @Override
    public String alterDatabase(Database currentModel, Database desiredModel, IAlterDatabaseInterceptor ... alterDatabaseInterceptors) {
        StringBuilder ddl = new StringBuilder();
        this.alterDatabase(currentModel, desiredModel, ddl, alterDatabaseInterceptors);
        return ddl.toString();
    }

    @Override
    public String alterTable(Table currentTable, Table desiredTable, IAlterDatabaseInterceptor ... alterDatabaseInterceptors) {
        Database currentModel = new Database();
        currentModel.addTable(currentTable);
        Database desiredModel = new Database();
        desiredModel.addTable(desiredTable);
        return this.alterDatabase(currentModel, desiredModel, alterDatabaseInterceptors);
    }

    protected void mergeOrRemovePlatformTypes(Database currentModel, Database desiredModel) {
    }

    public void alterDatabase(Database currentModel, Database desiredModel, StringBuilder ddl, IAlterDatabaseInterceptor ... alterDatabaseInterceptors) {
        currentModel = currentModel.copy();
        this.mergeOrRemovePlatformTypes(currentModel, desiredModel);
        List<IModelChange> detectedChanges = this.getDetectedChanges(currentModel, desiredModel, alterDatabaseInterceptors);
        this.processChanges(currentModel, desiredModel, detectedChanges, ddl);
    }

    @Override
    public boolean isAlterDatabase(Database currentModel, Database desiredModel, IAlterDatabaseInterceptor ... alterDatabaseInterceptors) {
        List<IModelChange> detectedChanges = this.getDetectedChanges(currentModel, desiredModel, alterDatabaseInterceptors);
        return detectedChanges.size() > 0;
    }

    @Override
    public List<IModelChange> getDetectedChanges(Database currentModel, Database desiredModel, IAlterDatabaseInterceptor ... alterDatabaseInterceptors) {
        ModelComparator comparator = new ModelComparator(this, this.databaseInfo, this.caseSensitive);
        List<IModelChange> detectedChanges = comparator.compare(currentModel, desiredModel);
        if (alterDatabaseInterceptors != null) {
            for (IAlterDatabaseInterceptor interceptor : alterDatabaseInterceptors) {
                detectedChanges = interceptor.intercept(detectedChanges, currentModel, desiredModel);
            }
        }
        return detectedChanges;
    }

    protected void processChanges(Database currentModel, Database desiredModel, List<IModelChange> changes, StringBuilder ddl) {
        this.processChanges(currentModel, desiredModel, changes, ddl, new Class[]{RemoveForeignKeyChange.class, RemoveIndexChange.class});
        this.processChanges(currentModel, desiredModel, changes, ddl, new Class[]{RemoveTableChange.class});
        MultiInstanceofPredicate predicate = new MultiInstanceofPredicate(new Class[]{RemovePrimaryKeyChange.class, AddPrimaryKeyChange.class, PrimaryKeyChange.class, RemoveColumnChange.class, AddColumnChange.class, ColumnAutoIncrementChange.class, ColumnDefaultValueChange.class, ColumnRequiredChange.class, ColumnDataTypeChange.class, ColumnSizeChange.class, ColumnGeneratedChange.class, CopyColumnValueChange.class, GeneratedColumnDefinitionChange.class});
        this.processTableStructureChanges(currentModel, desiredModel, CollectionUtils.select(changes, (Predicate)predicate), ddl);
        this.processChanges(currentModel, desiredModel, changes, ddl, new Class[]{AddTableChange.class});
        this.processChanges(currentModel, desiredModel, changes, ddl, new Class[]{AddForeignKeyChange.class, AddIndexChange.class});
    }

    protected void processChanges(Database currentModel, Database desiredModel, List<IModelChange> changes, StringBuilder ddl, Class<?>[] changeTypes) {
        for (IModelChange change : changes) {
            for (Class<?> changeType : changeTypes) {
                if (!change.getClass().equals(changeType)) continue;
                if (change.getClass().equals(AddTableChange.class)) {
                    this.processChange(currentModel, desiredModel, (AddTableChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(RemoveTableChange.class)) {
                    this.processChange(currentModel, desiredModel, (RemoveTableChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(AddIndexChange.class)) {
                    this.processChange(currentModel, desiredModel, (AddIndexChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(RemoveIndexChange.class)) {
                    this.processChange(currentModel, desiredModel, (RemoveIndexChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(AddForeignKeyChange.class)) {
                    this.processChange(currentModel, desiredModel, (AddForeignKeyChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(RemoveForeignKeyChange.class)) {
                    this.processChange(currentModel, desiredModel, (RemoveForeignKeyChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(AddPrimaryKeyChange.class)) {
                    this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(PrimaryKeyChange.class)) {
                    this.processChange(currentModel, desiredModel, (PrimaryKeyChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(RemovePrimaryKeyChange.class)) {
                    this.processChange(currentModel, desiredModel, (RemovePrimaryKeyChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(AddColumnChange.class)) {
                    this.processChange(currentModel, desiredModel, (AddColumnChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(RemoveColumnChange.class)) {
                    this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(ColumnAutoIncrementChange.class)) {
                    this.processChange(currentModel, desiredModel, (ColumnAutoIncrementChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(ColumnDefaultValueChange.class)) {
                    this.processChange(currentModel, desiredModel, (ColumnDefaultValueChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(ColumnRequiredChange.class)) {
                    this.processChange(currentModel, desiredModel, (ColumnRequiredChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(ColumnDataTypeChange.class)) {
                    this.processChange(currentModel, desiredModel, (ColumnDataTypeChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(ColumnSizeChange.class)) {
                    this.processChange(currentModel, desiredModel, (ColumnSizeChange)change, ddl);
                    continue;
                }
                if (change.getClass().equals(CopyColumnValueChange.class)) {
                    this.processChange(currentModel, desiredModel, (CopyColumnValueChange)change, ddl);
                    continue;
                }
                this.processChange(currentModel, desiredModel, change, ddl);
            }
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, IModelChange change, StringBuilder ddl) {
        this.log.warn("Change of type " + change.getClass() + " was not handled");
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveForeignKeyChange change, StringBuilder ddl) {
        this.writeExternalForeignKeyDropStmt(change.getChangedTable(), change.getForeignKey(), ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveIndexChange change, StringBuilder ddl) {
        this.writeExternalIndexDropStmt(change.getChangedTable(), change.getIndex(), ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveTableChange change, StringBuilder ddl) {
        this.dropTable(change.getChangedTable(), ddl, false, false);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddTableChange change, StringBuilder ddl) {
        this.createTable(change.getNewTable(), ddl, false, false);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddForeignKeyChange change, StringBuilder ddl) {
        this.writeExternalForeignKeyCreateStmt(desiredModel, change.getChangedTable(), change.getNewForeignKey(), ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddIndexChange change, StringBuilder ddl) {
        this.writeExternalIndexCreateStmt(change.getChangedTable(), change.getNewIndex(), ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void filterChanges(Collection<IModelChange> changes) {
    }

    /*
     * WARNING - void declaration
     */
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Collection<IModelChange> changes, StringBuilder ddl) {
        this.filterChanges(changes);
        LinkedHashMap<void, ArrayList<TableChange>> changesPerTable = new LinkedHashMap<void, ArrayList<TableChange>>();
        LinkedHashMap<String, List<ForeignKey>> unchangedFKs = new LinkedHashMap<String, List<ForeignKey>>();
        boolean caseSensitive = this.delimitedIdentifierModeOn;
        for (TableChange tableChange : changes) {
            void var10_14;
            ArrayList<TableChange> changesForTable;
            String string = tableChange.getChangedTable().getName();
            if (!caseSensitive) {
                String string2 = string.toUpperCase();
            }
            if ((changesForTable = (ArrayList<TableChange>)changesPerTable.get(var10_14)) == null) {
                changesForTable = new ArrayList<TableChange>();
                changesPerTable.put(var10_14, changesForTable);
                unchangedFKs.put((String)var10_14, this.getUnchangedForeignKeys(currentModel, desiredModel, (String)var10_14));
            }
            changesForTable.add(tableChange);
        }
        this.addRelevantFKsFromUnchangedTables(currentModel, desiredModel, changesPerTable.keySet(), unchangedFKs);
        for (Map.Entry<String, List<ForeignKey>> entry : unchangedFKs.entrySet()) {
            Table table = this.findTable(desiredModel, entry.getKey());
            Iterator<ForeignKey> fkIt = entry.getValue().iterator();
            while (fkIt.hasNext()) {
                this.writeExternalForeignKeyDropStmt(table, fkIt.next(), ddl);
            }
        }
        Database copyOfCurrentModel = this.copy(currentModel);
        for (Map.Entry entry : changesPerTable.entrySet()) {
            this.processTableStructureChanges(copyOfCurrentModel, desiredModel, (String)entry.getKey(), (List)entry.getValue(), ddl);
        }
        for (Map.Entry<String, List<ForeignKey>> entry : unchangedFKs.entrySet()) {
            Table targetTable = this.findTable(desiredModel, entry.getKey());
            Iterator<ForeignKey> fkIt = entry.getValue().iterator();
            while (fkIt.hasNext()) {
                this.writeExternalForeignKeyCreateStmt(desiredModel, targetTable, fkIt.next(), ddl);
            }
        }
    }

    protected Table findTable(Database currentModel, String tableName) {
        Table table = currentModel.findTable(tableName, this.delimitedIdentifierModeOn);
        if (table == null && this.delimitedIdentifierModeOn) {
            table = currentModel.findTable(tableName, false);
        }
        return table;
    }

    protected ForeignKey findForeignKey(Table table, ForeignKey fk) {
        ForeignKey key = table.findForeignKey(fk, this.delimitedIdentifierModeOn);
        if (key == null && this.delimitedIdentifierModeOn) {
            key = table.findForeignKey(fk, false);
        }
        return key;
    }

    private List<ForeignKey> getUnchangedForeignKeys(Database currentModel, Database desiredModel, String tableName) {
        ArrayList<ForeignKey> unchangedFKs = new ArrayList<ForeignKey>();
        Table sourceTable = this.findTable(currentModel, tableName);
        Table targetTable = this.findTable(desiredModel, tableName);
        for (int idx = 0; idx < targetTable.getForeignKeyCount(); ++idx) {
            ForeignKey targetFK = targetTable.getForeignKey(idx);
            ForeignKey sourceFK = this.findForeignKey(sourceTable, targetFK);
            if (sourceFK == null) continue;
            unchangedFKs.add(targetFK);
        }
        return unchangedFKs;
    }

    private void addRelevantFKsFromUnchangedTables(Database currentModel, Database desiredModel, Set<String> namesOfKnownChangedTables, Map<String, List<ForeignKey>> fksPerTable) {
        for (int tableIdx = 0; tableIdx < desiredModel.getTableCount(); ++tableIdx) {
            Table targetTable = desiredModel.getTable(tableIdx);
            String name = targetTable.getName();
            Table sourceTable = this.findTable(currentModel, name);
            ArrayList<ForeignKey> relevantFks = null;
            if (!this.caseSensitive) {
                name = name.toUpperCase();
            }
            if (sourceTable == null || namesOfKnownChangedTables.contains(name)) continue;
            for (int fkIdx = 0; fkIdx < targetTable.getForeignKeyCount(); ++fkIdx) {
                ForeignKey targetFk = targetTable.getForeignKey(fkIdx);
                ForeignKey sourceFk = sourceTable.findForeignKey(targetFk, this.caseSensitive);
                String refName = targetFk.getForeignTableName();
                if (!this.caseSensitive) {
                    refName = refName.toUpperCase();
                }
                if (sourceFk == null || !namesOfKnownChangedTables.contains(refName)) continue;
                if (relevantFks == null) {
                    relevantFks = new ArrayList<ForeignKey>();
                    fksPerTable.put(name, relevantFks);
                }
                relevantFks.add(targetFk);
            }
        }
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, String tableName, List<TableChange> changes, StringBuilder ddl) {
        StringBuilder tableDdl = new StringBuilder();
        Database originalModel = this.copy(currentModel);
        Table sourceTable = this.findTable(originalModel, tableName);
        Table targetTable = this.findTable(desiredModel, tableName);
        boolean requiresFullRebuild = false;
        Iterator<TableChange> changeIt = changes.iterator();
        while (!requiresFullRebuild && changeIt.hasNext()) {
            TableChange change = changeIt.next();
            if (change instanceof AddColumnChange) {
                AddColumnChange addColumnChange = (AddColumnChange)change;
                if (!addColumnChange.getNewColumn().isRequired() || addColumnChange.getNewColumn().getDefaultValue() != null || addColumnChange.getNewColumn().isAutoIncrement()) continue;
                requiresFullRebuild = true;
                continue;
            }
            if (!(change instanceof ColumnGeneratedChange) && !(change instanceof GeneratedColumnDefinitionChange)) continue;
            requiresFullRebuild = true;
        }
        if (!requiresFullRebuild) {
            this.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, changes, tableDdl);
        }
        if (!changes.isEmpty()) {
            boolean canMigrateData = true;
            Table tempTable = this.getTemporaryTableFor(sourceTable);
            Iterator<TableChange> it = changes.iterator();
            while (canMigrateData && it.hasNext()) {
                AddColumnChange addColumnChange;
                TableChange change = it.next();
                if (!(change instanceof AddColumnChange) || !(addColumnChange = (AddColumnChange)change).getNewColumn().isRequired() || addColumnChange.getNewColumn().isAutoIncrement() || addColumnChange.getNewColumn().getDefaultValue() != null) continue;
                this.log.warn("Data cannot be retained in table " + change.getChangedTable().getName() + " because of the addition of the required column " + addColumnChange.getNewColumn().getName() + " . The data is backed up in " + tempTable + ", consider manually migrating the data back or dropping this temp table.");
                canMigrateData = false;
            }
            Table realTargetTable = this.getRealTargetTableFor(desiredModel, sourceTable, targetTable);
            this.renameTable(sourceTable, tempTable, ddl);
            this.createTable(realTargetTable, ddl, false, true);
            if (canMigrateData) {
                this.writeCopyDataStatement(tempTable, targetTable, ddl);
                this.dropTemporaryTable(tempTable, ddl);
                this.writeFixLastIdentityValues(targetTable, ddl);
            }
        } else {
            ddl.append((CharSequence)tableDdl);
        }
    }

    protected void renameTable(Table sourceTable, Table tempTable, StringBuilder ddl) {
        this.dropTemporaryTable(tempTable, ddl);
        this.createTemporaryTable(tempTable, ddl);
        this.writeCopyDataStatement(sourceTable, tempTable, ddl);
        this.dropTable(sourceTable, ddl, false, true);
    }

    protected Database copy(Database currentModel) {
        try {
            return (Database)currentModel.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new DdlException(ex);
        }
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        TableChange change;
        if (changes.size() == 1 && (change = changes.get(0)) instanceof AddPrimaryKeyChange) {
            this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
            changes.clear();
        }
        Iterator<TableChange> it = changes.iterator();
        while (it.hasNext()) {
            ColumnDataTypeChange typeChange;
            TableChange change2 = it.next();
            if (!(change2 instanceof ColumnDataTypeChange) || (typeChange = (ColumnDataTypeChange)change2).getNewTypeCode() != -5 || !this.writeAlterColumnDataTypeToBigInt(typeChange, ddl)) continue;
            it.remove();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, CopyColumnValueChange change, StringBuilder ddl) {
        ddl.append("UPDATE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        ddl.append(" SET ");
        this.printIdentifier(this.getColumnName(change.getTargetColumn()), ddl);
        ddl.append("=");
        this.printIdentifier(this.getColumnName(change.getSourceColumn()), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected boolean writeAlterColumnDataTypeToBigInt(ColumnDataTypeChange change, StringBuilder ddl) {
        return false;
    }

    protected String getFullyQualifiedTableNameShorten(Table table) {
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)table.getCatalog())) {
            result = result + this.getDelimitedIdentifier(table.getCatalog()).concat(this.databaseInfo.getCatalogSeparator());
        }
        if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
            result = result + this.getDelimitedIdentifier(table.getSchema()).concat(this.databaseInfo.getSchemaSeparator());
        }
        result = result + this.getDelimitedIdentifier(this.getTableName(table.getName()));
        return result;
    }

    protected Table getTemporaryTableFor(Table targetTable) {
        return this.getTemporaryTableFor(targetTable, "_");
    }

    public Table getBackupTableFor(Table sourceTable) {
        return this.getTemporaryTableFor(sourceTable, "x");
    }

    public Table createBackupTableFor(Database model, Table sourceTable, StringBuilder ddl) {
        Table backupTable = this.getBackupTableFor(sourceTable);
        this.writeTableCreationStmt(backupTable, ddl);
        this.printEndOfStatement(ddl);
        this.writeCopyDataStatement(sourceTable, backupTable, ddl);
        return backupTable;
    }

    public void restoreTableFromBackup(Table backupTable, Table targetTable, LinkedHashMap<Column, Column> columnMap, StringBuilder ddl) {
        ddl.append("DELETE FROM ");
        ddl.append(this.getFullyQualifiedTableNameShorten(targetTable));
        this.printEndOfStatement(ddl);
        this.writeCopyDataStatement(backupTable, targetTable, columnMap, ddl);
    }

    protected Table getTemporaryTableFor(Table targetTable, String suffix) {
        Table table = new Table();
        table.setCatalog(targetTable.getCatalog());
        table.setSchema(targetTable.getSchema());
        table.setName(targetTable.getName() + suffix);
        table.setType(targetTable.getType());
        table.removeAllColumnDefaults();
        for (int idx = 0; idx < targetTable.getColumnCount(); ++idx) {
            try {
                Column clonedColumn = (Column)targetTable.getColumn(idx).clone();
                clonedColumn.setAutoIncrement(false);
                clonedColumn.setPrimaryKey(false);
                table.addColumn(clonedColumn);
                continue;
            }
            catch (CloneNotSupportedException ex) {
                throw new DdlException(ex);
            }
        }
        return table;
    }

    protected void createTemporaryTable(Table table, StringBuilder ddl) {
        this.createTable(table, ddl, true, false);
    }

    protected void dropTemporaryTable(Table table, StringBuilder ddl) {
        this.dropTable(table, ddl, true, false);
    }

    protected Table getRealTargetTableFor(Database targetModel, Table sourceTable, Table targetTable) {
        Table table = new Table();
        table.setCatalog(targetTable.getCatalog());
        table.setSchema(targetTable.getSchema());
        table.setName(targetTable.getName());
        table.setType(targetTable.getType());
        for (int idx = 0; idx < targetTable.getColumnCount(); ++idx) {
            try {
                table.addColumn((Column)targetTable.getColumn(idx).clone());
                continue;
            }
            catch (CloneNotSupportedException ex) {
                throw new DdlException(ex);
            }
        }
        boolean caseSensitive = this.delimitedIdentifierModeOn;
        for (int idx = 0; idx < targetTable.getIndexCount(); ++idx) {
            IIndex targetIndex = targetTable.getIndex(idx);
            IIndex sourceIndex = sourceTable.findIndex(targetIndex.getName(), caseSensitive);
            if (sourceIndex == null || (!caseSensitive || !sourceIndex.equals(targetIndex)) && (caseSensitive || !sourceIndex.equalsIgnoreCase(targetIndex))) continue;
            table.addIndex(targetIndex);
        }
        return table;
    }

    public void writeCopyDataStatement(Table sourceTable, Table targetTable, StringBuilder ddl) {
        LinkedHashMap<Column, Column> columnMap = this.getCopyDataColumnMapping(sourceTable, targetTable);
        this.writeCopyDataStatement(sourceTable, targetTable, columnMap, ddl);
    }

    public void writeCopyDataStatement(Table sourceTable, Table targetTable, LinkedHashMap<Column, Column> columnMap, StringBuilder ddl) {
        ddl.append("INSERT INTO ");
        ddl.append(this.getFullyQualifiedTableNameShorten(targetTable));
        ddl.append(" (");
        Iterator<Column> columnIt = columnMap.values().iterator();
        while (columnIt.hasNext()) {
            this.printIdentifier(this.getColumnName(columnIt.next()), ddl);
            if (!columnIt.hasNext()) continue;
            ddl.append(",");
        }
        ddl.append(") SELECT ");
        Iterator<Map.Entry<Column, Column>> columnsIt = columnMap.entrySet().iterator();
        while (columnsIt.hasNext()) {
            Map.Entry<Column, Column> entry = columnsIt.next();
            this.writeCastExpression(entry.getKey(), entry.getValue(), ddl);
            if (!columnsIt.hasNext()) continue;
            ddl.append(",");
        }
        ddl.append(" FROM ");
        ddl.append(this.getFullyQualifiedTableNameShorten(sourceTable));
        this.printEndOfStatement(ddl);
    }

    public LinkedHashMap<Column, Column> getCopyDataColumnMapping(Table sourceTable, Table targetTable) {
        LinkedHashMap<Column, Column> columns = new LinkedHashMap<Column, Column>();
        for (int idx = 0; idx < sourceTable.getColumnCount(); ++idx) {
            Column sourceColumn = sourceTable.getColumn(idx);
            Column targetColumn = targetTable.findColumn(sourceColumn.getName(), this.delimitedIdentifierModeOn);
            if (targetColumn == null || targetColumn.isGenerated()) continue;
            columns.put(sourceColumn, targetColumn);
        }
        return columns;
    }

    public LinkedHashMap<Column, Column> getCopyDataColumnOrderedMapping(Table sourceTable, Table targetTable) {
        LinkedHashMap<Column, Column> columns = new LinkedHashMap<Column, Column>();
        for (int idx = 0; idx < sourceTable.getColumnCount(); ++idx) {
            columns.put(sourceTable.getColumn(idx), targetTable.getColumn(idx));
        }
        return columns;
    }

    protected void writeCastExpression(Column sourceColumn, Column targetColumn, StringBuilder ddl) {
        this.printIdentifier(this.getColumnName(sourceColumn), ddl);
    }

    protected void processChange(Database currentModel, Database desiredModel, AddPrimaryKeyChange change, StringBuilder ddl) {
        this.writeExternalPrimaryKeysCreateStmt(change.getChangedTable(), change.getPrimaryKeyColumns(), ddl);
        change.apply(desiredModel, this.delimitedIdentifierModeOn);
    }

    protected ForeignKey findCorrespondingForeignKey(Table table, ForeignKey fk) {
        boolean caseMatters = this.delimitedIdentifierModeOn;
        boolean checkFkName = fk.getName() != null && fk.getName().length() > 0;
        Reference[] refs = fk.getReferences();
        ArrayList curRefs = new ArrayList();
        for (int fkIdx = 0; fkIdx < table.getForeignKeyCount(); ++fkIdx) {
            boolean checkCurFkName;
            ForeignKey curFk = table.getForeignKey(fkIdx);
            boolean bl = checkCurFkName = checkFkName && curFk.getName() != null && curFk.getName().length() > 0;
            if (checkCurFkName && !this.areEqual(fk.getName(), curFk.getName(), caseMatters) || !this.areEqual(fk.getForeignTableName(), curFk.getForeignTableName(), caseMatters)) continue;
            curRefs.clear();
            CollectionUtils.addAll(curRefs, (Object[])curFk.getReferences());
            if (curRefs.size() != refs.length) continue;
            for (int refIdx = 0; refIdx < refs.length; ++refIdx) {
                boolean found = false;
                for (int curRefIdx = 0; !found && curRefIdx < curRefs.size(); ++curRefIdx) {
                    Reference curRef = (Reference)curRefs.get(curRefIdx);
                    if ((!caseMatters || !refs[refIdx].equals(curRef)) && (caseMatters || !refs[refIdx].equalsIgnoreCase(curRef))) continue;
                    curRefs.remove(curRefIdx);
                    found = true;
                }
            }
            if (!curRefs.isEmpty()) continue;
            return curFk;
        }
        return null;
    }

    protected boolean areEqual(String string1, String string2, boolean caseMatters) {
        return caseMatters && string1.equals(string2) || !caseMatters && string1.equalsIgnoreCase(string2);
    }

    @Override
    public String createTable(Table table) {
        StringBuilder ddl = new StringBuilder();
        this.createTable(table, ddl, false, false);
        return ddl.toString();
    }

    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        this.writeTableCreationStmt(table, ddl);
        this.writeTableCreationStmtEnding(table, ddl);
        if (!this.databaseInfo.isIndicesEmbedded()) {
            this.writeExternalIndicesCreateStmt(table, ddl);
        }
        if (!this.databaseInfo.isPrimaryKeyEmbedded()) {
            this.writeExternalPrimaryKeysCreateStmt(table, table.getPrimaryKeyColumnsInIndexOrder(), ddl);
        }
    }

    public void createExternalForeignKeys(Database database, StringBuilder ddl) {
        for (int idx = 0; idx < database.getTableCount(); ++idx) {
            this.createExternalForeignKeys(database, database.getTable(idx), ddl);
        }
    }

    public void createExternalForeignKeys(Database database, Table table, StringBuilder ddl) {
        if (!this.databaseInfo.isForeignKeysEmbedded()) {
            for (int idx = 0; idx < table.getForeignKeyCount(); ++idx) {
                this.writeExternalForeignKeyCreateStmt(database, table, table.getForeignKey(idx), ddl);
            }
        }
    }

    @Override
    public String dropTables(Database database) {
        StringBuilder ddl = new StringBuilder();
        this.dropTables(database, ddl);
        return ddl.toString();
    }

    public void dropTables(Database database, StringBuilder ddl) {
        Table table;
        int idx;
        for (idx = database.getTableCount() - 1; idx >= 0; --idx) {
            table = database.getTable(idx);
            if (table.getName() == null || table.getName().length() <= 0) continue;
            this.dropExternalForeignKeys(table, ddl);
        }
        for (idx = database.getTableCount() - 1; idx >= 0; --idx) {
            table = database.getTable(idx);
            if (table.getName() == null || table.getName().length() <= 0) continue;
            this.writeTableComment(table, ddl);
            this.dropTable(table, ddl, false, false);
        }
    }

    public void dropTable(Database database, Table table, StringBuilder ddl) {
        for (int idx = database.getTableCount() - 1; idx >= 0; --idx) {
            Table otherTable = database.getTable(idx);
            ForeignKey[] fks = otherTable.getForeignKeys();
            for (int fkIdx = 0; fks != null && fkIdx < fks.length; ++fkIdx) {
                if (!fks[fkIdx].getForeignTable().equals(table)) continue;
                this.writeExternalForeignKeyDropStmt(otherTable, fks[fkIdx], ddl);
            }
        }
        this.dropExternalForeignKeys(table, ddl);
        this.writeTableComment(table, ddl);
        this.dropTable(table, ddl, false, false);
    }

    protected void dropTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        ddl.append("DROP TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.printEndOfStatement(ddl);
    }

    public void dropExternalForeignKeys(Table table, StringBuilder ddl) {
        if (!this.databaseInfo.isForeignKeysEmbedded()) {
            for (int idx = 0; idx < table.getForeignKeyCount(); ++idx) {
                this.writeExternalForeignKeyDropStmt(table, table.getForeignKey(idx), ddl);
            }
        }
    }

    public String getInsertSql(Table table, Map<String, Object> columnValues, boolean genPlaceholders) {
        Column column;
        int idx;
        StringBuilder buffer = new StringBuilder("INSERT INTO ");
        boolean addComma = false;
        buffer.append(this.getFullyQualifiedTableNameShorten(table));
        buffer.append(" (");
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            column = table.getColumn(idx);
            if (!columnValues.containsKey(column.getName())) continue;
            if (addComma) {
                buffer.append(", ");
            }
            buffer.append(this.getDelimitedIdentifier(column.getName()));
            addComma = true;
        }
        buffer.append(") VALUES (");
        if (genPlaceholders) {
            addComma = false;
            for (idx = 0; idx < columnValues.size(); ++idx) {
                if (addComma) {
                    buffer.append(", ");
                }
                buffer.append("?");
                addComma = true;
            }
        } else {
            addComma = false;
            for (idx = 0; idx < table.getColumnCount(); ++idx) {
                column = table.getColumn(idx);
                if (!columnValues.containsKey(column.getName())) continue;
                if (addComma) {
                    buffer.append(", ");
                }
                buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
                addComma = true;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public String getUpdateSql(Table table, Map<String, Object> columnValues, boolean genPlaceholders) {
        Column column;
        int idx;
        StringBuilder buffer = new StringBuilder("UPDATE ");
        boolean addSep = false;
        buffer.append(this.getFullyQualifiedTableNameShorten(table));
        buffer.append(" SET ");
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            column = table.getColumn(idx);
            if (column.isPrimaryKey() || !columnValues.containsKey(column.getName())) continue;
            if (addSep) {
                buffer.append(", ");
            }
            buffer.append(this.getDelimitedIdentifier(column.getName()));
            buffer.append(" = ");
            if (genPlaceholders) {
                buffer.append("?");
            } else {
                buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
            }
            addSep = true;
        }
        buffer.append(" WHERE ");
        addSep = false;
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            column = table.getColumn(idx);
            if (!column.isPrimaryKey() || !columnValues.containsKey(column.getName())) continue;
            if (addSep) {
                buffer.append(" AND ");
            }
            buffer.append(this.getDelimitedIdentifier(column.getName()));
            buffer.append(" = ");
            if (genPlaceholders) {
                buffer.append("?");
            } else {
                buffer.append(this.getValueAsString(column, columnValues.get(column.getName())));
            }
            addSep = true;
        }
        return buffer.toString();
    }

    public String getDeleteSql(Table table, Map<String, Object> pkValues, boolean genPlaceholders) {
        StringBuilder buffer = new StringBuilder("DELETE FROM ");
        boolean addSep = false;
        buffer.append(this.getFullyQualifiedTableNameShorten(table));
        if (pkValues != null && !pkValues.isEmpty()) {
            buffer.append(" WHERE ");
            for (Map.Entry<String, Object> entry : pkValues.entrySet()) {
                Column column = table.findColumn(entry.getKey());
                if (addSep) {
                    buffer.append(" AND ");
                }
                buffer.append(this.getDelimitedIdentifier(entry.getKey()));
                buffer.append(" = ");
                if (genPlaceholders) {
                    buffer.append("?");
                } else {
                    buffer.append(column == null ? entry.getValue() : this.getValueAsString(column, entry.getValue()));
                }
                addSep = true;
            }
        }
        return buffer.toString();
    }

    protected String getValueAsString(Column column, Object value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder result = new StringBuilder();
        switch (column.getMappedTypeCode()) {
            case 91: {
                result.append(this.databaseInfo.getValueQuoteToken());
                if (!(value instanceof String) && this.getValueDateFormat() != null) {
                    result.append(this.getValueDateFormat().format(value));
                } else {
                    result.append(value);
                }
                result.append(this.databaseInfo.getValueQuoteToken());
                break;
            }
            case 92: {
                result.append(this.databaseInfo.getValueQuoteToken());
                if (!(value instanceof String) && this.getValueTimeFormat() != null) {
                    result.append(this.getValueTimeFormat().format(value));
                } else {
                    result.append(value);
                }
                result.append(this.databaseInfo.getValueQuoteToken());
                break;
            }
            case 93: {
                result.append(this.databaseInfo.getValueQuoteToken());
                result.append(value);
                result.append(this.databaseInfo.getValueQuoteToken());
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                result.append(this.databaseInfo.getValueQuoteToken());
                if (!(value instanceof String) && this.getValueNumberFormat() != null) {
                    result.append(this.getValueNumberFormat().format(value));
                } else {
                    result.append(value);
                }
                result.append(this.databaseInfo.getValueQuoteToken());
                break;
            }
            default: {
                result.append(this.databaseInfo.getValueQuoteToken());
                result.append(this.escapeStringValue(value.toString()));
                result.append(this.databaseInfo.getValueQuoteToken());
            }
        }
        return result.toString();
    }

    public String getSelectLastIdentityValues(Table table) {
        return null;
    }

    public String fixLastIdentityValues(Table table) {
        return null;
    }

    public void writeFixLastIdentityValues(Table table, StringBuilder ddl) {
        String sql = this.fixLastIdentityValues(table);
        if (sql != null) {
            ddl.append(sql);
            this.printEndOfStatement(ddl);
        }
    }

    public String shortenName(String name, int desiredLength) {
        int originalLength = name.length();
        if (desiredLength <= 0 || originalLength <= desiredLength) {
            return name;
        }
        int delta = originalLength - desiredLength;
        int startCut = desiredLength / 2;
        StringBuilder result = new StringBuilder();
        result.append(name.substring(0, startCut));
        if (!(startCut != 0 && name.charAt(startCut - 1) == '_' || startCut + delta + 1 != originalLength && name.charAt(startCut + delta + 1) == '_')) {
            result.append("_");
        }
        result.append(name.substring(startCut + delta + 1, originalLength));
        return result.toString();
    }

    @Override
    public String getTableName(String tableName) {
        return this.shortenName(tableName, this.databaseInfo.getMaxTableNameLength());
    }

    protected void writeTableComment(Table table, StringBuilder ddl) {
        this.printComment("-----------------------------------------------------------------------", ddl);
        this.printComment(this.getFullyQualifiedTableNameShorten(table), ddl);
        this.printComment("-----------------------------------------------------------------------", ddl);
        this.println(ddl);
    }

    protected void writeTableAlterStmt(Table table, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.println(ddl);
        this.printIndent(ddl);
    }

    protected void writeTableCreationStmt(Table table, StringBuilder ddl) {
        ddl.append("CREATE TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        this.println("(", ddl);
        this.writeColumns(table, ddl);
        if (this.databaseInfo.isPrimaryKeyEmbedded()) {
            this.writeEmbeddedPrimaryKeysStmt(table, ddl);
        }
        if (this.databaseInfo.isForeignKeysEmbedded()) {
            this.writeEmbeddedForeignKeysStmt(table, ddl);
        }
        if (this.databaseInfo.isIndicesEmbedded()) {
            this.writeEmbeddedIndicesStmt(table, ddl);
        }
        this.println(ddl);
        ddl.append(")");
        if (AbstractDdlBuilder.isSpecifyIdentityGapLimit()) {
            this.writeIdentityGapLimit(ddl);
        }
    }

    protected void writeIdentityGapLimit(StringBuilder ddl) {
        int gapSize = AbstractDdlBuilder.getGapLimitSize();
        ddl.append("  with identity_gap = " + gapSize);
    }

    protected static boolean isSpecifyIdentityGapLimit() {
        return "true".equalsIgnoreCase(System.getProperty("org.jumpmind.symmetric.ddl.gap.limit", "false"));
    }

    protected static int getGapLimitSize() {
        return Integer.valueOf(System.getProperty("org.jumpmind.symmetric.ddl.gap.max", "10000"));
    }

    protected void writeTableCreationStmtEnding(Table table, StringBuilder ddl) {
        this.printEndOfStatement(ddl);
    }

    protected void writeColumns(Table table, StringBuilder ddl) {
        for (int idx = 0; idx < table.getColumnCount(); ++idx) {
            this.printIndent(ddl);
            this.writeColumn(table, table.getColumn(idx), ddl);
            if (idx >= table.getColumnCount() - 1) continue;
            this.println(",", ddl);
        }
    }

    protected String getColumnName(Column column) {
        return this.shortenName(column.getName(), this.databaseInfo.getMaxColumnNameLength());
    }

    protected void writeColumnTypeDefaultRequired(Table table, Column column, StringBuilder ddl) {
        this.printIdentifier(this.getColumnName(column), ddl);
        ddl.append(" ");
        this.writeColumnType(table, column, ddl);
    }

    protected void writeGeneratedColumn(Table table, Column column, StringBuilder ddl) {
        this.writeColumnTypeDefaultRequired(table, column, ddl);
        String definition = this.getDefinitionForGeneratedColumn(table, column);
        if (!StringUtils.isBlank((CharSequence)definition)) {
            if (!definition.startsWith("(") || !definition.endsWith(")")) {
                ddl.append(" AS ").append("(").append(definition).append(")");
            } else {
                ddl.append(" AS ").append(definition);
            }
        }
    }

    protected String getDefinitionForGeneratedColumn(Table table, Column column) {
        String definition = column.getDefaultValue();
        if (!StringUtils.isBlank((CharSequence)definition)) {
            for (PlatformColumn platformColumn : column.getPlatformColumns().values()) {
                if ("mysql".equals(platformColumn.getName())) {
                    for (Column col : table.getColumns()) {
                        definition = StringUtils.replaceIgnoreCase((String)definition, (String)("`" + col.getName() + "`"), (String)col.getName());
                    }
                    continue;
                }
                if (platformColumn.getName() == null || !platformColumn.getName().contains("mssql")) continue;
                for (Column col : table.getColumns()) {
                    definition = StringUtils.replaceIgnoreCase((String)definition, (String)("[" + col.getName() + "]"), (String)col.getName());
                }
            }
        }
        return definition;
    }

    @Override
    public String getColumnTypeDdl(Table table, Column column) {
        StringBuilder ddl = new StringBuilder();
        this.writeColumnType(table, column, ddl);
        return ddl.toString();
    }

    protected void writeColumnType(Table table, Column column, StringBuilder ddl) {
        ddl.append(this.getSqlType(column));
        if (!column.isGenerated()) {
            this.writeColumnDefaultValueStmt(table, column, ddl);
            if (column.isRequired() && this.databaseInfo.isNotNullColumnsSupported()) {
                ddl.append(" ");
                this.writeColumnNotNullableStmt(ddl);
            } else if (this.databaseInfo.isNullAsDefaultValueRequired() && this.databaseInfo.hasNullDefault(column.getMappedTypeCode())) {
                ddl.append(" ");
                this.writeColumnNullableStmt(ddl);
            }
        }
    }

    protected void writeColumn(Table table, Column column, StringBuilder ddl) {
        if (column.isGenerated() && this.databaseInfo.isGeneratedColumnsSupported()) {
            this.writeGeneratedColumn(table, column, ddl);
        } else {
            this.writeColumnTypeDefaultRequired(table, column, ddl);
        }
        if (column.isPrimaryKey() && this.databaseInfo.isPrimaryKeyEmbedded()) {
            this.writeColumnEmbeddedPrimaryKey(table, column, ddl);
        }
        if (column.isUnique() && this.databaseInfo.isUniqueEmbedded()) {
            this.writeColumnUniqueStmt(ddl);
        }
        if (column.isAutoIncrement() && !this.databaseInfo.isDefaultValueUsedForIdentitySpec()) {
            if (!this.databaseInfo.isNonPKIdentityColumnsSupported() && !column.isPrimaryKey()) {
                throw new ModelException("Column " + column.getName() + " in table " + table.getName() + " is auto-incrementing but not a primary key column, which is not supported by the platform");
            }
            ddl.append(" ");
            this.writeColumnAutoIncrementStmt(table, column, ddl);
        }
    }

    protected void writeColumnEmbeddedPrimaryKey(Table table, Column column, StringBuilder ddl) {
    }

    @Override
    public String getSqlType(Column column) {
        PlatformColumn platformColumn = column.findPlatformColumn(this.databaseName);
        String nativeType = this.getNativeType(column);
        if (platformColumn != null) {
            nativeType = platformColumn.getType();
        }
        int sizePos = nativeType.indexOf(SIZE_PLACEHOLDER);
        StringBuilder sqlType = new StringBuilder();
        sqlType.append(sizePos >= 0 ? nativeType.substring(0, sizePos) : nativeType);
        Integer size = column.getSizeAsInt();
        if (platformColumn != null) {
            size = platformColumn.getSize();
        } else if (column.getSize() == null || size == 0 && !TypeMap.isDateTimeType(column.getMappedTypeCode())) {
            size = this.databaseInfo.getDefaultSize(column.getMappedTypeCode());
        }
        int scale = column.getScale();
        if (platformColumn != null) {
            scale = platformColumn.getDecimalDigits();
        }
        if (size != null && size >= 0) {
            int maxSize = this.databaseInfo.getMaxSize(nativeType);
            if (maxSize > 0 && size > maxSize) {
                this.log.warn("Source column '{}' with size of {} exceeds maximum of {} for type {}", new Object[]{column.getName(), size, maxSize, nativeType});
                size = maxSize;
            }
            if (this.hasSize(column)) {
                if (size > 0) {
                    sqlType.append("(");
                    sqlType.append(size);
                    sqlType.append(")");
                }
            } else if (this.databaseInfo.hasPrecisionAndScale(column.getMappedTypeCode())) {
                StringBuilder precisionAndScale = new StringBuilder();
                precisionAndScale.append("(");
                precisionAndScale.append(size);
                if (scale >= 0) {
                    precisionAndScale.append(",");
                    precisionAndScale.append(scale);
                }
                precisionAndScale.append(")");
                if (!"(0,0)".equals(precisionAndScale.toString()) && !"(0)".equals(precisionAndScale.toString())) {
                    sqlType.append((CharSequence)precisionAndScale);
                }
            }
        }
        sqlType.append(sizePos >= 0 ? nativeType.substring(sizePos + SIZE_PLACEHOLDER.length()) : "");
        this.filterColumnSqlType(sqlType);
        return sqlType.toString();
    }

    protected boolean hasSize(Column column) {
        return this.databaseInfo.hasSize(column.getMappedTypeCode());
    }

    protected Integer getSize(Column column) {
        Integer size = column.getSizeAsInt();
        PlatformColumn platformColumn = column.findPlatformColumn(this.databaseName);
        if (platformColumn != null) {
            size = platformColumn.getSize();
        } else if (column.getSize() == null || size == 0 && !TypeMap.isDateTimeType(column.getMappedTypeCode())) {
            size = this.databaseInfo.getDefaultSize(column.getMappedTypeCode());
        }
        return size;
    }

    protected void filterColumnSqlType(StringBuilder sqlType) {
    }

    protected String getNativeType(Column column) {
        String nativeType = this.databaseInfo.getNativeType(column.getMappedTypeCode());
        return nativeType == null ? column.getMappedType() : nativeType;
    }

    protected String getBareNativeType(Column column) {
        String nativeType = this.getNativeType(column);
        int sizePos = nativeType.indexOf(SIZE_PLACEHOLDER);
        return sizePos >= 0 ? nativeType.substring(0, sizePos) : nativeType;
    }

    protected String getNativeDefaultValue(Column column) {
        String defaultValue = column.getDefaultValue();
        PlatformColumn platformColumn = column.findPlatformColumn(this.databaseName);
        if (platformColumn != null) {
            defaultValue = platformColumn.getDefaultValue();
        }
        return defaultValue;
    }

    protected String escapeStringValue(String value) {
        String result = value;
        for (Map.Entry<String, String> entry : this.charSequencesToEscape.entrySet()) {
            result = StringUtils.replace((String)result, (String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    protected boolean isValidDefaultValue(String defaultSpec, int typeCode) {
        return defaultSpec != null && (defaultSpec.length() > 0 || !TypeMap.isNumericType(typeCode) && !TypeMap.isDateTimeType(typeCode));
    }

    protected void writeColumnDefaultValueStmt(Table table, Column column, StringBuilder ddl) {
        Object parsedDefault = column.getParsedDefaultValue();
        if (parsedDefault != null) {
            if (!(this.databaseInfo.isDefaultValuesForLongTypesSupported() || column.getMappedTypeCode() != -4 && column.getMappedTypeCode() != -1)) {
                throw new ModelException("The platform does not support default values for LONGVARCHAR or LONGVARBINARY columns");
            }
            if (this.isValidDefaultValue(column.getDefaultValue(), column.getMappedTypeCode())) {
                ddl.append(" DEFAULT ");
                this.writeColumnDefaultValue(table, column, ddl);
            }
        } else if (this.databaseInfo.isDefaultValueUsedForIdentitySpec() && column.isAutoIncrement()) {
            ddl.append(" DEFAULT ");
            this.writeColumnDefaultValue(table, column, ddl);
        } else if (!StringUtils.isBlank((CharSequence)column.getDefaultValue())) {
            ddl.append(" DEFAULT ");
            this.writeColumnDefaultValue(table, column, ddl);
        }
    }

    protected void writeColumnDefaultValue(Table table, Column column, StringBuilder ddl) {
        this.printDefaultValue(this.getNativeDefaultValue(column), column, ddl);
    }

    protected void printDefaultValue(String defaultValue, Column column, StringBuilder ddl) {
        String defaultValueStr = this.mapDefaultValue(defaultValue, column);
        if (this.shouldUseQuotes(defaultValue, column)) {
            ddl.append(this.databaseInfo.getValueQuoteToken());
            ddl.append(this.escapeStringValue(defaultValueStr));
            ddl.append(this.databaseInfo.getValueQuoteToken());
        } else {
            ddl.append(defaultValueStr);
        }
    }

    protected boolean shouldUseQuotes(String defaultValue, Column column) {
        boolean isNull = false;
        if (defaultValue == null || defaultValue.equalsIgnoreCase("null") || defaultValue.equalsIgnoreCase("(null)")) {
            isNull = true;
        }
        String defaultValueStr = this.mapDefaultValue(defaultValue, column);
        if (this.databaseInfo.getDefaultValuesToLeaveUnquoted().contains(defaultValueStr)) {
            return false;
        }
        while (!isNull && defaultValueStr.startsWith("(") && defaultValueStr.endsWith(")")) {
            defaultValueStr = defaultValueStr.substring(1, defaultValueStr.length() - 1);
        }
        int typeCode = column.getMappedTypeCode();
        boolean shouldUseQuotes = !isNull && !defaultValueStr.contains("()") && !TypeMap.isNumericType(typeCode) && (!TypeMap.isDateTimeType(typeCode) || !defaultValueStr.toUpperCase().startsWith("TO_DATE(") && !defaultValueStr.toUpperCase().startsWith("TO_TIMESTAMP(") && !defaultValueStr.toUpperCase().startsWith("SYSDATE") && !defaultValueStr.toUpperCase().startsWith("NOW(") && !defaultValueStr.toUpperCase().startsWith("CURRENT_TIME") && !defaultValueStr.toUpperCase().startsWith("CURRENT_DATE") && !defaultValueStr.toUpperCase().startsWith("CURRENT TIME") && !defaultValueStr.toUpperCase().startsWith("CURRENT DATE") && !defaultValueStr.toUpperCase().startsWith("CURRENT_USER") && !defaultValueStr.toUpperCase().startsWith("CURRENT USER") && !defaultValueStr.toUpperCase().startsWith("USER") && !defaultValueStr.toUpperCase().startsWith("SYSTEM_USER") && !defaultValueStr.toUpperCase().startsWith("SESSION_USER") && !defaultValueStr.toUpperCase().startsWith("LOCALTIMESTAMP") && !defaultValueStr.toUpperCase().startsWith("DATE '") && !defaultValueStr.toUpperCase().startsWith("TIME '") && !defaultValueStr.toUpperCase().startsWith("TIMESTAMP '") && !defaultValueStr.toUpperCase().startsWith("INTERVAL '")) && (!defaultValueStr.toUpperCase().startsWith("N'") || !defaultValueStr.endsWith("'"));
        return shouldUseQuotes;
    }

    @Override
    public String mapDefaultValue(Object defaultValue, Column column) {
        if (defaultValue == null) {
            defaultValue = "NULL";
        }
        String defaultValueStr = defaultValue.toString();
        Map<String, String> defaultValuesToTranslate = this.databaseInfo.getDefaultValuesToTranslate();
        if (defaultValuesToTranslate.containsKey(defaultValueStr)) {
            return defaultValuesToTranslate.get(defaultValueStr);
        }
        return defaultValueStr;
    }

    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        ddl.append("IDENTITY");
    }

    protected void writeColumnNullableStmt(StringBuilder ddl) {
        ddl.append("NULL");
    }

    protected void writeColumnNotNullableStmt(StringBuilder ddl) {
        ddl.append("NOT NULL");
    }

    protected void writeColumnUniqueStmt(StringBuilder ddl) {
        ddl.append(" UNIQUE ");
    }

    @Override
    public boolean areColumnSizesTheSame(Column sourceColumn, Column targetColumn) {
        boolean sizeMatters = this.hasSize(targetColumn);
        boolean scaleMatters = this.databaseInfo.hasPrecisionAndScale(targetColumn.getMappedTypeCode());
        String targetSize = targetColumn.getSize();
        int targetScale = targetColumn.getScale();
        PlatformColumn platformTargetColumn = targetColumn.findPlatformColumn(this.databaseName);
        if (platformTargetColumn != null) {
            targetSize = String.valueOf(platformTargetColumn.getSize());
            targetScale = platformTargetColumn.getDecimalDigits();
            if (scaleMatters) {
                targetSize = targetSize + "," + targetScale;
            }
        }
        if (targetSize == null) {
            Integer defaultSize = this.databaseInfo.getDefaultSize(this.databaseInfo.getTargetJdbcType(targetColumn.getMappedTypeCode()));
            targetSize = defaultSize != null ? defaultSize.toString() : "0";
        }
        String sourceSize = sourceColumn.getSize();
        int sourceScale = sourceColumn.getScale();
        PlatformColumn platformSourceColumn = sourceColumn.findPlatformColumn(this.databaseName);
        if (platformSourceColumn != null) {
            sourceSize = String.valueOf(platformSourceColumn.getSize());
            sourceScale = platformSourceColumn.getDecimalDigits();
            if (scaleMatters) {
                sourceSize = sourceSize + "," + sourceScale;
            }
        }
        if (sizeMatters && !StringUtils.equals((CharSequence)sourceSize, (CharSequence)targetSize)) {
            return false;
        }
        return !scaleMatters || StringUtils.equals((CharSequence)sourceSize, (CharSequence)targetSize) && (sourceScale < 0 && targetScale == 0 || sourceScale == targetScale);
    }

    @Override
    public boolean areMappedTypesTheSame(Column sourceColumn, Column targetColumn) {
        return sourceColumn.getMappedTypeCode() == targetColumn.getMappedTypeCode();
    }

    @Override
    public String getForeignKeyName(Table table, ForeignKey fk) {
        boolean needsName;
        String fkName = fk.getName();
        boolean bl = needsName = fkName == null || fkName.length() == 0;
        if (needsName) {
            StringBuilder name = new StringBuilder();
            for (int idx = 0; idx < fk.getReferenceCount(); ++idx) {
                name.append(fk.getReference(idx).getLocalColumnName());
                name.append("_");
            }
            name.append(fk.getForeignTableName());
            fkName = this.getConstraintName(null, table, "FK", name.toString());
        }
        fkName = this.shortenName(fkName, this.databaseInfo.getMaxForeignKeyNameLength());
        if (needsName) {
            this.log.warn("Encountered a foreign key in table " + table.getName() + " that has no name. DdlUtils will use the auto-generated and shortened name " + fkName + " instead.");
        }
        return fkName;
    }

    @Override
    public String getConstraintName(String prefix, Table table, String secondPart, String suffix) {
        StringBuilder result = new StringBuilder();
        if (prefix != null) {
            result.append(prefix);
            result.append("_");
        }
        result.append(table.getName());
        result.append("_");
        result.append(secondPart);
        if (suffix != null) {
            result.append("_");
            result.append(suffix);
        }
        return this.shortenName(result.toString(), this.databaseInfo.getMaxConstraintNameLength());
    }

    protected void writeEmbeddedPrimaryKeysStmt(Table table, StringBuilder ddl) {
        Column[] primaryKeyColumns = table.getPrimaryKeyColumnsInIndexOrder();
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            this.printStartOfEmbeddedStatement(ddl);
            this.writePrimaryKeyStmt(table, primaryKeyColumns, ddl);
        }
    }

    protected void writeExternalPrimaryKeysCreateStmt(Table table, Column[] primaryKeyColumns, StringBuilder ddl) {
        if (primaryKeyColumns.length > 0 && this.shouldGeneratePrimaryKeys(primaryKeyColumns)) {
            ddl.append("ALTER TABLE ");
            ddl.append(this.getFullyQualifiedTableNameShorten(table));
            this.println(ddl);
            this.printIndent(ddl);
            ddl.append("ADD CONSTRAINT ");
            this.printIdentifier(this.getConstraintName(null, table, "PK", null), ddl);
            ddl.append(" ");
            this.writePrimaryKeyStmt(table, primaryKeyColumns, ddl);
            this.printEndOfStatement(ddl);
        }
    }

    protected boolean shouldGeneratePrimaryKeys(Column[] primaryKeyColumns) {
        return true;
    }

    protected void writePrimaryKeyStmt(Table table, Column[] primaryKeyColumns, StringBuilder ddl) {
        ddl.append("PRIMARY KEY (");
        for (int idx = 0; idx < primaryKeyColumns.length; ++idx) {
            this.printIdentifier(this.getColumnName(primaryKeyColumns[idx]), ddl);
            if (idx >= primaryKeyColumns.length - 1) continue;
            ddl.append(", ");
        }
        ddl.append(")");
    }

    @Override
    public String getIndexName(IIndex index) {
        return this.shortenName(index.getName(), this.databaseInfo.getMaxConstraintNameLength());
    }

    protected void writeExternalIndicesCreateStmt(Table table, StringBuilder ddl) {
        for (int idx = 0; idx < table.getIndexCount(); ++idx) {
            IIndex index = table.getIndex(idx);
            if (!index.isUnique() && !this.databaseInfo.isIndicesSupported()) {
                return;
            }
            this.writeExternalIndexCreateStmt(table, index, ddl);
        }
    }

    protected void writeEmbeddedIndicesStmt(Table table, StringBuilder ddl) {
        if (this.databaseInfo.isIndicesSupported()) {
            for (int idx = 0; idx < table.getIndexCount(); ++idx) {
                this.printStartOfEmbeddedStatement(ddl);
                this.writeEmbeddedIndexCreateStmt(table, table.getIndex(idx), ddl);
            }
        }
    }

    protected void writeExternalIndexCreateStmt(Table table, IIndex index, StringBuilder ddl) {
        if (this.databaseInfo.isIndicesSupported()) {
            if (index.getName() == null) {
                this.log.warn("Cannot write unnamed index " + index);
            } else {
                this.writeExternalIndexCreate(table, index, ddl);
                this.printEndOfStatement(ddl);
            }
        }
    }

    protected void writeExternalIndexCreate(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("CREATE");
        if (index.isUnique()) {
            ddl.append(" UNIQUE");
        }
        if (this.isFullTextIndex(index)) {
            ddl.append(" FULLTEXT");
        }
        ddl.append(" INDEX ");
        ddl.append(this.getFullyQualifiedIndexNameShorten(table, index));
        ddl.append(" ON ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        ddl.append(" (");
        for (int idx = 0; idx < index.getColumnCount(); ++idx) {
            IndexColumn idxColumn = index.getColumn(idx);
            if (idx > 0) {
                ddl.append(", ");
            }
            String name = this.shortenName(idxColumn.getName(), this.databaseInfo.getMaxColumnNameLength());
            if (table.findColumn(idxColumn.getName()) == null && name.contains("(")) {
                ddl.append(name);
                continue;
            }
            this.printIdentifier(name, ddl);
        }
        ddl.append(")");
    }

    protected String getFullyQualifiedIndexNameShorten(Table table, IIndex index) {
        return this.getDelimitedIdentifier(this.getIndexName(index));
    }

    protected boolean isFullTextIndex(IIndex index) {
        return false;
    }

    protected void writeEmbeddedIndexCreateStmt(Table table, IIndex index, StringBuilder ddl) {
        if (index.getName() != null && index.getName().length() > 0) {
            ddl.append(" CONSTRAINT ");
            this.printIdentifier(this.getIndexName(index), ddl);
        }
        if (index.isUnique()) {
            ddl.append(" UNIQUE");
        } else {
            ddl.append(" INDEX ");
        }
        ddl.append(" (");
        for (int idx = 0; idx < index.getColumnCount(); ++idx) {
            IndexColumn idxColumn = index.getColumn(idx);
            Column col = table.findColumn(idxColumn.getName());
            if (col == null) {
                throw new ModelException("Invalid column '" + idxColumn.getName() + "' on index " + index.getName() + " for table " + table.getName());
            }
            if (idx > 0) {
                ddl.append(", ");
            }
            this.printIdentifier(this.getColumnName(col), ddl);
        }
        ddl.append(")");
    }

    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        if (this.databaseInfo.isAlterTableForDropUsed()) {
            this.writeTableAlterStmt(table, ddl);
        }
        ddl.append("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index), ddl);
        if (!this.databaseInfo.isAlterTableForDropUsed()) {
            ddl.append(" ON ");
            ddl.append(this.getFullyQualifiedTableNameShorten(table));
        }
        this.printEndOfStatement(ddl);
    }

    protected void writeEmbeddedForeignKeysStmt(Table table, StringBuilder ddl) {
        for (int idx = 0; idx < table.getForeignKeyCount(); ++idx) {
            ForeignKey key = table.getForeignKey(idx);
            if (key.getForeignTableName() == null) {
                this.log.warn("Foreign key table is null for key " + key);
                continue;
            }
            this.printStartOfEmbeddedStatement(ddl);
            if (this.databaseInfo.isEmbeddedForeignKeysNamed()) {
                ddl.append("CONSTRAINT ");
                this.printIdentifier(this.getForeignKeyName(table, key), ddl);
                ddl.append(" ");
            }
            ddl.append("FOREIGN KEY (");
            this.writeLocalReferences(key, ddl);
            ddl.append(") REFERENCES ");
            if (StringUtils.isNotBlank((CharSequence)table.getCatalog())) {
                ddl.append(this.getDelimitedIdentifier(table.getCatalog())).append(".");
            }
            if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
                ddl.append(this.getDelimitedIdentifier(table.getSchema())).append(".");
            }
            this.printIdentifier(this.getTableName(key.getForeignTableName()), ddl);
            ddl.append(" (");
            this.writeForeignReferences(key, ddl);
            ddl.append(")");
            this.writeCascadeAttributesForForeignKey(key, ddl);
        }
    }

    protected void writeExternalForeignKeyCreateStmt(Database database, Table table, ForeignKey key, StringBuilder ddl) {
        if (key.getForeignTableName() == null) {
            this.log.warn("Foreign key table is null for key " + key);
        } else {
            this.writeTableAlterStmt(table, ddl);
            ddl.append("ADD CONSTRAINT ");
            this.printIdentifier(this.getForeignKeyName(table, key), ddl);
            ddl.append(" FOREIGN KEY (");
            this.writeLocalReferences(key, ddl);
            ddl.append(") REFERENCES ");
            if (StringUtils.isNotBlank((CharSequence)key.getForeignTableCatalog()) || StringUtils.isNotBlank((CharSequence)key.getForeignTableSchema())) {
                if (StringUtils.isNotBlank((CharSequence)key.getForeignTableCatalog())) {
                    this.printIdentifier(key.getForeignTableCatalog(), ddl);
                    ddl.append(".");
                }
                if (StringUtils.isNotBlank((CharSequence)key.getForeignTableSchema())) {
                    this.printIdentifier(key.getForeignTableSchema(), ddl);
                    ddl.append(".");
                }
            } else {
                if (StringUtils.isNotBlank((CharSequence)table.getCatalog())) {
                    this.printIdentifier(table.getCatalog(), ddl);
                    ddl.append(".");
                }
                if (StringUtils.isNotBlank((CharSequence)table.getSchema())) {
                    this.printIdentifier(table.getSchema(), ddl);
                    ddl.append(".");
                }
            }
            this.printIdentifier(this.getTableName(key.getForeignTableName()), ddl);
            ddl.append(" (");
            this.writeForeignReferences(key, ddl);
            ddl.append(")");
            this.writeCascadeAttributesForForeignKey(key, ddl);
            this.printEndOfStatement(ddl);
        }
    }

    protected void writeCascadeAttributesForForeignKey(ForeignKey key, StringBuilder ddl) {
        this.writeCascadeAttributesForForeignKeyDelete(key, ddl);
        this.writeCascadeAttributesForForeignKeyUpdate(key, ddl);
    }

    protected void writeCascadeAttributesForForeignKeyDelete(ForeignKey key, StringBuilder ddl) {
        if (key.getOnDeleteAction() != ForeignKey.ForeignKeyAction.RESTRICT && key.getOnDeleteAction() != ForeignKey.ForeignKeyAction.NOACTION) {
            ddl.append(" ON DELETE " + key.getOnDeleteAction().getForeignKeyActionName());
        }
    }

    protected void writeCascadeAttributesForForeignKeyUpdate(ForeignKey key, StringBuilder ddl) {
        if (key.getOnUpdateAction() != ForeignKey.ForeignKeyAction.RESTRICT && key.getOnUpdateAction() != ForeignKey.ForeignKeyAction.NOACTION) {
            ddl.append(" ON UPDATE " + key.getOnUpdateAction().getForeignKeyActionName());
        }
    }

    protected void writeLocalReferences(ForeignKey key, StringBuilder ddl) {
        for (int idx = 0; idx < key.getReferenceCount(); ++idx) {
            if (idx > 0) {
                ddl.append(", ");
            }
            this.printIdentifier(key.getReference(idx).getLocalColumnName(), ddl);
        }
    }

    protected void writeForeignReferences(ForeignKey key, StringBuilder ddl) {
        for (int idx = 0; idx < key.getReferenceCount(); ++idx) {
            if (idx > 0) {
                ddl.append(", ");
            }
            this.printIdentifier(key.getReference(idx).getForeignColumnName(), ddl);
        }
    }

    protected void writeExternalForeignKeyDropStmt(Table table, ForeignKey foreignKey, StringBuilder ddl) {
        this.writeTableAlterStmt(table, ddl);
        ddl.append("DROP CONSTRAINT ");
        this.printIdentifier(this.getForeignKeyName(table, foreignKey), ddl);
        this.printEndOfStatement(ddl);
    }

    protected void printComment(String text, StringBuilder ddl) {
        if (this.sqlCommentsOn) {
            ddl.append(this.databaseInfo.getCommentPrefix());
            ddl.append(" ");
            ddl.append(text);
            ddl.append(" ");
            ddl.append(this.databaseInfo.getCommentSuffix());
            this.println(ddl);
        }
    }

    protected void printStartOfEmbeddedStatement(StringBuilder ddl) {
        this.println(",", ddl);
        this.printIndent(ddl);
    }

    protected void printEndOfStatement(StringBuilder ddl) {
        this.println(this.databaseInfo.getSqlCommandDelimiter(), ddl);
    }

    protected void println(StringBuilder ddl) {
        ddl.append(LINE_SEPARATOR);
    }

    protected String getDelimitedIdentifier(String identifier) {
        if (this.delimitedIdentifierModeOn) {
            return this.databaseInfo.getDelimiterToken() + identifier + this.databaseInfo.getDelimiterToken();
        }
        return identifier;
    }

    protected void printIdentifier(String identifier, StringBuilder ddl) {
        ddl.append(this.getDelimitedIdentifier(identifier));
    }

    protected void printlnIdentifier(String identifier, StringBuilder ddl) {
        this.println(this.getDelimitedIdentifier(identifier), ddl);
    }

    protected void println(String text, StringBuilder ddl) {
        ddl.append(text);
        this.println(ddl);
    }

    protected void printIndent(StringBuilder ddl) {
        ddl.append(this.getIndent());
    }

    public boolean isScriptModeOn() {
        return this.scriptModeOn;
    }

    public void setScriptModeOn(boolean scriptModeOn) {
        this.scriptModeOn = scriptModeOn;
    }

    public boolean isSqlCommentsOn() {
        return this.sqlCommentsOn;
    }

    public void setSqlCommentsOn(boolean sqlCommentsOn) {
        if (!this.databaseInfo.isSqlCommentsSupported() && sqlCommentsOn) {
            throw new DdlException("Platform does not support SQL comments");
        }
        this.sqlCommentsOn = sqlCommentsOn;
    }

    @Override
    public boolean isDelimitedIdentifierModeOn() {
        return this.delimitedIdentifierModeOn;
    }

    @Override
    public void setDelimitedIdentifierModeOn(boolean delimitedIdentifierModeOn) {
        if (!this.databaseInfo.isDelimitedIdentifiersSupported() && delimitedIdentifierModeOn) {
            this.log.info("Platform does not support delimited identifier.  Delimited identifiers will not be enabled.");
        } else {
            this.delimitedIdentifierModeOn = delimitedIdentifierModeOn;
        }
    }

    @Override
    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public void initCteExpression() {
    }
}

