/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections4.OrderedIterator;
import org.apache.commons.collections4.set.ListOrderedSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;

public class ForeignKey
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Table foreignTable;
    private String foreignTableName;
    private ListOrderedSet<Reference> references = new ListOrderedSet();
    private boolean autoIndexPresent;
    private String foreignTableCatalog;
    private String foreignTableSchema;
    private ForeignKeyAction onDeleteAction = ForeignKeyAction.NOACTION;
    private ForeignKeyAction onUpdateAction = ForeignKeyAction.NOACTION;

    public ForeignKey() {
        this(null);
    }

    public ForeignKey(String name) {
        this(name, null);
    }

    public ForeignKey(String name, String foreignKeyTableName) {
        this.name = name;
        this.foreignTableName = foreignKeyTableName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Table getForeignTable() {
        return this.foreignTable;
    }

    public void setForeignTable(Table foreignTable) {
        this.foreignTable = foreignTable;
        this.foreignTableName = foreignTable == null ? null : foreignTable.getName();
        this.foreignTableCatalog = foreignTable == null ? null : foreignTable.getCatalog();
        this.foreignTableSchema = foreignTable == null ? null : foreignTable.getSchema();
    }

    public String getForeignTableName() {
        return this.foreignTableName;
    }

    public void setForeignTableName(String foreignTableName) {
        if (this.foreignTable != null && !this.foreignTable.getName().equals(foreignTableName)) {
            this.foreignTable = null;
        }
        this.foreignTableName = foreignTableName;
    }

    public int getReferenceCount() {
        return this.references.size();
    }

    public Reference getReference(int idx) {
        return (Reference)this.references.get(idx);
    }

    public Reference[] getReferences() {
        return (Reference[])this.references.toArray((Object[])new Reference[this.references.size()]);
    }

    public Reference getFirstReference() {
        return this.references.isEmpty() ? null : (Reference)this.references.get(0);
    }

    public void addReference(Reference reference) {
        if (reference != null) {
            for (int idx = 0; idx < this.references.size(); ++idx) {
                Reference curRef = this.getReference(idx);
                if (curRef.getSequenceValue() <= reference.getSequenceValue()) continue;
                this.references.add(idx, (Object)reference);
                return;
            }
            this.references.add((Object)reference);
        }
    }

    public void removeReference(Reference reference) {
        if (reference != null) {
            this.references.remove((Object)reference);
        }
    }

    public void removeReference(int idx) {
        this.references.remove(idx);
    }

    public boolean hasLocalColumn(Column column) {
        for (int idx = 0; idx < this.getReferenceCount(); ++idx) {
            if (!column.equals(this.getReference(idx).getLocalColumn())) continue;
            return true;
        }
        return false;
    }

    public boolean hasForeignColumn(Column column) {
        for (int idx = 0; idx < this.getReferenceCount(); ++idx) {
            if (!column.equals(this.getReference(idx).getForeignColumn())) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoIndexPresent() {
        return this.autoIndexPresent;
    }

    public void setAutoIndexPresent(boolean autoIndexPresent) {
        this.autoIndexPresent = autoIndexPresent;
    }

    public Object clone() throws CloneNotSupportedException {
        ForeignKey result = (ForeignKey)super.clone();
        result.name = this.name;
        result.foreignTableName = this.foreignTableName;
        result.references = new ListOrderedSet();
        result.foreignTableCatalog = this.foreignTableCatalog;
        result.foreignTableSchema = this.foreignTableSchema;
        result.onDeleteAction = this.getOnDeleteAction();
        result.onUpdateAction = this.getOnUpdateAction();
        OrderedIterator it = this.references.iterator();
        while (it.hasNext()) {
            result.references.add((Object)((Reference)((Reference)it.next()).clone()));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ForeignKey) {
            ForeignKeyAction myForeignKeyUpdateAction;
            ForeignKeyAction otherForeignKeyUpdateAction;
            ForeignKeyAction myForeignKeyDeleteAction;
            ForeignKey otherFk = (ForeignKey)obj;
            EqualsBuilder builder = new EqualsBuilder();
            if (this.isCheckName(otherFk)) {
                builder.append((Object)this.name, (Object)otherFk.name);
            }
            builder.append((Object)this.foreignTableName, (Object)otherFk.foreignTableName);
            ForeignKeyAction otherForeignKeyDeleteAction = otherFk.getOnDeleteAction();
            if (otherForeignKeyDeleteAction == ForeignKeyAction.RESTRICT) {
                otherForeignKeyDeleteAction = ForeignKeyAction.NOACTION;
            }
            if ((myForeignKeyDeleteAction = this.getOnDeleteAction()) == ForeignKeyAction.RESTRICT) {
                myForeignKeyDeleteAction = ForeignKeyAction.NOACTION;
            }
            if ((otherForeignKeyUpdateAction = otherFk.getOnUpdateAction()) == ForeignKeyAction.RESTRICT) {
                otherForeignKeyUpdateAction = ForeignKeyAction.NOACTION;
            }
            if ((myForeignKeyUpdateAction = this.getOnUpdateAction()) == ForeignKeyAction.RESTRICT) {
                myForeignKeyUpdateAction = ForeignKeyAction.NOACTION;
            }
            builder.append((Object)myForeignKeyDeleteAction, (Object)otherForeignKeyDeleteAction);
            builder.append((Object)myForeignKeyUpdateAction, (Object)otherForeignKeyUpdateAction);
            builder.append(this.references.size(), otherFk.references.size());
            for (int i = 0; i < this.references.size() && i < otherFk.references.size(); ++i) {
                builder.append(this.references.get(i), otherFk.references.get(i));
            }
            return builder.isEquals();
        }
        return false;
    }

    public boolean equalsIgnoreCase(ForeignKey otherFk) {
        boolean checkName = this.isCheckName(otherFk);
        if ((!checkName || this.name.equalsIgnoreCase(otherFk.name)) && this.foreignTableName.equalsIgnoreCase(otherFk.foreignTableName)) {
            ForeignKeyAction myForeignKeyUpdateAction;
            ForeignKeyAction myForeignKeyDeleteAction;
            ForeignKeyAction otherForeignKeyDeleteAction = otherFk.getOnDeleteAction();
            if (otherForeignKeyDeleteAction == ForeignKeyAction.RESTRICT) {
                otherForeignKeyDeleteAction = ForeignKeyAction.NOACTION;
            }
            if ((myForeignKeyDeleteAction = this.getOnDeleteAction()) == ForeignKeyAction.RESTRICT) {
                myForeignKeyDeleteAction = ForeignKeyAction.NOACTION;
            }
            if (otherForeignKeyDeleteAction != myForeignKeyDeleteAction) {
                return false;
            }
            ForeignKeyAction otherForeignKeyUpdateAction = otherFk.getOnUpdateAction();
            if (otherForeignKeyUpdateAction == ForeignKeyAction.RESTRICT) {
                otherForeignKeyUpdateAction = ForeignKeyAction.NOACTION;
            }
            if ((myForeignKeyUpdateAction = this.getOnUpdateAction()) == ForeignKeyAction.RESTRICT) {
                myForeignKeyUpdateAction = ForeignKeyAction.NOACTION;
            }
            if (otherForeignKeyUpdateAction != myForeignKeyUpdateAction) {
                return false;
            }
            HashSet<Reference> otherRefs = new HashSet<Reference>();
            otherRefs.addAll((Collection<Reference>)otherFk.references);
            for (Reference curLocalRef : this.references) {
                boolean found = false;
                Iterator otherIt = otherRefs.iterator();
                while (otherIt.hasNext()) {
                    Reference curOtherRef = (Reference)otherIt.next();
                    if (!curLocalRef.equalsIgnoreCase(curOtherRef)) continue;
                    otherIt.remove();
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return otherRefs.isEmpty();
        }
        return false;
    }

    private boolean isCheckName(ForeignKey otherFk) {
        return this.name != null && this.name.length() > 0 && otherFk.name != null && otherFk.name.length() > 0;
    }

    public int hashCode() {
        ForeignKeyAction myForeignKeyUpdateAction;
        ForeignKeyAction myForeignKeyDeleteAction;
        HashCodeBuilder builder = new HashCodeBuilder(17, 37).append((Object)this.foreignTableName).append(this.references);
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            builder.append((Object)this.name);
        }
        if ((myForeignKeyDeleteAction = this.getOnDeleteAction()) == ForeignKeyAction.RESTRICT) {
            myForeignKeyDeleteAction = ForeignKeyAction.NOACTION;
        }
        if ((myForeignKeyUpdateAction = this.getOnUpdateAction()) == ForeignKeyAction.RESTRICT) {
            myForeignKeyUpdateAction = ForeignKeyAction.NOACTION;
        }
        builder.append((Object)myForeignKeyDeleteAction);
        builder.append((Object)myForeignKeyUpdateAction);
        return builder.toHashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Foreign key [");
        if (this.getName() != null && this.getName().length() > 0) {
            result.append("name=");
            result.append(this.getName());
            result.append("; ");
        }
        result.append("foreign table=");
        result.append(this.getForeignTableName());
        result.append("; ");
        if (this.getOnDeleteAction() != ForeignKeyAction.RESTRICT && this.getOnDeleteAction() != ForeignKeyAction.NOACTION) {
            result.append("ON DELETE " + this.getOnDeleteAction().getForeignKeyActionName()).append("; ");
        }
        if (this.getOnUpdateAction() != ForeignKeyAction.RESTRICT && this.getOnUpdateAction() != ForeignKeyAction.NOACTION) {
            result.append("ON UPDATE " + this.getOnUpdateAction().getForeignKeyActionName()).append(";");
        }
        result.append(this.getReferenceCount());
        result.append(" references]");
        return result.toString();
    }

    public String toVerboseString() {
        StringBuilder result = new StringBuilder();
        result.append("Foreign key [");
        if (this.getName() != null && this.getName().length() > 0) {
            result.append("name=");
            result.append(this.getName());
            result.append("; ");
        }
        result.append("foreign table=");
        result.append(this.getForeignTableName());
        result.append(";");
        if (this.getOnDeleteAction() != ForeignKeyAction.RESTRICT && this.getOnDeleteAction() != ForeignKeyAction.NOACTION) {
            result.append(" ON DELETE " + this.getOnDeleteAction().getForeignKeyActionName());
        }
        if (this.getOnUpdateAction() != ForeignKeyAction.RESTRICT && this.getOnUpdateAction() != ForeignKeyAction.NOACTION) {
            result.append(" ON UPDATE " + this.getOnUpdateAction().getForeignKeyActionName());
        }
        result.append("] references:");
        for (int idx = 0; idx < this.getReferenceCount(); ++idx) {
            result.append(" ");
            result.append(this.getReference(idx));
        }
        return result.toString();
    }

    public String getForeignTableCatalog() {
        return this.foreignTableCatalog;
    }

    public void setForeignTableCatalog(String foreignTableCatalog) {
        this.foreignTableCatalog = foreignTableCatalog;
    }

    public String getForeignTableSchema() {
        return this.foreignTableSchema;
    }

    public void setForeignTableSchema(String foreignTableSchema) {
        this.foreignTableSchema = foreignTableSchema;
    }

    public ForeignKeyAction getOnDeleteAction() {
        return this.onDeleteAction;
    }

    public void setOnDeleteAction(ForeignKeyAction onDeleteAction) {
        this.onDeleteAction = onDeleteAction;
    }

    public ForeignKeyAction getOnUpdateAction() {
        return this.onUpdateAction;
    }

    public void setOnUpdateAction(ForeignKeyAction onUpdateAction) {
        this.onUpdateAction = onUpdateAction;
    }

    public static ForeignKeyAction getForeignKeyAction(short importedKeyAction) {
        switch (importedKeyAction) {
            case 0: {
                return ForeignKeyAction.CASCADE;
            }
            case 3: {
                return ForeignKeyAction.NOACTION;
            }
            case 1: {
                return ForeignKeyAction.RESTRICT;
            }
            case 4: {
                return ForeignKeyAction.SETDEFAULT;
            }
            case 2: {
                return ForeignKeyAction.SETNULL;
            }
        }
        return ForeignKeyAction.NOACTION;
    }

    public static ForeignKeyAction getForeignKeyActionByForeignKeyActionName(String foreignKeyActionName) throws IllegalArgumentException {
        for (ForeignKeyAction action : ForeignKeyAction.values()) {
            if (!StringUtils.equals((CharSequence)foreignKeyActionName, (CharSequence)action.getForeignKeyActionName())) continue;
            return action;
        }
        throw new IllegalArgumentException("Unknown ForeignKeyAction: " + foreignKeyActionName);
    }

    public static enum ForeignKeyAction {
        CASCADE("CASCADE"),
        NOACTION("NO ACTION"),
        SETNULL("SET NULL"),
        SETDEFAULT("SET DEFAULT"),
        RESTRICT("RESTRICT");

        private String foreignKeyActionName;

        private ForeignKeyAction(String foreignKeyActionName) {
            this.foreignKeyActionName = foreignKeyActionName;
        }

        public String getForeignKeyActionName() {
            return this.foreignKeyActionName;
        }
    }
}

