/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jumpmind.db.model.ModelException;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.TypeMap;

public class Column
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String javaName;
    private String description;
    private boolean primaryKey;
    private boolean required;
    private boolean autoIncrement;
    private boolean unique;
    private boolean generated;
    private boolean expressionAsDefaultValue;
    private int mappedTypeCode;
    private String mappedType;
    private String size;
    private Integer sizeAsInt;
    private int charOctetLength;
    private int scale;
    private String defaultValue;
    private int jdbcTypeCode = Integer.MIN_VALUE;
    private String jdbcTypeName;
    private boolean distributionKey;
    private int precisionRadix;
    private Map<String, PlatformColumn> platformColumns;
    private int primaryKeySequence;

    public Column() {
    }

    public Column(String name) {
        this(name, false);
    }

    public Column(String name, boolean primaryKey) {
        this.name = name;
        this.primaryKey = primaryKey;
    }

    public Column(String name, boolean primaryKey, int typeCode, int size, int scale) {
        this.name = name;
        this.primaryKey = primaryKey;
        this.required = primaryKey;
        this.setTypeCode(typeCode);
        this.setSizeAndScale(size, scale);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public boolean isExpressionAsDefaultValue() {
        return this.expressionAsDefaultValue;
    }

    public void setExpressionAsDefaultValue(boolean expressionAsDefaultValue) {
        this.expressionAsDefaultValue = expressionAsDefaultValue;
    }

    public int getMappedTypeCode() {
        return this.mappedTypeCode;
    }

    public final void setMappedTypeCode(int typeCode) {
        this.mappedType = TypeMap.getJdbcTypeName(typeCode);
        if (this.mappedType == null) {
            throw new ModelException("Unknown JDBC type code " + typeCode + " for : " + this.toString());
        }
        this.mappedTypeCode = typeCode;
    }

    public String getMappedType() {
        return this.mappedType;
    }

    public void setMappedType(String type) {
        Integer typeCode = TypeMap.getJdbcTypeCode(type);
        if (typeCode == null) {
            throw new ModelException("Unknown JDBC type " + type + " for : " + this.toString());
        }
        this.mappedTypeCode = typeCode;
        this.mappedType = TypeMap.getJdbcTypeName(typeCode);
    }

    public boolean isOfNumericType() {
        return TypeMap.isNumericType(this.getMappedTypeCode());
    }

    public boolean isOfTextType() {
        return TypeMap.isTextType(this.getMappedTypeCode());
    }

    public boolean isOfBinaryType() {
        return TypeMap.isBinaryType(this.getMappedTypeCode());
    }

    public boolean isOfSpecialType() {
        return TypeMap.isSpecialType(this.getMappedTypeCode());
    }

    public String getSize() {
        return this.size;
    }

    public int getSizeAsInt() {
        return this.sizeAsInt == null ? 0 : this.sizeAsInt;
    }

    public void setSize(String size) {
        if (size != null) {
            int pos = size.indexOf(",");
            this.size = size;
            if (pos < 0) {
                this.scale = 0;
                this.sizeAsInt = Integer.valueOf(size);
            } else {
                this.sizeAsInt = Integer.valueOf(size.substring(0, pos));
                this.scale = Integer.parseInt(size.substring(pos + 1));
            }
        } else {
            this.size = null;
            this.sizeAsInt = null;
            this.scale = 0;
        }
        if (this.platformColumns != null) {
            for (PlatformColumn platformColumn : this.platformColumns.values()) {
                platformColumn.setSize(this.sizeAsInt == null ? -1 : this.sizeAsInt);
                platformColumn.setDecimalDigits(size == null || size.indexOf(",") < 0 ? -1 : this.scale);
            }
        }
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.setSizeAndScale(this.getSizeAsInt(), scale);
    }

    public final void setSizeAndScale(int size, int scale) {
        this.sizeAsInt = size;
        this.scale = scale;
        this.size = String.valueOf(size);
        if (scale > 0) {
            this.size = this.size + "," + scale;
        }
        if (this.platformColumns != null) {
            for (PlatformColumn platformColumn : this.platformColumns.values()) {
                platformColumn.setSize(size);
                platformColumn.setDecimalDigits(scale);
            }
        }
    }

    public int getPrecisionRadix() {
        return this.precisionRadix;
    }

    public void setPrecisionRadix(int precisionRadix) {
        this.precisionRadix = precisionRadix;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * Exception decompiling
     */
    public Object getParsedDefaultValue() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getCleanDefaultValue() {
        return this.defaultValue.replace("'", "");
    }

    private String removeOuterParentheses(String value) {
        String newValue = new String(value);
        if (newValue != null) {
            while (newValue.startsWith("(") && newValue.endsWith(")")) {
                newValue = newValue.substring(1, newValue.length() - 1);
            }
        }
        return newValue;
    }

    public void removePlatformColumn(String databaseName) {
        if (this.platformColumns != null) {
            this.platformColumns.remove(databaseName);
        }
    }

    public void addPlatformColumn(PlatformColumn platformColumn) {
        if (this.platformColumns == null) {
            this.platformColumns = new HashMap<String, PlatformColumn>();
        }
        this.platformColumns.put(platformColumn.getName(), platformColumn);
    }

    public Map<String, PlatformColumn> getPlatformColumns() {
        return this.platformColumns;
    }

    public PlatformColumn findPlatformColumn(String name) {
        PlatformColumn platformColumn = null;
        if (this.platformColumns != null && (platformColumn = this.platformColumns.get(name)) == null) {
            if (name.contains("mssql")) {
                return this.findDifferentVersionPlatformColumn("mssql");
            }
            if (name.contains("oracle")) {
                return this.findDifferentVersionPlatformColumn("oracle");
            }
            if (name.contains("postgres")) {
                return this.findDifferentVersionPlatformColumn("postgres");
            }
            if (name.contains("sqlanywhere")) {
                return this.findDifferentVersionPlatformColumn("sqlanywhere");
            }
            if (name.contains("firebird")) {
                return this.findDifferentVersionPlatformColumn("firebird");
            }
            if (name.contains("hsqldb")) {
                return this.findDifferentVersionPlatformColumn("hsqldb");
            }
        }
        return platformColumn;
    }

    private PlatformColumn findDifferentVersionPlatformColumn(String name) {
        if (this.platformColumns != null) {
            for (Map.Entry<String, PlatformColumn> entry : this.platformColumns.entrySet()) {
                if (entry.getKey() == null || !entry.getKey().contains(name)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    public boolean anyPlatformColumnNameContains(String name) {
        if (this.platformColumns != null) {
            for (String platformColumnName : this.platformColumns.keySet()) {
                if (platformColumnName == null || !platformColumnName.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean anyPlatformColumnTypeContains(String type) {
        if (this.platformColumns != null) {
            for (PlatformColumn platformColumn : this.platformColumns.values()) {
                if (platformColumn.getType() == null || !platformColumn.getType().contains(type)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allPlatformColumnNamesContain(String name) {
        if (this.platformColumns != null) {
            for (String platformColumnName : this.platformColumns.keySet()) {
                if (platformColumnName == null || platformColumnName.contains(name)) continue;
                return false;
            }
        }
        return true;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        if (this.platformColumns != null) {
            Collection<PlatformColumn> cols = this.platformColumns.values();
            for (PlatformColumn platformColumn : cols) {
                platformColumn.setDefaultValue(defaultValue);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Column result = (Column)super.clone();
        result.name = this.name;
        result.javaName = this.javaName;
        result.primaryKey = this.primaryKey;
        result.required = this.required;
        result.autoIncrement = this.autoIncrement;
        result.mappedTypeCode = this.mappedTypeCode;
        result.mappedType = this.mappedType;
        result.size = this.size;
        result.defaultValue = this.defaultValue;
        result.scale = this.scale;
        result.size = this.size;
        result.sizeAsInt = this.sizeAsInt;
        if (this.platformColumns != null) {
            result.platformColumns = new HashMap<String, PlatformColumn>(this.platformColumns.size());
            for (Map.Entry<String, PlatformColumn> entry : this.platformColumns.entrySet()) {
                result.platformColumns.put(entry.getKey(), (PlatformColumn)entry.getValue().clone());
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Column) {
            Column other = (Column)obj;
            EqualsBuilder comparator = new EqualsBuilder();
            comparator.append((Object)this.name, (Object)other.name);
            comparator.append(this.primaryKey, other.primaryKey);
            comparator.append(this.required, other.required);
            comparator.append(this.autoIncrement, other.autoIncrement);
            comparator.append(this.mappedTypeCode, other.mappedTypeCode);
            comparator.append(this.getParsedDefaultValue(), other.getParsedDefaultValue());
            if (this.mappedTypeCode == 2 || this.mappedTypeCode == 3) {
                comparator.append((Object)this.size, (Object)other.size);
                comparator.append(this.scale, other.scale);
            } else if (this.mappedTypeCode == 1 || this.mappedTypeCode == 12 || this.mappedTypeCode == -2 || this.mappedTypeCode == -3) {
                comparator.append((Object)this.size, (Object)other.size);
            }
            return comparator.isEquals();
        }
        return false;
    }

    public boolean equalsByName(Column other) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.name, (CharSequence)other.name) && this.primaryKey == other.primaryKey;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        builder.append((Object)this.name);
        builder.append(this.primaryKey);
        builder.append(this.required);
        builder.append(this.autoIncrement);
        builder.append(this.mappedTypeCode);
        builder.append((Object)this.mappedType);
        builder.append(this.scale);
        builder.append(this.getParsedDefaultValue());
        if (!TypeMap.isNumericType(this.mappedTypeCode)) {
            builder.append((Object)this.size);
        }
        return builder.toHashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Column [name=");
        result.append(this.getName());
        result.append("; jdbcType=");
        result.append(this.getJdbcTypeName());
        result.append("; mappedType=");
        result.append(this.getMappedType());
        result.append("]");
        return result.toString();
    }

    public String toVerboseString() {
        StringBuilder result = new StringBuilder();
        result.append("Column [name=");
        result.append(this.getName());
        result.append("; javaName=");
        result.append(this.getJavaName());
        result.append("; type=");
        result.append(this.getMappedType());
        result.append("; typeCode=");
        result.append(this.getMappedTypeCode());
        result.append("; size=");
        result.append(this.getSize());
        result.append("; required=");
        result.append(this.isRequired());
        result.append("; primaryKey=");
        result.append(this.isPrimaryKey());
        result.append("; autoIncrement=");
        result.append(this.isAutoIncrement());
        result.append("; defaultValue=");
        result.append(this.getDefaultValue());
        result.append("; precisionRadix=");
        result.append(this.getPrecisionRadix());
        result.append("; scale=");
        result.append(this.getScale());
        result.append("]");
        return result.toString();
    }

    public void setJdbcTypeName(String jdbcTypeName) {
        this.jdbcTypeName = jdbcTypeName;
    }

    public String getJdbcTypeName() {
        return this.jdbcTypeName;
    }

    public boolean isDistributionKey() {
        return this.distributionKey;
    }

    public void setDistributionKey(boolean distributionKey) {
        this.distributionKey = distributionKey;
    }

    public final void setTypeCode(int typeCode) {
        this.setMappedTypeCode(typeCode);
        this.setJdbcTypeCode(typeCode);
    }

    public final void setJdbcTypeCode(int jdbcTypeCode) {
        this.jdbcTypeCode = jdbcTypeCode;
    }

    public int getJdbcTypeCode() {
        return this.jdbcTypeCode;
    }

    public boolean isTimestampWithTimezone() {
        return this.mappedTypeCode == -102 || this.mappedTypeCode == -101 || this.jdbcTypeCode == -102 || this.jdbcTypeCode == -101 || this.jdbcTypeName != null && this.jdbcTypeName.equals("timestamptz");
    }

    public boolean containsJdbcTypes() {
        return this.jdbcTypeCode != Integer.MIN_VALUE && this.jdbcTypeName != null;
    }

    public int getCharOctetLength() {
        return this.charOctetLength;
    }

    public void setCharOctetLength(int charOctetLength) {
        this.charOctetLength = charOctetLength;
    }

    public int getPrimaryKeySequence() {
        return this.primaryKeySequence;
    }

    public void setPrimaryKeySequence(int primaryKeySequence) {
        this.primaryKeySequence = primaryKeySequence;
    }
}

