/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.jumpmind.db.sql.SqlScriptReader;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.reader.AbstractTableDataReader;

public class SqlDataReader
extends AbstractTableDataReader {
    protected SqlScriptReader sqlScriptReader;

    public SqlDataReader(InputStream is) {
        super(BinaryEncoding.HEX, null, null, null, is);
    }

    public SqlDataReader(Reader reader) {
        super(BinaryEncoding.HEX, null, null, null, reader);
    }

    @Override
    protected void init() {
        this.readDataBeforeTable = true;
        this.sqlScriptReader = new SqlScriptReader(this.reader);
    }

    @Override
    protected CsvData readNext() {
        String sql = this.sqlScriptReader.readSqlStatement();
        if (sql != null) {
            return new CsvData(DataEventType.SQL, new String[]{sql});
        }
        return null;
    }

    @Override
    protected void finish() {
        try {
            this.sqlScriptReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

