/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data;

import java.util.HashMap;
import java.util.Map;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.IDataReader;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.symmetric.io.data.writer.DefaultDatabaseWriter;
import org.jumpmind.symmetric.io.data.writer.NestedDataWriter;
import org.jumpmind.util.Context;

public class DataContext
extends Context {
    protected IDataWriter writer;
    protected IDataReader reader;
    protected Batch batch;
    protected Table table;
    protected CsvData data;
    protected Throwable lastError;
    protected Map<String, Table> parsedTables = new HashMap<String, Table>();
    protected Table lastParsedTable = null;

    public DataContext() {
    }

    public DataContext(Batch batch) {
        this.batch = batch;
    }

    public DataContext(IDataReader reader) {
        this.reader = reader;
    }

    public IDataReader getReader() {
        return this.reader;
    }

    public IDataWriter getWriter() {
        return this.writer;
    }

    public void setReader(IDataReader reader) {
        this.reader = reader;
    }

    protected void setWriter(IDataWriter writer) {
        this.writer = writer;
    }

    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public void setData(CsvData data) {
        this.data = data;
    }

    public CsvData getData() {
        return this.data;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setLastError(Throwable lastError) {
        this.lastError = lastError;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public Map<String, Table> getParsedTables() {
        return this.parsedTables;
    }

    public Table getLastParsedTable() {
        return this.lastParsedTable;
    }

    public void setLastParsedTable(Table lastParsedTable) {
        this.lastParsedTable = lastParsedTable;
    }

    public ISqlTransaction findTransaction() {
        ISqlTransaction transaction = null;
        if (this.writer instanceof NestedDataWriter) {
            DefaultDatabaseWriter dbWriter = (DefaultDatabaseWriter)((NestedDataWriter)this.writer).getNestedWriterOfType(DefaultDatabaseWriter.class);
            if (dbWriter != null) {
                transaction = dbWriter.getTransaction();
            }
        } else if (this.writer instanceof DefaultDatabaseWriter) {
            transaction = ((DefaultDatabaseWriter)this.writer).getTransaction();
        }
        return transaction;
    }

    public ISqlTransaction findSymmetricTransaction(String tablePrefix) {
        ISqlTransaction transaction = null;
        if (this.writer instanceof NestedDataWriter) {
            DefaultDatabaseWriter dbWriter = (DefaultDatabaseWriter)((NestedDataWriter)this.writer).getNestedWriterOfType(DefaultDatabaseWriter.class);
            if (dbWriter != null) {
                transaction = dbWriter.getTransaction(tablePrefix);
            }
        } else if (this.writer instanceof DefaultDatabaseWriter) {
            transaction = ((DefaultDatabaseWriter)this.writer).getTransaction(tablePrefix);
        }
        return transaction;
    }
}

