/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data;

import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.util.Statistics;

public class Batch {
    public static final long UNKNOWN_BATCH_ID = -9999L;
    public static final String DEFAULT_CHANNEL_ID = "default";
    protected long batchId = -9999L;
    protected String sourceNodeId;
    protected String targetNodeId;
    protected boolean initialLoad;
    protected String channelId = "default";
    protected BinaryEncoding binaryEncoding;
    protected Date startTime;
    protected long lineCount;
    protected long dataReadMillis;
    protected long dataWriteMillis;
    protected boolean ignored = false;
    protected boolean common = false;
    protected boolean complete = false;
    protected BatchType batchType;
    protected Statistics statistics;
    protected boolean invalidRetry = false;
    protected boolean bulkLoaderFlag;
    protected Map<String, Long> timers = new HashMap<String, Long>();

    public boolean isBulkLoaderFlag() {
        return this.bulkLoaderFlag;
    }

    public void setBulkLoaderFlag(boolean bulkLoaderFlag) {
        this.bulkLoaderFlag = bulkLoaderFlag;
    }

    public Batch(BatchType batchType, long batchId, String channelId, BinaryEncoding binaryEncoding, String sourceNodeId, String targetNodeId, boolean common) {
        this.batchType = batchType;
        this.batchId = batchId;
        if (channelId != null) {
            this.channelId = channelId;
        }
        this.sourceNodeId = sourceNodeId;
        this.targetNodeId = targetNodeId;
        this.binaryEncoding = binaryEncoding;
        this.common = common;
        this.startTime = new Date();
    }

    public Batch() {
        this.startTime = new Date();
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public long incrementLineCount() {
        return ++this.lineCount;
    }

    public void incrementDataReadMillis(long millis) {
        this.dataReadMillis += millis;
    }

    public void incrementDataWriteMillis(long millis) {
        this.dataWriteMillis += millis;
    }

    public void startTimer(String name) {
        this.timers.put(name, System.currentTimeMillis());
    }

    public long endTimer(String name) {
        Long startTime = this.timers.remove(name);
        if (startTime != null) {
            return System.currentTimeMillis() - startTime;
        }
        return 0L;
    }

    public long getDataReadMillis() {
        return this.dataReadMillis;
    }

    public long getDataWriteMillis() {
        return this.dataWriteMillis;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(long lineCount) {
        this.lineCount = lineCount;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getSourceNodeId() {
        return this.sourceNodeId;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public String getNodeBatchId() {
        String nodeId = this.batchType == BatchType.EXTRACT ? this.targetNodeId : this.sourceNodeId;
        return String.format("%s-%d", nodeId, this.batchId);
    }

    public long getBatchId() {
        return this.batchId;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public boolean isInitialLoad() {
        return this.initialLoad;
    }

    public BinaryEncoding getBinaryEncoding() {
        return this.binaryEncoding;
    }

    public void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public void setCommon(boolean commonFlag) {
        this.common = commonFlag;
    }

    public boolean isCommon() {
        return this.common;
    }

    public BatchType getBatchType() {
        return this.batchType;
    }

    public String getStagedLocation() {
        if (this.batchType == BatchType.EXTRACT) {
            return Batch.getStagedLocation(this.common, this.targetNodeId, this.batchId);
        }
        return Batch.getStagedLocation(this.common, this.sourceNodeId, this.batchId);
    }

    public static String getStagedLocation(boolean common, String nodeId, long batchId) {
        return common ? "common/" + String.format("%03d", batchId % 1000L) : nodeId;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setBinaryEncoding(BinaryEncoding binaryEncoding) {
        this.binaryEncoding = binaryEncoding;
    }

    public void setSourceNodeId(String sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setInvalidRetry(boolean invalidRetry) {
        this.invalidRetry = invalidRetry;
    }

    public boolean isInvalidRetry() {
        return this.invalidRetry;
    }

    public String encodeBinary(String value) {
        if (value != null) {
            if (this.binaryEncoding == BinaryEncoding.HEX) {
                value = new String(Hex.encodeHex((byte[])value.getBytes(Charset.defaultCharset())));
            } else if (this.binaryEncoding == BinaryEncoding.BASE64) {
                value = new String(Base64.encodeBase64((byte[])value.getBytes(Charset.defaultCharset())), Charset.defaultCharset());
            }
        }
        return value;
    }

    public byte[] decodeBinary(String value) {
        if (value != null) {
            try {
                if (this.binaryEncoding == BinaryEncoding.HEX) {
                    return Hex.decodeHex((char[])value.toCharArray());
                }
                if (this.binaryEncoding == BinaryEncoding.BASE64) {
                    return Base64.decodeBase64((byte[])value.getBytes(Charset.defaultCharset()));
                }
                return value.getBytes(Charset.defaultCharset());
            }
            catch (DecoderException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static enum BatchType {
        EXTRACT,
        LOAD;

    }
}

