/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.wrapper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class WrapperLogHandler
extends StreamHandler {
    protected String filename;
    protected long maxByteCount;
    protected int maxLogCount;
    protected BufferedWriter writer;
    protected long byteCount;
    protected ScheduledExecutorService executor;

    public WrapperLogHandler(String filename, long maxByteCount, int maxLogCount) throws IOException {
        this.filename = filename;
        this.maxByteCount = maxByteCount;
        this.maxLogCount = maxLogCount;
        this.rotate();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleWithFixedDelay(new LogFlushTask(), 0L, 2000L, TimeUnit.MILLISECONDS);
    }

    protected final void rotate() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
        File file = new File(this.filename);
        this.byteCount = 0L;
        if (file.exists()) {
            this.byteCount = file.length();
        }
        if (this.byteCount >= this.maxByteCount) {
            new File(this.filename + "." + this.maxLogCount).delete();
            for (int i = this.maxLogCount - 1; i > 0; --i) {
                new File(this.filename + "." + i).renameTo(new File(this.filename + "." + (i + 1)));
            }
            new File(this.filename).renameTo(new File(this.filename + ".1"));
        }
        this.writer = new BufferedWriter(new FileWriter(file, true), 2048);
    }

    @Override
    public void publish(LogRecord record) {
        if (this.writer != null) {
            try {
                String msg = this.getFormatter().format(record);
                try {
                    this.writer.write(msg);
                    this.byteCount += (long)msg.length();
                    if (this.byteCount >= this.maxByteCount) {
                        this.rotate();
                    }
                }
                catch (Exception e) {
                    this.reportError(null, e, 1);
                }
            }
            catch (Exception e) {
                this.reportError(null, e, 5);
            }
        }
    }

    @Override
    public void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception e) {
                this.reportError(null, e, 2);
            }
        }
    }

    @Override
    public void close() throws SecurityException {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (Exception e) {
                this.reportError(null, e, 3);
            }
        }
        if (this.executor != null) {
            try {
                this.executor.shutdown();
            }
            catch (Exception e) {
                this.reportError(null, e, 3);
            }
        }
    }

    class LogFlushTask
    implements Runnable {
        LogFlushTask() {
        }

        @Override
        public void run() {
            WrapperLogHandler.this.flush();
        }
    }
}

