/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.wrapper;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.Winsvc;
import com.sun.jna.ptr.IntByReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jumpmind.symmetric.wrapper.Constants;
import org.jumpmind.symmetric.wrapper.WrapperConfig;
import org.jumpmind.symmetric.wrapper.WrapperException;
import org.jumpmind.symmetric.wrapper.WrapperService;
import org.jumpmind.symmetric.wrapper.jna.Advapi32Ex;
import org.jumpmind.symmetric.wrapper.jna.Kernel32Ex;
import org.jumpmind.symmetric.wrapper.jna.Shell32Ex;
import org.jumpmind.symmetric.wrapper.jna.WinsvcEx;

@IgnoreJRERequirement
public class WindowsService
extends WrapperService {
    private static final Logger logger = Logger.getLogger(WindowsService.class.getName());
    protected final String APP_EVENT_LOG = "SYSTEM\\CurrentControlSet\\Services\\EventLog\\Application";
    protected ServiceControlHandler serviceControlHandler;
    protected Advapi32Ex.SERVICE_STATUS_HANDLE serviceStatusHandle;
    protected Winsvc.SERVICE_STATUS serviceStatus;
    protected WinNT.HANDLE eventHandle;

    @Override
    protected boolean setWorkingDirectory(String dir) {
        try {
            System.setProperty("user.dir", new File(dir).getCanonicalPath());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Kernel32Ex.INSTANCE.SetCurrentDirectory(dir);
    }

    @Override
    public void init() {
        logger.log(Level.INFO, "Requesting service dispatch");
        WinsvcEx.SERVICE_TABLE_ENTRY entry = new WinsvcEx.SERVICE_TABLE_ENTRY(this.config.getName(), new ServiceMain());
        Structure[] serviceTable = (WinsvcEx.SERVICE_TABLE_ENTRY[])entry.toArray(2);
        if (!Advapi32Ex.INSTANCE.StartServiceCtrlDispatcher(serviceTable)) {
            logger.log(Level.SEVERE, "Error " + Native.getLastError());
            System.exit(Native.getLastError());
        }
    }

    @Override
    protected void initEnvironment(ProcessBuilder pb) {
        Map<String, String> env = pb.environment();
        String path = env.get("PATH");
        path = System.getProperty("user.dir") + "\\lib;" + (path != null ? path : "");
        env.put("PATH", path);
        logger.log(Level.INFO, "PATH is " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.isRunning()) {
            throw new WrapperException(5, 0, "Server is already running");
        }
        if (!this.isInstalled()) {
            super.start();
        } else {
            this.stopProcesses(true);
            Advapi32Ex advapi = Advapi32Ex.INSTANCE;
            Winsvc.SC_HANDLE manager = this.openServiceManager();
            Winsvc.SC_HANDLE service = advapi.OpenService(manager, this.config.getName(), 983551);
            try {
                if (service != null) {
                    System.out.println("Waiting for server to start");
                    if (!advapi.StartService(service, 0, null)) {
                        this.throwException("StartService");
                    }
                    Winsvc.SERVICE_STATUS_PROCESS status = this.waitForService(manager, service);
                    if (status.dwCurrentState == 1) {
                        throw new WrapperException(16, status.dwWin32ExitCode, "Unexpected exit from service");
                    }
                    System.out.println("Started");
                } else {
                    this.throwException("OpenService");
                }
            }
            finally {
                this.closeServiceHandle(service);
                this.closeServiceHandle(manager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.isInstalled()) {
            super.stop();
        } else {
            if (!this.isRunning()) {
                throw new WrapperException(6, 0, "Server is not running");
            }
            Advapi32Ex advapi = Advapi32Ex.INSTANCE;
            Winsvc.SC_HANDLE manager = this.openServiceManager();
            Winsvc.SC_HANDLE service = advapi.OpenService(manager, this.config.getName(), 983551);
            try {
                if (service != null) {
                    System.out.println("Waiting for server to stop");
                    if (!advapi.ControlService(service, 1, new Winsvc.SERVICE_STATUS())) {
                        this.throwException("ControlService");
                    }
                    Winsvc.SERVICE_STATUS_PROCESS status = this.waitForService(manager, service);
                    if (status.dwCurrentState != 1) {
                        throw new WrapperException(9, status.dwWin32ExitCode, "Service did not stop");
                    }
                    System.out.println("Stopped");
                } else {
                    this.throwException("OpenService");
                }
            }
            finally {
                this.closeServiceHandle(service);
                this.closeServiceHandle(manager);
            }
        }
    }

    @Override
    public boolean isRunning() {
        Advapi32 advapi = Advapi32.INSTANCE;
        Winsvc.SC_HANDLE manager = advapi.OpenSCManager(null, null, 4);
        if (manager == null) {
            this.throwException("OpenSCManager");
        } else {
            Winsvc.SC_HANDLE service = advapi.OpenService(manager, this.config.getName(), 4);
            if (service != null) {
                IntByReference bytesNeeded = new IntByReference();
                advapi.QueryServiceStatusEx(service, 0, null, 0, bytesNeeded);
                Winsvc.SERVICE_STATUS_PROCESS status = new Winsvc.SERVICE_STATUS_PROCESS(bytesNeeded.getValue());
                if (!advapi.QueryServiceStatusEx(service, 0, status, status.size(), bytesNeeded)) {
                    this.throwException("QueryServiceStatusEx");
                }
                this.closeServiceHandle(service);
                this.closeServiceHandle(manager);
                return status.dwCurrentState == 4 && super.isRunning();
            }
            this.closeServiceHandle(manager);
        }
        return super.isRunning();
    }

    @Override
    protected boolean isPidRunning(int pid) {
        boolean isRunning = false;
        if (pid != 0) {
            Kernel32Ex kernel;
            WinNT.HANDLE process;
            boolean foundProcess = false;
            String[] path = this.config.getJavaCommand().split("/|\\\\");
            String javaExe = path[path.length - 1].toLowerCase();
            try {
                String[] array;
                ProcessBuilder pb = new ProcessBuilder("wmic", "process", String.valueOf(pid), "get", "name");
                Process proc = pb.start();
                proc.getOutputStream().close();
                BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                final BufferedReader stderr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (stderr.read() != -1) {
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
                String line = null;
                String curLine = null;
                boolean isHeaderLine = true;
                while ((curLine = stdout.readLine()) != null && line == null) {
                    if (isHeaderLine) {
                        isHeaderLine = false;
                        continue;
                    }
                    if (line != null || curLine.trim().equals("")) continue;
                    line = curLine;
                }
                stdout.close();
                if (line != null && (array = line.split("\\s+")).length > 0) {
                    foundProcess = true;
                    isRunning = array[0].toLowerCase().contains(javaExe);
                    if (!isRunning) {
                        System.out.println("Ignoring old process ID being used by " + array[0]);
                    }
                }
            }
            catch (IOException pb) {
                // empty catch block
            }
            if (!foundProcess && (process = (kernel = Kernel32Ex.INSTANCE).OpenProcess(0x100000, false, pid)) != null) {
                int rc = kernel.WaitForSingleObject(process, 0);
                kernel.CloseHandle(process);
                isRunning = rc == 258;
            }
        }
        return isRunning;
    }

    @Override
    protected int getCurrentPid() {
        return Kernel32.INSTANCE.GetCurrentProcessId();
    }

    @Override
    public boolean isPrivileged() {
        try {
            this.closeServiceHandle(this.openServiceManager());
            return true;
        }
        catch (WrapperException e) {
            return false;
        }
    }

    @Override
    public void relaunchAsPrivileged(String className) {
        String quote = this.getWrapperCommandQuote();
        String args = "-DSYM_HOME=" + System.getenv("SYM_HOME") + " -Djava.io.tmpdir=" + quote + System.getProperty("java.io.tmpdir") + quote + " -cp " + quote + this.config.getClassPath() + quote + " " + className;
        Shell32Ex.SHELLEXECUTEINFO execInfo = new Shell32Ex.SHELLEXECUTEINFO();
        execInfo.lpFile = new WString(this.config.getJavaCommand().replaceAll("(?i)java$", "javaw").replaceAll("(?i)java.exe$", "javaw.exe"));
        execInfo.lpParameters = new WString(args);
        execInfo.nShow = 10;
        execInfo.fMask = 64;
        execInfo.lpVerb = new WString("runas");
        if (!Shell32Ex.INSTANCE.ShellExecuteEx(execInfo)) {
            this.throwException("ShellExecuteEx");
        }
        System.exit(0);
    }

    @Override
    public boolean isInstalled() {
        Advapi32 advapi = Advapi32.INSTANCE;
        boolean isInstalled = false;
        Winsvc.SC_HANDLE manager = advapi.OpenSCManager(null, null, 4);
        if (manager == null) {
            this.throwException("OpenSCManager");
        } else {
            Winsvc.SC_HANDLE service = advapi.OpenService(manager, this.config.getName(), 4);
            isInstalled = service != null;
            this.closeServiceHandle(service);
            this.closeServiceHandle(manager);
        }
        return isInstalled;
    }

    @Override
    protected int getProcessPid(Process process) {
        int pid = 0;
        try {
            Method method = Process.class.getDeclaredMethod("pid", null);
            Object object = method.invoke((Object)process, new Object[0]);
            pid = ((Long)object).intValue();
        }
        catch (Exception e) {
            try {
                Field field = process.getClass().getDeclaredField("handle");
                field.setAccessible(true);
                WinNT.HANDLE processHandle = new WinNT.HANDLE(Pointer.createConstant((long)field.getLong(process)));
                pid = Kernel32.INSTANCE.GetProcessId(processHandle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pid;
    }

    @Override
    protected void killProcess(int pid, boolean isTerminate) {
        Kernel32 kernel = Kernel32.INSTANCE;
        WinNT.HANDLE processHandle = kernel.OpenProcess(1, true, pid);
        if (processHandle == null) {
            this.throwException("OpenProcess");
        }
        kernel.TerminateProcess(processHandle, 99);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install() {
        if (this.isRunning()) {
            System.out.println("Server must be stopped before installing");
            System.exit(10);
        }
        Advapi32Ex advapi = Advapi32Ex.INSTANCE;
        Winsvc.SC_HANDLE manager = this.openServiceManager();
        Winsvc.SC_HANDLE service = advapi.OpenService(manager, this.config.getName(), 983551);
        try {
            String runAsPassword;
            String runAsUser;
            if (service != null) {
                throw new WrapperException(12, 0, "Service " + this.config.getName() + " is already installed");
            }
            System.out.println("Installing " + this.config.getName() + " ...");
            String dependencies = null;
            if (this.config.getDependencies() != null && this.config.getDependencies().size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String dependency : this.config.getDependencies()) {
                    sb.append(dependency).append("\u0000");
                }
                dependencies = sb.append("\u0000").toString();
            }
            if ((runAsUser = this.config.getRunAsUser()) != null && runAsUser.trim().length() == 0) {
                runAsUser = null;
            }
            if ((runAsPassword = this.config.getRunAsPassword()) != null && runAsPassword.trim().length() == 0) {
                runAsPassword = null;
            }
            if ((service = advapi.CreateService(manager, this.config.getName(), this.config.getDisplayName(), 983551, 16, this.config.isAutoStart() || this.config.isDelayStart() ? 2 : 3, 1, this.commandToString(this.getWrapperCommand("init", true)), null, null, dependencies, runAsUser, runAsPassword)) != null) {
                Advapi32Ex.SERVICE_DESCRIPTION desc = new Advapi32Ex.SERVICE_DESCRIPTION(this.config.getDescription());
                advapi.ChangeServiceConfig2(service, 1, desc);
                WinsvcEx.SC_ACTION.ByReference actionRef = null;
                WinsvcEx.SC_ACTION[] actionArray = null;
                List<WrapperConfig.FailureAction> failureActions = this.config.getFailureActions();
                if (failureActions.size() > 0) {
                    actionRef = new WinsvcEx.SC_ACTION.ByReference();
                    actionArray = (WinsvcEx.SC_ACTION[])actionRef.toArray(failureActions.size());
                }
                int i = 0;
                for (WrapperConfig.FailureAction failureAction : failureActions) {
                    actionArray[i].type = failureAction.getType();
                    actionArray[i].delay = failureAction.getDelay();
                    ++i;
                }
                WinsvcEx.SERVICE_FAILURE_ACTIONS actions = new WinsvcEx.SERVICE_FAILURE_ACTIONS(this.config.getFailureResetPeriod(), "", new WString(this.config.getFailureActionCommand()), failureActions.size(), actionRef);
                advapi.ChangeServiceConfig2(service, 2, actions);
                WinsvcEx.SERVICE_FAILURE_ACTIONS_FLAG flag = new WinsvcEx.SERVICE_FAILURE_ACTIONS_FLAG(false);
                advapi.ChangeServiceConfig2(service, 4, flag);
                if (this.config.isDelayStart()) {
                    WinsvcEx.SERVICE_DELAYED_AUTO_START_INFO delayedInfo = new WinsvcEx.SERVICE_DELAYED_AUTO_START_INFO(true);
                    advapi.ChangeServiceConfig2(service, 3, delayedInfo);
                }
            } else {
                this.throwException("CreateService");
            }
            System.out.println("Done");
        }
        finally {
            this.closeServiceHandle(service);
            this.closeServiceHandle(manager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() {
        int seconds;
        block12: {
            if (this.isRunning()) {
                throw new WrapperException(10, 0, "Server must be stopped before uninstalling");
            }
            Advapi32Ex advapi = Advapi32Ex.INSTANCE;
            Winsvc.SC_HANDLE manager = this.openServiceManager();
            Winsvc.SC_HANDLE service = advapi.OpenService(manager, this.config.getName(), 983551);
            try {
                if (service != null) {
                    System.out.println("Uninstalling " + this.config.getName() + " ...");
                    if (!advapi.DeleteService(service)) {
                        this.throwException("DeleteService");
                    }
                    break block12;
                }
                throw new WrapperException(11, 0, "Service " + this.config.getName() + " is not installed");
            }
            finally {
                this.closeServiceHandle(service);
                this.closeServiceHandle(manager);
            }
        }
        for (seconds = 0; seconds <= 30 && this.isInstalled(); ++seconds) {
            System.out.print(".");
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (seconds > 0) {
            System.out.println("");
        }
        if (this.isInstalled()) {
            System.out.println("Service manager did not complete");
        } else {
            System.out.println("Done");
        }
    }

    protected Winsvc.SC_HANDLE openServiceManager() {
        Advapi32 advapi = Advapi32.INSTANCE;
        Winsvc.SC_HANDLE handle = advapi.OpenSCManager(null, null, 983103);
        if (handle == null) {
            this.throwException("OpenSCManager");
        }
        return handle;
    }

    @Override
    protected void updateStatus(Constants.Status status) {
        switch (status) {
            case START_PENDING: {
                this.updateStatus(2, 0);
                break;
            }
            case RUNNING: {
                this.updateStatus(4, 1);
                this.logEvent(4, "The " + this.config.getName() + " service has started.");
                break;
            }
            case STOP_PENDING: {
                this.updateStatus(3, 0);
                break;
            }
            case STOPPED: {
                this.updateStatus(1, 0);
            }
        }
    }

    protected void updateStatus(int status, int controlsAccepted) {
        if (this.serviceStatus != null) {
            Advapi32Ex advapi = Advapi32Ex.INSTANCE;
            this.serviceStatus.dwCurrentState = status;
            this.serviceStatus.dwControlsAccepted = controlsAccepted;
            if (!advapi.SetServiceStatus(this.serviceStatusHandle.getPointer(), this.serviceStatus)) {
                this.throwException("SetServiceStatus");
            }
        }
    }

    protected void logEvent(int eventType, String message) {
        WinNT.HANDLE eventHandle = this.getEventHandle();
        if (eventHandle != null) {
            String[] messageArray = new String[]{message};
            Advapi32.INSTANCE.ReportEvent(eventHandle, eventType, 0, 0, null, 1, 0, messageArray, null);
        }
    }

    protected void logEvent(int eventType, String message, Throwable e) {
        WinNT.HANDLE eventHandle = this.getEventHandle();
        if (eventHandle != null) {
            StackTraceElement[] elements = e.getStackTrace();
            String[] messageArray = new String[elements.length + 2];
            messageArray[0] = message;
            messageArray[1] = " ";
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement element = elements[i];
                messageArray[i + 2] = element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")";
            }
            Advapi32.INSTANCE.ReportEvent(eventHandle, eventType, 0, 0, null, messageArray.length, 0, messageArray, null);
        }
    }

    protected WinNT.HANDLE getEventHandle() {
        if (this.eventHandle == null) {
            this.eventHandle = Advapi32.INSTANCE.RegisterEventSource(null, this.config.getName());
        }
        return this.eventHandle;
    }

    protected Winsvc.SERVICE_STATUS_PROCESS waitForService(Winsvc.SC_HANDLE manager, Winsvc.SC_HANDLE service) {
        Advapi32Ex advapi = Advapi32Ex.INSTANCE;
        IntByReference bytesNeeded = new IntByReference();
        advapi.QueryServiceStatusEx(service, 0, null, 0, bytesNeeded);
        Winsvc.SERVICE_STATUS_PROCESS status = new Winsvc.SERVICE_STATUS_PROCESS(bytesNeeded.getValue());
        for (int seconds = 0; seconds <= 5; ++seconds) {
            System.out.print(".");
            if (!advapi.QueryServiceStatusEx(service, 0, status, status.size(), bytesNeeded)) {
                this.throwException("QueryServiceStatusEx");
            }
            if (status.dwCurrentState == 1) break;
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println("");
        return status;
    }

    protected void closeServiceHandle(Winsvc.SC_HANDLE handle) {
        if (handle != null) {
            Advapi32Ex advapi = Advapi32Ex.INSTANCE;
            advapi.CloseServiceHandle(handle);
        }
    }

    protected void throwException(String name) {
        int rc = Native.getLastError();
        throw new WrapperException(19, rc, name + " returned error " + rc + ": " + Kernel32Util.formatMessageFromLastErrorCode((int)rc));
    }

    @Override
    protected String getWrapperCommandQuote() {
        return "\"";
    }

    class ServiceControlHandler
    implements Advapi32Ex.HANDLER_FUNCTION {
        ServiceControlHandler() {
        }

        @Override
        public void serviceControlHandler(int controlCode) {
            if (controlCode != 4) {
                logger.log(Level.INFO, "Service manager requesting control code " + controlCode);
            }
            if (controlCode == 1) {
                logger.log(Level.INFO, "Service manager requesting to stop service");
                WindowsService.this.shutdown();
            }
        }
    }

    class ServiceMain
    implements WinsvcEx.SERVICE_MAIN_FUNCTION {
        ServiceMain() {
        }

        @Override
        public void serviceMain(int argc, Pointer argv) {
            WindowsService.this.logEvent(4, "The " + WindowsService.this.config.getName() + " service is starting.");
            WindowsService.this.serviceControlHandler = new ServiceControlHandler();
            WindowsService.this.serviceStatusHandle = Advapi32Ex.INSTANCE.RegisterServiceCtrlHandlerEx(WindowsService.this.config.getName(), WindowsService.this.serviceControlHandler, null);
            if (WindowsService.this.serviceStatusHandle == null) {
                WindowsService.this.logEvent(1, "Failed to register service control handler.");
                System.exit(13);
            }
            WindowsService.this.serviceStatus = new Winsvc.SERVICE_STATUS();
            WindowsService.this.serviceStatus.dwServiceType = 16;
            boolean isRunning = false;
            try {
                isRunning = WindowsService.this.isRunning();
            }
            catch (Throwable e) {
                WindowsService.this.logEvent(1, "Failed to check run status.", e);
                WindowsService.this.updateStatus(1, 0);
                System.exit(23);
            }
            if (!isRunning) {
                try {
                    WindowsService.this.stopProcesses(true);
                }
                catch (Throwable e) {
                    WindowsService.this.logEvent(1, "Failed to stop abandoned processes.", e);
                    WindowsService.this.updateStatus(1, 0);
                    System.exit(9);
                }
                try {
                    WindowsService.this.execJava(false);
                }
                catch (Throwable e) {
                    WindowsService.this.logEvent(1, "Failed to execute Java application.", e);
                    WindowsService.this.updateStatus(1, 0);
                    System.exit(8);
                }
            } else {
                WindowsService.this.logEvent(1, "Exiting because Java application is running from another process.");
                WindowsService.this.updateStatus(1, 0);
                System.exit(24);
            }
        }
    }
}

