/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.LogSummaryAppender;
import org.jumpmind.util.SymRollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4j2Helper {
    private static final Logger log = LoggerFactory.getLogger(Log4j2Helper.class);

    public void initialize(boolean isDebug) throws MalformedURLException {
        URL log4jUrl = new URL(System.getProperty("log4j2.configurationFile", "file:" + AppUtils.getSymHome() + "/conf/log4j2-blank.xml"));
        File log4jFile = new File(new File(log4jUrl.getFile()).getParent(), "log4j2.xml");
        if (isDebug) {
            log4jFile = new File(log4jFile.getParent(), "log4j2-debug.xml");
        }
        if (log4jFile.exists()) {
            Configurator.initialize((String)"SYM", (String)log4jFile.getAbsolutePath());
        }
    }

    public LogSummaryAppender registerLogSummaryAppenderInternal(String name) {
        LogSummaryAppender appender = new LogSummaryAppender(name, (Filter)ThresholdFilter.createFilter((Level)Level.WARN, (Filter.Result)Filter.Result.ACCEPT, (Filter.Result)Filter.Result.DENY));
        this.addAppender((Appender)appender);
        return appender;
    }

    public void registerConsoleAppender() {
        if (this.getAppender("CONSOLE") == null && this.getAppender("CONSOLE_ERR") == null) {
            PatternLayout layout = PatternLayout.newBuilder().withPattern("[%X{engineName}] - %c{1} - %m%ex%n").build();
            ConsoleAppender appender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("CONSOLE")).setTarget(ConsoleAppender.Target.SYSTEM_ERR).setLayout((Layout)layout)).build();
            this.addAppender((Appender)appender);
        }
    }

    public void registerVerboseConsoleAppender() {
        this.removeAppender("CONSOLE");
        PatternLayout layout = PatternLayout.newBuilder().withPattern("%d %-5p [%c{2}] [%t] %m%ex%n").build();
        ConsoleAppender appender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName("CONSOLE")).setTarget(ConsoleAppender.Target.SYSTEM_ERR).setLayout((Layout)layout)).build();
        this.addAppender((Appender)appender);
    }

    public void registerRollingFileAppender(String overrideLogFileName) {
        Appender appender = this.getAppender("ROLLING");
        if (appender instanceof SymRollingFileAppender) {
            SymRollingFileAppender fa = (SymRollingFileAppender)appender;
            String fileName = fa.getFileName();
            if (overrideLogFileName != null) {
                fileName = fileName.replace("symmetric.log", overrideLogFileName);
                LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                Configuration config = ctx.getConfiguration();
                RollingFileAppender rolling = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setConfiguration(config)).setName("ROLLING")).withFileName(fileName).withFilePattern(fa.getFilePattern().replace("symmetric.log", overrideLogFileName)).setLayout(fa.getLayout())).withPolicy(fa.getTriggeringPolicy()).withStrategy(((RollingFileManager)fa.getManager()).getRolloverStrategy()).build();
                this.removeAppender("ROLLING");
                this.addAppender((Appender)rolling);
            }
            System.err.println(String.format("Log output will be written to %s", fileName));
        }
    }

    public Appender getAppender(String name) {
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        return (Appender)lc.getRootLogger().getAppenders().get(name);
    }

    public void addAppender(Appender appender) {
        try {
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            appender.start();
            lc.getRootLogger().addAppender(appender);
            lc.updateLoggers();
        }
        catch (Exception ex) {
            log.debug("Failed to add appender " + appender.getName(), (Throwable)ex);
        }
    }

    public void removeAppender(String name) {
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Appender appender = (Appender)lc.getRootLogger().getAppenders().get(name);
        if (appender != null) {
            lc.getRootLogger().removeAppender(appender);
        }
    }

    public File getLogDir() {
        Map<File, Layout<?>> fileLayouts = this.getLogFileLayout();
        if (fileLayouts != null && fileLayouts.size() > 0) {
            return fileLayouts.keySet().iterator().next().getParentFile();
        }
        return null;
    }

    public File getLogFile() {
        Map<File, Layout<?>> fileLayouts = this.getLogFileLayout();
        if (fileLayouts != null && fileLayouts.size() > 0) {
            return fileLayouts.keySet().iterator().next();
        }
        return null;
    }

    public boolean isDefaultLogLayoutPattern() {
        Map<File, Layout<?>> fileLayouts = this.getLogFileLayout();
        if (fileLayouts != null && fileLayouts.size() > 0) {
            Layout<?> layout = fileLayouts.values().iterator().next();
            try {
                if (layout instanceof PatternLayout) {
                    return ((PatternLayout)layout).getConversionPattern().equals("%d %p [%X{engineName}] [%c{1}] [%t] %m%ex%n");
                }
            }
            catch (Exception e) {
                log.debug("Unable to determine log file layout pattern. ", (Throwable)e);
            }
        }
        return false;
    }

    public Map<File, Layout<?>> getLogFileLayout() {
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        Map appenderMap = lc.getRootLogger().getAppenders();
        for (Appender appender : appenderMap.values()) {
            File file;
            String fileName = null;
            Layout layout = null;
            if (appender instanceof FileAppender) {
                fileName = ((FileAppender)appender).getFileName();
                layout = ((FileAppender)appender).getLayout();
            } else if (appender instanceof RollingFileAppender) {
                fileName = ((RollingFileAppender)appender).getFileName();
                layout = ((RollingFileAppender)appender).getLayout();
            } else if (appender instanceof SymRollingFileAppender) {
                fileName = ((SymRollingFileAppender)appender).getFileName();
                layout = ((SymRollingFileAppender)appender).getLayout();
            }
            if (fileName == null || !(file = new File(fileName)).exists()) continue;
            HashMap matches = new HashMap();
            matches.put(file, layout);
            return matches;
        }
        return null;
    }

    public void setLevel(String loggerName, org.slf4j.event.Level level) {
        Configurator.setLevel((String)loggerName, (Level)this.convertToLevel(level));
    }

    public org.slf4j.event.Level getLevel(String loggerName) {
        return this.convertFromLevel(LogManager.getLogger((String)loggerName).getLevel());
    }

    public org.slf4j.event.Level getRootLevel() {
        return this.convertFromLevel(LogManager.getRootLogger().getLevel());
    }

    public org.slf4j.event.Level convertFromLevel(Level level) {
        org.slf4j.event.Level converted = null;
        if (level == Level.TRACE) {
            converted = org.slf4j.event.Level.TRACE;
        } else if (level == Level.DEBUG) {
            converted = org.slf4j.event.Level.DEBUG;
        } else if (level == Level.INFO) {
            converted = org.slf4j.event.Level.INFO;
        } else if (level == Level.WARN) {
            converted = org.slf4j.event.Level.WARN;
        } else if (level == Level.ERROR) {
            converted = org.slf4j.event.Level.ERROR;
        } else if (level == Level.FATAL) {
            converted = org.slf4j.event.Level.ERROR;
        }
        return converted;
    }

    public Level convertToLevel(org.slf4j.event.Level level) {
        Level converted = null;
        if (level == org.slf4j.event.Level.TRACE) {
            converted = Level.TRACE;
        } else if (level == org.slf4j.event.Level.DEBUG) {
            converted = Level.DEBUG;
        } else if (level == org.slf4j.event.Level.INFO) {
            converted = Level.INFO;
        } else if (level == org.slf4j.event.Level.WARN) {
            converted = Level.WARN;
        } else if (level == org.slf4j.event.Level.ERROR) {
            converted = Level.ERROR;
        }
        return converted;
    }
}

