/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.security;

import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.SyncPoller;
import com.azure.identity.CredentialBuilderBase;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.certificates.models.CertificateKeyType;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.keys.KeyClient;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.security.BouncyCastleHelper;
import org.jumpmind.security.BouncyCastleSecurityService;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityService;
import org.jumpmind.util.AppUtils;

public class AzureKeyVaultSecurityService
extends BouncyCastleSecurityService
implements ISecurityService {
    private SecretClient secretClient;
    private KeyClient keyClient;
    private CertificateClient certificateClient;
    private KeyStore keyStore;
    private String azureKeyVaultUri;

    protected AzureKeyVaultSecurityService() {
        try {
            new BouncyCastleHelper().checkProviderInstalled();
            this.initializeAzureKeyVaultClients();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean supportsExportCertificate() {
        return false;
    }

    @Override
    public boolean supportsImportCertificate() {
        return false;
    }

    @Override
    public boolean supportsBackupCertificate() {
        return false;
    }

    @Override
    public boolean supportsGenerateSelfSignedCertificate() {
        return false;
    }

    private Certificate buildCertificate(KeyVaultCertificateWithPolicy keyVaultCertificate) {
        X509Certificate certificate = null;
        String certificateString = new String(keyVaultCertificate.getCer());
        if (certificateString != null) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(keyVaultCertificate.getCer()));
            }
            catch (CertificateException ce) {
                this.log.error("Certificate error", (Throwable)ce);
                throw new RuntimeException(ce);
            }
        }
        return certificate;
    }

    private PrivateKey createPrivateKeyFromPem(String pemString, String keyType) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new StringReader(pemString));){
            String line = reader.readLine();
            if (line == null || !line.contains("BEGIN PRIVATE KEY")) {
                throw new IllegalArgumentException("No PRIVATE KEY found");
            }
            line = "";
            while (line != null) {
                if (line.contains("END PRIVATE KEY")) {
                    break;
                }
                builder.append(line);
                line = reader.readLine();
            }
        }
        byte[] bytes = Base64.getDecoder().decode(builder.toString());
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(bytes);
        KeyFactory factory = KeyFactory.getInstance(keyType);
        return factory.generatePrivate(spec);
    }

    @Override
    public KeyStore getKeyStore() {
        try {
            if (this.keyStore == null) {
                String keyStoreType = System.getProperty("sym.keystore.type", "JCEKS");
                this.keyStore = KeyStore.getInstance(keyStoreType);
                String password = this.getKeyStorePassword();
                this.keyStore.load(null, password.toCharArray());
                String certAlias = System.getProperty("sym.keystore.ssl.cert.alias", "sym");
                for (SecretProperties secret : this.secretClient.listPropertiesOfSecrets()) {
                    if (certAlias.equals(secret.getName())) continue;
                    this.log.debug("Retrieving secret with name {}", (Object)secret.getName());
                    KeyVaultSecret secretWithValue = this.secretClient.getSecret(secret.getName(), secret.getVersion());
                    SecretKeySpec mySecretKey = new SecretKeySpec(secretWithValue.getValue().getBytes(), "DES");
                    this.keyStore.setKeyEntry(this.convertToParameterName(secretWithValue.getName()), mySecretKey, password.toCharArray(), null);
                }
                KeyVaultCertificateWithPolicy certificate = this.certificateClient.getCertificate(certAlias);
                if (certificate.getPolicy().isExportable().booleanValue()) {
                    SecretProperties secret;
                    secret = this.secretClient.getSecret(certAlias);
                    Certificate x509Certificate = this.buildCertificate(certificate);
                    if ("application/x-pkcs12".equals(secret.getProperties().getContentType())) {
                        try {
                            KeyStore localKeyStore = KeyStore.getInstance("PKCS12");
                            localKeyStore.load(new ByteArrayInputStream(Base64.getDecoder().decode(secret.getValue())), "".toCharArray());
                            String alias = localKeyStore.aliases().nextElement();
                            Key key = localKeyStore.getKey(alias, "".toCharArray());
                            this.keyStore.setKeyEntry(certAlias, key, password.toCharArray(), new Certificate[]{x509Certificate});
                        }
                        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
                            this.log.error("Unable to decode key", (Throwable)ex);
                            throw new RuntimeException(ex);
                        }
                    } else if ("application/x-pem-file".equals(secret.getProperties().getContentType())) {
                        PrivateKey key = this.createPrivateKeyFromPem(secret.getValue(), certificate.getPolicy().getKeyType().toString());
                        this.keyStore.setKeyEntry(certAlias, key, password.toCharArray(), new Certificate[]{x509Certificate});
                    }
                }
            }
            return this.keyStore;
        }
        catch (RuntimeException re) {
            this.keyStore = null;
            throw re;
        }
        catch (Exception e) {
            this.keyStore = null;
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void saveKeyStore(KeyStore ks, String password) throws Exception {
        String certAlias = System.getProperty("sym.keystore.ssl.cert.alias", "sym");
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (certAlias.equals(alias)) continue;
            Key key = ks.getKey(alias, password.toCharArray());
            this.setKeystoreEntry(alias, key);
        }
    }

    @Override
    public String getKeystoreEntry(String alias) throws Exception {
        KeyVaultSecret retrievedSecret = this.secretClient.getSecret(this.convertToKeyVaultName(alias));
        return retrievedSecret.getValue();
    }

    @Override
    public void setKeystoreEntry(String alias, String value) throws Exception {
        KeyVaultSecret key = new KeyVaultSecret(this.convertToKeyVaultName(alias), value);
        this.secretClient.setSecret(key);
    }

    public void setKeystoreEntry(String alias, Key key) throws Exception {
        String value = new String(key.getEncoded());
        this.setKeystoreEntry(alias, value);
    }

    @Override
    public void deleteKeystoreEntry(String alias) {
        try {
            SyncPoller deleteSecretPoller = this.secretClient.beginDeleteSecret(this.convertToKeyVaultName(alias));
            deleteSecretPoller.waitForCompletion();
            this.secretClient.purgeDeletedSecret(this.convertToKeyVaultName(alias));
        }
        catch (ResourceNotFoundException e) {
            this.log.info("Trying to delete key {}, but did not exist in the vault.", (Object)alias);
        }
    }

    @Override
    public synchronized void installDefaultSslCert(String host) {
        host = host == null ? AppUtils.getHostName() : host;
        String alias = System.getProperty("sym.keystore.ssl.cert.alias", "sym");
        KeyVaultCertificateWithPolicy cert = null;
        try {
            cert = this.certificateClient.getCertificate(this.convertToKeyVaultName(alias));
        }
        catch (ResourceNotFoundException e) {
            CertificatePolicy policy = new CertificatePolicy("Self", String.format("CN=%s, OU=SymmetricDS, O=JumpMind", host)).setKeyReusable(Boolean.valueOf(true)).setKeyType(CertificateKeyType.RSA).setKeySize(Integer.valueOf(2048)).setValidityInMonths(Integer.valueOf(300));
            SyncPoller certificatePoller = this.certificateClient.beginCreateCertificate(this.convertToKeyVaultName(alias), policy, Boolean.valueOf(true), new HashMap());
            certificatePoller.waitUntil(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED);
            cert = (KeyVaultCertificate)certificatePoller.getFinalResult();
            this.log.info("Successfully installed default ssl cert {}", (Object)cert.getName());
        }
    }

    @Override
    public synchronized void installSslCert(KeyStore.PrivateKeyEntry entry) {
        throw new NotImplementedException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized X509Certificate getCurrentSslCert() {
        String alias = System.getProperty("sym.keystore.ssl.cert.alias", "sym");
        byte[] cer = this.certificateClient.getCertificate(this.convertToKeyVaultName(alias)).getCer();
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(cer);){
            X509Certificate cert;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Certificate;
        }
        catch (Exception e) {
            if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
            throw (RuntimeException)e;
        }
    }

    @Override
    public synchronized String exportCurrentSslCert(boolean includePrivateKey) {
        throw new NotImplementedException();
    }

    private void initializeAzureKeyVaultClients() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        TokenCredential credential;
        this.azureKeyVaultUri = System.getProperties().getProperty("azure.keyvault.uri");
        String className = System.getProperties().getProperty("azure.credential.builder.classname");
        if (className == null || className.trim().equals("")) {
            className = "com.azure.identity.DefaultAzureCredentialBuilder";
        }
        try {
            CredentialBuilderBase credentialBuilder = (CredentialBuilderBase)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method buildMethod = credentialBuilder.getClass().getMethod("build", null);
            credential = (TokenCredential)buildMethod.invoke((Object)credentialBuilder, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.secretClient == null) {
            this.secretClient = new SecretClientBuilder().vaultUrl(this.azureKeyVaultUri).credential(credential).buildClient();
        }
        if (this.keyClient == null) {
            this.keyClient = new KeyClientBuilder().vaultUrl(this.azureKeyVaultUri).credential(credential).buildClient();
        }
        if (this.certificateClient == null) {
            this.certificateClient = new CertificateClientBuilder().vaultUrl(this.azureKeyVaultUri).credential(credential).buildClient();
        }
    }

    private String convertToParameterName(String keyVaultName) {
        return StringUtils.replaceChars((String)keyVaultName, (char)'-', (char)'.');
    }

    private String convertToKeyVaultName(String parameterName) {
        return StringUtils.replaceChars((String)parameterName, (char)'.', (char)'-');
    }

    @Override
    protected void checkThatKeystoreFileExists() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void initializeSecretKey() {
        if (secretKey != null) return;
        Class<SecurityService> clazz = SecurityService.class;
        synchronized (SecurityService.class) {
            if (secretKey != null) return;
            try {
                try {
                    String secret = this.secretClient.getSecret(this.convertToKeyVaultName("sym.secret")).getValue();
                    secretKey = (SecretKey)SerializationUtils.deserialize((byte[])Base64.getDecoder().decode(secret));
                }
                catch (ResourceNotFoundException e) {
                    secretKey = this.getDefaultSecretKey();
                    String secret = Base64.getEncoder().encodeToString(SerializationUtils.serialize((Serializable)secretKey));
                    this.secretClient.setSecret(this.convertToKeyVaultName("sym.secret"), secret);
                }
            }
            catch (Exception e) {
                if (!(e instanceof RuntimeException)) throw new RuntimeException(e);
                throw (RuntimeException)e;
            }
            return;
        }
    }
}

