/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.jmx;

import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ext.ISymmetricEngineAware;
import org.jumpmind.symmetric.service.IParameterService;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedOperationParameter;
import org.springframework.jmx.export.annotation.ManagedOperationParameters;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="The management interface for node parameters")
public class ParameterManagementService
implements IBuiltInExtensionPoint,
ISymmetricEngineAware {
    private IParameterService parameterService;

    public void setSymmetricEngine(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
    }

    @ManagedOperation(description="Reload supported parameters from file or database")
    public void rereadParameters() {
        this.parameterService.rereadParameters();
    }

    @ManagedOperation(description="Update a parameter for this node only")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="key", description="The name of the parameter"), @ManagedOperationParameter(name="value", description="The value for the parameter")})
    public void updateParameter(String key, String value) {
        this.parameterService.saveParameter(key, (Object)value, "jmx");
    }

    @ManagedOperation(description="Update a parameter for all nodes")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="key", description="The name of the parameter"), @ManagedOperationParameter(name="value", description="The value for the parameter")})
    public void updateParameterForAll(String key, String value) {
        this.parameterService.saveParameter("ALL", "ALL", key, (Object)value, "jmx");
    }

    @ManagedOperation(description="Update a parameter for all nodes in a group")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="nodeGroup", description="The name of the node group"), @ManagedOperationParameter(name="key", description="The name of the parameter"), @ManagedOperationParameter(name="value", description="The value for the parameter")})
    public void updateParameterForNodeGroup(String nodeGroup, String key, String value) {
        this.parameterService.saveParameter("ALL", nodeGroup, key, (Object)value, "jmx");
    }

    @ManagedOperation(description="Update a parameter for a specific node")
    @ManagedOperationParameters(value={@ManagedOperationParameter(name="externalId", description="The name of the external id of node"), @ManagedOperationParameter(name="nodeGroup", description="The name of the node group"), @ManagedOperationParameter(name="key", description="The name of the parameter"), @ManagedOperationParameter(name="value", description="The value for the parameter")})
    public void updateParameterForNode(String externalId, String nodeGroup, String key, String value) {
        this.parameterService.saveParameter(externalId, nodeGroup, key, (Object)value, "jmx");
    }

    @ManagedAttribute(description="The parameters configured for this SymmetricDS instance")
    public String getParametersList() {
        StringBuilder buffer = new StringBuilder();
        TypedProperties properties = this.parameterService.getAllParameters();
        buffer.append("<pre>");
        for (Object key : properties.keySet()) {
            buffer.append(key).append("=").append(properties.get(key)).append("\n");
        }
        buffer.append("</pre>");
        return buffer.toString();
    }
}

