/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.JobDefaults;
import org.jumpmind.symmetric.model.JobDefinition;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.RandomTimeSlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.scheduling.support.SimpleTriggerContext;

@ManagedResource(description="The management interface for a job")
public abstract class AbstractJob
implements Runnable,
IJob {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String jobName;
    private JobDefinition jobDefinition;
    private AtomicBoolean paused = new AtomicBoolean(false);
    private Date lastFinishTime;
    private AtomicBoolean running = new AtomicBoolean(false);
    private long lastExecutionTimeInMs;
    private long totalExecutionTimeInMs;
    private long numberOfRuns;
    private boolean started;
    private boolean hasNotRegisteredMessageBeenLogged = false;
    protected ISymmetricEngine engine;
    private ThreadPoolTaskScheduler taskScheduler;
    private ScheduledFuture<?> scheduledJob;
    private RandomTimeSlot randomTimeSlot;
    private CronTrigger cronTrigger;
    private Date periodicFirstRunTime;
    private IParameterService parameterService;
    private long processedCount;
    private String targetNodeId;
    private int targetNodeCount;

    public AbstractJob() {
    }

    public AbstractJob(String jobName, ISymmetricEngine engine, ThreadPoolTaskScheduler taskScheduler) {
        this.engine = engine;
        this.taskScheduler = taskScheduler;
        this.jobName = jobName;
        this.parameterService = engine.getParameterService();
        this.randomTimeSlot = new RandomTimeSlot(this.parameterService.getExternalId(), this.parameterService.getInt("job.random.max.start.time.ms"));
    }

    public void start() {
        if (this.scheduledJob == null && this.engine != null && !this.engine.getClusterService().isInfiniteLocked(this.getName())) {
            if (this.isCronSchedule()) {
                String cronExpression = this.getSchedule();
                this.cronTrigger = new CronTrigger(cronExpression);
                this.log.info("Starting job '{}' on cron schedule '{}' with the first run at {}", new Object[]{this.jobName, cronExpression, this.cronTrigger.nextExecutionTime((TriggerContext)new SimpleTriggerContext())});
                try {
                    this.scheduledJob = this.taskScheduler.schedule((Runnable)this, (Trigger)this.cronTrigger);
                }
                catch (Exception ex) {
                    throw new SymmetricException("Failed to schedule job '" + this.jobName + "' with schedule '" + this.getSchedule() + "'", (Throwable)ex);
                }
                this.started = true;
            } else {
                long newRunTime;
                long timeBetweenRunsInMs = this.getTimeBetweenRunsInMs();
                if (timeBetweenRunsInMs <= 0L) {
                    return;
                }
                if (this.randomTimeSlot == null) {
                    this.randomTimeSlot = new RandomTimeSlot(this.parameterService.getExternalId(), this.parameterService.getInt("job.random.max.start.time.ms"));
                }
                int startDelay = this.randomTimeSlot.getRandomValueSeededByExternalId();
                long currentTimeMillis = System.currentTimeMillis();
                long lastRunTime = currentTimeMillis - timeBetweenRunsInMs;
                Lock lock = (Lock)this.engine.getClusterService().findLocks().get(this.getName());
                if (lock != null && lock.getLastLockTime() != null && lastRunTime < (newRunTime = lock.getLastLockTime().getTime())) {
                    lastRunTime = newRunTime;
                }
                this.periodicFirstRunTime = new Date(lastRunTime + timeBetweenRunsInMs + (long)startDelay);
                this.log.info("Starting job '{}' on periodic schedule every {}ms with the first run at {}", new Object[]{this.jobName, timeBetweenRunsInMs, this.periodicFirstRunTime});
                this.scheduledJob = this.taskScheduler.scheduleWithFixedDelay((Runnable)this, this.periodicFirstRunTime, timeBetweenRunsInMs);
                this.started = true;
            }
        }
    }

    protected long getTimeBetweenRunsInMs() {
        long timeBetweenRunsInMs = -1L;
        String schedule = this.getSchedule();
        try {
            if (StringUtils.isEmpty((CharSequence)schedule)) {
                throw new SymmetricException("Schedule value is not defined for " + this.jobDefinition.getPeriodicParameter(), new Object[0]);
            }
            timeBetweenRunsInMs = Long.parseLong(this.getSchedule());
            if (timeBetweenRunsInMs <= 0L) {
                throw new SymmetricException("Schedule value must be positive, but was '" + schedule + "'", new Object[0]);
            }
        }
        catch (Exception ex) {
            this.log.error("Failed to schedule job '" + this.jobName + "' because of an invalid schedule: '" + this.getSchedule() + "' Check the " + this.jobDefinition.getPeriodicParameter() + " parameter.", (Throwable)ex);
            return -1L;
        }
        return timeBetweenRunsInMs;
    }

    public boolean stop() {
        boolean success = false;
        if (this.scheduledJob != null) {
            success = this.scheduledJob.cancel(true);
            this.scheduledJob = null;
            if (success) {
                this.log.info("The '{}' job has been cancelled", (Object)this.jobName);
                this.started = false;
            } else {
                this.log.warn("Failed to cancel the '{}' job", (Object)this.jobName);
            }
        }
        return success;
    }

    public String getName() {
        return this.jobName;
    }

    public JobDefinition getJobDefinition() {
        return this.jobDefinition;
    }

    public void setJobDefinition(JobDefinition jobDefinition) {
        this.jobDefinition = jobDefinition;
    }

    @ManagedOperation(description="Run this job if it isn't already running")
    public boolean invoke() {
        return this.invoke(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invoke(boolean force) {
        try {
            MDC.put((String)"engineName", (String)this.engine.getEngineName());
            IParameterService parameterService = this.engine.getParameterService();
            boolean ok = this.checkPrerequsites(force);
            if (!ok) {
                return false;
            }
            long startTime = System.currentTimeMillis();
            if (this.jobDefinition.isClustered()) {
                if (!this.engine.getClusterService().lock(this.jobName)) return true;
            }
            try {
                if (!this.running.compareAndSet(false, true)) {
                    this.log.info("Job '{}' is already running on another thread and will not run at this time.", (Object)this.getName());
                    boolean bl = false;
                    return bl;
                }
                if (parameterService.is("jobs.synchronized.enable")) {
                    Class<AbstractJob> clazz = AbstractJob.class;
                    synchronized (AbstractJob.class) {
                        this.doJob(force);
                        // ** MonitorExit[clazz] (shouldn't be in output)
                        return true;
                    }
                }
                this.doJob(force);
                return true;
            }
            finally {
                if (this.jobDefinition.isClustered()) {
                    this.engine.getClusterService().unlock(this.jobName);
                }
                this.lastFinishTime = new Date();
                long endTime = System.currentTimeMillis();
                this.lastExecutionTimeInMs = endTime - startTime;
                this.totalExecutionTimeInMs += this.lastExecutionTimeInMs;
                ++this.numberOfRuns;
                this.running.set(false);
            }
        }
        catch (Throwable ex) {
            this.log.error("Exception while executing job '" + this.getName() + "'", ex);
        }
        return true;
    }

    protected boolean checkPrerequsites(boolean force) {
        if (this.engine == null) {
            this.log.info("Could not find a reference to the SymmetricEngine while running job '{}'", (Object)this.getName());
            return false;
        }
        if (Thread.interrupted()) {
            this.log.warn("This thread was interrupted.  Not executing the job '{}' until the interrupted status has cleared", (Object)this.getName());
            return false;
        }
        if (!this.engine.isStarted()) {
            this.log.info("The engine is not currently started, will not run job '{}'", (Object)this.getName());
            return false;
        }
        if (this.running.get()) {
            this.log.info("Job '{}' is already marked as running, will not run again now.", (Object)this.getName());
            return false;
        }
        if (this.paused.get() && !force) {
            this.log.info("Job '{}' is paused and will not run at this time.", (Object)this.getName());
            return false;
        }
        if (this.jobDefinition.isRequiresRegistration() && !this.engine.getRegistrationService().isRegisteredWithServer() && !this.hasNotRegisteredMessageBeenLogged) {
            this.log.info("Did not run the '{}' job because the engine is not registered.", (Object)this.getName());
            this.hasNotRegisteredMessageBeenLogged = true;
        }
        if (this.jobDefinition.getNodeGroupId() != null && !this.jobDefinition.getNodeGroupId().equals("ALL") && !this.jobDefinition.getNodeGroupId().equals(this.engine.getNodeService().findIdentity().getNodeGroupId())) {
            this.log.info("Job should be only run on node groups '{}' but this is '{}'", (Object)this.jobDefinition.getNodeGroupId(), (Object)this.engine.getNodeService().findIdentity().getNodeGroupId());
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        MDC.put((String)"engineName", (String)(this.engine != null ? this.engine.getEngineName() : "unknown"));
        this.invoke(false);
    }

    protected abstract void doJob(boolean var1) throws Exception;

    @ManagedOperation(description="Pause this job")
    public void pause() {
        this.setPaused(true);
    }

    @ManagedOperation(description="Resume the job")
    public void unpause() {
        this.setPaused(false);
    }

    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }

    @ManagedAttribute(description="If true, this job has been paused")
    public boolean isPaused() {
        return this.paused.get();
    }

    @ManagedAttribute(description="If true, this job has been started")
    public boolean isStarted() {
        return this.started;
    }

    @ManagedMetric(description="The amount of time this job spent in execution during it's last run")
    public long getLastExecutionTimeInMs() {
        return this.lastExecutionTimeInMs;
    }

    @ManagedAttribute(description="The last time this job completed execution")
    public Date getLastFinishTime() {
        return this.lastFinishTime;
    }

    @ManagedAttribute(description="If true, the job is already running")
    public boolean isRunning() {
        return this.running.get();
    }

    @ManagedMetric(description="The number of times this job has been run during the lifetime of the JVM")
    public long getNumberOfRuns() {
        return this.numberOfRuns;
    }

    @ManagedMetric(description="The total amount of time this job has spent in execution during the lifetime of the JVM")
    public long getTotalExecutionTimeInMs() {
        return this.totalExecutionTimeInMs;
    }

    public Date getNextExecutionTime() {
        if (this.isCronSchedule() && this.cronTrigger != null) {
            return this.cronTrigger.nextExecutionTime(new TriggerContext(){

                public Date lastScheduledExecutionTime() {
                    return null;
                }

                public Date lastCompletionTime() {
                    return AbstractJob.this.getLastFinishTime();
                }

                public Date lastActualExecutionTime() {
                    return null;
                }
            });
        }
        if (this.isPeriodicSchedule()) {
            if (this.getLastFinishTime() != null) {
                return new Date(this.getLastFinishTime().getTime() + this.getTimeBetweenRunsInMs());
            }
            if (this.periodicFirstRunTime != null) {
                return new Date(this.periodicFirstRunTime.getTime() + this.getTimeBetweenRunsInMs());
            }
        }
        return null;
    }

    @ManagedMetric(description="The total amount of time this job has spend in execution during the lifetime of the JVM")
    public long getAverageExecutionTimeInMs() {
        if (this.numberOfRuns > 0L) {
            return this.totalExecutionTimeInMs / this.numberOfRuns;
        }
        return 0L;
    }

    public boolean isCronSchedule() {
        return !this.isPeriodicSchedule();
    }

    public boolean isPeriodicSchedule() {
        String schedule = this.getSchedule();
        return NumberUtils.isDigits((String)schedule);
    }

    public String getSchedule() {
        String cronSchedule = this.parameterService.getString(this.jobDefinition.getCronParameter());
        if (!StringUtils.isEmpty((CharSequence)cronSchedule)) {
            return cronSchedule;
        }
        String periodicSchedule = this.parameterService.getString(this.jobDefinition.getPeriodicParameter());
        if (!StringUtils.isEmpty((CharSequence)periodicSchedule)) {
            return periodicSchedule;
        }
        return this.jobDefinition.getDefaultSchedule();
    }

    public abstract JobDefaults getDefaults();

    public ISymmetricEngine getEngine() {
        return this.engine;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setEngine(ISymmetricEngine engine) {
        this.engine = engine;
    }

    public ThreadPoolTaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void setTaskScheduler(ThreadPoolTaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public long getProcessedCount() {
        return this.processedCount;
    }

    public void setProcessedCount(long processedCount) {
        this.processedCount = processedCount;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String targetNodeId) {
        this.targetNodeId = targetNodeId;
    }

    public int getTargetNodeCount() {
        return this.targetNodeCount;
    }

    public void setTargetNodeCount(int targetNodeCount) {
        this.targetNodeCount = targetNodeCount;
    }

    public String getDeprecatedStartParameter() {
        return null;
    }

    public IParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(IParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

