/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.jumpmind.db.model.Table;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.data.CsvData;
import org.jumpmind.symmetric.io.data.DataContext;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.io.data.IDataWriter;
import org.jumpmind.util.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpDataWriter
implements IDataWriter {
    private static final Logger logger = LoggerFactory.getLogger(FtpDataWriter.class);
    protected String server;
    protected String username;
    protected String password;
    protected Protocol protocol = Protocol.FTP;
    protected Format format = Format.CSV;
    protected String stagingDir;
    protected String remoteDir;
    protected Batch batch;
    protected Table table;
    protected Map<String, FileInfo> fileInfoByTable = new HashMap<String, FileInfo>();
    protected FileSystemManager manager;
    protected Map<Batch, Statistics> statistics = new HashMap<Batch, Statistics>();

    public void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setStagingDir(String stagingDir) {
        this.stagingDir = stagingDir;
    }

    public void open(DataContext context) {
        try {
            this.manager = VFS.getManager();
        }
        catch (FileSystemException e) {
            throw new IoException((Exception)((Object)e));
        }
    }

    public void close() {
    }

    public Map<Batch, Statistics> getStatistics() {
        return this.statistics;
    }

    public void start(Batch batch) {
        this.batch = batch;
        this.statistics.put(batch, new Statistics());
    }

    public boolean start(Table table) {
        this.table = table;
        this.createFile(table, this.batch);
        return true;
    }

    public void write(CsvData data) {
        if (this.format == Format.CSV && (data.getDataEventType() == DataEventType.UPDATE || data.getDataEventType() == DataEventType.INSERT)) {
            this.printCsvData(data);
        }
    }

    public void end(Table table) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Batch batch, boolean inError) {
        if (!inError) {
            try {
                this.closeFiles();
                this.sendFiles();
            }
            finally {
                this.deleteFiles();
            }
        }
        try {
            this.closeFiles();
        }
        finally {
            this.deleteFiles();
        }
    }

    protected void createFile(Table table, Batch batch) {
        FileInfo fileInfo = this.fileInfoByTable.get(table.getFullyQualifiedTableName());
        if (fileInfo == null) {
            try {
                fileInfo = new FileInfo();
                fileInfo.outputFile = new File(this.stagingDir, batch.getBatchId() + "-" + table.getFullyQualifiedTableName() + "." + this.format.name().toLowerCase());
                fileInfo.outputFile.getParentFile().mkdirs();
                fileInfo.outputFileWriter = new BufferedWriter(new FileWriter(fileInfo.outputFile));
                this.fileInfoByTable.put(table.getFullyQualifiedTableName(), fileInfo);
                if (this.format == Format.CSV) {
                    this.printCsvTableHeader();
                }
            }
            catch (IOException e) {
                throw new IoException((Exception)e);
            }
        }
    }

    protected void closeFiles() {
        Collection<FileInfo> fileInfos = this.fileInfoByTable.values();
        for (FileInfo fileInfo : fileInfos) {
            try {
                fileInfo.outputFileWriter.flush();
                fileInfo.outputFileWriter.close();
            }
            catch (IOException e) {
                logger.warn("", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFiles() {
        Collection<FileInfo> fileInfos = this.fileInfoByTable.values();
        for (FileInfo fileInfo : fileInfos) {
            try {
                fileInfo.outputFileWriter.close();
            }
            catch (IOException e) {
                logger.warn("", (Throwable)e);
            }
            finally {
                FileUtils.deleteQuietly((File)fileInfo.outputFile);
            }
        }
        this.fileInfoByTable.clear();
    }

    protected void sendFiles() {
        if (this.fileInfoByTable.size() > 0) {
            try {
                String sftpUri = this.buildUri();
                FileSystemOptions opts = new FileSystemOptions();
                FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(opts, true);
                SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
                SftpFileSystemConfigBuilder.getInstance().setSessionTimeout(opts, Duration.ofMillis(60000L));
                Collection<FileInfo> fileInfos = this.fileInfoByTable.values();
                for (FileInfo fileInfo : fileInfos) {
                    FileObject fileObject = this.manager.resolveFile(sftpUri + "/" + fileInfo.outputFile.getName(), opts);
                    FileObject localFileObject = this.manager.resolveFile(fileInfo.outputFile.getAbsolutePath());
                    fileObject.copyFrom(localFileObject, Selectors.SELECT_SELF);
                    fileObject.close();
                }
            }
            catch (FileSystemException e) {
                logger.warn("If you have not configured your ftp connection it should be configured in conf/ftp-extensions.xml");
                throw new IoException((Exception)((Object)e));
            }
            catch (Exception e) {
                throw new IoException(e);
            }
            finally {
                this.manager.close();
            }
        }
    }

    protected String buildUri() {
        String credentials = "";
        if (StringUtils.isNotBlank((CharSequence)this.username)) {
            credentials = this.username;
            if (StringUtils.isNotBlank((CharSequence)this.password)) {
                credentials = credentials + ":" + this.password;
            }
            credentials = credentials + "@";
        }
        String path = "";
        if (StringUtils.isNotBlank((CharSequence)this.remoteDir)) {
            path = "/" + this.remoteDir;
        }
        return this.protocol.toString().toLowerCase() + "://" + credentials + this.server + path;
    }

    protected void printCsvTableHeader() {
        this.println(this.table.getColumnNames());
    }

    protected void printCsvData(CsvData data) {
        this.println(data.getParsedData("rowData"));
    }

    protected void println(String ... data) {
        FileInfo fileInfo = this.fileInfoByTable.get(this.table.getFullyQualifiedTableName());
        if (fileInfo != null) {
            try {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < data.length; ++i) {
                    if (i != 0) {
                        buffer.append(",");
                    }
                    buffer.append(data[i]);
                }
                buffer.append("\n");
                fileInfo.outputFileWriter.write(buffer.toString());
                long byteCount = buffer.length();
                this.statistics.get(this.batch).increment("BYTECOUNT", byteCount);
            }
            catch (IOException e) {
                throw new IoException((Exception)e);
            }
        }
    }

    static class FileInfo {
        File outputFile;
        BufferedWriter outputFileWriter;

        FileInfo() {
        }
    }

    public static enum Protocol {
        FTP,
        SFTP;

    }

    public static enum Format {
        CSV;

    }
}

