/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.tibero;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.tibero.TiberoTriggerTemplate;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.service.IParameterService;

public class TiberoSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String Tibero_OBJECT_TYPE = "FUNCTION";
    static final String SQL_SELECT_TRIGGERS = "from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name = upper(?) and table_owner = upper(?)";
    static final String SQL_SELECT_TRANSACTIONS = "select min(start_time) from gv$transaction where status = 'ACTIVE'";
    static final String SQL_OBJECT_INSTALLED = "select count(*) from user_source where line = 1 and (((type = 'FUNCTION' or type = 'PACKAGE') and name=upper('$(functionName)')) or (name||'_'||type=upper('$(functionName)')))";
    static final String SQL_DROP_FUNCTION = "DROP FUNCTION $(functionName)";

    public TiberoSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new TiberoTriggerTemplate(this);
        if (parameterService.is("oracle.use.transaction.view")) {
            try {
                this.areDatabaseTransactionsPendingSince(System.currentTimeMillis());
                this.supportsTransactionViews = true;
            }
            catch (Exception ex) {
                this.log.warn("Was not able to enable the use of transaction views.  You might not have access to select from gv$transaction", (Throwable)ex);
            }
        }
    }

    protected void buildSqlReplacementTokens() {
        super.buildSqlReplacementTokens();
        if (this.parameterService.is("tibero.use.hints", true)) {
            this.sqlReplacementTokens.put("selectDataUsingGapsSqlHint", "/*+ index(d " + this.parameterService.getTablePrefix() + "_IDX_D_CHANNEL_ID) */");
        }
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        if (StringUtils.isBlank((CharSequence)schema)) {
            schema = this.platform.getDefaultSchema();
        }
        return this.platform.getSqlTemplate().queryForInt("select count(*) from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name = upper(?) and table_owner = upper(?)", new Object[]{triggerName, tableName, schema}) > 0;
    }

    protected String getDropTriggerSql(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName) {
        return "drop trigger " + triggerName;
    }

    public void createTrigger(StringBuilder sqlBuffer, DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table table, ISqlTransaction transaction) {
        try {
            super.createTrigger(sqlBuffer, dml, trigger, history, channel, this.parameterService.getTablePrefix(), table, transaction);
        }
        catch (SqlException ex) {
            if (ex.getErrorCode() == 4095) {
                try {
                    Map map = this.platform.getSqlTemplate().queryForMap("select * from ALL_TRIGGERS where owner = sys_context('USERENV', 'CURRENT_SCHEMA') and trigger_name = upper(?) and table_name = upper(?) and table_owner = upper(?)", new Object[]{history.getTriggerNameForDmlType(dml), history.getSourceTableName(), history.getSourceSchemaName()});
                    if (map != null) {
                        this.log.warn("Trigger named {} already exists on table {}.{} and it cannot be replaced", new Object[]{history.getTriggerNameForDmlType(dml), map.get("TABLE_OWNER"), map.get("TABLE_NAME")});
                    } else {
                        this.log.warn("Trigger named {} already exists on another table and it cannot be replaced", (Object)history.getTriggerNameForDmlType(dml));
                    }
                }
                catch (SqlException sqlException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public void createRequiredDatabaseObjects() {
        String wkt2geom;
        String pkgPackage;
        String triggerDisabled;
        String transactionId;
        String blobToClob = this.parameterService.getTablePrefix() + "_blob2clob";
        if (!this.installed(SQL_OBJECT_INSTALLED, blobToClob)) {
            String sql = "CREATE OR REPLACE FUNCTION $(functionName) (blob_in IN BLOB)                                                                                                                                                RETURN CLOB                                                                                                                                                             AS                                                                                                                                                                            v_clob    CLOB := null;                                                                                                                                                   v_varchar VARCHAR2(32767);                                                                                                                                                v_start   PLS_INTEGER := 1;                                                                                                                                               v_buffer  PLS_INTEGER := 999;                                                                                                                                         BEGIN                                                                                                                                                                         IF blob_in IS NOT NULL THEN                                                                                                                                                   IF DBMS_LOB.GETLENGTH(blob_in) > 0 THEN                                                                                                                                       DBMS_LOB.CREATETEMPORARY(v_clob, TRUE);                                                                                                                                   FOR i IN 1..CEIL(DBMS_LOB.GETLENGTH(blob_in) / v_buffer)                                                                                                                  LOOP                                                                                                                                                                          v_varchar := UTL_RAW.CAST_TO_VARCHAR2(UTL_ENCODE.base64_encode(DBMS_LOB.SUBSTR(blob_in, v_buffer, v_start)));                                                             v_varchar := REPLACE(v_varchar,CHR(13)||CHR(10));                                                                                                                         DBMS_LOB.WRITEAPPEND(v_clob, LENGTH(v_varchar), v_varchar);                                                                                                               v_start := v_start + v_buffer;                                                                                                                                        END LOOP;                                                                                                                                                             END IF;                                                                                                                                                               END IF;                                                                                                                                                                   RETURN v_clob;                                                                                                                                                        END $(functionName);                                                                                                                                                   ";
            this.install(sql, blobToClob);
        }
        if (!this.installed(SQL_OBJECT_INSTALLED, transactionId = this.parameterService.getTablePrefix() + "_transaction_id")) {
            String sql = "CREATE OR REPLACE function $(functionName)                                                                                                                                                                return varchar is                                                                                                                                                     begin                                                                                                                                                                    return DBMS_TRANSACTION.local_transaction_id(false);                                                                                                               end;                                                                                                                                                               ";
            this.install(sql, transactionId);
        }
        if (!this.installed(SQL_OBJECT_INSTALLED, triggerDisabled = this.parameterService.getTablePrefix() + "_trigger_disabled")) {
            String sql = "CREATE OR REPLACE function $(functionName) return varchar is                                                                                                                                              begin                                                                                                                                                                      return " + this.getSymmetricPackageName() + ".disable_trigger;                                                                                                                                      end;                                                                                                                                                                 ";
            this.install(sql, triggerDisabled);
        }
        if (!this.installed(SQL_OBJECT_INSTALLED, pkgPackage = this.parameterService.getTablePrefix() + "_pkg")) {
            String sql = "CREATE OR REPLACE package $(functionName) as                                                                                                                                                                         disable_trigger pls_integer;                                                                                                                                             disable_node_id varchar(50);                                                                                                                                             procedure setValue (a IN number);                                                                                                                                        procedure setNodeValue (node_id IN varchar);                                                                                                                         end " + this.getSymmetricPackageName() + ";                                                                                                                                                           ";
            this.install(sql, pkgPackage);
            sql = "CREATE OR REPLACE package body $(functionName) as                                                                                                                                                                   procedure setValue(a IN number) is                                                                                                                                      begin                                                                                                                                                                       $(functionName).disable_trigger:=a;                                                                                                                                        end;                                                                                                                                                                    procedure setNodeValue(node_id IN varchar) is                                                                                                                           begin                                                                                                                                                                       $(functionName).disable_node_id := node_id;                                                                                                                                end;                                                                                                                                                                end " + this.getSymmetricPackageName() + ";                                                                                                                                                           ";
            this.install(sql, pkgPackage);
        }
        if (!this.installed(SQL_OBJECT_INSTALLED, wkt2geom = this.parameterService.getTablePrefix() + "_wkt2geom")) {
            String sql = "  CREATE OR REPLACE                                                                                                             FUNCTION $(functionName)(                                    clob_in IN CLOB)                                       RETURN SDO_GEOMETRY                                    AS                                                         v_out SDO_GEOMETRY := NULL;                            BEGIN                                                      IF clob_in IS NOT NULL THEN                                IF DBMS_LOB.GETLENGTH(clob_in) > 0 THEN                    v_out := SDO_GEOMETRY(clob_in);                        END IF;                                                END IF;                                                  RETURN v_out;                                          END $(functionName);                                 ";
            this.install(sql, wkt2geom);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String pkgPackage;
        String wkt2geom;
        String triggerDisabled;
        String transactionId;
        String blobToClob = this.parameterService.getTablePrefix() + "_blob2clob";
        if (this.installed(SQL_OBJECT_INSTALLED, blobToClob)) {
            this.uninstall(SQL_DROP_FUNCTION, blobToClob);
        }
        if (this.installed(SQL_OBJECT_INSTALLED, transactionId = this.parameterService.getTablePrefix() + "_transaction_id")) {
            this.uninstall(SQL_DROP_FUNCTION, transactionId);
        }
        if (this.installed(SQL_OBJECT_INSTALLED, triggerDisabled = this.parameterService.getTablePrefix() + "_trigger_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, triggerDisabled);
        }
        if (this.installed(SQL_OBJECT_INSTALLED, wkt2geom = this.parameterService.getTablePrefix() + "_wkt2geom")) {
            this.uninstall(SQL_DROP_FUNCTION, wkt2geom);
        }
        if (this.installed(SQL_OBJECT_INSTALLED, pkgPackage = this.parameterService.getTablePrefix() + "_pkg")) {
            this.uninstall("DROP PACKAGE $(functionName)", pkgPackage);
        }
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.parameterService.getTablePrefix() + "_transaction_id()";
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case REQUEST: {
                return "SEQ_" + this.parameterService.getTablePrefix() + "_EXTRACT_EST_REQUEST_ID";
            }
            case DATA: {
                return "SEQ_" + this.parameterService.getTablePrefix() + "_DATA_DATA_ID";
            }
            case TRIGGER_HIST: {
                return "SEQ_" + this.parameterService.getTablePrefix() + "_TRIGGER_RIGGER_HIST_ID";
            }
        }
        return null;
    }

    public void cleanDatabase() {
        this.platform.getSqlTemplate().update("purge recyclebin", new Object[0]);
    }

    protected String getSymmetricPackageName() {
        return this.parameterService.getTablePrefix() + "_pkg";
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute(String.format("call %s.setValue(1)", this.getSymmetricPackageName()), new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute(String.format("call %s.setNodeValue('" + nodeId + "')", this.getSymmetricPackageName()), new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute(String.format("call %s.setValue(null)", this.getSymmetricPackageName()), new Object[0]);
        transaction.prepareAndExecute(String.format("call %s.setNodeValue(null)", this.getSymmetricPackageName()), new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return this.parameterService.getTablePrefix() + "_trigger_disabled() is null";
    }

    public final boolean areDatabaseTransactionsPendingSince(long time) {
        String returnValue = (String)this.platform.getSqlTemplate().queryForObject(SQL_SELECT_TRANSACTIONS, String.class, new Object[0]);
        if (returnValue != null) {
            try {
                Date date = DateUtils.parseDate((String)returnValue, (String[])new String[]{"MM/dd/yy HH:mm:ss"});
                return date.getTime() < time;
            }
            catch (ParseException e) {
                this.log.error("Could not parse the pending transactions date", (Throwable)e);
                return true;
            }
        }
        return false;
    }

    public Date getEarliestTransactionStartTime() {
        Date date = null;
        String returnValue = (String)this.platform.getSqlTemplate().queryForObject(SQL_SELECT_TRANSACTIONS, String.class, new Object[0]);
        if (returnValue != null) {
            try {
                date = DateUtils.parseDate((String)returnValue, (String[])new String[]{"MM/dd/yy HH:mm:ss"});
            }
            catch (ParseException e) {
                this.log.error("", (Throwable)e);
                date = new Date();
            }
        }
        return date;
    }

    public String massageDataExtractionSql(String sql, boolean isContainsBigLob) {
        if (!isContainsBigLob) {
            sql = StringUtils.replace((String)sql, (String)"d.row_data", (String)"dbms_lob.substr(d.row_data, 4000, 1 )");
            sql = StringUtils.replace((String)sql, (String)"d.old_data", (String)"dbms_lob.substr(d.old_data, 4000, 1 )");
            sql = StringUtils.replace((String)sql, (String)"d.pk_data", (String)"dbms_lob.substr(d.pk_data, 4000, 1 )");
        }
        sql = super.massageDataExtractionSql(sql, isContainsBigLob);
        return sql;
    }

    public String massageForLob(String sql, boolean isContainsBigLob) {
        if (!isContainsBigLob) {
            return String.format("dbms_lob.substr(%s, 4000, 1)", sql);
        }
        return super.massageForLob(sql, isContainsBigLob);
    }

    public boolean isInitialLoadTwoPassLob(Table table) {
        boolean initialLoadTwoPassLob = false;
        if (this.parameterService.is("initial.load.extract.use.two.pass.lob") && !TableConstants.getTables((String)this.parameterService.getTablePrefix()).contains(table.getNameLowerCase())) {
            for (Column column : table.getLobColumns(this.platform)) {
                if (!this.isInitialLoadTwoPassLobColumn(column)) continue;
                initialLoadTwoPassLob = true;
                break;
            }
        }
        return initialLoadTwoPassLob;
    }

    private boolean isInitialLoadTwoPassLobColumn(Column column) {
        String typeName = column.getJdbcTypeName();
        return typeName.equalsIgnoreCase("CLOB") || typeName.equalsIgnoreCase("BLOB");
    }

    public String getInitialLoadTwoPassLobLengthSql(Column column, boolean isFirstPass) {
        String quote = this.platform.getDdlBuilder().getDatabaseInfo().getDelimiterToken();
        if (!this.isInitialLoadTwoPassLobColumn(column)) {
            return null;
        }
        if (isFirstPass) {
            return "(t." + quote + column.getName() + quote + " is null or dbms_lob.getlength(t." + quote + column.getName() + quote + ") <= 4000)";
        }
        return "dbms_lob.getlength(t." + quote + column.getName() + quote + ") > 4000";
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        if (!trigger.isUseCaptureLobs()) {
            return "var_old_data is null or var_row_data != var_old_data";
        }
        return "dbms_lob.compare(nvl(var_row_data,'Null'),nvl(var_old_data,'Null')) != 0 ";
    }

    public String getTemplateNumberPrecisionSpec() {
        return this.parameterService.getString("tibero.template.precision", "30,10");
    }

    public PermissionType[] getSymTablePermissions() {
        PermissionType[] permissions = new PermissionType[]{PermissionType.CREATE_TABLE, PermissionType.DROP_TABLE, PermissionType.CREATE_TRIGGER, PermissionType.DROP_TRIGGER, PermissionType.EXECUTE};
        return permissions;
    }

    public String getDatabaseTimeSQL() {
        return "select current_timestamp from dual";
    }
}

