/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.raima;

import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.PermissionType;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.raima.RaimaTriggerTemplate;
import org.jumpmind.symmetric.service.IParameterService;

public class RaimaSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    public RaimaSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new RaimaTriggerTemplate(this);
        this.parameterService = parameterService;
    }

    public void createRequiredDatabaseObjects() {
        try (ISqlTransaction transaction = this.platform.getSqlTemplate().startSqlTransaction();){
            transaction.prepareAndExecute("declare sync_node_disabled varchar(50);", new Object[0]);
            transaction.prepareAndExecute("declare sync_triggers_disabled smallint;", new Object[0]);
            transaction.commit();
        }
    }

    public void dropRequiredDatabaseObjects() {
    }

    public boolean supportsTransactionId() {
        return false;
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        schema = schema == null ? (this.platform.getDefaultSchema() == null ? null : this.platform.getDefaultSchema()) : schema;
        String checkSchemaSql = schema != null && schema.length() > 0 ? " and schemaname='" + schema + "'" : "";
        return this.platform.getSqlTemplate().queryForInt("select count(*) from sys_trigger where name = ? and tabname = ?" + checkSchemaSql, new Object[]{triggerName, tableName.toUpperCase()}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        String sql = "drop trigger " + triggerName;
        this.logSql(sql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            try {
                this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
                this.platform.getSqlTemplate().update(sql, new Object[0]);
            }
            catch (Exception e) {
                this.log.warn("Trigger does not exist");
            }
        }
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("set sync_triggers_disabled = 1;", new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute("set sync_node_disabled = '" + nodeId + "';", new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("set sync_triggers_disabled = null;", new Object[0]);
        transaction.prepareAndExecute("set sync_node_disabled = null;", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return "sync_triggers_disabled is null";
    }

    public void cleanDatabase() {
    }

    public int getSqlTypeForIds() {
        return -5;
    }

    public boolean isClobSyncSupported() {
        return false;
    }

    public boolean isBlobSyncSupported() {
        return false;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.NONE;
    }

    public PermissionType[] getSymTablePermissions() {
        PermissionType[] permissions = new PermissionType[]{PermissionType.CREATE_TABLE, PermissionType.DROP_TABLE, PermissionType.CREATE_TRIGGER, PermissionType.DROP_TRIGGER};
        return permissions;
    }
}

