/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.postgresql;

import java.util.Date;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.postgresql.PostgreSqlTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class PostgreSqlSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String TRANSACTION_ID_EXPRESSION = "txid_current()";
    static final String SYNC_TRIGGERS_DISABLED_VARIABLE = "symmetric.triggers_disabled";
    static final String SYNC_NODE_DISABLED_VARIABLE = "symmetric.node_disabled";
    static final String SQL_DROP_FUNCTION = "drop function $(functionName)";
    static final String SQL_FUNCTION_INSTALLED = " select count(*) from information_schema.routines  where routine_name = '$(functionName)' and specific_schema = '$(defaultSchema)'";
    static final String SQL_SELECT_TRANSACTIONS = "select min(a.xact_start) from pg_stat_activity a join pg_catalog.pg_locks l on l.pid = a.pid  where l.mode = 'RowExclusiveLock'";
    private Boolean supportsTransactionId = null;

    public PostgreSqlSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new PostgreSqlTriggerTemplate(this);
        boolean bl = this.supportsDdlTriggers = this.databaseMajorVersion > 9 || this.databaseMajorVersion == 9 && this.databaseMinorVersion >= 3;
        if (parameterService.is("routing.gaps.use.transaction.view")) {
            try {
                this.getEarliestTransactionStartTime();
                this.supportsTransactionViews = true;
                this.log.info("Enabling use of transaction views for data gap detection.");
            }
            catch (Exception ex) {
                this.log.warn("Cannot enable use of transaction views for data gap detection.", (Throwable)ex);
            }
        }
        platform.getDatabaseInfo().setGeneratedColumnsSupported(this.databaseMajorVersion >= 12);
    }

    public void createRequiredDatabaseObjects() {
        String largeObjects;
        String nodeDisabled;
        try (ISqlTransaction transaction = null;){
            transaction = this.platform.getSqlTemplate().startSqlTransaction();
            this.enableSyncTriggers(transaction);
        }
        String triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled";
        if (!this.installed(SQL_FUNCTION_INSTALLED, triggersDisabled)) {
            String sql = "CREATE or REPLACE FUNCTION $(functionName)() RETURNS INTEGER AS $$                                                                                                                                                     DECLARE                                                                                                                                                                                                  triggerDisabled INTEGER;                                                                                                                                                                             BEGIN                                                                                                                                                                                                    select current_setting('symmetric.triggers_disabled') into triggerDisabled;                                                                                                                            return triggerDisabled;                                                                                                                                                                              EXCEPTION WHEN OTHERS THEN                                                                                                                                                                               return 0;                                                                                                                                                                                            END;                                                                                                                                                                                                   $$ LANGUAGE plpgsql;                                                                                                                                                   ";
            this.install(sql, triggersDisabled);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled")) {
            String sql = "CREATE or REPLACE FUNCTION $(functionName)() RETURNS VARCHAR AS $$                                                                                                                                                     DECLARE                                                                                                                                                                                                  nodeId VARCHAR(50);                                                                                                                                                                                  BEGIN                                                                                                                                                                                                    select current_setting('symmetric.node_disabled') into nodeId;                                                                                                                                         return nodeId;                                                                                                                                                                                       EXCEPTION WHEN OTHERS THEN                                                                                                                                                                               return '';                                                                                                                                                                                           END;                                                                                                                                                                                                   $$ LANGUAGE plpgsql;                                                                                                                                                   ";
            this.install(sql, nodeDisabled);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, largeObjects = this.parameterService.getTablePrefix() + "_largeobject")) {
            String sql = "CREATE OR REPLACE FUNCTION $(functionName)(objectId oid) RETURNS text AS $$                                                                                                                                            DECLARE                                                                                                                                                                                                  encodedBlob text;                                                                                                                                                                                      encodedBlobPage text;                                                                                                                                                                                BEGIN                                                                                                                                                                                                    encodedBlob := '';                                                                                                                                                                                     FOR encodedBlobPage IN SELECT pg_catalog.encode(data, 'escape')                                                                                                                                                   FROM pg_largeobject WHERE loid = objectId ORDER BY pageno LOOP                                                                                                                                           encodedBlob := encodedBlob || encodedBlobPage;                                                                                                                                                       END LOOP;                                                                                                                                                                                              RETURN pg_catalog.encode(pg_catalog.decode(encodedBlob, 'escape'), 'base64');                                                                                                                                              EXCEPTION WHEN OTHERS THEN                                                                                                                                                                               RETURN '';                                                                                                                                                                                           END                                                                                                                                                                                                    $$ LANGUAGE plpgsql;                                                                                                                                                   ";
            this.install(sql, largeObjects);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String largeObjects;
        String nodeDisabled;
        String triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled";
        if (this.installed(SQL_FUNCTION_INSTALLED, triggersDisabled)) {
            this.uninstall("drop function $(functionName)() cascade", triggersDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled")) {
            this.uninstall("drop function $(functionName)() cascade", nodeDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, largeObjects = this.parameterService.getTablePrefix() + "_largeobject")) {
            this.uninstall("drop function $(functionName)(objectId oid) cascade", largeObjects);
        }
    }

    public boolean requiresAutoCommitFalseToSetFetchSize() {
        return true;
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schema, String tableName, String triggerName) {
        if (this.platform.isMetadataIgnoreCase()) {
            return this.platform.getSqlTemplate().queryForInt("select count(*) from information_schema.triggers where trigger_name = ? and lower(event_object_table) = lower(?) and trigger_schema = ?", new Object[]{triggerName.toLowerCase(), tableName, schema == null ? this.platform.getDefaultSchema() : schema}) > 0;
        }
        return this.platform.getSqlTemplate().queryForInt("select count(*) from information_schema.triggers where trigger_name = ? and event_object_table = ? and trigger_schema = ?", new Object[]{triggerName.toLowerCase(), tableName, schema == null ? this.platform.getDefaultSchema() : schema}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        Table table = this.platform.getTableFromCache(catalogName, schemaName, tableName, false);
        if (table != null) {
            String quoteChar = this.platform.getDatabaseInfo().getDelimiterToken();
            String schemaPrefix = table.getSchema() == null ? "" : quoteChar + table.getSchema() + quoteChar + ".";
            String dropSql = "drop trigger IF EXISTS " + triggerName + " on " + schemaPrefix + quoteChar + table.getName() + quoteChar;
            this.logSql(dropSql, sqlBuffer);
            String dropFunction = "drop function IF EXISTS " + schemaPrefix + "f" + triggerName + "() cascade";
            this.logSql(dropFunction, sqlBuffer);
            if (this.parameterService.is("auto.sync.triggers")) {
                this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
                transaction.execute(dropSql);
                transaction.execute(dropFunction);
            }
        }
    }

    public boolean doesDdlTriggerExist(String catalogName, String schema, String triggerName) {
        boolean dropTriggerExists = this.platform.getSqlTemplate().queryForInt("select count(*) from pg_event_trigger where evtname = ?", new Object[]{triggerName.toLowerCase() + "_drop"}) > 0;
        return dropTriggerExists && this.platform.getSqlTemplate().queryForInt("select count(*) from pg_event_trigger where evtname = ?", new Object[]{triggerName.toLowerCase()}) > 0;
    }

    public void removeDdlTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName) {
        String dropSql = "drop event trigger IF EXISTS " + triggerName;
        this.logSql(dropSql, sqlBuffer);
        String dropFunction = "drop function IF EXISTS f" + triggerName + "() cascade";
        this.logSql(dropFunction, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            this.log.info("Removing DDL trigger " + triggerName);
            try {
                this.platform.getSqlTemplate().update(dropSql, new Object[0]);
                this.platform.getSqlTemplate().update(dropSql + "_drop", new Object[0]);
            }
            catch (Exception e) {
                this.log.warn("Tried to remove DDL trigger using: {} and failed because: {}", (Object)dropSql, (Object)e.getMessage());
            }
            try {
                this.platform.getSqlTemplate().update(dropFunction, new Object[0]);
                this.platform.getSqlTemplate().update("drop function IF EXISTS f" + triggerName + "_drop() cascade", new Object[0]);
            }
            catch (Exception e) {
                this.log.warn("Tried to remove DDL trigger function using: {} and failed because: {}", (Object)dropFunction, (Object)e.getMessage());
            }
        }
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("select set_config('symmetric.triggers_disabled', '1', false)", new Object[0]);
        if (nodeId == null) {
            nodeId = "";
        }
        transaction.prepareAndExecute("select set_config('symmetric.node_disabled', '" + nodeId + "', false)", new Object[0]);
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("select set_config('symmetric.triggers_disabled', '', false)", new Object[0]);
        transaction.prepareAndExecute("select set_config('symmetric.node_disabled', '', false)", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return "$(defaultSchema)" + this.parameterService.getTablePrefix() + "_triggers_disabled() = 0";
    }

    public String getSyncTriggersOnIncomingExpression() {
        return "$(defaultSchema)" + this.parameterService.getTablePrefix() + "_triggers_disabled() != 2";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        if (this.supportsTransactionId()) {
            return TRANSACTION_ID_EXPRESSION;
        }
        return "null";
    }

    public boolean supportsTransactionId() {
        if (this.supportsTransactionId == null) {
            this.supportsTransactionId = this.platform.getSqlTemplate().queryForInt("select count(*) from information_schema.routines where routine_name='txid_current'", new Object[0]) > 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.supportsTransactionId;
    }

    public final Date getEarliestTransactionStartTime() {
        Date minStartTime = (Date)this.platform.getSqlTemplate().queryForObject(SQL_SELECT_TRANSACTIONS, Date.class, new Object[0]);
        if (minStartTime == null) {
            minStartTime = new Date();
        }
        return minStartTime;
    }

    public boolean supportsTransactionViews() {
        return this.supportsTransactionViews && this.parameterService.is("routing.gaps.use.transaction.view");
    }

    public void cleanDatabase() {
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public int getSqlTypeForIds() {
        return -5;
    }

    protected String getDbSpecificDataHasChangedCondition(Trigger trigger) {
        return "var_old_data is null or var_row_data != var_old_data";
    }

    public long getCurrentSequenceValue(SequenceIdentifier identifier) {
        return this.platform.getSqlTemplate().queryForLong("select last_value from " + this.getSequenceName(identifier) + "_seq", new Object[0]);
    }
}

