/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.mssql;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.db.mssql.MsSql2008SymmetricDialect;
import org.jumpmind.symmetric.db.mssql.MsSql2016TriggerTemplate;
import org.jumpmind.symmetric.service.IParameterService;

public class MsSql2016SymmetricDialect
extends MsSql2008SymmetricDialect {
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "@sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "@sync_node_disabled";
    static final String SESSION_CONTEXT_FUNCTION_INSTALLED = "select count(case when object_definition(object_id('$(functionName)')) like '%SESSION_CONTEXT%' then 1 else null end)";
    static final String triggersDisabledFunctionSql = "create function dbo.$(functionName)() returns smallint   \n  begin        \n    declare @disabled varchar(50);      \n    set @disabled = CONVERT(varchar(50), SESSION_CONTEXT(N'@sync_triggers_disabled'));    \n    if @disabled is null      \n      return 0;       \n    else if @disabled = '2' \n      return 2; \n    return 1;         \n  end                 ";
    static final String nodeDisabledFunctionSql = "create function dbo.$(functionName)() returns varchar(50)    \n  begin                            \n    declare @node varchar(50);     \n    set @node = CONVERT(varchar(50), SESSION_CONTEXT(N'@sync_node_disabled'));   \n    return @node;  \n  end              ";
    protected Boolean supportsSessionContext = null;

    public MsSql2016SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new MsSql2016TriggerTemplate(this);
    }

    @Override
    protected void createTriggersDisabledFunction() {
        if (this.supportsSessionContext()) {
            String triggersDisabled = this.parameterService.getTablePrefix() + "_triggers_disabled";
            if (!this.installed("select count(object_name(object_id('$(functionName)')))", triggersDisabled)) {
                this.install(triggersDisabledFunctionSql, triggersDisabled);
            } else if (!this.installed(SESSION_CONTEXT_FUNCTION_INSTALLED, triggersDisabled)) {
                this.uninstall("drop function dbo.$(functionName)", triggersDisabled);
                this.install(triggersDisabledFunctionSql, triggersDisabled);
            } else {
                this.log.info("Function " + triggersDisabled + " using SESSION_CONTEXT is already installed");
            }
        } else {
            super.createTriggersDisabledFunction();
        }
    }

    @Override
    protected void createNodeDisabledFunction() {
        if (this.supportsSessionContext()) {
            String nodeDisabled = this.parameterService.getTablePrefix() + "_node_disabled";
            if (!this.installed("select count(object_name(object_id('$(functionName)')))", nodeDisabled)) {
                this.install(nodeDisabledFunctionSql, nodeDisabled);
            } else if (!this.installed(SESSION_CONTEXT_FUNCTION_INSTALLED, nodeDisabled)) {
                this.uninstall("drop function dbo.$(functionName)", nodeDisabled);
                this.install(nodeDisabledFunctionSql, nodeDisabled);
            } else {
                this.log.info("Function " + nodeDisabled + " using SESSION_CONTEXT is already installed");
            }
        } else {
            super.createNodeDisabledFunction();
        }
    }

    @Override
    protected boolean supportsDisableTriggers() {
        if (this.supportsSessionContext()) {
            return true;
        }
        return super.supportsDisableTriggers();
    }

    protected boolean supportsSessionContext() {
        if (this.supportsSessionContext == null) {
            try {
                this.getPlatform().getSqlTemplate().update("sp_set_session_context '@sync_node_disabled', NULL", new Object[0]);
                this.log.info("This database DOES support setting session context to disable triggers during a symmetricds data load");
                this.supportsSessionContext = true;
            }
            catch (Exception ex) {
                this.log.info("This database does NOT support setting session context to disable triggers during a symmetricds data load");
                this.supportsSessionContext = false;
            }
        }
        return this.supportsSessionContext == null ? false : this.supportsSessionContext;
    }

    @Override
    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        if (this.supportsSessionContext()) {
            transaction.prepareAndExecute("sp_set_session_context '@sync_triggers_disabled', '1';", new Object[0]);
            if (nodeId == null) {
                nodeId = "";
            }
            transaction.prepareAndExecute("sp_set_session_context '@sync_node_disabled', '" + nodeId + "';", new Object[0]);
        } else {
            super.disableSyncTriggers(transaction, nodeId);
        }
    }

    @Override
    public void enableSyncTriggers(ISqlTransaction transaction) {
        if (this.supportsSessionContext()) {
            transaction.prepareAndExecute("sp_set_session_context '@sync_triggers_disabled', NULL;", new Object[0]);
            transaction.prepareAndExecute("sp_set_session_context '@sync_node_disabled', NULL;", new Object[0]);
        } else {
            super.enableSyncTriggers(transaction);
        }
    }
}

