/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.interbase;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.interbase.InterbaseTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;
import org.springframework.jdbc.UncategorizedSQLException;

public class InterbaseSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    public static final String CONTEXT_TABLE_NAME = "temp_context";
    static final String CONTEXT_TABLE_CREATE = "create global temporary table %s (name varchar(30), context_value varchar(30)) on commit preserve rows";
    static final String CONTEXT_TABLE_INSERT = "insert into %s (name, context_value) values (?, ?)";
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from rdb$functions where rdb$function_name = upper('$(functionName)')";
    static final String SQL_DROP_FUNCTION = "DROP EXTERNAL FUNCTION $(functionName)";

    public InterbaseSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new InterbaseTriggerTemplate(this);
    }

    public void createRequiredDatabaseObjects() {
        String rtrim;
        String hex;
        String contextTableName = this.parameterService.getTablePrefix() + "_" + CONTEXT_TABLE_NAME;
        try {
            this.platform.getSqlTemplate().queryForInt("select count(*) from " + contextTableName, new Object[0]);
        }
        catch (Exception e) {
            try {
                this.log.info("Creating global temporary table {}", (Object)contextTableName);
                this.platform.getSqlTemplate().update(String.format(CONTEXT_TABLE_CREATE, contextTableName), new Object[0]);
            }
            catch (Exception ex) {
                this.log.error("Error while initializing Interbase dialect", (Throwable)ex);
            }
        }
        String escape = this.parameterService.getTablePrefix() + "_escape";
        if (!this.installed(SQL_FUNCTION_INSTALLED, escape)) {
            String sql = "declare external function $(functionName) cstring(32660)                                                                                                                                                 returns cstring(32660) free_it entry_point 'sym_escape' module_name 'sym_udf'                                                                                          ";
            this.install(sql, escape);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, hex = this.parameterService.getTablePrefix() + "_hex")) {
            String sql = "declare external function $(functionName) blob                                                                                                                                                           returns cstring(32660) free_it entry_point 'sym_hex' module_name 'sym_udf'                                                                                             ";
            this.install(sql, hex);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, rtrim = this.parameterService.getTablePrefix() + "_rtrim")) {
            String sql = "declare external function $(functionName) cstring(32767)                                                                                                                                                                               returns cstring(32767) free_it entry_point 'IB_UDF_rtrim' module_name 'ib_udf'                                                                                         ";
            this.install(sql, rtrim);
        }
        try {
            this.platform.getSqlTemplate().queryForObject("select sym_escape('') from rdb$database", String.class, new Object[0]);
        }
        catch (UncategorizedSQLException e) {
            if (e.getSQLException().getErrorCode() == -804) {
                this.log.error("Please install the sym_udf.so/dll to your {interbase_home}/UDF folder");
            }
            throw new RuntimeException("Function SYM_ESCAPE is not installed", e);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String rtrim;
        String hex;
        String escape = this.parameterService.getTablePrefix() + "_escape";
        if (this.installed(SQL_FUNCTION_INSTALLED, escape)) {
            this.uninstall(SQL_DROP_FUNCTION, escape);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, hex = this.parameterService.getTablePrefix() + "_hex")) {
            this.uninstall(SQL_DROP_FUNCTION, hex);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, rtrim = this.parameterService.getTablePrefix() + "_rtrim")) {
            this.uninstall(SQL_DROP_FUNCTION, rtrim);
        }
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schema, String tableName, String triggerName) {
        return this.platform.getSqlTemplate().queryForInt("select count(*) from rdb$triggers where rdb$trigger_name = ?", new Object[]{triggerName.toUpperCase()}) > 0;
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        String contextTableName = this.parameterService.getTablePrefix() + "_" + CONTEXT_TABLE_NAME;
        transaction.prepareAndExecute(String.format(CONTEXT_TABLE_INSERT, contextTableName), new Object[]{SYNC_TRIGGERS_DISABLED_USER_VARIABLE, "1"});
        if (nodeId != null) {
            transaction.prepareAndExecute(String.format(CONTEXT_TABLE_INSERT, contextTableName), new Object[]{SYNC_TRIGGERS_DISABLED_NODE_VARIABLE, nodeId});
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        String contextTableName = this.parameterService.getTablePrefix() + "_" + CONTEXT_TABLE_NAME;
        transaction.prepareAndExecute("delete from " + contextTableName, new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return ":sync_triggers_disabled is null";
    }

    public String getSequenceName(SequenceIdentifier identifier) {
        switch (identifier) {
            case REQUEST: {
                return "SYM_EXTRACT_RE_ST_REQUEST_ID";
            }
            case DATA: {
                return "SYM_DATA_DATA_ID";
            }
            case TRIGGER_HIST: {
                return "SYM_TRIGGER_TRIGGER_HIST_ID";
            }
        }
        return null;
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public void cleanDatabase() {
    }

    public String getName() {
        return super.getName();
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsTransactionId() {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return false;
    }

    public void truncateTable(String tableName) {
        this.platform.getSqlTemplate().update("delete from " + tableName, new Object[0]);
    }

    public void cleanupTriggers() {
        List names = this.platform.getSqlTemplate().query("select rdb$trigger_name from rdb$triggers where rdb$trigger_name like '" + this.parameterService.getTablePrefix().toUpperCase() + "_%'", (ISqlRowMapper)new StringMapper(), new Object[0]);
        for (String name : names) {
            this.platform.getSqlTemplate().update("drop trigger " + name, new Object[0]);
            this.log.info("Dropped trigger {}", (Object)name);
        }
    }

    public String massageDataExtractionSql(String sql, boolean isContainsBigLob) {
        if (!isContainsBigLob) {
            sql = StringUtils.replace((String)sql, (String)"d.row_data", (String)"cast(d.row_data as varchar(10000))");
            sql = StringUtils.replace((String)sql, (String)"d.old_data", (String)"cast(d.old_data as varchar(10000))");
            sql = StringUtils.replace((String)sql, (String)"d.pk_data", (String)"cast(d.pk_data as varchar(500))");
        }
        return sql;
    }

    public long getCurrentSequenceValue(SequenceIdentifier identifier) {
        return this.platform.getSqlTemplate().queryForLong("select gen_id(GEN_" + this.getSequenceName(identifier) + ", 0) from rdb$database", new Object[0]);
    }

    public Database readSymmetricSchemaFromXml() {
        Database db = super.readSymmetricSchemaFromXml();
        String prefix = this.parameterService.getTablePrefix();
        if (StringUtils.isNotBlank((CharSequence)prefix) && !prefix.endsWith("_")) {
            prefix = prefix + "_";
        }
        Column description = db.findTable(prefix + "trigger").findColumn("description");
        description.setJdbcTypeCode(12);
        description.setMappedType("VARCHAR");
        description.setSize("1024");
        return db;
    }

    public String getDatabaseTimeSQL() {
        return "select current_timestamp from rdb$database";
    }
}

