/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.hsqldb2;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.hsqldb2.HsqlDb2TriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class HsqlDb2SymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "drop function $(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from INFORMATION_SCHEMA.ROUTINES where ROUTINE_NAME=UPPER('$(functionName)')";

    public HsqlDb2SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new HsqlDb2TriggerTemplate(this);
        platform.getSqlTemplate().update("SET DATABASE DEFAULT TABLE TYPE CACHED", new Object[0]);
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schemaName, String tableName, String triggerName) {
        boolean exists = this.platform.getSqlTemplate().queryForInt("select count(*) from INFORMATION_SCHEMA.TRIGGERS WHERE TRIGGER_NAME = ?", new Object[]{triggerName}) > 0;
        return exists;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        int count;
        String dropSql = String.format("DROP TRIGGER %s", triggerName);
        this.logSql(dropSql, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers") && (count = transaction.execute(dropSql)) > 0) {
            this.log.info("Just dropped trigger {}", (Object)triggerName);
        }
    }

    public void createRequiredDatabaseObjects() {
        String getSession;
        String setSession;
        String encode = this.parameterService.getTablePrefix() + "_base_64_encode";
        if (!this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            String sql = "CREATE FUNCTION $(functionName)(binaryData BINARY)                                                                                                                                                      RETURNS VARCHAR(1000000)                                                                                                                                     NO SQL                                                                                                                                                       LANGUAGE JAVA PARAMETER STYLE JAVA                                                                                                                           EXTERNAL NAME                                                                                                                                                 'CLASSPATH:org.jumpmind.symmetric.db.hsqldb.HsqlDbFunctions.encodeBase64'                                                                                  ";
            this.install(sql, encode);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, setSession = this.parameterService.getTablePrefix() + "_set_session")) {
            String sql = "CREATE PROCEDURE $(functionName)(key VARCHAR(50), data VARCHAR(50))                                                                                                                                     NO SQL                                                                                                                                                       LANGUAGE JAVA PARAMETER STYLE JAVA                                                                                                                           EXTERNAL NAME                                                                                                                                                 'CLASSPATH:org.jumpmind.symmetric.db.hsqldb.HsqlDbFunctions.setSession'                                                                                    ";
            this.install(sql, setSession);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, getSession = this.parameterService.getTablePrefix() + "_get_session")) {
            String sql = "CREATE FUNCTION $(functionName)(key VARCHAR(50))                                                                                                                                                        RETURNS VARCHAR(50)                                                                                                                                          NO SQL                                                                                                                                                       LANGUAGE JAVA PARAMETER STYLE JAVA                                                                                                                           EXTERNAL NAME                                                                                                                                                 'CLASSPATH:org.jumpmind.symmetric.db.hsqldb.HsqlDbFunctions.getSession'                                                                                    ";
            this.install(sql, getSession);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String getSession;
        String setSession;
        String encode = this.parameterService.getTablePrefix() + "_base_64_encode";
        if (this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            this.uninstall(SQL_DROP_FUNCTION, encode);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, setSession = this.parameterService.getTablePrefix() + "_set_session")) {
            this.uninstall(SQL_DROP_FUNCTION, setSession);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, getSession = this.parameterService.getTablePrefix() + "_get_session")) {
            this.uninstall(SQL_DROP_FUNCTION, getSession);
        }
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("CALL " + this.parameterService.getTablePrefix() + "_set_session('sync_prevented','1')", new Object[0]);
        transaction.prepareAndExecute("CALL " + this.parameterService.getTablePrefix() + "_set_session('node_value','" + nodeId + "')", new Object[0]);
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("CALL " + this.parameterService.getTablePrefix() + "_set_session('sync_prevented',null)", new Object[0]);
        transaction.prepareAndExecute("CALL " + this.parameterService.getTablePrefix() + "_set_session('node_value',null)", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return " " + this.parameterService.getTablePrefix() + "_get_session('sync_prevented') is null ";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "null";
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public boolean supportsTransactionId() {
        return false;
    }

    public void truncateTable(String tableName) {
        this.platform.getSqlTemplate().update("delete from " + tableName, new Object[0]);
    }

    public void cleanDatabase() {
    }

    public boolean canGapsOccurInCapturedDataIds() {
        return false;
    }
}

