/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.hana;

import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.hana.HanaTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class HanaSymmetricDialect
extends AbstractSymmetricDialect {
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";
    static final String SQL_DROP_FUNCTION = "DROP FUNCTION $(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from functions where function_name = '$(functionName)';";

    public HanaSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new HanaTriggerTemplate((ISymmetricDialect)this);
        this.parameterService = parameterService;
    }

    public void cleanDatabase() {
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("set 'sync_triggers_disabled'='1'", new Object[0]);
        if (nodeId != null) {
            transaction.prepareAndExecute("set 'sync_node_disabled'='" + nodeId + "'", new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("set 'sync_triggers_disabled'=''", new Object[0]);
        transaction.prepareAndExecute("set 'sync_node_disabled'=''", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return "SESSION_CONTEXT('sync_triggers_disabled')  is null";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return this.parameterService.getTablePrefix() + "_transaction_id()";
    }

    public void dropRequiredDatabaseObjects() {
        String function = this.parameterService.getTablePrefix() + "_transaction_id";
        if (this.installed(SQL_FUNCTION_INSTALLED, function)) {
            this.uninstall(SQL_DROP_FUNCTION, function);
        }
    }

    public void createRequiredDatabaseObjects() {
        String transactionId = this.parameterService.getTablePrefix() + "_transaction_id";
        if (!this.installed(SQL_FUNCTION_INSTALLED, transactionId)) {
            String sql = "CREATE OR REPLACE function $(functionName)                                                                                                                                                                returns output1 varchar(50) LANGUAGE SQLSCRIPT AS                                                                                                                                                    begin                                                                                                                                                                    select transaction_id into output1 from M_TRANSACTIONS where connection_id = CURRENT_CONNECTION;                                                                                                            end;    ";
            this.install(sql, transactionId);
        }
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schema, String tableName, String triggerName) {
        return this.platform.getSqlTemplate().queryForInt("select count(*) from triggers where trigger_name like ? and subject_table_name like ?", new Object[]{triggerName, tableName.toUpperCase()}) > 0;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        schemaName = schemaName == null ? "" : schemaName + ".";
        String sql = "drop trigger " + schemaName + triggerName;
        this.logSql(sql, sqlBuffer);
        this.log.info("Dropping {} trigger for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
        if (this.parameterService.is("auto.sync.triggers")) {
            transaction.execute(sql);
        }
    }

    public String getDatabaseTimeSQL() {
        return "select current_timestamp from dummy";
    }
}

