/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.derby;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.derby.DerbyTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class DerbySymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "DROP FUNCTION $(functionName)";
    static final String SQL_DROP_PROCEDURE = "DROP PROCEDURE $(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from sys.sysaliases where alias = upper('$(functionName)')";

    public DerbySymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new DerbyTriggerTemplate(this);
        platform.getDatabaseInfo().setGeneratedColumnsSupported(!Version.isOlderThanVersion((String)this.getProductVersion(), (String)"10.5"));
    }

    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        return this.platform.getSqlTemplate().queryForInt("select count(*) from sys.systriggers where triggername = ?", new Object[]{triggerName.toUpperCase()}) > 0;
    }

    public void createRequiredDatabaseObjects() {
        String saveData;
        String syncNodeSetDisabled;
        String syncTriggersSetDisabled;
        String syncTriggersDisabled;
        String transactionId;
        String blobToString;
        String clobToString;
        String escape = this.parameterService.getTablePrefix() + "_escape";
        if (!this.installed(SQL_FUNCTION_INSTALLED, escape)) {
            String sql = "CREATE FUNCTION $(functionName)(STR VARCHAR(10000)) RETURNS                                                                                                                                             VARCHAR(10000) PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME                                                                                                  'org.jumpmind.symmetric.db.derby.DerbyFunctions.escape'                                                                                                                ";
            this.install(sql, escape);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, clobToString = this.parameterService.getTablePrefix() + "_clob_to_string")) {
            String sql = "CREATE FUNCTION $(functionName)(columnName varchar(50),                                                                                                                                                 tableName varchar(50), whereClause varchar(8000)) RETURNS                                                                                                               varchar(32672) PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME                                                                                          'org.jumpmind.symmetric.db.derby.DerbyFunctions.clobToString'                                                                                                          ";
            this.install(sql, clobToString);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, blobToString = this.parameterService.getTablePrefix() + "_blob_to_string")) {
            String sql = "CREATE FUNCTION $(functionName)(columnName varchar(50),                                                                                                                                                 tableName varchar(50), whereClause varchar(8000)) RETURNS                                                                                                               varchar(32672) PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME                                                                                          'org.jumpmind.symmetric.db.derby.DerbyFunctions.blobToString'                                                                                                          ";
            this.install(sql, blobToString);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, transactionId = this.parameterService.getTablePrefix() + "_transaction_id")) {
            String sql = "CREATE FUNCTION $(functionName)() RETURNS                                                                                                                                                               varchar(100) PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME                                                                                                    'org.jumpmind.symmetric.db.derby.DerbyFunctions.getTransactionId'                                                                                                      ";
            this.install(sql, transactionId);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, syncTriggersDisabled = this.parameterService.getTablePrefix() + "_sync_triggers_disabled")) {
            String sql = "CREATE FUNCTION $(functionName)() RETURNS                                                                                                                                                               integer PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME                                                                                                         'org.jumpmind.symmetric.db.derby.DerbyFunctions.isSyncDisabled'                                                                                                        ";
            this.install(sql, syncTriggersDisabled);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, syncTriggersSetDisabled = this.parameterService.getTablePrefix() + "_sync_triggers_set_disabled")) {
            String sql = "CREATE FUNCTION $(functionName)(state integer) RETURNS                                                                                                                                                    integer PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME                                                                                                           'org.jumpmind.symmetric.db.derby.DerbyFunctions.setSyncDisabled'                                                                                                       ";
            this.install(sql, syncTriggersSetDisabled);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, syncNodeSetDisabled = this.parameterService.getTablePrefix() + "_sync_node_set_disabled")) {
            String sql = "CREATE FUNCTION $(functionName)(nodeId varchar(50)) RETURNS                                                                                                                                               varchar(50) PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME                                                                                                       'org.jumpmind.symmetric.db.derby.DerbyFunctions.setSyncNodeDisabled'                                                                                                   ";
            this.install(sql, syncNodeSetDisabled);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, saveData = this.parameterService.getTablePrefix() + "_save_data")) {
            String sql = "CREATE PROCEDURE $(functionName)(enabled integer, schemaName varchar(50), prefixName varchar(50),                                                                                                                         tableName varchar(50), channelName varchar(50), dmlType varchar(1), triggerHistId int,                                                                                   transactionId varchar(1000), externalData varchar(50), columnNames varchar(32672), pkColumnNames varchar(32672))                                         PARAMETER STYLE JAVA LANGUAGE JAVA MODIFIES SQL DATA EXTERNAL NAME                                                                                                       'org.jumpmind.symmetric.db.derby.DerbyFunctions.insertData'                                                                                                            ";
            this.install(sql, saveData);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String saveData;
        String syncNodeSetDisabled;
        String syncTriggersSetDisabled;
        String syncTriggersDisabled;
        String transactionId;
        String blobToString;
        String clobToString;
        String escape = this.parameterService.getTablePrefix() + "_escape";
        if (this.installed(SQL_FUNCTION_INSTALLED, escape)) {
            this.uninstall(SQL_DROP_FUNCTION, escape);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, clobToString = this.parameterService.getTablePrefix() + "_clob_to_string")) {
            this.uninstall(SQL_DROP_FUNCTION, clobToString);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, blobToString = this.parameterService.getTablePrefix() + "_blob_to_string")) {
            this.uninstall(SQL_DROP_FUNCTION, blobToString);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, transactionId = this.parameterService.getTablePrefix() + "_transaction_id")) {
            this.uninstall(SQL_DROP_FUNCTION, transactionId);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, syncTriggersDisabled = this.parameterService.getTablePrefix() + "_sync_triggers_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, syncTriggersDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, syncTriggersSetDisabled = this.parameterService.getTablePrefix() + "_sync_triggers_set_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, syncTriggersSetDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, syncNodeSetDisabled = this.parameterService.getTablePrefix() + "_sync_node_set_disabled")) {
            this.uninstall(SQL_DROP_FUNCTION, syncNodeSetDisabled);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, saveData = this.parameterService.getTablePrefix() + "_save_data")) {
            this.uninstall(SQL_DROP_PROCEDURE, saveData);
        }
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.queryForObject(String.format("values %s_sync_triggers_set_disabled(1)", this.parameterService.getTablePrefix()), Integer.class, new Object[0]);
        if (nodeId != null) {
            transaction.queryForObject(String.format("values %s_sync_node_set_disabled('%s')", this.parameterService.getTablePrefix(), nodeId), String.class, new Object[0]);
        }
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.queryForObject(String.format("values %s_sync_triggers_set_disabled(0)", this.parameterService.getTablePrefix()), Integer.class, new Object[0]);
        transaction.queryForObject(String.format("values %s_sync_node_set_disabled(null)", this.parameterService.getTablePrefix()), String.class, new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return String.format("%s_sync_triggers_disabled() = 0", this.parameterService.getTablePrefix());
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return String.format("%s_transaction_id()", this.parameterService.getTablePrefix());
    }

    public void cleanDatabase() {
    }

    public void truncateTable(String tableName) {
        this.platform.getSqlTemplate().update("delete from " + tableName, new Object[0]);
    }

    public boolean needsToSelectLobData() {
        return true;
    }

    public String getDatabaseTimeSQL() {
        return "values current_timestamp";
    }
}

