/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;

public abstract class AbstractEmbeddedTrigger {
    protected static final char[] HEX = "0123456789abcdef".toCharArray();
    protected static final FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    protected static final String KEY_CONDITION_SQL = "CONDITION_SQL";
    protected static final String KEY_INSERT_DATA_SQL = "INSERT_DATA_SQL";
    protected static final String TEMPLATE_TABLE_SUFFIX = "_CONFIG";
    protected String triggerName;
    protected String schemaName;
    protected Map<String, String> templates = null;

    protected void init(Connection conn, String triggerName, String schemaName, String tableName) throws SQLException {
        if (this.templates == null) {
            this.schemaName = schemaName;
            this.triggerName = triggerName;
            this.templates = this.getTemplates(conn);
        }
        if (this.templates == null || this.templates.size() == 0) {
            throw new IllegalStateException(String.format("The '%s' SymmetricDS trigger is in an invalid state.  It needs to be dropped.", triggerName));
        }
    }

    public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
        String sql = null;
        try (Statement stmt = conn.createStatement();){
            sql = this.fillVirtualTableSql(this.templates.get(KEY_CONDITION_SQL), oldRow, newRow);
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next() && rs.getInt(1) > 0) {
                rs.close();
                sql = this.fillVirtualTableSql(this.templates.get(KEY_INSERT_DATA_SQL), oldRow, newRow);
                stmt.executeUpdate(sql);
            }
        }
        catch (SQLException ex) {
            System.err.println("This sql failed: " + sql);
            Throwable rootException = ex;
            while (rootException.getCause() != null && !rootException.getCause().equals(ex)) {
                rootException = ex.getCause();
            }
            rootException.printStackTrace();
            throw ex;
        }
    }

    protected String fillVirtualTableSql(String sql, Object[] oldRow, Object[] newRow) throws SQLException {
        int columnCount = oldRow != null ? oldRow.length : newRow.length;
        StringBuilder out = new StringBuilder();
        String[] tokens = sql.split("\\?");
        int tokenIndex = 0;
        tokenIndex = this.forEachColumn(columnCount, newRow, out, tokenIndex, tokens);
        tokenIndex = this.forEachColumn(columnCount, oldRow, out, tokenIndex, tokens);
        out.append(tokens[tokenIndex]);
        return out.toString();
    }

    private int forEachColumn(int columnCount, Object[] data, StringBuilder out, int tokenIndex, String[] tokens) {
        for (int i = 0; i < columnCount; ++i) {
            out.append(tokens[tokenIndex++]);
            if (data != null) {
                data[i] = this.appendVirtualTableStringValue(data[i], out);
                continue;
            }
            out.append("null");
        }
        return tokenIndex;
    }

    protected Object appendVirtualTableStringValue(Object value, StringBuilder out) {
        if (value == null) {
            out.append("null");
        } else if (value instanceof String || value instanceof Reader || value instanceof JdbcClob) {
            if (value instanceof Reader) {
                try {
                    value = this.readStringAndClose((Reader)value, -1);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (value instanceof JdbcClob) {
                try {
                    value = this.readStringAndClose(((JdbcClob)value).getCharacterStream(), -1);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            out.append("'");
            out.append(this.escapeString(value));
            out.append("'");
        } else if (value instanceof Number) {
            out.append(value);
        } else if (value instanceof Boolean) {
            out.append(value);
        } else if (value instanceof InputStream) {
            out.append("'");
            try {
                value = AbstractEmbeddedTrigger.convertBytesToString(AbstractEmbeddedTrigger.readBytesAndClose((InputStream)value, -1));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            out.append(this.escapeString(value));
            out.append("'");
        } else if (value instanceof JdbcBlob) {
            out.append("'");
            try {
                value = new String(AbstractEmbeddedTrigger.readBytesAndClose(((JdbcBlob)value).getBinaryStream(), -1), StandardCharsets.UTF_8);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            out.append(this.escapeString(value));
            out.append("'");
        } else if (value instanceof Date) {
            out.append("'");
            out.append(DATE_FORMATTER.format(value));
            out.append("'");
        } else if (value instanceof LocalDate) {
            out.append("'");
            out.append(((LocalDate)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            out.append("'");
        } else if (value instanceof LocalTime) {
            out.append("'");
            out.append(((LocalTime)value).format(DateTimeFormatter.ofPattern("HH:mm:ss.SSS")));
            out.append("'");
        } else if (value instanceof LocalDateTime) {
            out.append("'");
            out.append(((LocalDateTime)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")));
            out.append("'");
        } else if (value instanceof byte[]) {
            out.append("'");
            value = AbstractEmbeddedTrigger.convertBytesToString((byte[])value, ((byte[])value).length);
            out.append(this.escapeString(value));
            out.append("'");
        } else {
            throw new IllegalStateException(String.format("Type not supported: %s", value.getClass().getName()));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readStringAndClose(Reader paramReader, int paramInt) throws IOException {
        try {
            String str;
            if (paramInt <= 0) {
                paramInt = Integer.MAX_VALUE;
            }
            int i = Math.min(4096, paramInt);
            StringWriter localStringWriter = new StringWriter(paramInt == Integer.MAX_VALUE ? i : paramInt);
            char[] arrayOfChar = new char[i];
            while (paramInt > 0) {
                int j = Math.min(i, paramInt);
                if ((j = paramReader.read(arrayOfChar, 0, j)) < 0) break;
                localStringWriter.write(arrayOfChar, 0, j);
                paramInt -= j;
            }
            String string = str = localStringWriter.toString();
            return string;
        }
        finally {
            paramReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytesAndClose(InputStream paramInputStream, int paramInt) throws IOException {
        try {
            byte[] arrayOfByte2;
            if (paramInt <= 0) {
                paramInt = Integer.MAX_VALUE;
            }
            int i = Math.min(4096, paramInt);
            ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream(i);
            byte[] arrayOfByte1 = new byte[i];
            while (paramInt > 0) {
                int j = Math.min(i, paramInt);
                if ((j = paramInputStream.read(arrayOfByte1, 0, j)) < 0) break;
                localByteArrayOutputStream.write(arrayOfByte1, 0, j);
                paramInt -= j;
            }
            byte[] byArray = arrayOfByte2 = localByteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            paramInputStream.close();
        }
    }

    public static String convertBytesToString(byte[] paramArrayOfByte) {
        return AbstractEmbeddedTrigger.convertBytesToString(paramArrayOfByte, paramArrayOfByte.length);
    }

    public static String convertBytesToString(byte[] paramArrayOfByte, int paramInt) {
        char[] arrayOfChar1 = new char[paramInt + paramInt];
        char[] arrayOfChar2 = HEX;
        for (int i = 0; i < paramInt; ++i) {
            int j = paramArrayOfByte[i] & 0xFF;
            arrayOfChar1[i + i] = arrayOfChar2[j >> 4];
            arrayOfChar1[i + i + 1] = arrayOfChar2[j & 0xF];
        }
        return new String(arrayOfChar1);
    }

    protected String escapeString(Object val) {
        return val == null ? null : val.toString().replaceAll("'", "''");
    }

    protected Map<String, String> getTemplates(Connection conn) throws SQLException {
        HashMap<String, String> templates = new HashMap<String, String>();
        Throwable throwable = null;
        try (Statement stmt = conn.createStatement();){
            String schemaPrefix = this.schemaName != null && this.schemaName.length() > 0 ? "\"" + this.schemaName + "\"." : "";
            ResultSet rs = stmt.executeQuery(String.format("select * from %s%s%s", schemaPrefix, this.triggerName, TEMPLATE_TABLE_SUFFIX));
            if (rs.next()) {
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    templates.put(metaData.getColumnName(i), rs.getString(i));
                }
                HashMap<String, String> hashMap = templates;
                return hashMap;
            }
            try {
                throw new SQLException(String.format("%s is in an invalid state.  %s%s did not return a row.", this.triggerName, this.triggerName, TEMPLATE_TABLE_SUFFIX));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

