/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.AbstractCommandLauncher;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.io.data.DbImport;
import org.jumpmind.symmetric.io.data.writer.IDatabaseWriterFilter;

public class DbImportCommand
extends AbstractCommandLauncher {
    private static final String OPTION_FORMAT = "format";
    private static final String OPTION_CATALOG = "catalog";
    private static final String OPTION_SCHEMA = "schema";
    private static final String OPTION_TABLE = "table";
    private static final String OPTION_USE_VARIABLE_DATES = "use-variable-dates";
    private static final String OPTION_COMMIT = "commit";
    private static final String OPTION_INTERVAL = "interval";
    private static final String OPTION_IGNORE = "ignore";
    private static final String OPTION_REPLACE = "replace";
    private static final String OPTION_FORCE = "force";
    private static final String OPTION_ALTER = "alter";
    private static final String OPTION_FILTER_CLASSES = "filter-classes";
    private static final String OPTION_DROP_IF_EXISTS = "drop-if-exists";
    private static final String OPTION_ALTER_CASE = "alter-case";

    public DbImportCommand() {
        super("dbimport", "[file...]", "DbImport.Option.");
    }

    public static void main(String[] args) {
        new DbImportCommand().execute(args);
    }

    @Override
    protected boolean printHelpIfNoOptionsAreProvided() {
        return false;
    }

    @Override
    protected boolean requiresPropertiesFile(CommandLine line) {
        return true;
    }

    @Override
    protected void printHelp(CommandLine cmd, Options options) {
        System.out.println(this.app + " version " + Version.version());
        System.out.println("Import data from file to database tables.\n");
        super.printHelp(cmd, options);
    }

    @Override
    protected void buildOptions(Options options) {
        super.buildOptions(options);
        this.addOption(options, null, OPTION_FORMAT, true);
        this.addOption(options, null, OPTION_CATALOG, true);
        this.addOption(options, null, OPTION_SCHEMA, true);
        this.addOption(options, null, OPTION_TABLE, true);
        this.addOption(options, null, OPTION_USE_VARIABLE_DATES, false);
        this.addOption(options, null, OPTION_COMMIT, true);
        this.addOption(options, null, OPTION_INTERVAL, true);
        this.addOption(options, null, OPTION_IGNORE, false);
        this.addOption(options, null, OPTION_REPLACE, false);
        this.addOption(options, null, OPTION_FORCE, false);
        this.addOption(options, null, OPTION_ALTER, false);
        this.addOption(options, null, OPTION_FILTER_CLASSES, true);
        this.addOption(options, null, OPTION_DROP_IF_EXISTS, false);
        this.addOption(options, null, OPTION_ALTER_CASE, false);
    }

    @Override
    protected boolean executeWithOptions(CommandLine line) throws Exception {
        String[] args;
        String filters;
        DbImport dbImport = new DbImport(this.getDatabasePlatform(true));
        if (line.hasOption(OPTION_FORMAT)) {
            dbImport.setFormat(DbImport.Format.valueOf((String)line.getOptionValue(OPTION_FORMAT).toUpperCase()));
        }
        if (line.hasOption(OPTION_CATALOG)) {
            dbImport.setCatalog(line.getOptionValue(OPTION_CATALOG));
        }
        if (line.hasOption(OPTION_SCHEMA)) {
            dbImport.setSchema(line.getOptionValue(OPTION_SCHEMA));
        }
        if (line.hasOption(OPTION_USE_VARIABLE_DATES)) {
            dbImport.setUseVariableForDates(true);
        }
        if (line.hasOption(OPTION_COMMIT)) {
            dbImport.setCommitRate(Long.parseLong(line.getOptionValue(OPTION_COMMIT)));
        }
        if (line.hasOption(OPTION_INTERVAL)) {
            dbImport.setInterval(Integer.parseInt(line.getOptionValue(OPTION_INTERVAL)));
        }
        if (line.hasOption(OPTION_ALTER_CASE)) {
            dbImport.setAlterCaseToMatchDatabaseDefaultCase(true);
        }
        if (line.hasOption(OPTION_DROP_IF_EXISTS)) {
            dbImport.setDropIfExists(true);
        }
        if (line.hasOption(OPTION_ALTER)) {
            dbImport.setAlterTables(true);
        }
        if (line.hasOption(OPTION_FILTER_CLASSES) && StringUtils.isNotBlank((CharSequence)(filters = line.getOptionValue(OPTION_FILTER_CLASSES)))) {
            String[] clazzes;
            String[] stringArray = clazzes = filters.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String clazz = stringArray[i];
                if (!StringUtils.isNotBlank((CharSequence)clazz)) continue;
                IDatabaseWriterFilter databaseWriterFilter = (IDatabaseWriterFilter)Class.forName(clazz.trim()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                dbImport.addDatabaseWriterFilter(databaseWriterFilter);
            }
        }
        if (line.hasOption(OPTION_FORCE)) {
            dbImport.setForceImport(true);
        }
        if (line.hasOption(OPTION_REPLACE)) {
            dbImport.setReplaceRows(true);
        }
        if (line.hasOption(OPTION_IGNORE)) {
            dbImport.setIgnoreCollisions(true);
        }
        if ((args = line.getArgs()).length == 0) {
            dbImport.importTables(System.in, line.getOptionValue(OPTION_TABLE));
        } else {
            for (String fileName : args) {
                if (new File(fileName).exists()) continue;
                throw new RuntimeException("Cannot find file " + fileName);
            }
            for (String fileName : args) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
                dbImport.importTables((InputStream)in, line.getOptionValue(OPTION_TABLE));
                in.close();
            }
        }
        return true;
    }
}

